/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.customUsageCollectors.ui;

import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

@State(name="ShortcutsCollector", storages={@Storage(value="statistics.shortcuts.xml", roamingType=RoamingType.DISABLED)})
public class ShortcutsCollector
implements PersistentStateComponent<MyState> {
    private MyState myState = new MyState();
    private static final List<Pair<Integer, String>> ourModifiers = new ArrayList<Pair<Integer, String>>(6);
    private static final Map<Integer, String> ourKeyCodes;

    @NotNull
    public MyState getState() {
        MyState myState = this.myState;
        if (myState == null) {
            ShortcutsCollector.$$$reportNull$$$0(0);
        }
        return myState;
    }

    public void loadState(MyState state) {
        this.myState = state;
    }

    public static void record(AnActionEvent event) {
        ShortcutsCollector._record(event, false);
    }

    public static void recordDoubleShortcut(AnActionEvent event) {
        ShortcutsCollector._record(event, true);
    }

    private static void _record(AnActionEvent event, boolean isDoubleShortcut) {
        InputEvent e = event.getInputEvent();
        if (e instanceof KeyEvent) {
            KeyboardShortcut shortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent((KeyEvent)e), null);
            String key2 = ShortcutsCollector.getShortcutText(shortcut);
            if (isDoubleShortcut) {
                key2 = key2 + "+" + key2;
            }
            ShortcutsCollector.incValue(key2);
        }
    }

    private static String getShortcutText(KeyboardShortcut shortcut) {
        String keyModifiersText;
        String results = "";
        int modifiers = shortcut.getFirstKeyStroke().getModifiers();
        if (modifiers > 0 && !(keyModifiersText = ShortcutsCollector.getLocaleUnawareKeyModifiersText(modifiers)).isEmpty()) {
            results = keyModifiersText + "+";
        }
        results = results + ShortcutsCollector.getLocaleUnawareKeyText(shortcut.getFirstKeyStroke().getKeyCode());
        return results;
    }

    private static void incValue(String key2) {
        ShortcutsCollector collector = ShortcutsCollector.getInstance();
        if (collector == null) {
            return;
        }
        Map<String, Integer> values = collector.getState().myValues;
        values.put(key2, (Integer)ContainerUtil.getOrElse(values, (Object)key2, (Object)0) + 1);
    }

    private static ShortcutsCollector getInstance() {
        return (ShortcutsCollector)ServiceManager.getService(ShortcutsCollector.class);
    }

    private static String getLocaleUnawareKeyText(int keyCode) {
        if (keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90) {
            return String.valueOf((char)keyCode);
        }
        String knownKeyCode = ourKeyCodes.get(keyCode);
        if (knownKeyCode != null) {
            return knownKeyCode;
        }
        if (keyCode >= 96 && keyCode <= 105) {
            char c = (char)(keyCode - 96 + 48);
            return "NumPad-" + c;
        }
        if ((keyCode & 0x1000000) != 0) {
            return String.valueOf((char)(keyCode ^ 0x1000000));
        }
        return "Unknown keyCode: 0x" + Integer.toString(keyCode, 16);
    }

    private static String getLocaleUnawareKeyModifiersText(int modifiers) {
        List pressed = ourModifiers.stream().filter(p -> ((Integer)p.first & modifiers) != 0).map(p -> (String)p.second).collect(Collectors.toList());
        return StringUtil.join(pressed, (String)"+");
    }

    static {
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)4, (Object)"Meta"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)2, (Object)"Ctrl"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)8, (Object)"Alt"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)1, (Object)"Shift"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)32, (Object)"Alt Graph"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)16, (Object)"Button1"));
        ourKeyCodes = new HashMap<Integer, String>();
        ourKeyCodes.put(10, "Enter");
        ourKeyCodes.put(8, "Backspace");
        ourKeyCodes.put(9, "Tab");
        ourKeyCodes.put(3, "Cancel");
        ourKeyCodes.put(12, "Clear");
        ourKeyCodes.put(65312, "Compose");
        ourKeyCodes.put(19, "Pause");
        ourKeyCodes.put(20, "Caps Lock");
        ourKeyCodes.put(27, "Escape");
        ourKeyCodes.put(32, "Space");
        ourKeyCodes.put(33, "Page Up");
        ourKeyCodes.put(34, "Page Down");
        ourKeyCodes.put(35, "End");
        ourKeyCodes.put(36, "Home");
        ourKeyCodes.put(37, "Left");
        ourKeyCodes.put(38, "Up");
        ourKeyCodes.put(39, "Right");
        ourKeyCodes.put(40, "Down");
        ourKeyCodes.put(65368, "Begin");
        ourKeyCodes.put(16, "Shift");
        ourKeyCodes.put(17, "Control");
        ourKeyCodes.put(18, "Alt");
        ourKeyCodes.put(157, "Meta");
        ourKeyCodes.put(65406, "Alt Graph");
        ourKeyCodes.put(44, "Comma");
        ourKeyCodes.put(46, "Period");
        ourKeyCodes.put(47, "Slash");
        ourKeyCodes.put(59, "Semicolon");
        ourKeyCodes.put(61, "Equals");
        ourKeyCodes.put(91, "Open Bracket");
        ourKeyCodes.put(92, "Back Slash");
        ourKeyCodes.put(93, "Close Bracket");
        ourKeyCodes.put(106, "NumPad *");
        ourKeyCodes.put(107, "NumPad +");
        ourKeyCodes.put(108, "NumPad ,");
        ourKeyCodes.put(109, "NumPad -");
        ourKeyCodes.put(110, "NumPad .");
        ourKeyCodes.put(111, "NumPad /");
        ourKeyCodes.put(127, "Delete");
        ourKeyCodes.put(144, "Num Lock");
        ourKeyCodes.put(145, "Scroll Lock");
        ourKeyCodes.put(524, "Windows");
        ourKeyCodes.put(525, "Context Menu");
        ourKeyCodes.put(112, "F1");
        ourKeyCodes.put(113, "F2");
        ourKeyCodes.put(114, "F3");
        ourKeyCodes.put(115, "F4");
        ourKeyCodes.put(116, "F5");
        ourKeyCodes.put(117, "F6");
        ourKeyCodes.put(118, "F7");
        ourKeyCodes.put(119, "F8");
        ourKeyCodes.put(120, "F9");
        ourKeyCodes.put(121, "F10");
        ourKeyCodes.put(122, "F11");
        ourKeyCodes.put(123, "F12");
        ourKeyCodes.put(61440, "F13");
        ourKeyCodes.put(61441, "F14");
        ourKeyCodes.put(61442, "F15");
        ourKeyCodes.put(61443, "F16");
        ourKeyCodes.put(61444, "F17");
        ourKeyCodes.put(61445, "F18");
        ourKeyCodes.put(61446, "F19");
        ourKeyCodes.put(61447, "F20");
        ourKeyCodes.put(61448, "F21");
        ourKeyCodes.put(61449, "F22");
        ourKeyCodes.put(61450, "F23");
        ourKeyCodes.put(61451, "F24");
        ourKeyCodes.put(154, "Print Screen");
        ourKeyCodes.put(155, "Insert");
        ourKeyCodes.put(156, "Help");
        ourKeyCodes.put(192, "Back Quote");
        ourKeyCodes.put(222, "Quote");
        ourKeyCodes.put(224, "Up");
        ourKeyCodes.put(225, "Down");
        ourKeyCodes.put(226, "Left");
        ourKeyCodes.put(227, "Right");
        ourKeyCodes.put(128, "Dead Grave");
        ourKeyCodes.put(129, "Dead Acute");
        ourKeyCodes.put(130, "Dead Circumflex");
        ourKeyCodes.put(131, "Dead Tilde");
        ourKeyCodes.put(132, "Dead Macron");
        ourKeyCodes.put(133, "Dead Breve");
        ourKeyCodes.put(134, "Dead Above Dot");
        ourKeyCodes.put(135, "Dead Diaeresis");
        ourKeyCodes.put(136, "Dead Above Ring");
        ourKeyCodes.put(137, "Dead Double Acute");
        ourKeyCodes.put(138, "Dead Caron");
        ourKeyCodes.put(139, "Dead Cedilla");
        ourKeyCodes.put(140, "Dead Ogonek");
        ourKeyCodes.put(141, "Dead Iota");
        ourKeyCodes.put(142, "Dead Voiced Sound");
        ourKeyCodes.put(143, "Dead Semivoiced Sound");
        ourKeyCodes.put(150, "Ampersand");
        ourKeyCodes.put(151, "Asterisk");
        ourKeyCodes.put(152, "Double Quote");
        ourKeyCodes.put(153, "Less");
        ourKeyCodes.put(160, "Greater");
        ourKeyCodes.put(161, "Left Brace");
        ourKeyCodes.put(162, "Right Brace");
        ourKeyCodes.put(512, "At");
        ourKeyCodes.put(513, "Colon");
        ourKeyCodes.put(514, "Circumflex");
        ourKeyCodes.put(515, "Dollar");
        ourKeyCodes.put(516, "Euro");
        ourKeyCodes.put(517, "Exclamation Mark");
        ourKeyCodes.put(518, "Inverted Exclamation Mark");
        ourKeyCodes.put(519, "Left Parenthesis");
        ourKeyCodes.put(520, "Number Sign");
        ourKeyCodes.put(45, "Minus");
        ourKeyCodes.put(521, "Plus");
        ourKeyCodes.put(522, "Right Parenthesis");
        ourKeyCodes.put(523, "Underscore");
        ourKeyCodes.put(24, "Final");
        ourKeyCodes.put(28, "Convert");
        ourKeyCodes.put(29, "No Convert");
        ourKeyCodes.put(30, "Accept");
        ourKeyCodes.put(31, "Mode Change");
        ourKeyCodes.put(21, "Kana");
        ourKeyCodes.put(25, "Kanji");
        ourKeyCodes.put(240, "Alphanumeric");
        ourKeyCodes.put(241, "Katakana");
        ourKeyCodes.put(242, "Hiragana");
        ourKeyCodes.put(243, "Full-Width");
        ourKeyCodes.put(244, "Half-Width");
        ourKeyCodes.put(245, "Roman Characters");
        ourKeyCodes.put(256, "All Candidates");
        ourKeyCodes.put(257, "Previous Candidate");
        ourKeyCodes.put(258, "Code Input");
        ourKeyCodes.put(259, "Japanese Katakana");
        ourKeyCodes.put(260, "Japanese Hiragana");
        ourKeyCodes.put(261, "Japanese Roman");
        ourKeyCodes.put(262, "Kana Lock");
        ourKeyCodes.put(263, "Input Method On/Off");
        ourKeyCodes.put(65481, "Again");
        ourKeyCodes.put(65483, "Undo");
        ourKeyCodes.put(65485, "Copy");
        ourKeyCodes.put(65487, "Paste");
        ourKeyCodes.put(65489, "Cut");
        ourKeyCodes.put(65488, "Find");
        ourKeyCodes.put(65482, "Props");
        ourKeyCodes.put(65480, "Stop");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/customUsageCollectors/ui/ShortcutsCollector", "getState"));
    }

    static final class ShortcutUsagesCollector
    extends UsagesCollector {
        private static final GroupDescriptor GROUP = GroupDescriptor.create(ShortcutUsagesCollector.getGroupName(), 100.0);

        ShortcutUsagesCollector() {
        }

        private static String getGroupName() {
            if (SystemInfo.isMac) {
                return "Shortcuts on Mac";
            }
            if (SystemInfo.isWindows) {
                return "Shortcuts on Windows";
            }
            if (SystemInfo.isLinux) {
                return "Shortcuts on Linux";
            }
            return "Shortcuts on OtherOs";
        }

        @Override
        @NotNull
        public Set<UsageDescriptor> getUsages() {
            MyState state = ShortcutsCollector.getInstance().getState();
            Set set2 = ContainerUtil.map2Set(state.myValues.entrySet(), e -> new UsageDescriptor((String)e.getKey(), (Integer)e.getValue()));
            if (set2 == null) {
                ShortcutUsagesCollector.$$$reportNull$$$0(0);
            }
            return set2;
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GROUP;
            if (groupDescriptor == null) {
                ShortcutUsagesCollector.$$$reportNull$$$0(1);
            }
            return groupDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/internal/statistic/customUsageCollectors/ui/ShortcutsCollector$ShortcutUsagesCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static final class MyState {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="shortcut", valueAttributeName="count")
        public final Map<String, Integer> myValues = new HashMap<String, Integer>();

        MyState() {
        }
    }
}

