/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.libraryJar;

import com.intellij.facet.frameworks.SettingsConnectionService;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptor;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptors;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryJarStatisticsService
extends SettingsConnectionService
implements StartupActivity,
DumbAware {
    private static final String FILE_NAME = "statistics/library-jar-statistics.xml";
    private static final String DEFAULT_SETTINGS_URL = "https://www.jetbrains.com/idea/download-assistant.xml";
    private static final String DEFAULT_SERVICE_URL = "https://frameworks.jetbrains.com";
    private static final LibraryJarStatisticsService myInstance = new LibraryJarStatisticsService();
    private LibraryJarDescriptor[] myDescriptors;

    public static LibraryJarStatisticsService getInstance() {
        return myInstance;
    }

    protected LibraryJarStatisticsService() {
        super(DEFAULT_SETTINGS_URL, DEFAULT_SERVICE_URL);
    }

    @NotNull
    public LibraryJarDescriptor[] getTechnologyDescriptors() {
        if (this.myDescriptors == null) {
            if (!StatisticsUploadAssistant.isSendAllowed()) {
                if (LibraryJarDescriptor.EMPTY == null) {
                    LibraryJarStatisticsService.$$$reportNull$$$0(0);
                }
                return LibraryJarDescriptor.EMPTY;
            }
            URL url = this.createVersionsUrl();
            if (url == null) {
                if (LibraryJarDescriptor.EMPTY == null) {
                    LibraryJarStatisticsService.$$$reportNull$$$0(1);
                }
                return LibraryJarDescriptor.EMPTY;
            }
            LibraryJarDescriptors descriptors = LibraryJarStatisticsService.deserialize(url);
            LibraryJarDescriptor[] libraryJarDescriptorArray = this.myDescriptors = descriptors == null ? LibraryJarDescriptor.EMPTY : descriptors.getDescriptors();
        }
        if (this.myDescriptors == null) {
            LibraryJarStatisticsService.$$$reportNull$$$0(2);
        }
        return this.myDescriptors;
    }

    @Nullable
    private static LibraryJarDescriptors deserialize(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        LibraryJarDescriptors libraryJarDescriptors = null;
        try {
            libraryJarDescriptors = (LibraryJarDescriptors)XmlSerializer.deserialize((URL)url, LibraryJarDescriptors.class);
        }
        catch (XmlSerializationException xmlSerializationException) {
            // empty catch block
        }
        return libraryJarDescriptors;
    }

    @Nullable
    private URL createVersionsUrl() {
        String serviceUrl = this.getServiceUrl();
        if (StringUtil.isNotEmpty((String)serviceUrl)) {
            try {
                String url = serviceUrl + "/" + FILE_NAME;
                HttpConfigurable.getInstance().prepareURL(url);
                return new URL(url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public void runActivity(@NotNull Project project2) {
        Application application;
        if (project2 == null) {
            LibraryJarStatisticsService.$$$reportNull$$$0(3);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> LibraryJarStatisticsService.getInstance().getTechnologyDescriptors());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/libraryJar/LibraryJarStatisticsService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTechnologyDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/libraryJar/LibraryJarStatisticsService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

