/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javadoc;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.javadoc.JavadocHelper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorNavigationDelegate;
import com.intellij.openapi.editor.EditorNavigationDelegateAdapter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavadocNavigationDelegate
extends EditorNavigationDelegateAdapter {
    private static final JavadocHelper ourHelper = JavadocHelper.getInstance();

    @NotNull
    public EditorNavigationDelegate.Result navigateToLineEnd(@NotNull Editor editor, @NotNull DataContext dataContext) {
        if (editor == null) {
            JavadocNavigationDelegate.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            JavadocNavigationDelegate.$$$reportNull$$$0(1);
        }
        if (!CodeInsightSettings.getInstance().SMART_END_ACTION) {
            EditorNavigationDelegate.Result result2 = EditorNavigationDelegate.Result.CONTINUE;
            if (result2 == null) {
                JavadocNavigationDelegate.$$$reportNull$$$0(2);
            }
            return result2;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            EditorNavigationDelegate.Result result3 = EditorNavigationDelegate.Result.CONTINUE;
            if (result3 == null) {
                JavadocNavigationDelegate.$$$reportNull$$$0(3);
            }
            return result3;
        }
        Document document = editor.getDocument();
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        }
        if (psiFile == null) {
            EditorNavigationDelegate.Result result4 = EditorNavigationDelegate.Result.CONTINUE;
            if (result4 == null) {
                JavadocNavigationDelegate.$$$reportNull$$$0(4);
            }
            return result4;
        }
        EditorNavigationDelegate.Result result5 = JavadocNavigationDelegate.navigateToLineEnd(editor, psiFile);
        if (result5 == null) {
            JavadocNavigationDelegate.$$$reportNull$$$0(5);
        }
        return result5;
    }

    public static EditorNavigationDelegate.Result navigateToLineEnd(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            JavadocNavigationDelegate.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            JavadocNavigationDelegate.$$$reportNull$$$0(7);
        }
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int offset = caretModel.getOffset();
        CharSequence text2 = document.getCharsSequence();
        int line = caretModel.getLogicalPosition().line;
        int endLineOffset = document.getLineEndOffset(line);
        LogicalPosition endLineLogicalPosition = editor.offsetToLogicalPosition(endLineOffset);
        int lastNonWsSymbolOffset = CharArrayUtil.shiftBackward((CharSequence)text2, (int)endLineOffset, (String)" \t");
        if (lastNonWsSymbolOffset > offset || caretModel.getLogicalPosition().column > endLineLogicalPosition.column) {
            return EditorNavigationDelegate.Result.CONTINUE;
        }
        Pair<JavadocHelper.JavadocParameterInfo, List<JavadocHelper.JavadocParameterInfo>> pair2 = ourHelper.parse(psiFile, editor, offset);
        if (pair2.first == null || ((JavadocHelper.JavadocParameterInfo)pair2.first).parameterDescriptionStartPosition != null) {
            return EditorNavigationDelegate.Result.CONTINUE;
        }
        LogicalPosition position = ourHelper.calculateDescriptionStartPosition(psiFile, (Collection)pair2.second, (JavadocHelper.JavadocParameterInfo)pair2.first);
        ourHelper.navigate(position, editor, psiFile.getProject());
        return EditorNavigationDelegate.Result.STOP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javadoc/JavadocNavigationDelegate";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javadoc/JavadocNavigationDelegate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "navigateToLineEnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "navigateToLineEnd";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

