/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonUtil {
    private JsonUtil() {
    }

    @Nullable
    public static <T> T as(@Nullable Object expression2, @NotNull Class<T> cls) {
        if (cls == null) {
            JsonUtil.$$$reportNull$$$0(0);
        }
        if (expression2 == null) {
            return null;
        }
        if (cls.isAssignableFrom(expression2.getClass())) {
            return (T)expression2;
        }
        return null;
    }

    @Nullable
    public static <T extends JsonElement> T getPropertyValueOfType(@NotNull JsonObject object, @NotNull String name2, @NotNull Class<T> clazz) {
        JsonProperty property;
        if (object == null) {
            JsonUtil.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            JsonUtil.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            JsonUtil.$$$reportNull$$$0(3);
        }
        if ((property = object.findProperty(name2)) == null) {
            return null;
        }
        return (T)((JsonElement)ObjectUtils.tryCast((Object)property.getValue(), clazz));
    }

    @Nullable
    public static List<String> getChildAsStringList(@NotNull JsonObject object, @NotNull String name2) {
        JsonArray array;
        if (object == null) {
            JsonUtil.$$$reportNull$$$0(4);
        }
        if (name2 == null) {
            JsonUtil.$$$reportNull$$$0(5);
        }
        if ((array = JsonUtil.getPropertyValueOfType(object, name2, JsonArray.class)) != null) {
            return array.getValueList().stream().filter(value2 -> value2 instanceof JsonStringLiteral).map(value2 -> StringUtil.unquoteString((String)value2.getText())).collect(Collectors.toList());
        }
        return null;
    }

    @Nullable
    public static List<String> getChildAsSingleStringOrList(@NotNull JsonObject object, @NotNull String name2) {
        List<String> list2;
        if (object == null) {
            JsonUtil.$$$reportNull$$$0(6);
        }
        if (name2 == null) {
            JsonUtil.$$$reportNull$$$0(7);
        }
        if ((list2 = JsonUtil.getChildAsStringList(object, name2)) != null) {
            return list2;
        }
        JsonStringLiteral literal = JsonUtil.getPropertyValueOfType(object, name2, JsonStringLiteral.class);
        return literal == null ? null : Collections.singletonList(StringUtil.unquoteString((String)literal.getText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/JsonUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "as";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyValueOfType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildAsStringList";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildAsSingleStringOrList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

