/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor.lineMover;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonLineMover
extends LineMover {
    private boolean myShouldAddComma = false;

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            JsonLineMover.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            JsonLineMover.$$$reportNull$$$0(1);
        }
        if (info == null) {
            JsonLineMover.$$$reportNull$$$0(2);
        }
        this.myShouldAddComma = false;
        if (!(file2 instanceof JsonFile) || !super.checkAvailable(editor, file2, info, down)) {
            return false;
        }
        Pair<PsiElement, PsiElement> movedElementRange = JsonLineMover.getElementRange((Editor)editor, (PsiFile)file2, (LineRange)info.toMove);
        if (!this.isValidElementRange(movedElementRange)) {
            return false;
        }
        movedElementRange = this.expandCommentsInRange(movedElementRange);
        info.toMove = new LineRange((PsiElement)movedElementRange.getFirst(), (PsiElement)movedElementRange.getSecond());
        int lineCount = editor.getDocument().getLineCount();
        info.toMove2 = down ? new LineRange(info.toMove.endLine, Math.min(info.toMove.endLine + 1, lineCount)) : new LineRange(Math.max(info.toMove.startLine - 1, 0), info.toMove.startLine);
        if (movedElementRange.getFirst() instanceof PsiComment && movedElementRange.getSecond() instanceof PsiComment) {
            return true;
        }
        Pair destElementRange = JsonLineMover.getElementRange((Editor)editor, (PsiFile)file2, (LineRange)info.toMove2);
        if (this.isValidElementRange((Pair<PsiElement, PsiElement>)destElementRange) && ((PsiElement)movedElementRange.getFirst()).getParent() == ((PsiElement)destElementRange.getSecond()).getParent()) {
            PsiElement lowerRightElement;
            PsiElement commonParent = ((PsiElement)movedElementRange.getFirst()).getParent();
            PsiElement psiElement = lowerRightElement = down ? (PsiElement)destElementRange.getSecond() : (PsiElement)movedElementRange.getSecond();
            if (lowerRightElement instanceof JsonElement && (commonParent instanceof JsonArray && this.notFollowedByNextElementOrComma(lowerRightElement, JsonValue.class) || commonParent instanceof JsonObject && this.notFollowedByNextElementOrComma(lowerRightElement, JsonProperty.class))) {
                this.myShouldAddComma = true;
            }
        }
        return true;
    }

    @NotNull
    private Pair<PsiElement, PsiElement> expandCommentsInRange(@NotNull Pair<PsiElement, PsiElement> range) {
        if (range == null) {
            JsonLineMover.$$$reportNull$$$0(3);
        }
        PsiElement upper = JsonPsiUtil.findFurthestSiblingOfSameType((PsiElement)range.getFirst(), false);
        PsiElement lower = JsonPsiUtil.findFurthestSiblingOfSameType((PsiElement)range.getSecond(), true);
        Pair pair2 = Pair.create((Object)upper, (Object)lower);
        if (pair2 == null) {
            JsonLineMover.$$$reportNull$$$0(4);
        }
        return pair2;
    }

    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            JsonLineMover.$$$reportNull$$$0(5);
        }
        if (info == null) {
            JsonLineMover.$$$reportNull$$$0(6);
        }
        if (this.myShouldAddComma) {
            Document document = editor.getDocument();
            int lineBelow = down ? info.toMove2.endLine - 1 : info.toMove.endLine - 1;
            document.insertString(document.getLineEndOffset(lineBelow), (CharSequence)",");
            int lineAbove = down ? info.toMove.endLine - 1 : info.toMove2.endLine - 1;
            int lineAboveEndOffset = document.getLineEndOffset(lineAbove);
            String aboveLineEnding = document.getText(new TextRange(lineAboveEndOffset - 1, lineAboveEndOffset));
            if (aboveLineEnding.equals(",")) {
                document.deleteString(lineAboveEndOffset - 1, lineAboveEndOffset);
            }
            Project project2 = editor.getProject();
            assert (project2 != null);
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        }
    }

    private boolean notFollowedByNextElementOrComma(@NotNull PsiElement anchor, @NotNull Class<? extends PsiElement> nextElementType) {
        if (anchor == null) {
            JsonLineMover.$$$reportNull$$$0(7);
        }
        if (nextElementType == null) {
            JsonLineMover.$$$reportNull$$$0(8);
        }
        return PsiTreeUtil.getNextSiblingOfType((PsiElement)anchor, nextElementType) == null && TreeUtil.findSibling(anchor.getNode(), JsonElementTypes.COMMA) == null;
    }

    private boolean isValidElementRange(@Nullable Pair<PsiElement, PsiElement> elementRange) {
        if (elementRange == null) {
            return false;
        }
        return ((PsiElement)elementRange.getFirst()).getParent() == ((PsiElement)elementRange.getSecond()).getParent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/editor/lineMover/JsonLineMover";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/editor/lineMover/JsonLineMover";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "expandCommentsInRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "expandCommentsInRange";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "beforeMove";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "notFollowedByNextElementOrComma";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

