/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

public class HtmlQuotesFormatPreprocessor
implements PreFormatProcessor {
    @Override
    @NotNull
    public TextRange process(@NotNull ASTNode node, @NotNull TextRange range) {
        PsiElement psiElement;
        if (node == null) {
            HtmlQuotesFormatPreprocessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            HtmlQuotesFormatPreprocessor.$$$reportNull$$$0(1);
        }
        if ((psiElement = node.getPsi()) != null && psiElement.isValid() && psiElement.getLanguage().is((Language)HTMLLanguage.INSTANCE)) {
            CodeStyleSettings rootSettings = CodeStyleSettingsManager.getSettings((Project)psiElement.getProject());
            HtmlCodeStyleSettings htmlSettings = (HtmlCodeStyleSettings)rootSettings.getCustomSettings(HtmlCodeStyleSettings.class);
            CodeStyleSettings.QuoteStyle quoteStyle = htmlSettings.HTML_QUOTE_STYLE;
            if (quoteStyle != CodeStyleSettings.QuoteStyle.None && htmlSettings.HTML_ENFORCE_QUOTES) {
                PostFormatProcessorHelper postFormatProcessorHelper = new PostFormatProcessorHelper((CommonCodeStyleSettings)rootSettings);
                postFormatProcessorHelper.setResultTextRange(range);
                HtmlQuotesConverter converter2 = new HtmlQuotesConverter(quoteStyle, psiElement, postFormatProcessorHelper);
                Document document = converter2.getDocument();
                if (document != null) {
                    DocumentUtil.executeInBulk(document, true, converter2);
                }
                TextRange textRange = postFormatProcessorHelper.getResultTextRange();
                if (textRange == null) {
                    HtmlQuotesFormatPreprocessor.$$$reportNull$$$0(2);
                }
                return textRange;
            }
        }
        TextRange textRange = range;
        if (textRange == null) {
            HtmlQuotesFormatPreprocessor.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/html/HtmlQuotesFormatPreprocessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/html/HtmlQuotesFormatPreprocessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class HtmlQuotesConverter
    extends XmlRecursiveElementVisitor
    implements Runnable {
        private TextRange myOriginalRange;
        private final Document myDocument;
        private final PsiDocumentManager myDocumentManager;
        private final PostFormatProcessorHelper myPostProcessorHelper;
        private final PsiElement myContext;
        private final String myNewQuote;

        public HtmlQuotesConverter(@NotNull CodeStyleSettings.QuoteStyle style, @NotNull PsiElement context, @NotNull PostFormatProcessorHelper postFormatProcessorHelper) {
            if (style == null) {
                HtmlQuotesConverter.$$$reportNull$$$0(0);
            }
            if (context == null) {
                HtmlQuotesConverter.$$$reportNull$$$0(1);
            }
            if (postFormatProcessorHelper == null) {
                HtmlQuotesConverter.$$$reportNull$$$0(2);
            }
            this.myPostProcessorHelper = postFormatProcessorHelper;
            Project project2 = context.getProject();
            PsiFile file2 = context.getContainingFile();
            this.myContext = context;
            this.myOriginalRange = postFormatProcessorHelper.getResultTextRange();
            this.myDocumentManager = PsiDocumentManager.getInstance((Project)project2);
            this.myDocument = file2.getViewProvider().getDocument();
            switch (style) {
                case Single: {
                    this.myNewQuote = "'";
                    break;
                }
                case Double: {
                    this.myNewQuote = "\"";
                    break;
                }
                default: {
                    this.myNewQuote = String.valueOf(0);
                }
            }
        }

        public Document getDocument() {
            return this.myDocument;
        }

        public void visitXmlAttributeValue(XmlAttributeValue value2) {
            PsiElement child;
            if (this.myOriginalRange.contains(value2.getTextRange()) && (child = value2.getFirstChild()) != null && !this.containsQuoteChars(value2)) {
                if (child.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                    CharSequence delimiterChars;
                    PsiElement lastChild = value2.getLastChild();
                    if (lastChild != null && lastChild.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && (delimiterChars = child.getNode().getChars()).length() == 1 && !StringUtil.equals((CharSequence)delimiterChars, (CharSequence)this.myNewQuote)) {
                        int startOffset = value2.getTextRange().getStartOffset();
                        int endOffset = value2.getTextRange().getEndOffset();
                        this.replaceString(startOffset, startOffset + 1, this.myNewQuote);
                        this.replaceString(endOffset - 1, endOffset, this.myNewQuote);
                    }
                } else if (child.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && child == value2.getLastChild()) {
                    this.insertString(child.getTextRange().getStartOffset(), this.myNewQuote);
                    this.insertString(child.getTextRange().getEndOffset(), this.myNewQuote);
                }
            }
        }

        private void replaceString(int start, int end, String newValue) {
            int mappedStart = this.myPostProcessorHelper.mapOffset(start);
            int mappedEnd = this.myPostProcessorHelper.mapOffset(end);
            this.myDocument.replaceString(mappedStart, mappedEnd, (CharSequence)newValue);
            this.myPostProcessorHelper.updateResultRange(end - start, newValue.length());
        }

        private void insertString(int offset, String value2) {
            int mappedOffset = this.myPostProcessorHelper.mapOffset(offset);
            this.myDocument.insertString(mappedOffset, (CharSequence)value2);
            this.myPostProcessorHelper.updateResultRange(0, value2.length());
        }

        private boolean containsQuoteChars(@NotNull XmlAttributeValue value2) {
            if (value2 == null) {
                HtmlQuotesConverter.$$$reportNull$$$0(3);
            }
            for (PsiElement child = value2.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (HtmlQuotesConverter.isDelimiter(child.getNode().getElementType()) || !StringUtil.contains((CharSequence)child.getNode().getChars(), (CharSequence)this.myNewQuote)) continue;
                return true;
            }
            return false;
        }

        private static boolean isDelimiter(@NotNull IElementType elementType) {
            if (elementType == null) {
                HtmlQuotesConverter.$$$reportNull$$$0(4);
            }
            return elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER || elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
        }

        @Override
        public void run() {
            if (this.myDocument != null) {
                this.myDocumentManager.doPostponedOperationsAndUnblockDocument(this.myDocument);
                this.myContext.accept((PsiElementVisitor)this);
                this.myDocumentManager.commitDocument(this.myDocument);
            }
        }

        public static void runOnElement(@NotNull CodeStyleSettings.QuoteStyle quoteStyle, @NotNull PsiElement element) {
            if (quoteStyle == null) {
                HtmlQuotesConverter.$$$reportNull$$$0(5);
            }
            if (element == null) {
                HtmlQuotesConverter.$$$reportNull$$$0(6);
            }
            PostFormatProcessorHelper postFormatProcessorHelper = new PostFormatProcessorHelper(null);
            postFormatProcessorHelper.setResultTextRange(element.getTextRange());
            new HtmlQuotesConverter(quoteStyle, element, postFormatProcessorHelper).run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "style";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "postFormatProcessorHelper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "quoteStyle";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containsQuoteChars";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDelimiter";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runOnElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

