/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.CompletionMemory;
import com.intellij.codeInsight.documentation.PlatformDocumentationUtil;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.javadoc.JavaDocExternalFilter;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.javadoc.JavaDocInfoGeneratorFactory;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.ide.util.PackageUtil;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.LangBundle;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebBrowserUrlProviderKt;

public class JavaDocumentationProvider
extends DocumentationProviderEx
implements CodeDocumentationProvider,
ExternalDocumentationProvider {
    private static final Logger LOG = Logger.getInstance(JavaDocumentationProvider.class);
    private static final String LINE_SEPARATOR = "\n";
    private static final String PARAM_TAG = "@param";
    private static final String RETURN_TAG = "@return";
    private static final String THROWS_TAG = "@throws";
    public static final String HTML_EXTENSION = ".html";
    public static final String PACKAGE_SUMMARY_FILE = "package-summary.html";

    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof PsiClass) {
            return JavaDocumentationProvider.generateClassInfo((PsiClass)element);
        }
        if (element instanceof PsiMethod) {
            return JavaDocumentationProvider.generateMethodInfo((PsiMethod)element, JavaDocumentationProvider.calcSubstitutor(originalElement));
        }
        if (element instanceof PsiField) {
            return JavaDocumentationProvider.generateFieldInfo((PsiField)element, JavaDocumentationProvider.calcSubstitutor(originalElement));
        }
        if (element instanceof PsiVariable) {
            return JavaDocumentationProvider.generateVariableInfo((PsiVariable)element);
        }
        if (element instanceof PsiPackage) {
            return JavaDocumentationProvider.generatePackageInfo((PsiPackage)element);
        }
        if (element instanceof BeanPropertyElement) {
            return JavaDocumentationProvider.generateMethodInfo(((BeanPropertyElement)element).getMethod(), PsiSubstitutor.EMPTY);
        }
        if (element instanceof PsiJavaModule) {
            return JavaDocumentationProvider.generateModuleInfo((PsiJavaModule)element);
        }
        return null;
    }

    private static PsiSubstitutor calcSubstitutor(PsiElement originalElement) {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (originalElement instanceof PsiReferenceExpression) {
            LOG.assertTrue(originalElement.isValid());
            substitutor = ((PsiReferenceExpression)originalElement).advancedResolve(true).getSubstitutor();
        }
        return substitutor;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return JavaDocumentationProvider.getExternalJavaDocUrl(element);
    }

    private static void newLine(StringBuilder buffer) {
        buffer.append("\n ");
    }

    private static void generateInitializer(StringBuilder buffer, PsiVariable variable) {
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null) {
            JavaDocInfoGenerator.appendExpressionValue(buffer, initializer, " = ");
            PsiExpression constantInitializer = JavaDocInfoGenerator.calcInitializerExpression(variable);
            if (constantInitializer != null) {
                buffer.append(LINE_SEPARATOR);
                JavaDocInfoGenerator.appendExpressionValue(buffer, constantInitializer, CodeInsightBundle.message((String)"javadoc.resolved.value", (Object[])new Object[0]));
            }
        }
    }

    private static void generateModifiers(StringBuilder buffer, PsiModifierListOwner element) {
        String modifiers = PsiFormatUtil.formatModifiers((PsiModifierListOwner)element, (int)16384);
        if (modifiers.length() > 0) {
            buffer.append(modifiers);
            buffer.append(" ");
        }
    }

    private static String generatePackageInfo(PsiPackage aPackage) {
        return aPackage.getQualifiedName();
    }

    private static void generateOrderEntryAndPackageInfo(StringBuilder buffer, @NotNull PsiElement element) {
        String packageName;
        PsiFile file2;
        if (element == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(0);
        }
        if ((file2 = element.getContainingFile()) != null) {
            JavaDocumentationProvider.generateOrderEntryInfo(buffer, file2.getVirtualFile(), element.getProject());
        }
        if (file2 instanceof PsiJavaFile && (packageName = ((PsiJavaFile)file2).getPackageName()).length() > 0) {
            buffer.append(packageName);
            JavaDocumentationProvider.newLine(buffer);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void generateOrderEntryInfo(StringBuilder buffer, VirtualFile file2, Project project2) {
        if (file2 == null) return;
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        if (!index.isInLibrarySource(file2) && !index.isInLibraryClasses(file2)) {
            Module module2 = index.getModuleForFile(file2);
            if (module2 == null) return;
            buffer.append('[').append(module2.getName()).append("] ");
            return;
        }
        index.getOrderEntriesForFile(file2).stream().filter(LibraryOrSdkOrderEntry.class::isInstance).findFirst().ifPresent(entry -> buffer.append('[').append(StringUtil.escapeXml((String)entry.getPresentableName())).append("] "));
    }

    public static String generateClassInfo(PsiClass aClass) {
        StringBuilder buffer = new StringBuilder();
        if (aClass instanceof PsiAnonymousClass) {
            return LangBundle.message("java.terms.anonymous.class", new Object[0]);
        }
        JavaDocumentationProvider.generateOrderEntryAndPackageInfo(buffer, (PsiElement)aClass);
        JavaDocumentationProvider.generateModifiers(buffer, (PsiModifierListOwner)aClass);
        String classString = aClass.isAnnotationType() ? "java.terms.annotation.interface" : (aClass.isInterface() ? "java.terms.interface" : (aClass instanceof PsiTypeParameter ? "java.terms.type.parameter" : (aClass.isEnum() ? "java.terms.enum" : "java.terms.class")));
        buffer.append(LangBundle.message(classString, new Object[0])).append(" ");
        buffer.append(JavaDocUtil.getShortestClassName(aClass, (PsiElement)aClass));
        JavaDocumentationProvider.generateTypeParameters((PsiTypeParameterListOwner)aClass, buffer);
        if (!aClass.isEnum() && !aClass.isAnnotationType()) {
            PsiReferenceList extendsList = aClass.getExtendsList();
            JavaDocumentationProvider.writeExtends(aClass, buffer, extendsList == null ? PsiClassType.EMPTY_ARRAY : extendsList.getReferencedTypes());
        }
        JavaDocumentationProvider.writeImplements(aClass, buffer, aClass.getImplementsListTypes());
        return buffer.toString();
    }

    public static void writeImplements(PsiClass aClass, StringBuilder buffer, PsiClassType[] refs) {
        if (refs.length > 0) {
            JavaDocumentationProvider.newLine(buffer);
            buffer.append("implements ");
            JavaDocumentationProvider.writeTypeRefs(aClass, buffer, refs);
        }
    }

    public static void writeExtends(PsiClass aClass, StringBuilder buffer, PsiClassType[] refs) {
        if (refs.length > 0 || !aClass.isInterface() && !"java.lang.Object".equals(aClass.getQualifiedName())) {
            buffer.append(" extends ");
            if (refs.length == 0) {
                buffer.append("Object");
            } else {
                JavaDocumentationProvider.writeTypeRefs(aClass, buffer, refs);
            }
        }
    }

    private static void writeTypeRefs(PsiClass aClass, StringBuilder buffer, PsiClassType[] refs) {
        for (int i = 0; i < refs.length; ++i) {
            JavaDocInfoGenerator.generateType(buffer, (PsiType)refs[i], (PsiElement)aClass, false, true);
            if (i >= refs.length - 1) continue;
            buffer.append(", ");
        }
    }

    public static void generateTypeParameters(PsiTypeParameterListOwner typeParameterOwner, StringBuilder buffer) {
        if (typeParameterOwner.hasTypeParameters()) {
            PsiTypeParameter[] params = typeParameterOwner.getTypeParameters();
            buffer.append("&lt;");
            for (int i = 0; i < params.length; ++i) {
                PsiTypeParameter p = params[i];
                buffer.append(p.getName());
                PsiClassType[] refs = p.getExtendsList().getReferencedTypes();
                if (refs.length > 0) {
                    buffer.append(" extends ");
                    for (int j = 0; j < refs.length; ++j) {
                        JavaDocInfoGenerator.generateType(buffer, (PsiType)refs[j], (PsiElement)typeParameterOwner, false, true);
                        if (j >= refs.length - 1) continue;
                        buffer.append(" & ");
                    }
                }
                if (i >= params.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append("&gt;");
        }
    }

    public static String generateMethodInfo(PsiMethod method, PsiSubstitutor substitutor) {
        StringBuilder buffer = new StringBuilder();
        PsiClass parentClass = method.getContainingClass();
        if (parentClass != null && !(parentClass instanceof PsiAnonymousClass)) {
            if (method.isConstructor()) {
                JavaDocumentationProvider.generateOrderEntryAndPackageInfo(buffer, (PsiElement)parentClass);
            }
            buffer.append(JavaDocUtil.getShortestClassName(parentClass, (PsiElement)method));
            JavaDocumentationProvider.newLine(buffer);
        }
        JavaDocumentationProvider.generateModifiers(buffer, (PsiModifierListOwner)method);
        JavaDocumentationProvider.generateTypeParameters((PsiTypeParameterListOwner)method, buffer);
        if (method.getReturnType() != null) {
            JavaDocInfoGenerator.generateType(buffer, substitutor.substitute(method.getReturnType()), (PsiElement)method, false, true);
            buffer.append(" ");
        }
        buffer.append(method.getName());
        buffer.append("(");
        PsiParameter[] params = method.getParameterList().getParameters();
        for (int i = 0; i < params.length; ++i) {
            PsiParameter param = params[i];
            JavaDocInfoGenerator.generateType(buffer, substitutor.substitute(param.getType()), (PsiElement)method, false, true);
            buffer.append(" ");
            if (param.getName() != null) {
                buffer.append(param.getName());
            }
            if (i >= params.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        PsiClassType[] refs = method.getThrowsList().getReferencedTypes();
        if (refs.length > 0) {
            JavaDocumentationProvider.newLine(buffer);
            buffer.append(" throws ");
            for (int i = 0; i < refs.length; ++i) {
                PsiClass throwsClass = refs[i].resolve();
                if (throwsClass != null) {
                    buffer.append(JavaDocUtil.getShortestClassName(throwsClass, (PsiElement)method));
                } else {
                    buffer.append(refs[i].getPresentableText());
                }
                if (i >= refs.length - 1) continue;
                buffer.append(", ");
            }
        }
        return buffer.toString();
    }

    private static String generateFieldInfo(PsiField field, PsiSubstitutor substitutor) {
        StringBuilder buffer = new StringBuilder();
        PsiClass parentClass = field.getContainingClass();
        if (parentClass != null && !(parentClass instanceof PsiAnonymousClass)) {
            buffer.append(JavaDocUtil.getShortestClassName(parentClass, (PsiElement)field));
            JavaDocumentationProvider.newLine(buffer);
        }
        JavaDocumentationProvider.generateModifiers(buffer, (PsiModifierListOwner)field);
        JavaDocInfoGenerator.generateType(buffer, substitutor.substitute(field.getType()), (PsiElement)field, false, true);
        buffer.append(" ");
        buffer.append(field.getName());
        JavaDocumentationProvider.generateInitializer(buffer, (PsiVariable)field);
        JavaDocInfoGenerator.enumConstantOrdinal(buffer, field, parentClass, LINE_SEPARATOR);
        return buffer.toString();
    }

    private static String generateVariableInfo(PsiVariable variable) {
        StringBuilder buffer = new StringBuilder();
        JavaDocumentationProvider.generateModifiers(buffer, (PsiModifierListOwner)variable);
        JavaDocInfoGenerator.generateType(buffer, variable.getType(), (PsiElement)variable, false, true);
        buffer.append(" ");
        buffer.append(variable.getName());
        JavaDocumentationProvider.generateInitializer(buffer, variable);
        return buffer.toString();
    }

    private static String generateModuleInfo(PsiJavaModule module2) {
        StringBuilder sb = new StringBuilder();
        VirtualFile file2 = PsiImplUtil.getModuleVirtualFile(module2);
        JavaDocumentationProvider.generateOrderEntryInfo(sb, file2, module2.getProject());
        sb.append(LangBundle.message("java.terms.module", new Object[0])).append(' ').append(module2.getName());
        return sb.toString();
    }

    public PsiComment findExistingDocComment(PsiComment comment) {
        PsiJavaDocumentedElement owner2;
        if (comment instanceof PsiDocComment && (owner2 = ((PsiDocComment)comment).getOwner()) != null) {
            return owner2.getDocComment();
        }
        return null;
    }

    @Nullable
    public Pair<PsiElement, PsiComment> parseContext(@NotNull PsiElement startPoint) {
        if (startPoint == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(1);
        }
        for (PsiElement current = startPoint; current != null; current = current.getParent()) {
            if (current instanceof PsiJavaDocumentedElement && !(current instanceof PsiTypeParameter) && !(current instanceof PsiAnonymousClass)) {
                PsiDocComment comment = ((PsiJavaDocumentedElement)current).getDocComment();
                return Pair.create((Object)(current instanceof PsiField ? ((PsiField)current).getModifierList() : current), (Object)comment);
            }
            if (!PackageUtil.isPackageInfoFile(current)) continue;
            return Pair.create((Object)current, (Object)JavaDocumentationProvider.getPackageInfoComment(current));
        }
        return null;
    }

    public String generateDocumentationContentStub(PsiComment _comment) {
        PsiTypeParameterList typeParameterList;
        PsiJavaDocumentedElement commentOwner = ((PsiDocComment)_comment).getOwner();
        Project project2 = _comment.getProject();
        StringBuilder builder = new StringBuilder();
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)LanguageCommenters.INSTANCE.forLanguage(_comment.getLanguage());
        if (commentOwner instanceof PsiMethod) {
            PsiJavaCodeReferenceElement[] references;
            PsiMethod psiMethod = (PsiMethod)commentOwner;
            JavaDocumentationProvider.generateParametersTakingDocFromSuperMethods(project2, builder, commenter, psiMethod);
            PsiTypeParameterList typeParameterList2 = psiMethod.getTypeParameterList();
            if (typeParameterList2 != null) {
                JavaDocumentationProvider.createTypeParamsListComment(builder, project2, commenter, typeParameterList2);
            }
            if (psiMethod.getReturnType() != null && !PsiType.VOID.equals((Object)psiMethod.getReturnType())) {
                builder.append(CodeDocumentationUtil.createDocCommentLine(RETURN_TAG, _comment.getContainingFile(), commenter));
                builder.append(LINE_SEPARATOR);
            }
            for (PsiJavaCodeReferenceElement reference : references = psiMethod.getThrowsList().getReferenceElements()) {
                builder.append(CodeDocumentationUtil.createDocCommentLine(THROWS_TAG, _comment.getContainingFile(), commenter));
                builder.append(reference.getText());
                builder.append(LINE_SEPARATOR);
            }
        } else if (commentOwner instanceof PsiClass && (typeParameterList = ((PsiClass)commentOwner).getTypeParameterList()) != null) {
            JavaDocumentationProvider.createTypeParamsListComment(builder, project2, commenter, typeParameterList);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    public static void generateParametersTakingDocFromSuperMethods(Project project2, StringBuilder builder, CodeDocumentationAwareCommenter commenter, PsiMethod psiMethod) {
        PsiMethod[] superMethods;
        PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
        HashMap param2Description = new HashMap();
        for (PsiMethod psiMethod2 : superMethods = psiMethod.findSuperMethods()) {
            PsiDocTag[] params;
            PsiDocComment comment = psiMethod2.getDocComment();
            if (comment == null) continue;
            for (PsiDocTag param : params = comment.findTagsByName("param")) {
                PsiElement[] dataElements = param.getDataElements();
                if (dataElements == null) continue;
                String paramName = null;
                for (PsiElement dataElement : dataElements) {
                    if (!(dataElement instanceof PsiDocParamRef)) continue;
                    paramName = dataElement.getReference().getCanonicalText();
                    break;
                }
                if (paramName == null) continue;
                param2Description.put(paramName, param.getText());
            }
        }
        for (PsiMethod psiMethod3 : parameters2) {
            String description = (String)param2Description.get(psiMethod3.getName());
            if (description != null) {
                builder.append(CodeDocumentationUtil.createDocCommentLine("", psiMethod.getContainingFile(), commenter));
                if (description.indexOf(10) > -1) {
                    description = description.substring(0, description.lastIndexOf(10));
                }
                builder.append(description);
            } else {
                builder.append(CodeDocumentationUtil.createDocCommentLine(PARAM_TAG, psiMethod.getContainingFile(), commenter));
                builder.append(psiMethod3.getName());
            }
            builder.append(LINE_SEPARATOR);
        }
    }

    public static void createTypeParamsListComment(StringBuilder buffer, Project project2, CodeDocumentationAwareCommenter commenter, PsiTypeParameterList typeParameterList) {
        PsiTypeParameter[] typeParameters;
        for (PsiTypeParameter typeParameter : typeParameters = typeParameterList.getTypeParameters()) {
            buffer.append(CodeDocumentationUtil.createDocCommentLine(PARAM_TAG, typeParameterList.getContainingFile(), commenter));
            buffer.append("<").append(typeParameter.getName()).append(">");
            buffer.append(LINE_SEPARATOR);
        }
    }

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        PsiElement elt;
        if (element instanceof PsiExpressionList || element instanceof PsiReferenceExpression && element.getParent() instanceof PsiMethodCallExpression) {
            element = element.getParent();
            originalElement = null;
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiMethod method = CompletionMemory.getChosenMethod((PsiCall)((PsiMethodCallExpression)element));
            if (method == null) {
                return this.getMethodCandidateInfo((PsiMethodCallExpression)element);
            }
            element = method;
        }
        PsiElement psiElement = elt = originalElement != null && !(originalElement instanceof PsiPackage) ? PsiTreeUtil.prevLeaf((PsiElement)originalElement) : element;
        if (elt instanceof PsiErrorElement) {
            elt = elt.getPrevSibling();
        } else if (elt != null && !(elt instanceof PsiNewExpression)) {
            elt = elt.getParent();
        }
        if (elt instanceof PsiNewExpression) {
            PsiMethod[] constructors;
            PsiElement resolve2;
            PsiJavaCodeReferenceElement reference;
            PsiClass targetClass = null;
            if (element instanceof PsiJavaCodeReferenceElement) {
                PsiElement resolve3 = ((PsiJavaCodeReferenceElement)element).resolve();
                if (resolve3 instanceof PsiClass) {
                    targetClass = (PsiClass)resolve3;
                }
            } else if (element instanceof PsiClass) {
                targetClass = (PsiClass)element;
            } else if (element instanceof PsiNewExpression && (reference = ((PsiNewExpression)element).getClassReference()) != null && (resolve2 = reference.resolve()) instanceof PsiClass) {
                targetClass = (PsiClass)resolve2;
            }
            if (targetClass != null && (constructors = targetClass.getConstructors()).length > 0) {
                if (constructors.length == 1) {
                    return this.generateDoc((PsiElement)constructors[0], originalElement);
                }
                StringBuilder sb = new StringBuilder();
                for (PsiMethod constructor : constructors) {
                    String str = PsiFormatUtil.formatMethod((PsiMethod)constructor, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)259, (int)3);
                    JavaDocumentationProvider.createElementLink(sb, (PsiElement)constructor, StringUtil.escapeXml((String)str));
                }
                return CodeInsightBundle.message((String)"javadoc.constructor.candidates", (Object[])new Object[]{targetClass.getName(), sb});
            }
        }
        return JavaDocumentationProvider.generateExternalJavadoc(element);
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    public static String generateExternalJavadoc(@NotNull PsiElement element) {
        if (element == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(2);
        }
        List<String> docURLs = JavaDocumentationProvider.getExternalJavaDocUrl(element);
        return JavaDocumentationProvider.generateExternalJavadoc(element, docURLs);
    }

    @Nullable
    public static String generateExternalJavadoc(@NotNull PsiElement element, @Nullable List<String> docURLs) {
        if (element == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(3);
        }
        JavaDocInfoGenerator javaDocInfoGenerator = JavaDocInfoGeneratorFactory.create(element.getProject(), element);
        return JavaDocumentationProvider.generateExternalJavadoc(javaDocInfoGenerator, docURLs);
    }

    @Nullable
    public static String generateExternalJavadoc(@NotNull PsiElement element, @NotNull JavaDocInfoGenerator generator) {
        if (element == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (generator == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(5);
        }
        List<String> docURLs = JavaDocumentationProvider.getExternalJavaDocUrl(element);
        return JavaDocumentationProvider.generateExternalJavadoc(generator, docURLs);
    }

    @Nullable
    private static String generateExternalJavadoc(@NotNull JavaDocInfoGenerator generator, @Nullable List<String> docURLs) {
        if (generator == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(6);
        }
        return JavaDocExternalFilter.filterInternalDocInfo(generator.generateDocInfo(docURLs));
    }

    @Nullable
    private static String fetchExternalJavadoc(PsiElement element, String fromUrl, @NotNull JavaDocExternalFilter filter2) {
        if (filter2 == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(7);
        }
        try {
            String externalDoc = filter2.getExternalDocInfoForElement(fromUrl, element);
            if (!StringUtil.isEmpty((String)externalDoc)) {
                return externalDoc;
            }
        }
        catch (ProcessCanceledException externalDoc) {
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        return null;
    }

    private String getMethodCandidateInfo(PsiMethodCallExpression expr) {
        PsiResolveHelper rh = JavaPsiFacade.getInstance((Project)expr.getProject()).getResolveHelper();
        CandidateInfo[] candidates = rh.getReferencedMethodCandidates((PsiCallExpression)expr, true);
        String text2 = expr.getText();
        if (candidates.length > 0) {
            PsiElement element;
            if (candidates.length == 1 && (element = candidates[0].getElement()) instanceof PsiMethod) {
                return this.generateDoc(element, null);
            }
            StringBuilder sb = new StringBuilder();
            for (CandidateInfo candidate : candidates) {
                PsiElement element2 = candidate.getElement();
                if (!(element2 instanceof PsiMethod)) continue;
                String str = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element2), (PsiSubstitutor)candidate.getSubstitutor(), (int)259, (int)2);
                JavaDocumentationProvider.createElementLink(sb, element2, StringUtil.escapeXml((String)str));
            }
            return CodeInsightBundle.message((String)"javadoc.candidates", (Object[])new Object[]{text2, sb});
        }
        return CodeInsightBundle.message((String)"javadoc.candidates.not.found", (Object[])new Object[]{text2});
    }

    private static void createElementLink(StringBuilder sb, PsiElement element, String str) {
        sb.append("&nbsp;&nbsp;<a href=\"psi_element://");
        sb.append(JavaDocUtil.getReferenceText(element.getProject(), element));
        sb.append("\">");
        sb.append(str);
        sb.append("</a>");
        sb.append("<br>");
    }

    @Nullable
    public static List<String> getExternalJavaDocUrl(PsiElement element) {
        PsiPackage aPackage;
        PsiClass aClass;
        List<String> urls = null;
        if (element instanceof PsiClass) {
            urls = JavaDocumentationProvider.findUrlForClass((PsiClass)element);
        } else if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            aClass = field.getContainingClass();
            if (aClass != null && (urls = JavaDocumentationProvider.findUrlForClass(aClass)) != null) {
                for (int i = 0; i < urls.size(); ++i) {
                    urls.set(i, urls.get(i) + "#" + field.getName());
                }
            }
        } else if (element instanceof PsiMethod) {
            List<String> classUrls;
            PsiMethod method = (PsiMethod)element;
            aClass = method.getContainingClass();
            if (aClass != null && (classUrls = JavaDocumentationProvider.findUrlForClass(aClass)) != null) {
                urls = ContainerUtil.newSmartList();
                boolean useJava8Format = PsiUtil.isLanguageLevel8OrHigher((PsiElement)method);
                Set<String> signatures = JavaDocumentationProvider.getHtmlMethodSignatures(method, useJava8Format);
                for (String signature : signatures) {
                    for (String classUrl : classUrls) {
                        urls.add(classUrl + "#" + signature);
                    }
                }
            }
        } else if (element instanceof PsiPackage) {
            urls = JavaDocumentationProvider.findUrlForPackage((PsiPackage)element);
        } else if (element instanceof PsiDirectory && (aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element)) != null) {
            urls = JavaDocumentationProvider.findUrlForPackage(aPackage);
        }
        if (urls == null || urls.isEmpty()) {
            return null;
        }
        for (int i = 0; i < urls.size(); ++i) {
            urls.set(i, FileUtil.toSystemIndependentName((String)urls.get(i)));
        }
        return urls;
    }

    public static Set<String> getHtmlMethodSignatures(PsiMethod method, boolean java8FormatFirst) {
        LinkedHashSet<String> signatures = new LinkedHashSet<String>();
        signatures.add(JavaDocumentationProvider.formatMethodSignature(method, true, java8FormatFirst));
        signatures.add(JavaDocumentationProvider.formatMethodSignature(method, false, java8FormatFirst));
        signatures.add(JavaDocumentationProvider.formatMethodSignature(method, true, !java8FormatFirst));
        signatures.add(JavaDocumentationProvider.formatMethodSignature(method, false, !java8FormatFirst));
        return signatures;
    }

    private static String formatMethodSignature(PsiMethod method, boolean raw, boolean java8Format) {
        int options = 257;
        int parameterOptions = 8194;
        if (raw) {
            options |= 0x20000;
            parameterOptions |= 0x20000;
        }
        String signature = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)parameterOptions, (int)999);
        if (java8Format) {
            signature = signature.replaceAll("\\(|\\)|, ", "-").replaceAll("\\[\\]", ":A");
        }
        return signature;
    }

    @Nullable
    public static PsiDocComment getPackageInfoComment(@NotNull PsiElement packageInfoFile) {
        if (packageInfoFile == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(8);
        }
        return (PsiDocComment)PsiTreeUtil.getChildOfType((PsiElement)packageInfoFile, PsiDocComment.class);
    }

    @Nullable
    public static List<String> findUrlForClass(@NotNull PsiClass aClass) {
        String qName;
        if (aClass == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(9);
        }
        if ((qName = aClass.getQualifiedName()) == null) {
            return null;
        }
        PsiFile file2 = aClass.getContainingFile();
        if (!(file2 instanceof PsiJavaFile)) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String packageName = ((PsiJavaFile)file2).getPackageName();
        String relPath = packageName.isEmpty() ? qName + HTML_EXTENSION : packageName.replace('.', '/') + '/' + qName.substring(packageName.length() + 1) + HTML_EXTENSION;
        return JavaDocumentationProvider.findUrlForVirtualFile(file2.getProject(), virtualFile, relPath);
    }

    @Nullable
    public static List<String> findUrlForVirtualFile(@NotNull Project project2, @NotNull VirtualFile virtualFile, @NotNull String relPath) {
        String[] javadocPaths;
        List<String> httpRoots;
        VirtualFile jar;
        VirtualFileSystem fs;
        ProjectFileIndex fileIndex;
        Module module2;
        if (project2 == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (virtualFile == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(11);
        }
        if (relPath == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(12);
        }
        if ((module2 = (fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex()).getModuleForFile(virtualFile)) == null && (fs = virtualFile.getFileSystem()) instanceof JarFileSystem && (jar = ((JarFileSystem)fs).getVirtualFileForJar(virtualFile)) != null) {
            module2 = fileIndex.getModuleForFile(jar);
        }
        if (!(module2 == null || (httpRoots = PlatformDocumentationUtil.getHttpRoots(javadocPaths = JavaModuleExternalPaths.getInstance((Module)module2).getJavadocUrls(), relPath)) == null && fileIndex.isInLibraryClasses(virtualFile))) {
            return httpRoots;
        }
        for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(virtualFile)) {
            for (VirtualFile root : orderEntry.getFiles(JavadocOrderRootType.getInstance())) {
                List<Url> urls;
                if (root.getFileSystem() != JarFileSystem.getInstance()) continue;
                VirtualFile file2 = root.findFileByRelativePath(relPath);
                List<Url> list2 = urls = file2 == null ? null : BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls(file2, project2, null);
                if (ContainerUtil.isEmpty(urls)) continue;
                SmartList result2 = new SmartList();
                for (Url url : urls) {
                    result2.add(url.toExternalForm());
                }
                return result2;
            }
            List<String> httpRoot = PlatformDocumentationUtil.getHttpRoots(JavadocOrderRootType.getUrls(orderEntry), relPath);
            if (httpRoot == null) continue;
            return httpRoot;
        }
        return null;
    }

    @Nullable
    public static List<String> findUrlForPackage(PsiPackage aPackage) {
        String qName = aPackage.getQualifiedName();
        qName = qName.replace('.', '/') + '/' + PACKAGE_SUMMARY_FILE;
        for (PsiDirectory directory : aPackage.getDirectories()) {
            List<String> url = JavaDocumentationProvider.findUrlForVirtualFile(aPackage.getProject(), directory.getVirtualFile(), qName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return JavaDocUtil.findReferenceTarget(psiManager, link, context);
    }

    public String fetchExternalDocumentation(Project project2, PsiElement element, List<String> docUrls) {
        return JavaDocumentationProvider.fetchExternalJavadoc(element, project2, docUrls);
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)this, (PsiElement)element, (PsiElement)originalElement);
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file2, @Nullable PsiElement contextElement) {
        PsiDirectory directory;
        PsiDocComment docComment;
        if (editor == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(14);
        }
        if ((docComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PsiDocComment.class, (boolean)false)) != null && JavaDocUtil.isInsidePackageInfo(docComment) && (directory = file2.getContainingDirectory()) != null) {
            return JavaDirectoryService.getInstance().getPackage(directory);
        }
        return null;
    }

    public static String fetchExternalJavadoc(PsiElement element, Project project2, List<String> docURLs) {
        return JavaDocumentationProvider.fetchExternalJavadoc(element, docURLs, new JavaDocExternalFilter(project2));
    }

    public static String fetchExternalJavadoc(PsiElement element, List<String> docURLs, @NotNull JavaDocExternalFilter docFilter) {
        if (docFilter == null) {
            JavaDocumentationProvider.$$$reportNull$$$0(15);
        }
        if (docURLs != null) {
            for (String docURL : docURLs) {
                try {
                    String javadoc = JavaDocumentationProvider.fetchExternalJavadoc(element, docURL, docFilter);
                    if (javadoc == null) continue;
                    return javadoc;
                }
                catch (IndexNotReadyException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageInfoFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docFilter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/java/JavaDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateOrderEntryAndPackageInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "generateExternalJavadoc";
                break;
            }
            case 7: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchExternalJavadoc";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageInfoComment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findUrlForClass";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "findUrlForVirtualFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomDocumentationElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

