/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionValidatorUtil {
    private InspectionValidatorUtil() {
    }

    public static void addDescriptor(@NotNull Collection<VirtualFile> result2, @Nullable ConfigFile configFile) {
        if (result2 == null) {
            InspectionValidatorUtil.$$$reportNull$$$0(0);
        }
        if (configFile != null) {
            ContainerUtil.addIfNotNull(result2, (Object)configFile.getVirtualFile());
        }
    }

    public static void addFile(@NotNull Collection<VirtualFile> result2, @Nullable PsiFile psiFile) {
        if (result2 == null) {
            InspectionValidatorUtil.$$$reportNull$$$0(1);
        }
        if (psiFile != null) {
            ContainerUtil.addIfNotNull(result2, (Object)psiFile.getVirtualFile());
        }
    }

    public static Collection<VirtualFile> expandCompileScopeIfNeeded(Collection<VirtualFile> result2, CompileContext context) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex();
        THashSet set2 = new THashSet();
        THashSet modules = new THashSet();
        for (VirtualFile file2 : result2) {
            if (index.getSourceRootForFile(file2) != null) continue;
            set2.add((Object)file2);
            ContainerUtil.addIfNotNull((Collection)modules, (Object)index.getModuleForFile(file2));
        }
        if (!set2.isEmpty()) {
            ((CompileContextEx)context).addScope(new FileSetCompileScope((Collection<VirtualFile>)set2, (Module[])modules.toArray((Object[])new Module[modules.size()])));
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "result";
        objectArray2[1] = "com/intellij/openapi/compiler/util/InspectionValidatorUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

