/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.actions.MergeActionGroup;
import com.intellij.openapi.diff.actions.MergeOperations;
import com.intellij.openapi.diff.impl.DiffLineMarkerRenderer;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.EditorSource;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.InlineFragment;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.util.GutterActionRenderer;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffMarkup
implements EditorSource,
Disposable {
    private static final Logger LOG = Logger.getInstance(DiffMarkup.class);
    private static final int LAYER = 5999;
    private final ArrayList<RangeHighlighter> myExtraHighLighters;
    private final ArrayList<RangeHighlighter> myHighLighters;
    private final HashSet<RangeHighlighter> myActionHighlighters;
    @Nullable
    private final Project myProject;
    private final List<Disposable> myDisposables;
    private boolean myDisposed;

    protected DiffMarkup(@Nullable Project project2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DiffMarkup.$$$reportNull$$$0(0);
        }
        this.myExtraHighLighters = new ArrayList();
        this.myHighLighters = new ArrayList();
        this.myActionHighlighters = new HashSet();
        this.myDisposables = new ArrayList<Disposable>();
        this.myDisposed = false;
        this.myProject = project2;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @Nullable
    private MarkupModel getMarkupModel() {
        EditorEx editor = this.getEditor();
        return editor == null ? null : editor.getMarkupModel();
    }

    public void highlightText(@NotNull Fragment fragment, @Nullable GutterIconRenderer gutterIconRenderer) {
        RangeHighlighter rangeMarker;
        if (fragment == null) {
            DiffMarkup.$$$reportNull$$$0(1);
        }
        MarkupModel markupModel = this.getMarkupModel();
        EditorEx editor = this.getEditor();
        TextDiffTypeEnum diffTypeEnum = fragment.getType();
        if (diffTypeEnum == null || markupModel == null || editor == null) {
            return;
        }
        TextDiffType type2 = fragment instanceof LineFragment ? DiffUtil.makeTextDiffType((LineFragment)fragment) : TextDiffType.create(diffTypeEnum);
        TextRange range = fragment.getRange(this.getSide());
        final TextAttributes attributes = type2.getTextAttributes(editor);
        if (attributes == null) {
            return;
        }
        if (range.getLength() == 0) {
            int offset = range.getStartOffset();
            rangeMarker = markupModel.addRangeHighlighter(offset, offset, 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
            rangeMarker.setCustomRenderer(new CustomHighlighterRenderer(){

                public void paint(@NotNull Editor ed, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
                    if (ed == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (highlighter == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (g == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    g.setColor(attributes.getBackgroundColor());
                    Point point = ed.logicalPositionToXY(ed.offsetToLogicalPosition(highlighter.getStartOffset()));
                    int endy = point.y + ed.getLineHeight() - 1;
                    g.drawLine(point.x, point.y, point.x, endy);
                    g.drawLine(point.x - 1, point.y, point.x - 1, endy);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "ed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "highlighter";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "g";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/diff/impl/highlighting/DiffMarkup$1";
                    objectArray[2] = "paint";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        } else {
            rangeMarker = markupModel.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
        }
        if (gutterIconRenderer != null) {
            rangeMarker.setGutterIconRenderer(gutterIconRenderer);
        }
        DiffMarkup.setLineMarkerRenderer(rangeMarker, fragment, type2);
        rangeMarker.setThinErrorStripeMark(true);
        if (DiffUtil.isInlineWrapper(fragment)) {
            rangeMarker.setErrorStripeMarkColor(null);
        }
        this.saveHighlighter(rangeMarker);
    }

    private static void setLineMarkerRenderer(RangeHighlighter rangeMarker, Fragment fragment, TextDiffType type2) {
        if (!(fragment instanceof InlineFragment)) {
            rangeMarker.setLineMarkerRenderer((LineMarkerRenderer)DiffLineMarkerRenderer.createInstance(type2));
        }
    }

    public void addLineMarker(int line, @Nullable TextDiffType type2, SeparatorPlacement separatorPlacement) {
        RangeHighlighter marker = this.createLineMarker(type2, line, separatorPlacement);
        if (marker != null) {
            this.saveHighlighter(marker);
        }
    }

    @Nullable
    private RangeHighlighter createLineMarker(final @Nullable TextDiffType type2, int line, SeparatorPlacement placement) {
        MarkupModel markupModel = this.getMarkupModel();
        Document document = this.getDocument();
        if (markupModel == null || document == null || type2 == null) {
            return null;
        }
        final Color color = this.getLineSeparatorColorForType(type2);
        if (color == null) {
            return null;
        }
        RangeHighlighter marker = markupModel.addLineHighlighter(line, 5999, null);
        marker.setLineSeparatorColor(color);
        marker.setLineSeparatorPlacement(placement);
        marker.setLineSeparatorRenderer(new LineSeparatorRenderer(){

            public void drawLine(Graphics g, int x1, int x2, int y) {
                if (type2.isInlineWrapper()) {
                    UIUtil.drawLine((Graphics2D)((Graphics2D)g), (int)x1, (int)y, (int)x2, (int)y, null, (Color)DiffUtil.getFramingColor(color));
                } else {
                    DiffUtil.drawDoubleShadowedLine((Graphics2D)g, x1, x2, y, color);
                }
            }
        });
        return marker;
    }

    @Nullable
    private Color getLineSeparatorColorForType(@NotNull TextDiffType type2) {
        EditorEx editor;
        if (type2 == null) {
            DiffMarkup.$$$reportNull$$$0(2);
        }
        if ((editor = this.getEditor()) == null) {
            return null;
        }
        return type2.getPolygonColor(editor);
    }

    private void saveHighlighter(@NotNull RangeHighlighter marker) {
        if (marker == null) {
            DiffMarkup.$$$reportNull$$$0(3);
        }
        this.myHighLighters.add(marker);
    }

    @Nullable
    public Document getDocument() {
        EditorEx editor = this.getEditor();
        return editor == null ? null : editor.getDocument();
    }

    public void addAction(@Nullable MergeOperations.Operation operation, int lineStartOffset) {
        RangeHighlighter highlighter = this.createAction(operation, lineStartOffset);
        if (highlighter != null) {
            this.myActionHighlighters.add((Object)highlighter);
        }
    }

    @Nullable
    private RangeHighlighter createAction(@Nullable MergeOperations.Operation operation, int lineStartOffset) {
        MarkupModel markupModel = this.getMarkupModel();
        if (operation == null || markupModel == null) {
            return null;
        }
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(lineStartOffset, lineStartOffset, 3000, new TextAttributes(null, null, null, null, 0), HighlighterTargetArea.LINES_IN_RANGE);
        MergeActionGroup.OperationAction action = new MergeActionGroup.OperationAction(operation);
        highlighter.setGutterIconRenderer((GutterIconRenderer)new GutterActionRenderer((AnAction)action));
        return highlighter;
    }

    public void resetHighlighters() {
        this.removeHighlighters(this.myHighLighters);
        this.removeHighlighters((Collection<RangeHighlighter>)this.myActionHighlighters);
        for (RangeHighlighter highLighter : this.myExtraHighLighters) {
            highLighter.dispose();
        }
        this.myExtraHighLighters.clear();
    }

    private void removeHighlighters(@NotNull Collection<RangeHighlighter> highlighters) {
        MarkupModel markupModel;
        if (highlighters == null) {
            DiffMarkup.$$$reportNull$$$0(4);
        }
        if ((markupModel = this.getMarkupModel()) != null) {
            for (RangeHighlighter highlighter : highlighters) {
                highlighter.dispose();
            }
        }
        highlighters.clear();
    }

    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    protected void runRegisteredDisposables() {
        this.resetHighlighters();
        for (Disposable runnable2 : this.myDisposables) {
            Disposer.dispose((Disposable)runnable2);
        }
        this.myDisposables.clear();
    }

    @Override
    public void addDisposable(@NotNull Disposable disposable) {
        if (disposable == null) {
            DiffMarkup.$$$reportNull$$$0(5);
        }
        Disposer.register((Disposable)this, (Disposable)disposable);
        this.myDisposables.add(disposable);
    }

    @Nullable
    public String getText() {
        Document document = this.getDocument();
        return document == null ? null : document.getText();
    }

    protected final boolean isDisposed() {
        return this.myDisposed;
    }

    public final void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.onDisposed();
        this.myDisposed = true;
    }

    protected void onDisposed() {
    }

    public void removeActions() {
        this.removeHighlighters((Collection<RangeHighlighter>)this.myActionHighlighters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/highlighting/DiffMarkup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineSeparatorColorForType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "saveHighlighter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeHighlighters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addDisposable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

