/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeHighlighterHolder;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

class SimpleChange
extends Change
implements DiffRangeMarker.RangeInvalidListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.Change");
    private ChangeType myType;
    private final Change.SimpleChangeSide[] mySides;
    private final ChangeList myChangeList;

    SimpleChange(@NotNull ChangeType type2, @NotNull TextRange range1, @NotNull TextRange range2, @NotNull ChangeList changeList) {
        if (type2 == null) {
            SimpleChange.$$$reportNull$$$0(0);
        }
        if (range1 == null) {
            SimpleChange.$$$reportNull$$$0(1);
        }
        if (range2 == null) {
            SimpleChange.$$$reportNull$$$0(2);
        }
        if (changeList == null) {
            SimpleChange.$$$reportNull$$$0(3);
        }
        this.mySides = new Change.SimpleChangeSide[]{this.createSide(changeList, range1, FragmentSide.SIDE1), this.createSide(changeList, range2, FragmentSide.SIDE2)};
        this.myType = type2;
        this.myChangeList = changeList;
    }

    @NotNull
    private Change.SimpleChangeSide createSide(@NotNull ChangeList changeList, @NotNull TextRange range1, @NotNull FragmentSide side) {
        if (changeList == null) {
            SimpleChange.$$$reportNull$$$0(4);
        }
        if (range1 == null) {
            SimpleChange.$$$reportNull$$$0(5);
        }
        if (side == null) {
            SimpleChange.$$$reportNull$$$0(6);
        }
        Change.SimpleChangeSide simpleChangeSide = new Change.SimpleChangeSide(side, new DiffRangeMarker(changeList.getDocument(side), range1, this));
        if (simpleChangeSide == null) {
            SimpleChange.$$$reportNull$$$0(7);
        }
        return simpleChangeSide;
    }

    @Override
    protected void changeSide(@NotNull ChangeSide sideToChange, @NotNull DiffRangeMarker newRange) {
        if (sideToChange == null) {
            SimpleChange.$$$reportNull$$$0(8);
        }
        if (newRange == null) {
            SimpleChange.$$$reportNull$$$0(9);
        }
        for (int i = 0; i < this.mySides.length; ++i) {
            Change.SimpleChangeSide side = this.mySides[i];
            if (!side.equals(sideToChange)) continue;
            this.mySides[i] = new Change.SimpleChangeSide(sideToChange, newRange);
            break;
        }
    }

    @Override
    protected void removeFromList() {
        this.myChangeList.remove(this);
    }

    @Override
    @NotNull
    public ChangeSide getChangeSide(@NotNull FragmentSide side) {
        if (side == null) {
            SimpleChange.$$$reportNull$$$0(10);
        }
        Change.SimpleChangeSide simpleChangeSide = this.mySides[side.getIndex()];
        if (simpleChangeSide == null) {
            SimpleChange.$$$reportNull$$$0(11);
        }
        return simpleChangeSide;
    }

    @Override
    public ChangeType getType() {
        return this.myType;
    }

    @Override
    public ChangeList getChangeList() {
        return this.myChangeList;
    }

    @Override
    public void onApplied() {
        this.myType = ChangeType.deriveApplied(this.myType);
        for (Change.SimpleChangeSide side : this.mySides) {
            ChangeHighlighterHolder highlighterHolder = side.getHighlighterHolder();
            highlighterHolder.setActions(AnAction.EMPTY_ARRAY);
            highlighterHolder.updateHighlighter(side, this.myType);
        }
        this.myChangeList.apply(this);
    }

    @Override
    public void onRemovedFromList() {
        for (int i = 0; i < this.mySides.length; ++i) {
            Change.SimpleChangeSide side = this.mySides[i];
            side.getRange().removeListener(this);
            side.getHighlighterHolder().removeHighlighters();
            this.mySides[i] = null;
        }
    }

    @Override
    public boolean isValid() {
        LOG.assertTrue(this.mySides[0] == null == (this.mySides[1] == null));
        return this.mySides[0] != null;
    }

    @Override
    public void onRangeInvalidated() {
        this.myChangeList.remove(this);
    }

    static Change fromRanges(@NotNull TextRange baseRange, @NotNull TextRange versionRange, @NotNull ChangeList changeList) {
        if (baseRange == null) {
            SimpleChange.$$$reportNull$$$0(12);
        }
        if (versionRange == null) {
            SimpleChange.$$$reportNull$$$0(13);
        }
        if (changeList == null) {
            SimpleChange.$$$reportNull$$$0(14);
        }
        ChangeType type2 = ChangeType.fromRanges(baseRange, versionRange);
        return new SimpleChange(type2, baseRange, versionRange, changeList);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range2";
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/incrementalMerge/SimpleChange";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sideToChange";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRange";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseRange";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/SimpleChange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSide";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeSide";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSide";
                break;
            }
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "changeSide";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChangeSide";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fromRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

