/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlipCommaIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            FlipCommaIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Flip ','" == null) {
            FlipCommaIntention.$$$reportNull$$$0(1);
        }
        return "Flip ','";
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement comma;
        if (project2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(4);
        }
        if ((comma = FlipCommaIntention.currentCommaElement(editor, file2)) == null) {
            return false;
        }
        PsiElement left = FlipCommaIntention.smartAdvance(comma, false);
        PsiElement right = FlipCommaIntention.smartAdvance(comma, true);
        return left != null && right != null && !left.getText().equals(right.getText());
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement element;
        if (project2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(7);
        }
        if ((element = FlipCommaIntention.currentCommaElement(editor, file2)) != null) {
            FlipCommaIntention.swapAtComma(element);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void swapAtComma(@NotNull PsiElement comma) {
        if (comma == null) {
            FlipCommaIntention.$$$reportNull$$$0(8);
        }
        PsiElement prev = FlipCommaIntention.smartAdvance(comma, false);
        PsiElement next = FlipCommaIntention.smartAdvance(comma, true);
        if (prev != null && next != null) {
            if (Flipper.tryFlip(prev, next)) {
                return;
            }
            PsiElement copy = prev.copy();
            prev.replace(next);
            next.replace(copy);
        }
    }

    private static PsiElement currentCommaElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement element;
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(10);
        }
        if (!FlipCommaIntention.isComma(element = FlipCommaIntention.leftElement(editor, file2)) && !FlipCommaIntention.isComma(element = FlipCommaIntention.rightElement(editor, file2))) {
            return null;
        }
        return element;
    }

    @Nullable
    private static PsiElement leftElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(12);
        }
        return file2.findElementAt(editor.getCaretModel().getOffset() - 1);
    }

    @Nullable
    private static PsiElement rightElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(14);
        }
        return file2.findElementAt(editor.getCaretModel().getOffset());
    }

    private static boolean isComma(@Nullable PsiElement element) {
        return element != null && element.getText().equals(",");
    }

    @NotNull
    private static JBIterable<PsiElement> getSiblings(PsiElement element, boolean fwd) {
        SyntaxTraverser.ApiEx api = fwd ? SyntaxTraverser.psiApi() : SyntaxTraverser.psiApiReversed();
        JBIterable flatSiblings = JBIterable.generate((Object)element, arg_0 -> ((SyntaxTraverser.ApiEx)api).next(arg_0)).skip(1);
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.syntaxTraverser((SyntaxTraverser.Api)api).withRoots((Iterable)flatSiblings)).expandAndSkip(e -> api.typeOf(e) == GeneratedParserUtilBase.DUMMY_BLOCK)).traverse();
        if (jBIterable == null) {
            FlipCommaIntention.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    private static boolean isFlippable(PsiElement e) {
        if (e instanceof PsiWhiteSpace || e instanceof PsiComment) {
            return false;
        }
        return StringUtil.isNotEmpty((String)e.getText());
    }

    @Nullable
    private static PsiElement smartAdvance(PsiElement element, boolean fwd) {
        PsiElement candidate = (PsiElement)FlipCommaIntention.getSiblings(element, fwd).filter(e -> FlipCommaIntention.isFlippable(e)).first();
        if (candidate != null && FlipCommaIntention.isBrace(candidate)) {
            return null;
        }
        return candidate;
    }

    private static boolean isBrace(@NotNull PsiElement candidate) {
        PairedBraceMatcher braceMatcher;
        ASTNode node;
        if (candidate == null) {
            FlipCommaIntention.$$$reportNull$$$0(16);
        }
        if ((node = candidate.getNode()) != null && node.getFirstChildNode() == null && (braceMatcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(candidate.getLanguage())) != null) {
            IElementType elementType = node.getElementType();
            for (BracePair pair2 : braceMatcher.getPairs()) {
                if (elementType != pair2.getLeftBraceType() && elementType != pair2.getRightBraceType()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/FlipCommaIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comma";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/FlipCommaIntention";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "swapAtComma";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "currentCommaElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "leftElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "rightElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isBrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Flipper {
        public static final LanguageExtension<Flipper> EXTENSION = new LanguageExtension("com.intellij.flipCommaIntention.flipper");

        public boolean flip(PsiElement var1, PsiElement var2);

        public static boolean tryFlip(PsiElement left, PsiElement right) {
            Language language = left.getLanguage();
            for (Flipper handler2 : EXTENSION.allForLanguage(language)) {
                if (!handler2.flip(left, right)) continue;
                return true;
            }
            return false;
        }
    }
}

