/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorsSchemeImpl
extends AbstractColorsScheme
implements ExternalizableScheme {
    private final Map<TextAttributesKey, TextAttributes> myAttributesTempMap = ContainerUtil.newConcurrentMap();

    public EditorColorsSchemeImpl(EditorColorsScheme parentScheme) {
        super(parentScheme);
    }

    @Override
    public void copyTo(AbstractColorsScheme newScheme) {
        super.copyTo(newScheme);
        this.myAttributesTempMap.clear();
    }

    public void setAttributes(@NotNull TextAttributesKey key2, @NotNull TextAttributes attributes) {
        if (key2 == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(1);
        }
        if (TextAttributesKey.isTemp((TextAttributesKey)key2)) {
            this.myAttributesTempMap.put(key2, attributes);
        } else if (attributes == INHERITED_ATTRS_MARKER || !Comparing.equal((Object)attributes, (Object)this.getAttributes(key2))) {
            this.myAttributesMap.put(key2, attributes);
            this.myAttributesTempMap.clear();
        }
    }

    public void setColor(ColorKey key2, Color color) {
        if (color == INHERITED_COLOR_MARKER || !Comparing.equal((Object)color, (Object)this.getColor(key2))) {
            this.myColorsMap.put(key2, ObjectUtils.notNull((Object)color, (Object)NULL_COLOR_MARKER));
        }
    }

    public TextAttributes getAttributes(@Nullable TextAttributesKey key2) {
        if (key2 != null) {
            if (TextAttributesKey.isTemp((TextAttributesKey)key2)) {
                return this.myAttributesTempMap.get(key2);
            }
            TextAttributes attributes = this.getDirectlyDefinedAttributes(key2);
            if (attributes != null && attributes != INHERITED_ATTRS_MARKER) {
                return attributes;
            }
            TextAttributesKey fallbackKey = key2.getFallbackAttributeKey();
            if (fallbackKey != null && (attributes = this.getFallbackAttributes(fallbackKey)) != null) {
                return attributes;
            }
        }
        return this.myParentScheme.getAttributes(key2);
    }

    @Nullable
    public Color getColor(ColorKey key2) {
        if (key2 != null) {
            Color color = this.getDirectlyDefinedColor(key2);
            if (color == NULL_COLOR_MARKER) {
                return null;
            }
            if (color != null && color != INHERITED_COLOR_MARKER) {
                return color;
            }
            ColorKey fallbackKey = key2.getFallbackColorKey();
            if (fallbackKey != null && (color = this.getFallbackColor(fallbackKey)) != null) {
                return color;
            }
        }
        return this.myParentScheme.getColor(key2);
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this.myParentScheme);
        this.copyTo(newScheme);
        newScheme.setName(this.getName());
        newScheme.setDefaultMetaInfo(this);
        return newScheme;
    }

    @Override
    protected boolean attributesEqual(AbstractColorsScheme otherScheme) {
        return this.compareAttributes(otherScheme, new ArrayList<Function<TextAttributesKey, Boolean>>());
    }

    @Override
    protected boolean colorsEqual(AbstractColorsScheme otherScheme, @Nullable Predicate<ColorKey> colorKeyFilter) {
        ArrayList<Predicate<ColorKey>> filters = new ArrayList<Predicate<ColorKey>>();
        if (colorKeyFilter != null) {
            filters.add(colorKeyFilter);
        }
        return this.compareColors(otherScheme, filters);
    }

    private boolean compareAttributes(@NotNull AbstractColorsScheme otherScheme, @NotNull Collection<Function<TextAttributesKey, Boolean>> filters) {
        if (otherScheme == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(2);
        }
        if (filters == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(3);
        }
        for (TextAttributesKey key3 : this.myAttributesMap.keySet()) {
            if (EditorColorsSchemeImpl.isTextAttributeKeyIgnored(filters, key3) || this.getAttributes(key3).equals((Object)otherScheme.getAttributes(key3))) continue;
            return false;
        }
        filters.add(key2 -> this.myAttributesMap.containsKey(key2));
        return !(this.myParentScheme instanceof EditorColorsSchemeImpl) || ((EditorColorsSchemeImpl)this.myParentScheme).compareAttributes(otherScheme, filters);
    }

    private static boolean isTextAttributeKeyIgnored(@NotNull Collection<Function<TextAttributesKey, Boolean>> filters, TextAttributesKey key2) {
        if (filters == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(4);
        }
        for (Function<TextAttributesKey, Boolean> filter2 : filters) {
            if (!filter2.apply(key2).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean compareColors(@NotNull AbstractColorsScheme otherScheme, @NotNull Collection<Predicate<ColorKey>> filters) {
        if (otherScheme == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(5);
        }
        if (filters == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(6);
        }
        for (ColorKey key3 : this.myColorsMap.keySet()) {
            Color thisColor = this.getColor(key3);
            Color otherColor = otherScheme.getColor(key3);
            if (!EditorColorsSchemeImpl.isColorKeyAccepted(filters, key3) || Comparing.equal((Object)thisColor, (Object)otherColor)) continue;
            return false;
        }
        filters.add(key2 -> !this.myColorsMap.containsKey(key2));
        return !(this.myParentScheme instanceof EditorColorsSchemeImpl) || ((EditorColorsSchemeImpl)this.myParentScheme).compareColors(otherScheme, filters);
    }

    private static boolean isColorKeyAccepted(@NotNull Collection<Predicate<ColorKey>> filters, @NotNull ColorKey key2) {
        if (filters == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(7);
        }
        if (key2 == null) {
            EditorColorsSchemeImpl.$$$reportNull$$$0(8);
        }
        for (Predicate<ColorKey> filter2 : filters) {
            if (filter2.test(key2)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherScheme";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setAttributes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compareAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTextAttributeKeyIgnored";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "compareColors";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isColorKeyAccepted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

