/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ObjectUtils;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PersistentRangeMarker
extends RangeMarkerImpl {
    private LinesCols myLinesCols;

    PersistentRangeMarker(DocumentEx document, int startOffset, int endOffset, boolean register) {
        super(document, startOffset, endOffset, register);
        this.myLinesCols = (LinesCols)ObjectUtils.assertNotNull((Object)PersistentRangeMarker.storeLinesAndCols(document, this.getStartOffset(), this.getEndOffset()));
    }

    @Nullable
    static LinesCols storeLinesAndCols(Document myDocument, int startOffset, int endOffset) {
        int myEndColumn;
        int myEndLine;
        int myStartColumn;
        int myStartLine;
        if (startOffset <= myDocument.getTextLength()) {
            myStartLine = myDocument.getLineNumber(startOffset);
            myStartColumn = startOffset - myDocument.getLineStartOffset(myStartLine);
            if (myStartColumn < 0) {
                return null;
            }
        } else {
            return null;
        }
        if (endOffset <= myDocument.getTextLength()) {
            myEndLine = myDocument.getLineNumber(endOffset);
            myEndColumn = endOffset - myDocument.getLineStartOffset(myEndLine);
            if (myEndColumn < 0) {
                return null;
            }
        } else {
            return null;
        }
        return new LinesCols(myStartLine, myStartColumn, myEndLine, myEndColumn);
    }

    @Nullable
    static Pair<TextRange, LinesCols> translateViaDiff(@NotNull DocumentEventImpl event, @NotNull LinesCols linesCols) {
        if (event == null) {
            PersistentRangeMarker.$$$reportNull$$$0(0);
        }
        if (linesCols == null) {
            PersistentRangeMarker.$$$reportNull$$$0(1);
        }
        try {
            int myStartLine = event.translateLineViaDiffStrict(linesCols.myStartLine);
            Document document = event.getDocument();
            if (myStartLine < 0 || myStartLine >= document.getLineCount()) {
                return null;
            }
            int start = document.getLineStartOffset(myStartLine) + linesCols.myStartColumn;
            if (start >= document.getTextLength()) {
                return null;
            }
            int myEndLine = event.translateLineViaDiffStrict(linesCols.myEndLine);
            if (myEndLine < 0 || myEndLine >= document.getLineCount()) {
                return null;
            }
            int end = document.getLineStartOffset(myEndLine) + linesCols.myEndColumn;
            if (end > document.getTextLength() || end < start) {
                return null;
            }
            if (end > event.getDocument().getTextLength() || myEndLine < myStartLine || myStartLine == myEndLine && linesCols.myEndColumn < linesCols.myStartColumn || event.getDocument().getLineCount() < myEndLine) {
                return null;
            }
            return Pair.create((Object)new TextRange(start, end), (Object)new LinesCols(myStartLine, linesCols.myStartColumn, myEndLine, linesCols.myEndColumn));
        }
        catch (FilesTooBigForDiffException e) {
            return null;
        }
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            PersistentRangeMarker.$$$reportNull$$$0(2);
        }
        if (!this.isValid()) {
            return;
        }
        Pair<TextRange, LinesCols> pair2 = PersistentRangeMarker.applyChange(e, this, this.intervalStart(), this.intervalEnd(), this.isGreedyToLeft(), this.isGreedyToRight(), this.isStickingToRight(), this.myLinesCols);
        if (pair2 == null) {
            this.invalidate(e);
            return;
        }
        this.setIntervalStart(((TextRange)pair2.first).getStartOffset());
        this.setIntervalEnd(((TextRange)pair2.first).getEndOffset());
        this.myLinesCols = (LinesCols)pair2.second;
    }

    @Nullable
    private static Pair<TextRange, LinesCols> applyChange(DocumentEvent event, Segment range, int intervalStart, int intervalEnd, boolean greedyLeft, boolean greedyRight, boolean stickingToRight, LinesCols linesCols) {
        boolean shouldTranslateViaDiff = PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, range.getStartOffset(), range.getEndOffset());
        Pair translated = null;
        if (shouldTranslateViaDiff) {
            translated = PersistentRangeMarker.translateViaDiff((DocumentEventImpl)event, linesCols);
        }
        if (translated == null) {
            TextRange fallback = PersistentRangeMarker.applyChange(event, intervalStart, intervalEnd, greedyLeft, greedyRight, stickingToRight);
            if (fallback == null) {
                return null;
            }
            LinesCols lc = PersistentRangeMarker.storeLinesAndCols(event.getDocument(), fallback.getStartOffset(), fallback.getEndOffset());
            if (lc == null) {
                return null;
            }
            translated = Pair.create((Object)fallback, (Object)lc);
        }
        return translated;
    }

    @Override
    public String toString() {
        return "PersistentRangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + " " + this.myLinesCols + (this.isGreedyToRight() ? "]" : ")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linesCols";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/PersistentRangeMarker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "translateViaDiff";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "changedUpdateImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class LinesCols {
        private final int myStartLine;
        private final int myStartColumn;
        private final int myEndLine;
        private final int myEndColumn;

        LinesCols(int startLine, int startColumn, int endLine, int endColumn) {
            this.myStartLine = startLine;
            this.myStartColumn = startColumn;
            this.myEndLine = endLine;
            this.myEndColumn = endColumn;
        }

        public String toString() {
            return this.myStartLine + ":" + this.myStartColumn + "-" + this.myEndLine + ":" + this.myEndColumn;
        }
    }
}

