/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskLocation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemRuntimeConfigurationProducer
extends RuntimeConfigurationProducer {
    private PsiElement mySourceElement;

    public AbstractExternalSystemRuntimeConfigurationProducer(@NotNull AbstractExternalSystemTaskConfigurationType type2) {
        if (type2 == null) {
            AbstractExternalSystemRuntimeConfigurationProducer.$$$reportNull$$$0(0);
        }
        super((ConfigurationType)type2);
    }

    public PsiElement getSourceElement() {
        return this.mySourceElement;
    }

    @Nullable
    protected RunnerAndConfigurationSettings createConfigurationByElement(Location location, ConfigurationContext context) {
        if (!(location instanceof ExternalSystemTaskLocation)) {
            return null;
        }
        ExternalSystemTaskLocation taskLocation = (ExternalSystemTaskLocation)location;
        this.mySourceElement = taskLocation.getPsiElement();
        RunManager runManager = RunManager.getInstance((Project)taskLocation.getProject());
        RunnerAndConfigurationSettings settings = runManager.createConfiguration("", this.getConfigurationFactory());
        ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)settings.getConfiguration();
        ExternalSystemTaskExecutionSettings taskExecutionSettings = configuration.getSettings();
        ExternalTaskExecutionInfo task = taskLocation.getTaskInfo();
        taskExecutionSettings.setExternalProjectPath(task.getSettings().getExternalProjectPath());
        taskExecutionSettings.setTaskNames(task.getSettings().getTaskNames());
        configuration.setName(AbstractExternalSystemTaskConfigurationType.generateName(location.getProject(), taskExecutionSettings));
        return settings;
    }

    @Nullable
    protected RunnerAndConfigurationSettings findExistingByElement(Location location, @NotNull List<RunnerAndConfigurationSettings> existingConfigurationsSettings, ConfigurationContext context) {
        if (existingConfigurationsSettings == null) {
            AbstractExternalSystemRuntimeConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (!(location instanceof ExternalSystemTaskLocation)) {
            return null;
        }
        ExternalTaskExecutionInfo taskInfo = ((ExternalSystemTaskLocation)location).getTaskInfo();
        for (RunnerAndConfigurationSettings settings : existingConfigurationsSettings) {
            RunConfiguration runConfiguration = settings.getConfiguration();
            if (!(runConfiguration instanceof ExternalSystemRunConfiguration) || !AbstractExternalSystemRuntimeConfigurationProducer.match(taskInfo, ((ExternalSystemRunConfiguration)runConfiguration).getSettings())) continue;
            return settings;
        }
        return null;
    }

    private static boolean match(@NotNull ExternalTaskExecutionInfo task, @NotNull ExternalSystemTaskExecutionSettings settings) {
        if (task == null) {
            AbstractExternalSystemRuntimeConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            AbstractExternalSystemRuntimeConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (!task.getSettings().getExternalProjectPath().equals(settings.getExternalProjectPath())) {
            return false;
        }
        List taskNames = settings.getTaskNames();
        return task.getSettings().getTaskNames().equals(taskNames);
    }

    public int compareTo(@NotNull Object o) {
        if (o == null) {
            AbstractExternalSystemRuntimeConfigurationProducer.$$$reportNull$$$0(4);
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingConfigurationsSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemRuntimeConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingByElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "match";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

