/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.TaskCompletionProvider;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectPathField;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskSettingsControl
implements ExternalSystemSettingsControl<ExternalSystemTaskExecutionSettings> {
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final Project myProject;
    private JBLabel myProjectPathLabel;
    private ExternalProjectPathField myProjectPathField;
    private JBLabel myTasksLabel;
    private EditorTextField myTasksTextField;
    private JBLabel myVmOptionsLabel;
    private RawCommandLineEditor myVmOptionsEditor;
    private JBLabel myArgumentsLabel;
    private RawCommandLineEditor myArgumentsEditor;
    private EnvironmentVariablesComponent myEnvVariablesComponent;
    @Nullable
    private ExternalSystemTaskExecutionSettings myOriginalSettings;

    public ExternalSystemTaskSettingsControl(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        if (project2 == null) {
            ExternalSystemTaskSettingsControl.$$$reportNull$$$0(0);
        }
        if (externalSystemId == null) {
            ExternalSystemTaskSettingsControl.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myExternalSystemId = externalSystemId;
    }

    public void setOriginalSettings(@Nullable ExternalSystemTaskExecutionSettings originalSettings) {
        this.myOriginalSettings = originalSettings;
    }

    @Override
    public void fillUi(@NotNull PaintAwarePanel canvas, int indentLevel) {
        if (canvas == null) {
            ExternalSystemTaskSettingsControl.$$$reportNull$$$0(2);
        }
        this.myProjectPathLabel = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.project", (Object[])new Object[]{this.myExternalSystemId.getReadableName()}));
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.myExternalSystemId);
        FileChooserDescriptor projectPathChooserDescriptor = null;
        if (manager instanceof ExternalSystemUiAware) {
            projectPathChooserDescriptor = ((ExternalSystemUiAware)manager).getExternalProjectConfigDescriptor();
        }
        if (projectPathChooserDescriptor == null) {
            projectPathChooserDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        }
        String title = ExternalSystemBundle.message((String)"settings.label.select.project", (Object[])new Object[]{this.myExternalSystemId.getReadableName()});
        this.myProjectPathField = new ExternalProjectPathField(this.myProject, this.myExternalSystemId, projectPathChooserDescriptor, title){

            public Dimension getPreferredSize() {
                return ExternalSystemTaskSettingsControl.this.myVmOptionsEditor == null ? super.getPreferredSize() : ExternalSystemTaskSettingsControl.this.myVmOptionsEditor.getTextField().getPreferredSize();
            }
        };
        canvas.add((Component)this.myProjectPathLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        canvas.add((Component)((Object)this.myProjectPathField), ExternalSystemUiUtil.getFillLineConstraints(0));
        this.myTasksLabel = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.tasks", (Object[])new Object[0]));
        this.myTasksTextField = new EditorTextField("", this.myProject, (FileType)PlainTextFileType.INSTANCE);
        canvas.add((Component)this.myTasksLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        GridBag c = ExternalSystemUiUtil.getFillLineConstraints(0);
        c.insets.right = this.myProjectPathField.getButton().getPreferredSize().width + 8;
        canvas.add((Component)((Object)this.myTasksTextField), c);
        new TaskCompletionProvider(this.myProject, this.myExternalSystemId, this.myProjectPathField).apply(this.myTasksTextField);
        this.myVmOptionsLabel = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.vmoptions", (Object[])new Object[0]));
        this.myVmOptionsEditor = new RawCommandLineEditor();
        this.myVmOptionsEditor.setDialogCaption(ExternalSystemBundle.message((String)"run.configuration.settings.label.vmoptions", (Object[])new Object[0]));
        canvas.add((Component)this.myVmOptionsLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        canvas.add((Component)this.myVmOptionsEditor, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.myArgumentsLabel = new JBLabel(ExternalSystemBundle.message((String)"run.configuration.settings.label.arguments", (Object[])new Object[0]));
        this.myArgumentsEditor = new RawCommandLineEditor();
        this.myArgumentsEditor.setDialogCaption(ExternalSystemBundle.message((String)"run.configuration.settings.label.arguments", (Object[])new Object[0]));
        canvas.add((Component)this.myArgumentsLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        canvas.add((Component)this.myArgumentsEditor, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.myEnvVariablesComponent = new EnvironmentVariablesComponent();
        JBLabel myEnvVariablesComponentLabel = this.myEnvVariablesComponent.getLabel();
        myEnvVariablesComponentLabel.remove((Component)myEnvVariablesComponentLabel);
        canvas.add((Component)myEnvVariablesComponentLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        canvas.add((Component)((Object)this.myEnvVariablesComponent), ExternalSystemUiUtil.getFillLineConstraints(0));
    }

    @Override
    public void reset() {
        this.myProjectPathField.setText("");
        this.myTasksTextField.setText("");
        this.myVmOptionsEditor.setText("");
        this.myArgumentsEditor.setText("");
        this.myEnvVariablesComponent.setEnvData(EnvironmentVariablesData.DEFAULT);
        this.showUi(true);
        if (this.myOriginalSettings == null) {
            return;
        }
        String path = this.myOriginalSettings.getExternalProjectPath();
        if (StringUtil.isEmpty((String)path)) {
            path = "";
        }
        this.myProjectPathField.setText(path);
        this.myTasksTextField.setText(StringUtil.join((Collection)this.myOriginalSettings.getTaskNames(), (String)" "));
        this.myVmOptionsEditor.setText(this.myOriginalSettings.getVmOptions());
        this.myArgumentsEditor.setText(this.myOriginalSettings.getScriptParameters());
        this.myEnvVariablesComponent.setEnvData(EnvironmentVariablesData.create(this.myOriginalSettings.getEnv(), this.myOriginalSettings.isPassParentEnvs()));
    }

    @Override
    public boolean isModified() {
        if (this.myOriginalSettings == null) {
            return false;
        }
        return !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.myProjectPathField.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.myOriginalSettings.getExternalProjectPath())) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.myTasksTextField.getText()), (String)ExternalSystemApiUtil.normalizePath((String)StringUtil.join((Collection)this.myOriginalSettings.getTaskNames(), (String)" "))) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.myVmOptionsEditor.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.myOriginalSettings.getVmOptions())) || !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.myArgumentsEditor.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.myOriginalSettings.getScriptParameters())) || this.myEnvVariablesComponent.isPassParentEnvs() != this.myOriginalSettings.isPassParentEnvs() || !this.myEnvVariablesComponent.getEnvs().equals(this.myOriginalSettings.getEnv());
    }

    @Override
    public void apply(@NotNull ExternalSystemTaskExecutionSettings settings) {
        if (settings == null) {
            ExternalSystemTaskSettingsControl.$$$reportNull$$$0(3);
        }
        String projectPath = this.myProjectPathField.getText();
        settings.setExternalProjectPath(projectPath);
        settings.setTaskNames(StringUtil.split((String)this.myTasksTextField.getText(), (String)" "));
        settings.setVmOptions(this.myVmOptionsEditor.getText());
        settings.setScriptParameters(this.myArgumentsEditor.getText());
        settings.setPassParentEnvs(this.myEnvVariablesComponent.isPassParentEnvs());
        settings.setEnv((Map)ContainerUtil.newHashMap(this.myEnvVariablesComponent.getEnvs()));
    }

    @Override
    public boolean validate(@NotNull ExternalSystemTaskExecutionSettings settings) throws ConfigurationException {
        if (settings == null) {
            ExternalSystemTaskSettingsControl.$$$reportNull$$$0(4);
        }
        String projectPath = this.myProjectPathField.getText();
        if (this.myOriginalSettings == null) {
            throw new ConfigurationException(String.format("Can't store external task settings into run configuration. Reason: target run configuration is undefined. Tasks: '%s', external project: '%s', vm options: '%s', arguments: '%s'", this.myTasksTextField.getText(), projectPath, this.myVmOptionsEditor.getText(), this.myArgumentsEditor.getText()));
        }
        return true;
    }

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi(this);
    }

    @Override
    public void showUi(boolean show) {
        ExternalSystemUiUtil.showUi(this, show);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canvas";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskSettingsControl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fillUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

