/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.execution.NotSupportedException;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalSystemTask
extends UserDataHolderBase
implements ExternalSystemTask {
    private static final Logger LOG = Logger.getInstance(AbstractExternalSystemTask.class);
    private final AtomicReference<ExternalSystemTaskState> myState;
    private final AtomicReference<Throwable> myError;
    @NotNull
    private final transient Project myIdeProject;
    @NotNull
    private final ExternalSystemTaskId myId;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final String myExternalProjectPath;

    protected AbstractExternalSystemTask(@NotNull ProjectSystemId id, @NotNull ExternalSystemTaskType type2, @NotNull Project project2, @NotNull String externalProjectPath) {
        if (id == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(2);
        }
        if (externalProjectPath == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(3);
        }
        this.myState = new AtomicReference<ExternalSystemTaskState>(ExternalSystemTaskState.NOT_STARTED);
        this.myError = new AtomicReference();
        this.myExternalSystemId = id;
        this.myIdeProject = project2;
        this.myId = ExternalSystemTaskId.create((ProjectSystemId)id, (ExternalSystemTaskType)type2, (Project)this.myIdeProject);
        this.myExternalProjectPath = externalProjectPath;
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = this.myExternalSystemId;
        if (projectSystemId == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(4);
        }
        return projectSystemId;
    }

    @NotNull
    public ExternalSystemTaskId getId() {
        ExternalSystemTaskId externalSystemTaskId = this.myId;
        if (externalSystemTaskId == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(5);
        }
        return externalSystemTaskId;
    }

    @NotNull
    public ExternalSystemTaskState getState() {
        ExternalSystemTaskState externalSystemTaskState = this.myState.get();
        if (externalSystemTaskState == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(6);
        }
        return externalSystemTaskState;
    }

    protected void setState(@NotNull ExternalSystemTaskState state) {
        if (state == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(7);
        }
        this.myState.set(state);
    }

    protected boolean compareAndSetState(@NotNull ExternalSystemTaskState expect, @NotNull ExternalSystemTaskState update2) {
        if (expect == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(8);
        }
        if (update2 == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(9);
        }
        return this.myState.compareAndSet(expect, update2);
    }

    public Throwable getError() {
        return this.myError.get();
    }

    @NotNull
    public Project getIdeProject() {
        Project project2 = this.myIdeProject;
        if (project2 == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(10);
        }
        return project2;
    }

    @NotNull
    public String getExternalProjectPath() {
        String string = this.myExternalProjectPath;
        if (string == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void refreshState() {
        block3: {
            if (this.getState() != ExternalSystemTaskState.IN_PROGRESS) {
                return;
            }
            ExternalSystemFacadeManager manager = (ExternalSystemFacadeManager)ServiceManager.getService(ExternalSystemFacadeManager.class);
            try {
                RemoteExternalSystemFacade facade = manager.getFacade(this.myIdeProject, this.myExternalProjectPath, this.myExternalSystemId);
                this.setState(facade.isTaskInProgress(this.getId()) ? ExternalSystemTaskState.IN_PROGRESS : ExternalSystemTaskState.FAILED);
            }
            catch (Throwable e) {
                this.setState(ExternalSystemTaskState.FAILED);
                this.myError.set(e);
                if (this.myIdeProject.isDisposed()) break block3;
                LOG.warn(e);
            }
        }
    }

    public void execute(final @NotNull ProgressIndicator indicator, ExternalSystemTaskNotificationListener ... listeners) {
        if (indicator == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(12);
        }
        if (listeners == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(13);
        }
        indicator.setIndeterminate(true);
        ExternalSystemTaskNotificationListenerAdapter adapter = new ExternalSystemTaskNotificationListenerAdapter(){

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event instanceof ExternalSystemTaskExecutionEvent && ((ExternalSystemTaskExecutionEvent)event).getProgressEvent() instanceof ExternalSystemStatusEvent) {
                    String sizeInfo;
                    ExternalSystemStatusEvent progressEvent = (ExternalSystemStatusEvent)((ExternalSystemTaskExecutionEvent)event).getProgressEvent();
                    if (progressEvent.getTotal() <= 0L) {
                        indicator.setIndeterminate(true);
                        sizeInfo = "bytes".equals(progressEvent.getUnit()) ? StringUtil.formatFileSize((long)progressEvent.getProgress()) + " / ?" : "";
                    } else {
                        indicator.setIndeterminate(false);
                        indicator.setFraction((double)progressEvent.getProgress() / (double)progressEvent.getTotal());
                        sizeInfo = "bytes".equals(progressEvent.getUnit()) ? StringUtil.formatFileSize((long)progressEvent.getProgress()) + " / " + StringUtil.formatFileSize((long)progressEvent.getTotal()) : "";
                    }
                    String description = event.getDescription();
                    indicator.setText(AbstractExternalSystemTask.this.wrapProgressText(description) + (sizeInfo.isEmpty() ? "" : "  (" + sizeInfo + ')'));
                } else {
                    indicator.setIndeterminate(true);
                    indicator.setText(AbstractExternalSystemTask.this.wrapProgressText(event.getDescription()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask$1", "onStatusChange"));
            }
        };
        ExternalSystemTaskNotificationListener[] ls = listeners.length > 0 ? (ExternalSystemTaskNotificationListener[])ArrayUtil.append((Object[])listeners, (Object)adapter) : new ExternalSystemTaskNotificationListener[]{adapter};
        this.execute(ls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExternalSystemTaskNotificationListener ... listeners) {
        if (listeners == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(14);
        }
        if (!this.compareAndSetState(ExternalSystemTaskState.NOT_STARTED, ExternalSystemTaskState.IN_PROGRESS)) {
            return;
        }
        ExternalSystemProgressNotificationManager progressManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        for (ExternalSystemTaskNotificationListener listener2 : listeners) {
            progressManager.addNotificationListener(this.getId(), listener2);
        }
        ExternalSystemProcessingManager processingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class);
        try {
            processingManager.add(this);
            this.doExecute();
            this.setState(ExternalSystemTaskState.FINISHED);
        }
        catch (Throwable e) {
            this.setState(ExternalSystemTaskState.FAILED);
            this.myError.set(e);
            LOG.warn(e);
        }
        finally {
            for (ExternalSystemTaskNotificationListener listener3 : listeners) {
                progressManager.removeNotificationListener(listener3);
            }
            processingManager.release(this.getId());
        }
    }

    protected abstract void doExecute() throws Exception;

    public boolean cancel(final @NotNull ProgressIndicator indicator, ExternalSystemTaskNotificationListener ... listeners) {
        if (indicator == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(15);
        }
        if (listeners == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(16);
        }
        indicator.setIndeterminate(true);
        ExternalSystemTaskNotificationListenerAdapter adapter = new ExternalSystemTaskNotificationListenerAdapter(){

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setText(AbstractExternalSystemTask.this.wrapProgressText(event.getDescription()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask$2", "onStatusChange"));
            }
        };
        ExternalSystemTaskNotificationListener[] ls = listeners.length > 0 ? (ExternalSystemTaskNotificationListener[])ArrayUtil.append((Object[])listeners, (Object)adapter) : new ExternalSystemTaskNotificationListener[]{adapter};
        return this.cancel(ls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(ExternalSystemTaskNotificationListener ... listeners) {
        ExternalSystemTaskState currentTaskState;
        if (listeners == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(17);
        }
        if ((currentTaskState = this.getState()).isStopped()) {
            return true;
        }
        ExternalSystemProgressNotificationManager progressManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        for (ExternalSystemTaskNotificationListener listener2 : listeners) {
            progressManager.addNotificationListener(this.getId(), listener2);
        }
        if (!this.compareAndSetState(currentTaskState, ExternalSystemTaskState.CANCELING)) {
            return false;
        }
        int result2 = 0;
        try {
            int n = result2 = this.doCancel();
            return n != 0;
        }
        catch (NotSupportedException e) {
            NotificationData notification = new NotificationData("Cancellation failed", e.getMessage(), NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            notification.setBalloonNotification(true);
            ExternalSystemNotificationManager.getInstance(this.getIdeProject()).showNotification(this.getExternalSystemId(), notification);
        }
        catch (Throwable e) {
            this.setState(ExternalSystemTaskState.CANCELLATION_FAILED);
            this.myError.set(e);
            LOG.warn(e);
        }
        finally {
            for (ExternalSystemTaskNotificationListener listener3 : listeners) {
                progressManager.removeNotificationListener(listener3);
            }
        }
        return result2 != 0;
    }

    protected abstract boolean doCancel() throws Exception;

    @NotNull
    protected String wrapProgressText(@NotNull String text2) {
        if (text2 == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(18);
        }
        String string = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{this.getExternalSystemId(), text2});
        if (string == null) {
            AbstractExternalSystemTask.$$$reportNull$$$0(19);
        }
        return string;
    }

    public int hashCode() {
        return this.myId.hashCode() + this.myExternalSystemId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbstractExternalSystemTask task = (AbstractExternalSystemTask)((Object)o);
        return this.myId.equals((Object)task.myId) && this.myExternalSystemId.equals((Object)task.myExternalSystemId);
    }

    public String toString() {
        return String.format("%s task %s: %s", this.myExternalSystemId.getReadableName(), this.myId, this.myState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expect";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/AbstractExternalSystemTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSystemId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapProgressText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSetState";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cancel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "wrapProgressText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

