/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationData
implements Disposable {
    @NotNull
    private String myTitle;
    @NotNull
    private String myMessage;
    @NotNull
    private NotificationCategory myNotificationCategory;
    @NotNull
    private final NotificationSource myNotificationSource;
    @NotNull
    private NotificationListener myListener;
    @Nullable
    private String myFilePath;
    @Nullable
    private Navigatable navigatable;
    private int myLine;
    private int myColumn;
    private boolean myBalloonNotification;
    @Nullable
    private String myBalloonGroup;
    private final Map<String, NotificationListener> myListenerMap;

    public NotificationData(@NotNull String title, @NotNull String message2, @NotNull NotificationCategory notificationCategory, @NotNull NotificationSource notificationSource) {
        if (title == null) {
            NotificationData.$$$reportNull$$$0(0);
        }
        if (message2 == null) {
            NotificationData.$$$reportNull$$$0(1);
        }
        if (notificationCategory == null) {
            NotificationData.$$$reportNull$$$0(2);
        }
        if (notificationSource == null) {
            NotificationData.$$$reportNull$$$0(3);
        }
        this(title, message2, notificationCategory, notificationSource, null, -1, -1, false);
    }

    public NotificationData(@NotNull String title, @NotNull String message2, @NotNull NotificationCategory notificationCategory, @NotNull NotificationSource notificationSource, @Nullable String filePath, int line, int column, boolean balloonNotification) {
        if (title == null) {
            NotificationData.$$$reportNull$$$0(4);
        }
        if (message2 == null) {
            NotificationData.$$$reportNull$$$0(5);
        }
        if (notificationCategory == null) {
            NotificationData.$$$reportNull$$$0(6);
        }
        if (notificationSource == null) {
            NotificationData.$$$reportNull$$$0(7);
        }
        this.myTitle = title;
        this.myMessage = message2;
        this.myNotificationCategory = notificationCategory;
        this.myNotificationSource = notificationSource;
        this.myListenerMap = ContainerUtil.newHashMap();
        this.myListener = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                NotificationListener notificationListener = (NotificationListener)NotificationData.this.myListenerMap.get(event.getDescription());
                if (notificationListener != null) {
                    notificationListener.hyperlinkUpdate(notification, event);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/externalSystem/service/notification/NotificationData$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myFilePath = filePath;
        this.myLine = line;
        this.myColumn = column;
        this.myBalloonNotification = balloonNotification;
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            NotificationData.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setTitle(@NotNull String title) {
        if (title == null) {
            NotificationData.$$$reportNull$$$0(9);
        }
        this.myTitle = title;
    }

    @NotNull
    public String getMessage() {
        String string = this.myMessage;
        if (string == null) {
            NotificationData.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setMessage(@NotNull String message2) {
        if (message2 == null) {
            NotificationData.$$$reportNull$$$0(11);
        }
        this.myMessage = message2;
    }

    @NotNull
    public NotificationCategory getNotificationCategory() {
        NotificationCategory notificationCategory = this.myNotificationCategory;
        if (notificationCategory == null) {
            NotificationData.$$$reportNull$$$0(12);
        }
        return notificationCategory;
    }

    public void setNotificationCategory(@NotNull NotificationCategory notificationCategory) {
        if (notificationCategory == null) {
            NotificationData.$$$reportNull$$$0(13);
        }
        this.myNotificationCategory = notificationCategory;
    }

    @NotNull
    public NotificationSource getNotificationSource() {
        NotificationSource notificationSource = this.myNotificationSource;
        if (notificationSource == null) {
            NotificationData.$$$reportNull$$$0(14);
        }
        return notificationSource;
    }

    @NotNull
    public NotificationListener getListener() {
        NotificationListener notificationListener = this.myListener;
        if (notificationListener == null) {
            NotificationData.$$$reportNull$$$0(15);
        }
        return notificationListener;
    }

    @Nullable
    public String getFilePath() {
        return this.myFilePath;
    }

    public void setFilePath(@Nullable String filePath) {
        this.myFilePath = filePath;
    }

    @NotNull
    public Integer getLine() {
        Integer n = this.myLine;
        if (n == null) {
            NotificationData.$$$reportNull$$$0(16);
        }
        return n;
    }

    public void setLine(int line) {
        this.myLine = line;
    }

    public int getColumn() {
        return this.myColumn;
    }

    public void setColumn(int column) {
        this.myColumn = column;
    }

    public boolean isBalloonNotification() {
        return this.myBalloonNotification;
    }

    public void setBalloonNotification(boolean balloonNotification) {
        this.myBalloonNotification = balloonNotification;
    }

    public void setListener(@NotNull String listenerId, @NotNull NotificationListener listener2) {
        if (listenerId == null) {
            NotificationData.$$$reportNull$$$0(17);
        }
        if (listener2 == null) {
            NotificationData.$$$reportNull$$$0(18);
        }
        this.myListenerMap.put(listenerId, listener2);
    }

    boolean hasLinks() {
        return !this.myListenerMap.isEmpty();
    }

    public List<String> getRegisteredListenerIds() {
        return ContainerUtil.newArrayList(this.myListenerMap.keySet());
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.navigatable;
    }

    public void setNavigatable(@Nullable Navigatable navigatable) {
        this.navigatable = navigatable;
    }

    @Nullable
    public String getBalloonGroup() {
        return this.myBalloonGroup;
    }

    public void setBalloonGroup(@Nullable String balloonGroup) {
        this.myBalloonGroup = balloonGroup;
    }

    public void dispose() {
        this.myListenerMap.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationCategory";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationSource";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/notification/NotificationData";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerId";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/notification/NotificationData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationCategory";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationSource";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getListener";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setMessage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setNotificationCategory";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

