/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483648)
public class ProjectDataServiceImpl
extends AbstractProjectDataService<ProjectData, Project> {
    @NotNull
    public Key<ProjectData> getTargetDataKey() {
        Key key2 = ProjectKeys.PROJECT;
        if (key2 == null) {
            ProjectDataServiceImpl.$$$reportNull$$$0(0);
        }
        return key2;
    }

    public void importData(@NotNull Collection<DataNode<ProjectData>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ProjectDataServiceImpl.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            ProjectDataServiceImpl.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            ProjectDataServiceImpl.$$$reportNull$$$0(3);
        }
        if (toImport.isEmpty()) {
            return;
        }
        if (toImport.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected to get a single project but got %d: %s", toImport.size(), toImport));
        }
        DataNode<ProjectData> node = toImport.iterator().next();
        assert (projectData == node.getData());
        if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project2, (ProjectData)((ProjectData)node.getData()))) {
            return;
        }
        if (!project2.getName().equals(projectData.getInternalName())) {
            ProjectDataServiceImpl.renameProject(projectData.getInternalName(), projectData.getOwner(), project2);
        }
    }

    private static void renameProject(final @NotNull String newName, final @NotNull ProjectSystemId externalSystemId, final @NotNull Project project2) {
        if (newName == null) {
            ProjectDataServiceImpl.$$$reportNull$$$0(4);
        }
        if (externalSystemId == null) {
            ProjectDataServiceImpl.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            ProjectDataServiceImpl.$$$reportNull$$$0(6);
        }
        if (!(project2 instanceof ProjectEx) || newName.equals(project2.getName())) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                String oldName = project2.getName();
                ((ProjectEx)project2).setProjectName(newName);
                ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)externalSystemId).getPublisher().onProjectRenamed(oldName, newName);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataServiceImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renameProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

