/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.settings;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.ui.HideableTitledPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractImportFromExternalSystemControl<ProjectSettings extends ExternalProjectSettings, L extends ExternalSystemSettingsListener<ProjectSettings>, SystemSettings extends AbstractExternalSystemSettings<SystemSettings, ProjectSettings, L>> {
    @NotNull
    private final SystemSettings mySystemSettings;
    @NotNull
    private final ProjectSettings myProjectSettings;
    @NotNull
    private final PaintAwarePanel myComponent;
    @NotNull
    private final NamePathComponent myLinkedProjectPathField;
    @Nullable
    private final HideableTitledPanel hideableSystemSettingsPanel;
    @NotNull
    private final ProjectFormatPanel myProjectFormatPanel;
    @NotNull
    private final ExternalSystemSettingsControl<ProjectSettings> myProjectSettingsControl;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @Nullable
    private final ExternalSystemSettingsControl<SystemSettings> mySystemSettingsControl;
    @Nullable
    Project myCurrentProject;
    private boolean myShowProjectFormatPanel;
    private final JLabel myProjectFormatLabel;

    protected AbstractImportFromExternalSystemControl(@NotNull ProjectSystemId externalSystemId, @NotNull SystemSettings systemSettings, @NotNull ProjectSettings projectSettings) {
        if (externalSystemId == null) {
            AbstractImportFromExternalSystemControl.$$$reportNull$$$0(0);
        }
        if (systemSettings == null) {
            AbstractImportFromExternalSystemControl.$$$reportNull$$$0(1);
        }
        if (projectSettings == null) {
            AbstractImportFromExternalSystemControl.$$$reportNull$$$0(2);
        }
        this(externalSystemId, systemSettings, projectSettings, false);
    }

    protected AbstractImportFromExternalSystemControl(@NotNull ProjectSystemId externalSystemId, @NotNull SystemSettings systemSettings, @NotNull ProjectSettings projectSettings, boolean showProjectFormatPanel) {
        if (externalSystemId == null) {
            AbstractImportFromExternalSystemControl.$$$reportNull$$$0(3);
        }
        if (systemSettings == null) {
            AbstractImportFromExternalSystemControl.$$$reportNull$$$0(4);
        }
        if (projectSettings == null) {
            AbstractImportFromExternalSystemControl.$$$reportNull$$$0(5);
        }
        this.myComponent = new PaintAwarePanel(new GridBagLayout());
        this.myExternalSystemId = externalSystemId;
        this.mySystemSettings = systemSettings;
        this.myProjectSettings = projectSettings;
        this.myProjectSettingsControl = this.createProjectSettingsControl(projectSettings);
        this.mySystemSettingsControl = this.createSystemSettingsControl(systemSettings);
        this.myShowProjectFormatPanel = showProjectFormatPanel;
        String projectPathTitle = ExternalSystemBundle.message((String)"settings.label.select.project", (Object[])new Object[]{externalSystemId.getReadableName()});
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        this.myLinkedProjectPathField = new NamePathComponent("", projectPathTitle, projectPathTitle, "", false, false);
        this.myLinkedProjectPathField.setNameComponentVisible(false);
        this.myLinkedProjectPathField.setNameValue("untitled");
        FileChooserDescriptor fileChooserDescriptor2 = manager.getExternalProjectDescriptor();
        BrowseFilesListener browseButtonActionListener = new BrowseFilesListener(this.myLinkedProjectPathField.getPathComponent(), projectPathTitle, "", fileChooserDescriptor2);
        this.myLinkedProjectPathField.getPathPanel().setBrowseButtonActionListener((ActionListener)browseButtonActionListener);
        this.myLinkedProjectPathField.getPathComponent().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractImportFromExternalSystemControl.this.onLinkedProjectPathChange(AbstractImportFromExternalSystemControl.this.myLinkedProjectPathField.getPath());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractImportFromExternalSystemControl.this.onLinkedProjectPathChange(AbstractImportFromExternalSystemControl.this.myLinkedProjectPathField.getPath());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractImportFromExternalSystemControl.this.onLinkedProjectPathChange(AbstractImportFromExternalSystemControl.this.myLinkedProjectPathField.getPath());
            }
        });
        this.myComponent.add((Component)this.myLinkedProjectPathField, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.myProjectSettingsControl.fillUi(this.myComponent, 0);
        this.myProjectFormatPanel = new ProjectFormatPanel();
        this.myProjectFormatLabel = new JLabel(ExternalSystemBundle.message((String)"settings.label.project.format", (Object[])new Object[0]));
        this.myComponent.add((Component)this.myProjectFormatLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        this.myComponent.add((Component)this.myProjectFormatPanel.getStorageFormatComboBox(), ExternalSystemUiUtil.getFillLineConstraints(0));
        if (this.mySystemSettingsControl != null) {
            PaintAwarePanel mySystemSettingsControlPanel = new PaintAwarePanel();
            this.mySystemSettingsControl.fillUi(mySystemSettingsControlPanel, 0);
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)mySystemSettingsControlPanel, "Center");
            this.hideableSystemSettingsPanel = new HideableTitledPanel(ExternalSystemBundle.message((String)"settings.title.system.settings", (Object[])new Object[]{this.myExternalSystemId.getReadableName()}), false);
            this.hideableSystemSettingsPanel.setContentComponent(panel2);
            this.hideableSystemSettingsPanel.setOn(false);
            this.myComponent.add((Component)this.hideableSystemSettingsPanel, ExternalSystemUiUtil.getFillLineConstraints(0));
        } else {
            this.hideableSystemSettingsPanel = null;
        }
        ExternalSystemUiUtil.fillBottom(this.myComponent);
    }

    public void setCurrentProject(@Nullable Project currentProject) {
        this.myCurrentProject = currentProject;
    }

    protected abstract void onLinkedProjectPathChange(@NotNull String var1);

    @NotNull
    protected abstract ExternalSystemSettingsControl<ProjectSettings> createProjectSettingsControl(@NotNull ProjectSettings var1);

    @Nullable
    protected abstract ExternalSystemSettingsControl<SystemSettings> createSystemSettingsControl(@NotNull SystemSettings var1);

    @NotNull
    public JComponent getComponent() {
        PaintAwarePanel paintAwarePanel = this.myComponent;
        if (paintAwarePanel == null) {
            AbstractImportFromExternalSystemControl.$$$reportNull$$$0(6);
        }
        return paintAwarePanel;
    }

    @NotNull
    public ExternalSystemSettingsControl<ProjectSettings> getProjectSettingsControl() {
        ExternalSystemSettingsControl<ProjectSettings> externalSystemSettingsControl = this.myProjectSettingsControl;
        if (externalSystemSettingsControl == null) {
            AbstractImportFromExternalSystemControl.$$$reportNull$$$0(7);
        }
        return externalSystemSettingsControl;
    }

    @Nullable
    public ExternalSystemSettingsControl<SystemSettings> getSystemSettingsControl() {
        return this.mySystemSettingsControl;
    }

    public void setLinkedProjectPath(@NotNull String path) {
        if (path == null) {
            AbstractImportFromExternalSystemControl.$$$reportNull$$$0(8);
        }
        this.myProjectSettings.setExternalProjectPath(path);
        this.myLinkedProjectPathField.setPath(path);
    }

    @NotNull
    public SystemSettings getSystemSettings() {
        SystemSettings SystemSettings = this.mySystemSettings;
        if (SystemSettings == null) {
            AbstractImportFromExternalSystemControl.$$$reportNull$$$0(9);
        }
        return SystemSettings;
    }

    @NotNull
    public ProjectSettings getProjectSettings() {
        ProjectSettings ProjectSettings2 = this.myProjectSettings;
        if (ProjectSettings2 == null) {
            AbstractImportFromExternalSystemControl.$$$reportNull$$$0(10);
        }
        return ProjectSettings2;
    }

    public void setShowProjectFormatPanel(boolean showProjectFormatPanel) {
        this.myShowProjectFormatPanel = showProjectFormatPanel;
    }

    public void reset() {
        this.reset(null);
    }

    public void reset(@Nullable WizardContext wizardContext) {
        this.myLinkedProjectPathField.setNameComponentVisible(false);
        this.myLinkedProjectPathField.setNameValue("untitled");
        this.myLinkedProjectPathField.setPath("");
        this.myProjectSettingsControl.reset(wizardContext);
        if (this.mySystemSettingsControl != null) {
            this.mySystemSettingsControl.reset(wizardContext);
        }
        if (this.hideableSystemSettingsPanel != null) {
            this.hideableSystemSettingsPanel.setOn(false);
        }
        this.myProjectFormatLabel.setVisible(this.myShowProjectFormatPanel);
        this.myProjectFormatPanel.setVisible(this.myShowProjectFormatPanel);
        this.myProjectFormatPanel.getPanel().setVisible(this.myShowProjectFormatPanel);
        this.myProjectFormatPanel.getStorageFormatComboBox().setVisible(this.myShowProjectFormatPanel);
    }

    public void apply() {
        String linkedProjectPath = this.myLinkedProjectPathField.getPath();
        this.myProjectSettings.setExternalProjectPath(ExternalSystemApiUtil.normalizePath((String)linkedProjectPath));
        this.myProjectSettingsControl.apply(this.myProjectSettings);
        if (this.mySystemSettingsControl != null) {
            this.mySystemSettingsControl.apply(this.mySystemSettings);
        }
    }

    @Nullable
    public ProjectFormatPanel getProjectFormatPanel() {
        return this.myShowProjectFormatPanel ? this.myProjectFormatPanel : null;
    }

    public boolean validate(WizardContext wizardContext, boolean defaultFormat) throws ConfigurationException {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return true;
        }
        if (!this.myProjectSettingsControl.validate(this.myProjectSettings)) {
            return false;
        }
        if (this.mySystemSettingsControl != null && !this.mySystemSettingsControl.validate(this.mySystemSettings)) {
            return false;
        }
        String linkedProjectPath = this.myLinkedProjectPathField.getPath();
        if (StringUtil.isEmpty((String)linkedProjectPath)) {
            throw new ConfigurationException(ExternalSystemBundle.message((String)"error.project.undefined", (Object[])new Object[0]));
        }
        if (this.myCurrentProject != null) {
            ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.myExternalSystemId);
            assert (manager != null);
            AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myCurrentProject);
            if (settings.getLinkedProjectSettings(linkedProjectPath) != null) {
                throw new ConfigurationException(ExternalSystemBundle.message((String)"error.project.already.registered", (Object[])new Object[0]));
            }
        }
        return !wizardContext.isCreatingNewProject() || this.myLinkedProjectPathField.validateNameAndPath(wizardContext, defaultFormat);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemSettings";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSettingsControl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setLinkedProjectPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

