/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationsNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=40)
public class ModuleNode
extends ExternalSystemNode<ModuleData> {
    private final boolean myIsRoot;
    private final ModuleData myData;
    private final RunConfigurationsNode myRunConfigurationsNode;

    public ModuleNode(ExternalProjectsView externalProjectsView, DataNode<ModuleData> dataNode, boolean isRoot) {
        super(externalProjectsView, null, dataNode);
        this.myIsRoot = isRoot;
        this.myData = (ModuleData)dataNode.getData();
        this.myRunConfigurationsNode = new RunConfigurationsNode(externalProjectsView, this);
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.setIcon(this.getUiAware().getProjectIcon());
        String hint = null;
        if (this.myIsRoot) {
            hint = "root";
        }
        String tooltip = this.myData.toString() + (this.myData.getDescription() != null ? "<br>" + this.myData.getDescription() : "");
        this.setNameAndTooltip(this.getName(), tooltip, hint);
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode> doBuildChildren() {
        ArrayList myChildNodes = ContainerUtil.newArrayList();
        myChildNodes.addAll(super.doBuildChildren());
        myChildNodes.add(this.myRunConfigurationsNode);
        ArrayList arrayList = myChildNodes;
        if (arrayList == null) {
            ModuleNode.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public String getName() {
        return this.myData.getId();
    }

    @Override
    @Nullable
    protected String getMenuId() {
        return "ExternalSystemView.ModuleMenu";
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    @Override
    public int compareTo(@NotNull ExternalSystemNode node) {
        if (node == null) {
            ModuleNode.$$$reportNull$$$0(1);
        }
        return this.myIsRoot ? -1 : (node instanceof ModuleNode && ((ModuleNode)node).myIsRoot ? 1 : super.compareTo(node));
    }

    public void updateRunConfigurations() {
        this.myRunConfigurationsNode.updateRunConfigurations();
        this.childrenChanged();
        this.getExternalProjectsView().updateUpTo(this);
        this.getExternalProjectsView().updateUpTo(this.myRunConfigurationsNode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ModuleNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ModuleNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

