/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.TestEditorSplitter;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.awt.Component;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class TestEditorManagerImpl
extends FileEditorManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.idea.test.TestEditorManagerImpl");
    private final TestEditorSplitter myTestEditorSplitter;
    private final Project myProject;
    private int counter;
    private final Map<VirtualFile, Editor> myVirtualFile2Editor;
    private VirtualFile myActiveFile;
    private static final LightVirtualFile LIGHT_VIRTUAL_FILE = new LightVirtualFile("Dummy.java");

    public TestEditorManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(0);
        }
        this.myTestEditorSplitter = new TestEditorSplitter();
        this.counter = 0;
        this.myVirtualFile2Editor = new HashMap();
        this.myProject = project2;
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
        project2.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(Project project2) {
                if (project2 == TestEditorManagerImpl.this.myProject) {
                    TestEditorManagerImpl.this.closeAllFiles();
                }
            }
        });
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, boolean searchForSplitter) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(1);
        }
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            if (file2 == null) {
                TestEditorManagerImpl.$$$reportNull$$$0(58);
            }
            result2.set(this.openFileImpl3(file2, focusEditor));
        }, "", null);
        Pair pair2 = (Pair)result2.get();
        if (pair2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(2);
        }
        return pair2;
    }

    private Pair<FileEditor[], FileEditorProvider[]> openFileImpl3(VirtualFile file2, boolean focusEditor) {
        FileEditorProvider provider = (FileEditorProvider)file2.getUserData(FileEditorProvider.KEY);
        if (provider != null && provider.accept(this.getProject(), file2)) {
            return Pair.create((Object)new FileEditor[]{provider.createEditor(this.getProject(), file2)}, (Object)new FileEditorProvider[]{provider});
        }
        Editor editor = this.openTextEditor(new OpenFileDescriptor(this.myProject, file2), focusEditor);
        assert (editor != null);
        TextEditor fileEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        FileEditorProvider fileEditorProvider = TestEditorManagerImpl.getProvider();
        Pair result2 = Pair.create((Object)new FileEditor[]{fileEditor}, (Object)new FileEditorProvider[]{fileEditorProvider});
        this.modifyTabWell(() -> this.lambda$openFileImpl3$1(file2, (FileEditor)fileEditor, fileEditorProvider));
        return result2;
    }

    private void modifyTabWell(Runnable tabWellModification) {
        FileEditor lastFocusedEditor = this.myTestEditorSplitter.getFocusedFileEditor();
        VirtualFile lastFocusedFile = this.myTestEditorSplitter.getFocusedFile();
        FileEditorProvider oldProvider = this.myTestEditorSplitter.getProviderFromFocused();
        tabWellModification.run();
        FileEditor currentlyFocusedEditor = this.myTestEditorSplitter.getFocusedFileEditor();
        VirtualFile currentlyFocusedFile = this.myTestEditorSplitter.getFocusedFile();
        FileEditorProvider newProvider = this.myTestEditorSplitter.getProviderFromFocused();
        FileEditorManagerEvent event = new FileEditorManagerEvent((FileEditorManager)this, lastFocusedFile, lastFocusedEditor, oldProvider, currentlyFocusedFile, currentlyFocusedEditor, newProvider);
        FileEditorManagerListener publisher = (FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
        this.notifyPublisher(() -> publisher.selectionChanged(event));
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, @NotNull EditorWindow window) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(3);
        }
        if (window == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(4);
        }
        Pair<FileEditor[], FileEditorProvider[]> pair2 = this.openFileWithProviders(file2, focusEditor, false);
        if (pair2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(5);
        }
        return pair2;
    }

    @Override
    public boolean isInsideChange() {
        return false;
    }

    @Override
    @NotNull
    public ActionCallback notifyPublisher(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(6);
        }
        runnable2.run();
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(7);
        }
        return actionCallback;
    }

    @Override
    public EditorsSplitters getSplittersFor(Component c) {
        return null;
    }

    @Override
    public void createSplitter(int orientation, EditorWindow window) {
        String containerName = this.createNewTabbedContainerName();
        this.myTestEditorSplitter.setActiveTabGroup(containerName);
    }

    private String createNewTabbedContainerName() {
        ++this.counter;
        return "SplitTabContainer" + ((Object)this.counter).toString();
    }

    @Override
    public void changeSplitterOrientation() {
    }

    @Override
    public void flipTabs() {
    }

    @Override
    public boolean tabsMode() {
        return false;
    }

    @Override
    public boolean isInSplitter() {
        return false;
    }

    @Override
    public boolean hasOpenedFile() {
        return false;
    }

    @Override
    public VirtualFile getCurrentFile() {
        return this.myActiveFile;
    }

    @Override
    public Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Override
    public boolean isChanged(@NotNull EditorComposite editor) {
        if (editor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(9);
        }
        return false;
    }

    @Override
    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        if (window == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Override
    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        if (window == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(11);
        }
        return null;
    }

    public void addTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(12);
        }
        if (component == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(13);
        }
    }

    public void removeTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(14);
        }
        if (component == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(15);
        }
    }

    public void addBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(16);
        }
        if (component == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(17);
        }
    }

    public void removeBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(18);
        }
        if (component == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(19);
        }
    }

    @Override
    public void closeAllFiles() {
        for (VirtualFile file2 : new LinkedList<VirtualFile>(this.myVirtualFile2Editor.keySet())) {
            this.closeFile(file2);
        }
    }

    private static FileEditorProvider getProvider() {
        return new FileEditorProvider(){

            public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return false;
            }

            @NotNull
            public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                throw new IncorrectOperationException();
            }

            public void disposeEditor(@NotNull FileEditor editor) {
                if (editor == null) {
                    2.$$$reportNull$$$0(4);
                }
            }

            @NotNull
            public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project2, @NotNull VirtualFile file2) {
                if (sourceElement == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (project2 == null) {
                    2.$$$reportNull$$$0(6);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(7);
                }
                throw new IncorrectOperationException();
            }

            @NotNull
            public String getEditorTypeId() {
                if ("" == null) {
                    2.$$$reportNull$$$0(8);
                }
                return "";
            }

            @NotNull
            public FileEditorPolicy getPolicy() {
                throw new IncorrectOperationException();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 8: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 8: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sourceElement";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$2";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEditorTypeId";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "accept";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "createEditor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "disposeEditor";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "readState";
                        break;
                    }
                    case 8: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 8: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    public EditorWindow getCurrentWindow() {
        return null;
    }

    @Override
    @NotNull
    public AsyncResult<EditorWindow> getActiveWindow() {
        AsyncResult asyncResult = AsyncResult.done(null);
        if (asyncResult == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(20);
        }
        return asyncResult;
    }

    @Override
    public void setCurrentWindow(EditorWindow window) {
    }

    @Override
    public VirtualFile getFile(@NotNull FileEditor editor) {
        if (editor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(21);
        }
        return LIGHT_VIRTUAL_FILE;
    }

    @Override
    public void updateFilePresentation(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(22);
        }
    }

    @Override
    public void unsplitWindow() {
    }

    @Override
    public void unsplitAllWindow() {
    }

    @Override
    @NotNull
    public EditorWindow[] getWindows() {
        EditorWindow[] editorWindowArray = new EditorWindow[]{};
        if (editorWindowArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(23);
        }
        return editorWindowArray;
    }

    public FileEditor getSelectedEditor(@NotNull VirtualFile file2) {
        Editor editor;
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(24);
        }
        return (editor = this.getEditor(file2)) == null ? null : TextEditorProvider.getInstance().getTextEditor(editor);
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(25);
        }
        return this.getEditor(file2) != null;
    }

    @NotNull
    public FileEditor[] getEditors(@NotNull VirtualFile file2) {
        FileEditor e;
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(26);
        }
        if ((e = this.getSelectedEditor(file2)) == null) {
            FileEditor[] fileEditorArray = new FileEditor[]{};
            if (fileEditorArray == null) {
                TestEditorManagerImpl.$$$reportNull$$$0(27);
            }
            return fileEditorArray;
        }
        FileEditor[] fileEditorArray = new FileEditor[]{e};
        if (fileEditorArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(28);
        }
        return fileEditorArray;
    }

    @NotNull
    public FileEditor[] getAllEditors(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(29);
        }
        FileEditor[] fileEditorArray = this.getEditors(file2);
        if (fileEditorArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(30);
        }
        return fileEditorArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getSiblings(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(31);
        }
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        this.closeAllFiles();
    }

    public void closeFile(@NotNull VirtualFile file2) {
        Editor editor;
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(32);
        }
        if ((editor = this.myVirtualFile2Editor.remove(file2)) != null) {
            TextEditorProvider editorProvider = TextEditorProvider.getInstance();
            editorProvider.disposeEditor((FileEditor)editorProvider.getTextEditor(editor));
            EditorFactory.getInstance().releaseEditor(editor);
        }
        if (Comparing.equal((Object)file2, (Object)this.myActiveFile)) {
            this.myActiveFile = null;
        }
        this.modifyTabWell(() -> {
            if (file2 == null) {
                TestEditorManagerImpl.$$$reportNull$$$0(57);
            }
            this.myTestEditorSplitter.closeFile(file2);
        });
    }

    @Override
    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(33);
        }
        if (window == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(34);
        }
        this.closeFile(file2);
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] virtualFileArray;
        if (this.myActiveFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = this.myActiveFile;
        }
        if (virtualFileArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(35);
        }
        return virtualFileArray;
    }

    @NotNull
    public FileEditor[] getSelectedEditors() {
        FileEditor[] fileEditorArray = new FileEditor[]{};
        if (fileEditorArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(36);
        }
        return fileEditorArray;
    }

    public Editor getSelectedTextEditor() {
        return this.myActiveFile != null ? this.getEditor(this.myActiveFile) : null;
    }

    @Override
    public JComponent getComponent() {
        return new JLabel();
    }

    @NotNull
    public VirtualFile[] getOpenFiles() {
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(this.myVirtualFile2Editor.keySet());
        if (virtualFileArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(37);
        }
        return virtualFileArray;
    }

    public Editor getEditor(VirtualFile file2) {
        return this.myVirtualFile2Editor.get(file2);
    }

    @NotNull
    public FileEditor[] getAllEditors() {
        FileEditor[] result2 = new FileEditor[this.myVirtualFile2Editor.size()];
        int i = 0;
        for (Map.Entry<VirtualFile, Editor> entry : this.myVirtualFile2Editor.entrySet()) {
            TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(entry.getValue());
            result2[i++] = textEditor;
        }
        if (result2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(38);
        }
        return result2;
    }

    public void showEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComponent) {
        if (editor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(39);
        }
        if (annotationComponent == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(40);
        }
    }

    public void removeEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComponent) {
        if (editor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(41);
        }
        if (annotationComponent == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(42);
        }
    }

    public Editor openTextEditor(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        VirtualFile file2;
        Editor editor;
        if (descriptor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(43);
        }
        if ((editor = this.myVirtualFile2Editor.get(file2 = descriptor2.getFile())) == null) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
            LOG.assertTrue(psiFile != null, (Object)file2);
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
            LOG.assertTrue(document != null, (Object)psiFile);
            editor = EditorFactory.getInstance().createEditor(document, this.myProject);
            EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)this.myProject, (VirtualFile)file2);
            ((EditorEx)editor).setHighlighter(highlighter);
            ((EditorEx)editor).setFile(file2);
            this.myVirtualFile2Editor.put(file2, editor);
        }
        if (descriptor2.getOffset() >= 0) {
            editor.getCaretModel().moveToOffset(descriptor2.getOffset());
        } else if (descriptor2.getLine() >= 0 && descriptor2.getColumn() >= 0) {
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(descriptor2.getLine(), descriptor2.getColumn()));
        }
        editor.getSelectionModel().removeSelection();
        this.myActiveFile = file2;
        return editor;
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(44);
        }
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(45);
        }
        if (parentDisposable == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(46);
        }
    }

    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(47);
        }
    }

    @NotNull
    public List<FileEditor> openEditor(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        if (descriptor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(48);
        }
        List<FileEditor> list2 = Collections.emptyList();
        if (list2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(49);
        }
        return list2;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(50);
        }
        return project2;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(51);
        }
        Pair<FileEditor, FileEditorProvider> editorAndProvider = this.myTestEditorSplitter.getEditorAndProvider(file2);
        FileEditor[] fileEditor = new FileEditor[]{};
        FileEditorProvider[] fileEditorProvider = new FileEditorProvider[]{};
        if (editorAndProvider != null) {
            fileEditor = new FileEditor[]{(FileEditor)editorAndProvider.first};
            fileEditorProvider = new FileEditorProvider[]{(FileEditorProvider)editorAndProvider.second};
        }
        Pair pair2 = Pair.create((Object)fileEditor, (Object)fileEditorProvider);
        if (pair2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(52);
        }
        return pair2;
    }

    @Override
    public int getWindowSplitCount() {
        return 0;
    }

    @Override
    public boolean hasSplitOrUndockedWindows() {
        return false;
    }

    @Override
    @NotNull
    public EditorsSplitters getSplitters() {
        throw new IncorrectOperationException();
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(53);
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(54);
        }
        return actionCallback;
    }

    public void setSelectedEditor(@NotNull VirtualFile file2, @NotNull String fileEditorProviderId) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(55);
        }
        if (fileEditorProviderId == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(56);
        }
    }

    private /* synthetic */ void lambda$openFileImpl3$1(VirtualFile file2, FileEditor fileEditor, FileEditorProvider fileEditorProvider) {
        this.myTestEditorSplitter.openAndFocusTab(file2, fileEditor, fileEditorProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 20: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 49: 
            case 50: 
            case 52: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 20: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 49: 
            case 50: 
            case 52: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 51: 
            case 55: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 20: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 49: 
            case 50: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationComponent";
                break;
            }
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 44: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorProviderId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileWithProviders";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyPublisher";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindows";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 30: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEditors";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditors";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFiles";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "openEditor";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsWithProviders";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "openFileWithProviders";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 20: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 49: 
            case 50: 
            case 52: 
            case 54: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyPublisher";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEditorWithProvider";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isChanged";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNextWindow";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPrevWindow";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addTopComponent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeTopComponent";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addBottomComponent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeBottomComponent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateFilePresentation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEditor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isFileOpen";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAllEditors";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getSiblings";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "closeFile";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "showEditorAnnotation";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorAnnotation";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "openTextEditor";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addFileEditorManagerListener";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "removeFileEditorManagerListener";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "openEditor";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsWithProviders";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedEditor";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$closeFile$3";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openFileWithProviders$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 20: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 49: 
            case 50: 
            case 52: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

