/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.ui.KeymapScheme;
import com.intellij.openapi.keymap.impl.ui.KeymapSelector;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class KeymapSchemeManager
extends AbstractSchemeActions<KeymapScheme>
implements SchemesModel<KeymapScheme> {
    private static final Condition<Keymap> FILTER = keymap -> !SystemInfo.isMac || !"$default".equals(keymap.getName());
    private final ArrayList<KeymapScheme> list = new ArrayList();
    private final KeymapSelector selector;
    private static final Comparator<Keymap> KEYMAP_COMPARATOR = (keymap1, keymap2) -> {
        Keymap parent2;
        if (keymap1 == keymap2) {
            return 0;
        }
        if (keymap1 == null) {
            return -1;
        }
        if (keymap2 == null) {
            return 1;
        }
        Keymap parent1 = !keymap1.canModify() ? null : keymap1.getParent();
        Keymap keymap = parent2 = !keymap2.canModify() ? null : keymap2.getParent();
        if (parent1 == null) {
            parent1 = keymap1;
        }
        if (parent2 == null) {
            parent2 = keymap2;
        }
        if (parent1 == parent2) {
            if (!keymap1.canModify()) {
                return -1;
            }
            if (!keymap2.canModify()) {
                return 1;
            }
            return StringUtil.naturalCompare((String)keymap1.getPresentableName(), (String)keymap2.getPresentableName());
        }
        return StringUtil.naturalCompare((String)parent1.getPresentableName(), (String)parent2.getPresentableName());
    };
    private static final Comparator<KeymapScheme> SCHEME_COMPARATOR = (scheme1, scheme2) -> {
        if (scheme1 == scheme2) {
            return 0;
        }
        if (scheme1 == null) {
            return -1;
        }
        if (scheme2 == null) {
            return 1;
        }
        return KEYMAP_COMPARATOR.compare(scheme1.getCurrent(), scheme2.getCurrent());
    };

    KeymapSchemeManager(KeymapSelector selector2) {
        super(selector2);
        this.selector = selector2;
    }

    Keymap getSelectedKeymap() {
        KeymapScheme scheme2 = (KeymapScheme)this.selector.getSelectedScheme();
        return scheme2 == null ? null : scheme2.getCurrent();
    }

    Keymap getMutableKeymap(Keymap keymap) {
        KeymapScheme scheme2 = this.find(keymap);
        if (scheme2 == null) {
            return null;
        }
        if (scheme2.isMutable()) {
            return scheme2.getMutable();
        }
        String name2 = KeyMapBundle.message((String)"new.keymap.name", (Object[])new Object[]{keymap.getPresentableName()});
        int i = 1;
        while (this.containsScheme(name2, false)) {
            name2 = KeyMapBundle.message((String)"new.indexed.keymap.name", (Object[])new Object[]{keymap.getPresentableName(), i});
            ++i;
        }
        return this.copyScheme(scheme2, name2).getMutable();
    }

    void visitMutableKeymaps(Consumer<Keymap> consumer) {
        for (KeymapScheme scheme2 : this.list) {
            if (!scheme2.isMutable()) continue;
            consumer.accept(scheme2.getMutable());
        }
    }

    @Override
    protected Class<KeymapScheme> getSchemeType() {
        return KeymapScheme.class;
    }

    @Override
    protected void onSchemeChanged(@Nullable KeymapScheme scheme2) {
        this.selector.notifyConsumer(scheme2);
    }

    @Override
    public boolean isProjectScheme(@NotNull KeymapScheme scheme2) {
        if (scheme2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(0);
        }
        return false;
    }

    @Override
    public boolean canDuplicateScheme(@NotNull KeymapScheme scheme2) {
        if (scheme2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    protected void duplicateScheme(@NotNull KeymapScheme parent, @NotNull String name2) {
        if (parent == null) {
            KeymapSchemeManager.$$$reportNull$$$0(2);
        }
        if (name2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(3);
        }
        this.copyScheme(parent, name2);
    }

    @NotNull
    private KeymapScheme copyScheme(@NotNull KeymapScheme parent, @NotNull String name2) {
        if (parent == null) {
            KeymapSchemeManager.$$$reportNull$$$0(4);
        }
        if (name2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(5);
        }
        KeymapScheme scheme2 = parent.copy(name2);
        this.list.add(scheme2);
        this.selector.selectKeymap(scheme2, true);
        KeymapScheme keymapScheme = scheme2;
        if (keymapScheme == null) {
            KeymapSchemeManager.$$$reportNull$$$0(6);
        }
        return keymapScheme;
    }

    @Override
    public boolean canDeleteScheme(@NotNull KeymapScheme scheme2) {
        if (scheme2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(7);
        }
        return scheme2.isMutable();
    }

    @Override
    public void removeScheme(@NotNull KeymapScheme scheme2) {
        if (scheme2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(8);
        }
        this.list.remove(scheme2);
        this.selector.selectKeymap(this.getSchemeToSelect(scheme2.getParent()), true);
    }

    @Override
    public boolean canRenameScheme(@NotNull KeymapScheme scheme2) {
        if (scheme2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(9);
        }
        return scheme2.isMutable();
    }

    @Override
    protected void renameScheme(@NotNull KeymapScheme scheme2, @NotNull String name2) {
        if (scheme2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(10);
        }
        if (name2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(11);
        }
        scheme2.setName(name2);
        this.selector.selectKeymap(scheme2, true);
    }

    @Override
    public boolean containsScheme(@NotNull String name2, boolean projectScheme) {
        if (name2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(12);
        }
        return null != this.find((KeymapScheme scheme2) -> {
            if (name2 == null) {
                KeymapSchemeManager.$$$reportNull$$$0(18);
            }
            return scheme2.contains(name2);
        });
    }

    @Override
    public boolean differsFromDefault(@NotNull KeymapScheme scheme2) {
        if (scheme2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(13);
        }
        return scheme2.canReset();
    }

    @Override
    public boolean canResetScheme(@NotNull KeymapScheme scheme2) {
        if (scheme2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(14);
        }
        return scheme2.isMutable();
    }

    @Override
    protected void resetScheme(@NotNull KeymapScheme scheme2) {
        if (scheme2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(15);
        }
        scheme2.reset();
        this.selector.selectKeymap(scheme2, true);
    }

    boolean canResetActionInKeymap(Keymap mutable, String actionId) {
        KeymapScheme scheme2 = this.find(mutable);
        return scheme2 != null && scheme2.canReset(actionId);
    }

    void resetActionInKeymap(Keymap mutable, String actionId) {
        KeymapScheme scheme2 = this.find(mutable);
        if (scheme2 == null) {
            return;
        }
        scheme2.reset(actionId);
        this.selector.selectKeymap(scheme2, false);
    }

    private KeymapScheme find(Keymap keymap) {
        return keymap == null ? null : this.find((KeymapScheme scheme2) -> scheme2.contains(keymap));
    }

    private KeymapScheme find(@NotNull Predicate<KeymapScheme> predicate) {
        if (predicate == null) {
            KeymapSchemeManager.$$$reportNull$$$0(16);
        }
        for (KeymapScheme scheme2 : this.list) {
            if (!predicate.test(scheme2)) continue;
            return scheme2;
        }
        return null;
    }

    void reset() {
        this.list.clear();
        KeymapSchemeManager.getKeymaps().forEach(keymap -> this.list.add(new KeymapScheme((Keymap)keymap)));
        this.selector.selectKeymap(this.getSchemeToSelect(null), true);
    }

    String apply() {
        HashSet<String> set2 = new HashSet<String>();
        for (KeymapScheme scheme3 : this.list) {
            String name2 = scheme3.getName();
            if (StringUtil.isEmptyOrSpaces((String)name2)) {
                return KeyMapBundle.message((String)"configuration.all.keymaps.should.have.non.empty.names.error.message", (Object[])new Object[0]);
            }
            if (set2.add(name2)) continue;
            return KeyMapBundle.message((String)"configuration.all.keymaps.should.have.unique.names.error.message", (Object[])new Object[0]);
        }
        KeymapScheme selected = (KeymapScheme)this.selector.getSelectedScheme();
        Keymap active = selected == null ? null : selected.getOriginal();
        List keymaps = this.list.stream().map(scheme2 -> scheme2.apply()).collect(Collectors.toList());
        KeymapManagerImpl manager = (KeymapManagerImpl)KeymapManager.getInstance();
        manager.setKeymaps(keymaps, active, FILTER);
        this.selector.notifyConsumer(selected);
        return null;
    }

    @NotNull
    private static List<Keymap> getKeymaps() {
        KeymapManagerImpl manager = (KeymapManagerImpl)KeymapManager.getInstance();
        List<Keymap> list2 = manager.getKeymaps(FILTER);
        if (list2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(17);
        }
        return list2;
    }

    private KeymapScheme getSchemeToSelect(Keymap active) {
        if (active == null) {
            active = KeymapManager.getInstance().getActiveKeymap();
        }
        KeymapScheme found = null;
        for (KeymapScheme scheme2 : this.list) {
            Keymap keymap = scheme2.getOriginal();
            if (keymap == active) {
                return scheme2;
            }
            if (found != null && !"Mac OS X 10.5+".equals(keymap.getName())) continue;
            found = scheme2;
        }
        return found;
    }

    boolean isModified() {
        Keymap active;
        KeymapScheme selected = (KeymapScheme)this.selector.getSelectedScheme();
        Keymap keymap = active = selected == null ? null : selected.getOriginal();
        if (!Objects.equals(active, KeymapManager.getInstance().getActiveKeymap())) {
            return true;
        }
        Iterator keymaps = KeymapSchemeManager.getKeymaps().stream().sorted(KEYMAP_COMPARATOR).iterator();
        Iterator<KeymapScheme> schemes = this.list.iterator();
        while (keymaps.hasNext() && schemes.hasNext()) {
            if (Objects.equals(keymaps.next(), schemes.next().getCurrent())) continue;
            return true;
        }
        return keymaps.hasNext() || schemes.hasNext();
    }

    List<KeymapScheme> getSchemes() {
        this.list.sort(SCHEME_COMPARATOR);
        return this.list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/KeymapSchemeManager";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapSchemeManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyScheme";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeymaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isProjectScheme";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canDuplicateScheme";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "duplicateScheme";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyScheme";
                break;
            }
            case 6: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteScheme";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeScheme";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canRenameScheme";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "renameScheme";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsScheme";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "differsFromDefault";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canResetScheme";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resetScheme";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$containsScheme$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

