/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.UnknownModuleType;
import com.intellij.openapi.module.impl.AutomaticModuleUnloader;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleFileListener;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.module.impl.ModulePathKt;
import com.intellij.openapi.module.impl.UnloadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.UnloadedModulesListChange;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectModuleManager", storages={@Storage(value="modules.xml")})
public class ModuleManagerComponent
extends ModuleManagerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleManagerComponent");
    private final MessageBusConnection myMessageBusConnection;

    public ModuleManagerComponent(@NotNull Project project2) {
        if (project2 == null) {
            ModuleManagerComponent.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myMessageBusConnection = project2.getMessageBus().connect((Disposable)this);
        this.myMessageBusConnection.setDefaultHandler(new MessageHandler(){

            public void handle(Method event, Object ... params) {
                ModuleManagerComponent.this.cleanCachedStuff();
            }
        });
        this.myMessageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS);
        if (project2.isDefault()) {
            return;
        }
        this.myMessageBusConnection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener(){

            public void projectComponentsInitialized(@NotNull Project project2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (project2 != ModuleManagerComponent.this.myProject) {
                    return;
                }
                long t = System.currentTimeMillis();
                ModuleManagerComponent.this.loadModules(ModuleManagerComponent.this.myModuleModel);
                t = System.currentTimeMillis() - t;
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.info(ModuleManagerComponent.this.myModuleModel.getModules().length + " module(s) loaded in " + t + " ms");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/impl/ModuleManagerComponent$2", "projectComponentsInitialized"));
            }
        });
        this.myMessageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new ModuleFileListener(this));
    }

    @Override
    protected void unloadNewlyAddedModulesIfPossible(Set<ModulePath> modulesToLoad, List<UnloadedModuleDescriptionImpl> modulesToUnload) {
        UnloadedModulesListChange change = AutomaticModuleUnloader.getInstance(this.myProject).processNewModules(modulesToLoad, modulesToUnload);
        modulesToLoad.removeAll(change.getToUnload());
        modulesToUnload.addAll(change.getToUnloadDescriptions());
    }

    @Override
    protected void showUnknownModuleTypeNotification(@NotNull List<Module> modulesWithUnknownTypes) {
        if (modulesWithUnknownTypes == null) {
            ModuleManagerComponent.$$$reportNull$$$0(1);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !modulesWithUnknownTypes.isEmpty()) {
            String message2;
            if (modulesWithUnknownTypes.size() == 1) {
                message2 = ProjectBundle.message((String)"module.unknown.type.single.error", (Object[])new Object[]{modulesWithUnknownTypes.get(0).getName(), ModuleType.get((Module)modulesWithUnknownTypes.get(0)).getId()});
            } else {
                StringBuilder modulesBuilder = new StringBuilder();
                for (Module module2 : modulesWithUnknownTypes) {
                    modulesBuilder.append("<br>\"");
                    modulesBuilder.append(module2.getName()).append("\" (type '").append(ModuleType.get((Module)module2).getId()).append("')");
                }
                modulesBuilder.append("<br>");
                message2 = ProjectBundle.message((String)"module.unknown.type.multiple.error", (Object[])new Object[]{modulesBuilder.toString()});
            }
            Notifications.Bus.notify((Notification)new Notification("Module Manager", ProjectBundle.message((String)"module.unknown.type.title", (Object[])new Object[0]), message2, NotificationType.WARNING), (Project)this.myProject);
        }
    }

    @Override
    @NotNull
    protected ModuleEx createModule(@NotNull String filePath) {
        if (filePath == null) {
            ModuleManagerComponent.$$$reportNull$$$0(2);
        }
        ModuleImpl moduleImpl = new ModuleImpl(ModulePathKt.getModuleNameByFilePath(filePath), this.myProject);
        if (moduleImpl == null) {
            ModuleManagerComponent.$$$reportNull$$$0(3);
        }
        return moduleImpl;
    }

    @Override
    @NotNull
    protected ModuleEx createAndLoadModule(@NotNull String filePath) {
        if (filePath == null) {
            ModuleManagerComponent.$$$reportNull$$$0(4);
        }
        ModuleEx moduleEx = this.createModule(filePath);
        if (moduleEx == null) {
            ModuleManagerComponent.$$$reportNull$$$0(5);
        }
        return moduleEx;
    }

    @Override
    protected void setUnloadedModuleNames(@NotNull List<String> unloadedModuleNames) {
        if (unloadedModuleNames == null) {
            ModuleManagerComponent.$$$reportNull$$$0(6);
        }
        super.setUnloadedModuleNames(unloadedModuleNames);
        if (!unloadedModuleNames.isEmpty()) {
            ArrayList<String> loadedModules = new ArrayList<String>(this.myModuleModel.myModules.keySet());
            loadedModules.removeAll(new HashSet<String>(unloadedModuleNames));
            AutomaticModuleUnloader.getInstance(this.myProject).setLoadedModules(loadedModules);
        }
    }

    @Override
    protected boolean isUnknownModuleType(@NotNull Module module2) {
        if (module2 == null) {
            ModuleManagerComponent.$$$reportNull$$$0(7);
        }
        return ModuleType.get((Module)module2) instanceof UnknownModuleType;
    }

    @Override
    protected void fireModulesAdded() {
        for (Module module2 : this.myModuleModel.getModules()) {
            TransactionGuard.getInstance().submitTransactionAndWait(() -> this.fireModuleAddedInWriteAction((ModuleEx)module2));
        }
    }

    @Override
    protected void deliverPendingEvents() {
        this.myMessageBusConnection.deliverImmediately();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesWithUnknownTypes";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/ModuleManagerComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModuleNames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/ModuleManagerComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndLoadModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showUnknownModuleTypeNotification";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAndLoadModule";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setUnloadedModuleNames";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUnknownModuleType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

