/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.ModuleStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.ExternalModuleListStorage;
import com.intellij.openapi.module.impl.ExternalModuleListStorageKt;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleLoadingErrorDescription;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.module.impl.ModulePathSaveItem;
import com.intellij.openapi.module.impl.SaveItem;
import com.intellij.openapi.module.impl.UnloadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.UnloadedModulesListStorage;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleManagerImpl
extends ModuleManager
implements Disposable,
PersistentStateComponent<Element>,
ProjectComponent {
    public static final String COMPONENT_NAME = "ProjectModuleManager";
    public static final String ELEMENT_MODULES = "modules";
    public static final String ELEMENT_MODULE = "module";
    public static final String ATTRIBUTE_FILEURL = "fileurl";
    public static final String ATTRIBUTE_FILEPATH = "filepath";
    public static final String ATTRIBUTE_GROUP = "group";
    public static final String IML_EXTENSION = ".iml";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleManagerImpl");
    private static final Key<String> DISPOSED_MODULE_NAME = Key.create((String)"DisposedNeverAddedModuleName");
    public static final String MODULE_GROUP_SEPARATOR = "/";
    protected final Project myProject;
    protected final MessageBus myMessageBus;
    protected volatile ModuleModelImpl myModuleModel;
    private Set<ModulePath> myModulePathsToLoad;
    private final Set<ModulePath> myFailedModulePaths;
    private final Map<String, UnloadedModuleDescriptionImpl> myUnloadedModules;
    private double myProgressStep;
    private volatile Module[] myCachedSortedModules;
    private volatile Comparator<Module> myCachedModuleComparator;

    public static ModuleManagerImpl getInstanceImpl(Project project2) {
        return (ModuleManagerImpl)ModuleManagerImpl.getInstance((Project)project2);
    }

    public ModuleManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(0);
        }
        this.myModuleModel = new ModuleModelImpl(this);
        this.myFailedModulePaths = new THashSet();
        this.myUnloadedModules = new LinkedHashMap<String, UnloadedModuleDescriptionImpl>();
        this.myProject = project2;
        this.myMessageBus = project2.getMessageBus();
    }

    public void projectOpened() {
        this.fireModulesAdded();
        for (Module module2 : this.myModuleModel.getModules()) {
            ((ModuleEx)module2).projectOpened();
        }
    }

    public void projectClosed() {
        for (Module module2 : this.myModuleModel.getModules()) {
            ((ModuleEx)module2).projectClosed();
        }
    }

    protected void cleanCachedStuff() {
        this.myCachedModuleComparator = null;
        this.myCachedSortedModules = null;
    }

    public void dispose() {
        this.myModuleModel.disposeModel();
    }

    public Element getState() {
        Element e = new Element("state");
        this.writeExternal(e, ExternalModuleListStorageKt.getFilteredModuleList(this.myProject, this.getModules(), false));
        return e;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ModuleManagerImpl.$$$reportNull$$$0(1);
        }
        LinkedHashSet<ModulePath> files = ModuleManagerImpl.getPathsToModuleFiles(state);
        Set<ModulePath> externalModules = ((ExternalModuleListStorage)this.myProject.getComponent(ExternalModuleListStorage.class)).getLoadedState();
        if (externalModules != null) {
            files.addAll(externalModules);
        }
        this.loadState(files);
    }

    public void noStateLoaded() {
        Set<ModulePath> externalModules = ((ExternalModuleListStorage)this.myProject.getComponent(ExternalModuleListStorage.class)).getLoadedState();
        if (externalModules != null) {
            this.loadState(new LinkedHashSet<ModulePath>(externalModules));
        }
    }

    public void loadStateFromModulePaths(LinkedHashSet<ModulePath> modulePaths) {
        this.loadState(modulePaths);
    }

    private void loadState(Set<ModulePath> modulePaths) {
        boolean isFirstLoadState = this.myModulePathsToLoad == null;
        this.myModulePathsToLoad = modulePaths;
        HashSet<String> unloadedModuleNames = new HashSet<String>(UnloadedModulesListStorage.getInstance(this.myProject).getUnloadedModuleNames());
        Iterator<ModulePath> iterator = this.myModulePathsToLoad.iterator();
        ArrayList<ModulePath> unloadedModulePaths = new ArrayList<ModulePath>();
        while (iterator.hasNext()) {
            ModulePath modulePath = iterator.next();
            if (!unloadedModuleNames.contains(modulePath.getModuleName())) continue;
            unloadedModulePaths.add(modulePath);
            iterator.remove();
        }
        ArrayList<UnloadedModuleDescriptionImpl> unloaded = new ArrayList<UnloadedModuleDescriptionImpl>(UnloadedModuleDescriptionImpl.createFromPaths(unloadedModulePaths, this));
        if (!unloaded.isEmpty()) {
            this.unloadNewlyAddedModulesIfPossible(this.myModulePathsToLoad, unloaded);
        }
        this.myUnloadedModules.clear();
        for (UnloadedModuleDescriptionImpl description : unloaded) {
            this.myUnloadedModules.put(description.getName(), description);
        }
        if (isFirstLoadState) {
            return;
        }
        ModifiableModuleModel model = this.getModifiableModel();
        Module[] existingModules = model.getModules();
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        THashMap modulePathMap = new THashMap(this.myModulePathsToLoad.size());
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            modulePathMap.put(modulePath.getPath(), modulePath);
        }
        for (Module existingModule : existingModules) {
            Object[] group;
            ModulePath correspondingPath = (ModulePath)modulePathMap.remove(existingModule.getModuleFilePath());
            if (correspondingPath == null) {
                model.disposeModule(existingModule);
                continue;
            }
            this.myModulePathsToLoad.remove(correspondingPath);
            String groupStr = correspondingPath.getGroup();
            Object[] objectArray = group = groupStr == null ? null : groupStr.split(MODULE_GROUP_SEPARATOR);
            if (Arrays.equals(group, model.getModuleGroupPath(existingModule))) continue;
            groupInterner.setModuleGroupPath(model, existingModule, (String[])group);
        }
        this.loadModules((ModuleModelImpl)model);
        ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableModuleModel)model).commit());
        this.myModulePathsToLoad.clear();
    }

    protected void unloadNewlyAddedModulesIfPossible(Set<ModulePath> modulesToLoad, List<UnloadedModuleDescriptionImpl> modulesToUnload) {
    }

    @NotNull
    public static LinkedHashSet<ModulePath> getPathsToModuleFiles(@NotNull Element element) {
        if (element == null) {
            ModuleManagerImpl.$$$reportNull$$$0(2);
        }
        LinkedHashSet<ModulePath> paths = new LinkedHashSet<ModulePath>();
        Element modules = element.getChild(ELEMENT_MODULES);
        if (modules != null) {
            for (Element moduleElement : modules.getChildren(ELEMENT_MODULE)) {
                String fileUrlValue = moduleElement.getAttributeValue(ATTRIBUTE_FILEURL);
                String filepath = fileUrlValue == null ? moduleElement.getAttributeValue(ATTRIBUTE_FILEPATH) : VirtualFileManager.extractPath((String)fileUrlValue);
                paths.add(new ModulePath(FileUtilRt.toSystemIndependentName((String)filepath), moduleElement.getAttributeValue(ATTRIBUTE_GROUP)));
            }
        }
        LinkedHashSet<ModulePath> linkedHashSet = paths;
        if (linkedHashSet == null) {
            ModuleManagerImpl.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    protected void loadModules(@NotNull ModuleModelImpl moduleModel) {
        if (moduleModel == null) {
            ModuleManagerImpl.$$$reportNull$$$0(4);
        }
        this.myFailedModulePaths.clear();
        if (this.myModulePathsToLoad == null || this.myModulePathsToLoad.isEmpty()) {
            return;
        }
        this.myFailedModulePaths.addAll(this.myModulePathsToLoad);
        ProgressIndicator globalIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        EmptyProgressIndicator progressIndicator = this.myProject.isDefault() || globalIndicator == null ? new EmptyProgressIndicator() : globalIndicator;
        progressIndicator.setText("Loading modules...");
        progressIndicator.setText2("");
        List<ModuleLoadingErrorDescription> errors = Collections.synchronizedList(new ArrayList());
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        ExecutorService service = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"modules loader", (int)JobSchedulerImpl.CORES_COUNT);
        ArrayList<Pair> tasks = new ArrayList<Pair>();
        THashSet paths = new THashSet();
        boolean parallel = Registry.is((String)"parallel.modules.loading") && !ApplicationManager.getApplication().isDispatchThread();
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            if (progressIndicator.isCanceled()) break;
            String path = modulePath.getPath();
            if (!paths.add(path)) continue;
            if (!parallel) {
                tasks.add(Pair.create(null, (Object)modulePath));
                continue;
            }
            tasks.add(Pair.create(service.submit(() -> this.lambda$loadModules$1((ProgressIndicator)progressIndicator, moduleModel, path, errors, modulePath)), (Object)modulePath));
        }
        SmartList modulesWithUnknownTypes = new SmartList();
        for (Pair task : tasks) {
            if (progressIndicator.isCanceled()) break;
            try {
                ModulePath modulePath;
                String groupPathString;
                Module module2;
                if (parallel) {
                    Module module22 = (Module)((Future)task.first).get();
                } else {
                    module2 = moduleModel.loadModuleInternal(((ModulePath)task.second).getPath());
                    progressIndicator.setFraction(progressIndicator.getFraction() + this.myProgressStep);
                }
                if (module2 == null) continue;
                if (this.isUnknownModuleType(module2)) {
                    modulesWithUnknownTypes.add(module2);
                }
                if ((groupPathString = (modulePath = (ModulePath)task.second).getGroup()) != null) {
                    groupInterner.setModuleGroupPath(moduleModel, module2, groupPathString.split(MODULE_GROUP_SEPARATOR));
                }
                this.myFailedModulePaths.remove(modulePath);
            }
            catch (IOException e) {
                this.reportError(errors, (ModulePath)task.second, e);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        service.shutdown();
        progressIndicator.checkCanceled();
        Application application = ApplicationManager.getApplication();
        if (application.isInternal() || application.isEAP() || ApplicationInfo.getInstance().getBuild().isSnapshot()) {
            THashMap track = new THashMap();
            for (Module module3 : moduleModel.getModules()) {
                for (String url : ModuleRootManager.getInstance((Module)module3).getContentRootUrls()) {
                    Module oldModule = track.put(url, module3);
                    if (oldModule == null) continue;
                    LOG.error("Module '" + module3.getName() + "' and module '" + oldModule.getName() + "' have the same content root: " + url);
                }
            }
        }
        this.onModuleLoadErrors(moduleModel, errors);
        this.showUnknownModuleTypeNotification((List<Module>)modulesWithUnknownTypes);
    }

    private void reportError(List<ModuleLoadingErrorDescription> errors, ModulePath modulePath, Exception e) {
        errors.add(new ModuleLoadingErrorDescription(ProjectBundle.message((String)"module.cannot.load.error", (Object[])new Object[]{modulePath.getPath(), e.getMessage()}), modulePath, this));
    }

    public int getModulePathsCount() {
        return this.myModulePathsToLoad == null ? 0 : this.myModulePathsToLoad.size();
    }

    public void setProgressStep(double step) {
        this.myProgressStep = step;
    }

    protected boolean isUnknownModuleType(@NotNull Module module2) {
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(5);
        }
        return false;
    }

    protected void showUnknownModuleTypeNotification(@NotNull List<Module> types) {
        if (types == null) {
            ModuleManagerImpl.$$$reportNull$$$0(6);
        }
    }

    protected void fireModuleAdded(@NotNull Module module2) {
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(7);
        }
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).moduleAdded(this.myProject, module2);
    }

    protected void fireModuleRemoved(@NotNull Module module2) {
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(8);
        }
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).moduleRemoved(this.myProject, module2);
    }

    protected void fireBeforeModuleRemoved(@NotNull Module module2) {
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(9);
        }
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).beforeModuleRemoved(this.myProject, module2);
    }

    protected void fireModulesRenamed(@NotNull List<Module> modules, @NotNull Map<Module, String> oldNames) {
        if (modules == null) {
            ModuleManagerImpl.$$$reportNull$$$0(10);
        }
        if (oldNames == null) {
            ModuleManagerImpl.$$$reportNull$$$0(11);
        }
        if (!modules.isEmpty()) {
            ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).modulesRenamed(this.myProject, modules, oldNames::get);
        }
    }

    private void onModuleLoadErrors(@NotNull ModuleModelImpl moduleModel, @NotNull List<ModuleLoadingErrorDescription> errors) {
        if (moduleModel == null) {
            ModuleManagerImpl.$$$reportNull$$$0(12);
        }
        if (errors == null) {
            ModuleManagerImpl.$$$reportNull$$$0(13);
        }
        if (errors.isEmpty()) {
            return;
        }
        ModuleModelImpl.access$502(moduleModel, null);
        for (ModuleLoadingErrorDescription error : errors) {
            ModuleEx module2 = moduleModel.getModuleByFilePath(error.getModulePath().getPath());
            if (module2 == null) continue;
            moduleModel.myModules.remove(module2.getName());
            ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)module2), module2.getDisposed());
        }
        this.fireModuleLoadErrors(errors);
    }

    protected void fireModuleLoadErrors(@NotNull List<ModuleLoadingErrorDescription> errors) {
        if (errors == null) {
            ModuleManagerImpl.$$$reportNull$$$0(14);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            throw new RuntimeException(errors.get(0).getDescription());
        }
        ProjectLoadingErrorsNotifier.getInstance(this.myProject).registerErrors(errors);
    }

    public void removeFailedModulePath(@NotNull ModulePath modulePath) {
        if (modulePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(15);
        }
        this.myFailedModulePaths.remove(modulePath);
        this.incModificationCount();
    }

    @NotNull
    public ModifiableModuleModel getModifiableModel() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ModuleModelImpl moduleModelImpl = new ModuleModelImpl(this.myModuleModel);
        if (moduleModelImpl == null) {
            ModuleManagerImpl.$$$reportNull$$$0(16);
        }
        return moduleModelImpl;
    }

    public void writeExternal(@NotNull Element element, @NotNull List<Module> collection) {
        if (element == null) {
            ModuleManagerImpl.$$$reportNull$$$0(17);
        }
        if (collection == null) {
            ModuleManagerImpl.$$$reportNull$$$0(18);
        }
        ArrayList<SaveItem> sorted = new ArrayList<SaveItem>(collection.size() + this.myFailedModulePaths.size() + this.myUnloadedModules.size());
        for (Module module2 : collection) {
            sorted.add(new ModuleSaveItem(module2));
        }
        for (ModulePath modulePath : this.myFailedModulePaths) {
            sorted.add(new ModulePathSaveItem(modulePath));
        }
        for (UnloadedModuleDescriptionImpl description : this.myUnloadedModules.values()) {
            sorted.add(new ModulePathSaveItem(description.getModulePath()));
        }
        if (!sorted.isEmpty()) {
            Collections.sort(sorted, Comparator.comparing(SaveItem::getModuleName));
            Element modules = new Element(ELEMENT_MODULES);
            for (SaveItem saveItem : sorted) {
                saveItem.writeExternal(modules);
            }
            element.addContent(modules);
        }
    }

    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(19);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module2 = modifiableModel.newModule(filePath, moduleTypeId);
        modifiableModel.commit();
        Module module3 = module2;
        if (module3 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(20);
        }
        return module3;
    }

    @NotNull
    public Module loadModule(@NotNull String filePath) throws IOException, ModuleWithNameAlreadyExists {
        if (filePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(21);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module2 = modifiableModel.loadModule(filePath);
        modifiableModel.commit();
        Module module3 = module2;
        if (module3 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(22);
        }
        return module3;
    }

    public void disposeModule(@NotNull Module module2) {
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(23);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (module2 == null) {
                ModuleManagerImpl.$$$reportNull$$$0(48);
            }
            ModifiableModuleModel modifiableModel = this.getModifiableModel();
            modifiableModel.disposeModule(module2);
            modifiableModel.commit();
        });
    }

    @NotNull
    public Module[] getModules() {
        if (this.myModuleModel.myIsWritable) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        Module[] moduleArray = this.myModuleModel.getModules();
        if (moduleArray == null) {
            ModuleManagerImpl.$$$reportNull$$$0(24);
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getSortedModules() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        if (this.myCachedSortedModules == null) {
            this.myCachedSortedModules = this.myModuleModel.getSortedModules();
        }
        if (this.myCachedSortedModules == null) {
            ModuleManagerImpl.$$$reportNull$$$0(25);
        }
        return this.myCachedSortedModules;
    }

    public Module findModuleByName(@NotNull String name2) {
        if (name2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(26);
        }
        return this.myModuleModel.findModuleByName(name2);
    }

    @NotNull
    public Comparator<Module> moduleDependencyComparator() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        if (this.myCachedModuleComparator == null) {
            this.myCachedModuleComparator = this.myModuleModel.moduleDependencyComparator();
        }
        Comparator<Module> comparator2 = this.myCachedModuleComparator;
        if (comparator2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(27);
        }
        return comparator2;
    }

    protected void deliverPendingEvents() {
    }

    @NotNull
    public Graph<Module> moduleGraph() {
        Graph<Module> graph = this.moduleGraph(true);
        if (graph == null) {
            ModuleManagerImpl.$$$reportNull$$$0(28);
        }
        return graph;
    }

    @NotNull
    public Graph<Module> moduleGraph(boolean includeTests) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Graph graph = this.myModuleModel.moduleGraph(includeTests);
        if (graph == null) {
            ModuleManagerImpl.$$$reportNull$$$0(29);
        }
        return graph;
    }

    @NotNull
    public List<Module> getModuleDependentModules(@NotNull Module module2) {
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(30);
        }
        SmartList result2 = new SmartList();
        for (Module aModule : this.getModules()) {
            if (!ModuleManagerImpl.isModuleDependsOn(aModule, module2)) continue;
            result2.add(aModule);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ModuleManagerImpl.$$$reportNull$$$0(31);
        }
        return smartList;
    }

    public boolean isModuleDependent(@NotNull Module module2, @NotNull Module onModule) {
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(32);
        }
        if (onModule == null) {
            ModuleManagerImpl.$$$reportNull$$$0(33);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return ModuleManagerImpl.isModuleDependsOn(module2, onModule);
    }

    private static boolean isModuleDependsOn(@NotNull Module module2, @NotNull Module onModule) {
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(34);
        }
        if (onModule == null) {
            ModuleManagerImpl.$$$reportNull$$$0(35);
        }
        return ModuleRootManager.getInstance((Module)module2).isDependsOn(onModule);
    }

    protected void fireModulesAdded() {
        for (Module module2 : this.myModuleModel.getModules()) {
            this.fireModuleAddedInWriteAction((ModuleEx)module2);
        }
    }

    protected void fireModuleAddedInWriteAction(@NotNull ModuleEx module2) {
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(36);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (module2 == null) {
                ModuleManagerImpl.$$$reportNull$$$0(47);
            }
            if (!module2.isLoaded()) {
                module2.moduleAdded();
                this.fireModuleAdded(module2);
            }
        });
    }

    public static void commitModelWithRunnable(@NotNull ModifiableModuleModel model, Runnable runnable2) {
        if (model == null) {
            ModuleManagerImpl.$$$reportNull$$$0(37);
        }
        ((ModuleModelImpl)model).commitWithRunnable(runnable2);
    }

    @NotNull
    protected abstract ModuleEx createModule(@NotNull String var1);

    @NotNull
    protected abstract ModuleEx createAndLoadModule(@NotNull String var1) throws IOException;

    private void commitModel(ModuleModelImpl moduleModel, Runnable runnable2) {
        THashSet removedModules;
        THashSet addedModules;
        ModuleModelImpl.access$502(this.myModuleModel, null);
        this.incModificationCount();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<Module> oldModules = Arrays.asList(this.myModuleModel.getModules());
        THashSet newModules = Arrays.asList(moduleModel.getModules());
        if (oldModules.isEmpty()) {
            addedModules = newModules;
            removedModules = Collections.emptyList();
        } else {
            addedModules = new THashSet(newModules);
            addedModules.removeAll(oldModules);
            removedModules = new THashSet(oldModules);
            removedModules.removeAll((Collection<?>)newModules);
        }
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(() -> this.lambda$commitModel$5((Collection)removedModules, moduleModel, oldModules, runnable2, (Collection)addedModules), false, true);
    }

    public void fireModuleRenamedByVfsEvent(@NotNull Module module2, @NotNull String oldName) {
        Module moduleInMap;
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(38);
        }
        if (oldName == null) {
            ModuleManagerImpl.$$$reportNull$$$0(39);
        }
        LOG.assertTrue((moduleInMap = this.myModuleModel.myModules.remove(oldName)) == null || moduleInMap == module2);
        this.myModuleModel.myModules.put(module2.getName(), module2);
        this.incModificationCount();
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(() -> {
            if (module2 == null) {
                ModuleManagerImpl.$$$reportNull$$$0(45);
            }
            if (oldName == null) {
                ModuleManagerImpl.$$$reportNull$$$0(46);
            }
            this.fireModulesRenamed(Collections.singletonList(module2), Collections.singletonMap(module2, oldName));
        }, false, true);
    }

    public String[] getModuleGroupPath(@NotNull Module module2) {
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(40);
        }
        return this.myModuleModel.getModuleGroupPath(module2);
    }

    public boolean hasModuleGroups() {
        return this.myModuleModel.hasModuleGroups();
    }

    public Collection<ModuleDescription> getAllModuleDescriptions() {
        Module[] modules = this.getModules();
        ArrayList<ModuleDescription> descriptions = new ArrayList<ModuleDescription>(modules.length + this.myUnloadedModules.size());
        for (Module module2 : modules) {
            descriptions.add((ModuleDescription)new LoadedModuleDescriptionImpl(module2));
        }
        descriptions.addAll(this.myUnloadedModules.values());
        return descriptions;
    }

    public Collection<UnloadedModuleDescription> getUnloadedModuleDescriptions() {
        return Collections.unmodifiableCollection(this.myUnloadedModules.values());
    }

    @Nullable
    public UnloadedModuleDescription getUnloadedModuleDescription(@NotNull String moduleName) {
        if (moduleName == null) {
            ModuleManagerImpl.$$$reportNull$$$0(41);
        }
        return this.myUnloadedModules.get(moduleName);
    }

    public void setUnloadedModules(@NotNull List<String> unloadedModuleNames) {
        if (unloadedModuleNames == null) {
            ModuleManagerImpl.$$$reportNull$$$0(42);
        }
        if (this.myUnloadedModules.keySet().equals(unloadedModuleNames)) {
            return;
        }
        this.setUnloadedModuleNames(unloadedModuleNames);
        ModifiableModuleModel model = this.getModifiableModel();
        LinkedHashMap<String, UnloadedModuleDescriptionImpl> toLoad = new LinkedHashMap<String, UnloadedModuleDescriptionImpl>(this.myUnloadedModules);
        this.myUnloadedModules.clear();
        for (String name2 : unloadedModuleNames) {
            if (toLoad.containsKey(name2)) {
                this.myUnloadedModules.put(name2, (UnloadedModuleDescriptionImpl)toLoad.remove(name2));
                continue;
            }
            Module module2 = this.findModuleByName(name2);
            if (module2 == null) continue;
            LoadedModuleDescriptionImpl description = new LoadedModuleDescriptionImpl(module2);
            ModuleSaveItem saveItem = new ModuleSaveItem(module2);
            ModulePath modulePath = new ModulePath(saveItem.getModuleFilePath(), saveItem.getGroupPathString());
            VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
            List contentRoots = ContainerUtil.map((Object[])ModuleRootManager.getInstance((Module)module2).getContentRootUrls(), url -> pointerManager.create(url, (Disposable)this, null));
            UnloadedModuleDescriptionImpl unloadedModuleDescription = new UnloadedModuleDescriptionImpl(modulePath, description.getDependencyModuleNames(), contentRoots);
            ServiceKt.getStateStore((ComponentManager)module2).save(new ArrayList<Pair<StateStorage.SaveSession, VirtualFile>>());
            model.disposeModule(module2);
            this.myUnloadedModules.put(name2, unloadedModuleDescription);
        }
        ArrayList<ModulePath> oldFailedPaths = new ArrayList<ModulePath>(this.myFailedModulePaths);
        this.myModulePathsToLoad = toLoad.values().stream().map(UnloadedModuleDescriptionImpl::getModulePath).collect(Collectors.toCollection(LinkedHashSet::new));
        this.loadModules((ModuleModelImpl)model);
        ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableModuleModel)model).commit());
        this.myFailedModulePaths.addAll(oldFailedPaths);
        this.myModulePathsToLoad.clear();
    }

    public void removeUnloadedModules(@NotNull Collection<UnloadedModuleDescription> unloadedModules) {
        if (unloadedModules == null) {
            ModuleManagerImpl.$$$reportNull$$$0(43);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (UnloadedModuleDescription module2 : unloadedModules) {
            this.myUnloadedModules.remove(module2.getName());
        }
        this.setUnloadedModuleNames(new ArrayList<String>(this.myUnloadedModules.keySet()));
    }

    protected void setUnloadedModuleNames(@NotNull List<String> unloadedModuleNames) {
        if (unloadedModuleNames == null) {
            ModuleManagerImpl.$$$reportNull$$$0(44);
        }
        UnloadedModulesListStorage.getInstance(this.myProject).setUnloadedModuleNames(unloadedModuleNames);
    }

    public void setModuleGroupPath(Module module2, String[] groupPath) {
        this.myModuleModel.setModuleGroupPath(module2, groupPath);
    }

    private /* synthetic */ void lambda$commitModel$5(Collection removedModules, ModuleModelImpl moduleModel, Collection oldModules, Runnable runnable2, Collection addedModules) {
        for (Object removedModule : removedModules) {
            this.fireBeforeModuleRemoved((Module)removedModule);
            this.cleanCachedStuff();
        }
        if (!moduleModel.myModulesToDispose.isEmpty()) {
            ArrayList neverAddedModules = new ArrayList(moduleModel.myModulesToDispose);
            neverAddedModules.removeAll(oldModules);
            for (Module neverAddedModule : neverAddedModules) {
                neverAddedModule.putUserData(DISPOSED_MODULE_NAME, (Object)neverAddedModule.getName());
                Disposer.dispose((Disposable)neverAddedModule);
            }
        }
        if (runnable2 != null) {
            runnable2.run();
        }
        Map modulesToNewNamesMap = moduleModel.myModuleToNewName;
        Set modulesToBeRenamed = modulesToNewNamesMap.keySet();
        modulesToBeRenamed.removeAll(moduleModel.myModulesToDispose);
        ArrayList<Module> modules = new ArrayList<Module>();
        HashMap oldNames = ContainerUtil.newHashMap();
        for (Module module2 : modulesToBeRenamed) {
            oldNames.put(module2, module2.getName());
            moduleModel.myModules.remove(module2.getName());
            modules.add(module2);
            ((ModuleEx)module2).rename((String)modulesToNewNamesMap.get(module2), true);
            moduleModel.myModules.put(module2.getName(), module2);
            this.myUnloadedModules.remove(module2.getName());
        }
        moduleModel.myIsWritable = false;
        this.myModuleModel = moduleModel;
        for (Module module2 : removedModules) {
            this.fireModuleRemoved(module2);
            this.cleanCachedStuff();
            Disposer.dispose((Disposable)module2);
            this.cleanCachedStuff();
        }
        for (Module addedModule : addedModules) {
            this.myUnloadedModules.remove(addedModule.getName());
            ((ModuleEx)addedModule).moduleAdded();
            this.cleanCachedStuff();
            this.fireModuleAdded(addedModule);
            this.cleanCachedStuff();
        }
        this.cleanCachedStuff();
        this.fireModulesRenamed(modules, oldNames);
        this.cleanCachedStuff();
        UnloadedModulesListStorage unloadedModulesListStorage = UnloadedModulesListStorage.getInstance(this.myProject);
        this.setUnloadedModuleNames(ContainerUtil.filter(unloadedModulesListStorage.getUnloadedModuleNames(), this.myUnloadedModules::containsKey));
    }

    private /* synthetic */ Module lambda$loadModules$1(ProgressIndicator progressIndicator, @NotNull ModuleModelImpl moduleModel, String path, List errors, ModulePath modulePath) throws Exception {
        if (moduleModel == null) {
            ModuleManagerImpl.$$$reportNull$$$0(49);
        }
        progressIndicator.setFraction(progressIndicator.getFraction() + this.myProgressStep);
        return (Module)ProgressManager.getInstance().runProcess(() -> {
            if (moduleModel == null) {
                ModuleManagerImpl.$$$reportNull$$$0(50);
            }
            try {
                return this.myProject.isDisposed() ? null : moduleModel.loadModuleInternal(path);
            }
            catch (IOException e) {
                this.reportError(errors, modulePath, e);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return null;
        }, (ProgressIndicator)ProgressWrapper.wrap(progressIndicator));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/ModuleManagerImpl";
                break;
            }
            case 4: 
            case 12: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 23: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 45: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_MODULE;
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_MODULES;
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNames";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onModule";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModuleNames";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToModuleFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "newModule";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModule";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedModules";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleDependencyComparator";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleGraph";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDependentModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPathsToModuleFiles";
                break;
            }
            case 3: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadModules";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnknownModuleType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showUnknownModuleTypeNotification";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleAdded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleRemoved";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeModuleRemoved";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fireModulesRenamed";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onModuleLoadErrors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleLoadErrors";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeFailedModulePath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "newModule";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadModule";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "disposeModule";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findModuleByName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDependentModules";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependent";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependsOn";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleAddedInWriteAction";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "commitModelWithRunnable";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleRenamedByVfsEvent";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getModuleGroupPath";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getUnloadedModuleDescription";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setUnloadedModules";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "removeUnloadedModules";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setUnloadedModuleNames";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fireModuleRenamedByVfsEvent$6";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fireModuleAddedInWriteAction$4";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$disposeModule$3";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadModules$1";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ModuleModelImpl
    implements ModifiableModuleModel {
        final Map<String, Module> myModules;
        private volatile Module[] myModulesCache;
        private final List<Module> myModulesToDispose;
        private final Map<Module, String> myModuleToNewName;
        private final Map<String, Module> myNewNameToModule;
        private boolean myIsWritable;
        private Map<Module, String[]> myModuleGroupPath;
        private final ModuleManagerImpl myManager;

        private ModuleModelImpl(@NotNull ModuleManagerImpl manager) {
            if (manager == null) {
                ModuleModelImpl.$$$reportNull$$$0(0);
            }
            this.myModules = Collections.synchronizedMap(new LinkedHashMap());
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new com.intellij.util.containers.HashMap();
            this.myNewNameToModule = new com.intellij.util.containers.HashMap();
            this.myManager = manager;
            this.myIsWritable = false;
        }

        private ModuleModelImpl(@NotNull ModuleModelImpl that) {
            if (that == null) {
                ModuleModelImpl.$$$reportNull$$$0(1);
            }
            this.myModules = Collections.synchronizedMap(new LinkedHashMap());
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new com.intellij.util.containers.HashMap();
            this.myNewNameToModule = new com.intellij.util.containers.HashMap();
            this.myManager = that.myManager;
            this.myModules.putAll(that.myModules);
            Map<Module, String[]> groupPath = that.myModuleGroupPath;
            if (groupPath != null) {
                this.myModuleGroupPath = new THashMap();
                this.myModuleGroupPath.putAll(that.myModuleGroupPath);
            }
            this.myIsWritable = true;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myIsWritable, (Object)"Attempt to modify committed ModifiableModuleModel");
        }

        @NotNull
        public Module[] getModules() {
            Module[] cache = this.myModulesCache;
            if (cache == null) {
                Collection<Module> modules = this.myModules.values();
                this.myModulesCache = cache = modules.toArray(new Module[modules.size()]);
            }
            if (cache == null) {
                ModuleModelImpl.$$$reportNull$$$0(2);
            }
            return cache;
        }

        @NotNull
        private Module[] getSortedModules() {
            Module[] allModules = (Module[])this.getModules().clone();
            Arrays.sort(allModules, this.moduleDependencyComparator());
            if (allModules == null) {
                ModuleModelImpl.$$$reportNull$$$0(3);
            }
            return allModules;
        }

        public void renameModule(@NotNull Module module2, @NotNull String newName) throws ModuleWithNameAlreadyExists {
            if (module2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(4);
            }
            if (newName == null) {
                ModuleModelImpl.$$$reportNull$$$0(5);
            }
            Module oldModule = this.getModuleByNewName(newName);
            this.myNewNameToModule.remove(this.myModuleToNewName.get(module2));
            if (module2.getName().equals(newName)) {
                this.myModuleToNewName.remove(module2);
                this.myNewNameToModule.remove(newName);
            } else {
                this.myModuleToNewName.put(module2, newName);
                this.myNewNameToModule.put(newName, module2);
            }
            if (oldModule != null) {
                throw new ModuleWithNameAlreadyExists(ProjectBundle.message((String)"module.already.exists.error", (Object[])new Object[]{newName}), newName);
            }
        }

        public Module getModuleToBeRenamed(@NotNull String newName) {
            if (newName == null) {
                ModuleModelImpl.$$$reportNull$$$0(6);
            }
            return this.myNewNameToModule.get(newName);
        }

        private Module getModuleByNewName(@NotNull String newName) {
            Module moduleToBeRenamed;
            if (newName == null) {
                ModuleModelImpl.$$$reportNull$$$0(7);
            }
            if ((moduleToBeRenamed = this.getModuleToBeRenamed(newName)) != null) {
                return moduleToBeRenamed;
            }
            Module moduleWithOldName = this.findModuleByName(newName);
            return this.myModuleToNewName.get(moduleWithOldName) == null ? moduleWithOldName : null;
        }

        public String getNewName(@NotNull Module module2) {
            if (module2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(8);
            }
            return this.myModuleToNewName.get(module2);
        }

        @NotNull
        public Module newModule(@NotNull String filePath, String moduleTypeId) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(9);
            }
            Module module2 = this.newModule(filePath, moduleTypeId, null);
            if (module2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(10);
            }
            return module2;
        }

        @NotNull
        public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId, @Nullable Map<String, String> options) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(11);
            }
            if (moduleTypeId == null) {
                ModuleModelImpl.$$$reportNull$$$0(12);
            }
            this.assertWritable();
            filePath = FileUtil.toSystemIndependentName((String)ModuleModelImpl.resolveShortWindowsName(filePath));
            ModuleEx module2 = this.getModuleByFilePath(filePath);
            if (module2 != null) {
                ModuleEx moduleEx = module2;
                if (moduleEx == null) {
                    ModuleModelImpl.$$$reportNull$$$0(13);
                }
                return moduleEx;
            }
            ModuleEx newModule = module2 = this.myManager.createModule(filePath);
            String finalFilePath = filePath;
            this.initModule(module2, () -> {
                if (moduleTypeId == null) {
                    ModuleModelImpl.$$$reportNull$$$0(29);
                }
                ((ModuleStore)((Object)ServiceKt.getStateStore((ComponentManager)newModule))).setPath(finalFilePath, true);
                newModule.setModuleType(moduleTypeId);
                if (options != null) {
                    for (Map.Entry option : options.entrySet()) {
                        newModule.setOption((String)option.getKey(), (String)option.getValue());
                    }
                }
            });
            ModuleEx moduleEx = module2;
            if (moduleEx == null) {
                ModuleModelImpl.$$$reportNull$$$0(14);
            }
            return moduleEx;
        }

        @NotNull
        private static String resolveShortWindowsName(@NotNull String filePath) {
            String string;
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(15);
            }
            try {
                string = FileUtil.resolveShortWindowsName((String)filePath);
            }
            catch (IOException ignored) {
                String string2 = filePath;
                if (string2 == null) {
                    ModuleModelImpl.$$$reportNull$$$0(17);
                }
                return string2;
            }
            if (string == null) {
                ModuleModelImpl.$$$reportNull$$$0(16);
            }
            return string;
        }

        @Nullable
        private ModuleEx getModuleByFilePath(@NotNull String filePath) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(18);
            }
            for (Module module2 : this.getModules()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? module2.getModuleFilePath().equals(filePath) : module2.getModuleFilePath().equalsIgnoreCase(filePath))) continue;
                return (ModuleEx)module2;
            }
            return null;
        }

        @NotNull
        public Module loadModule(@NotNull String filePath) throws IOException {
            ModuleEx moduleEx;
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(19);
            }
            this.assertWritable();
            String resolvedPath = FileUtilRt.toSystemIndependentName((String)ModuleModelImpl.resolveShortWindowsName(filePath));
            try {
                ModuleEx module2 = this.getModuleByFilePath(resolvedPath);
                moduleEx = module2 == null ? this.loadModuleInternal(resolvedPath) : module2;
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(ProjectBundle.message((String)"module.corrupted.file.error", (Object[])new Object[]{FileUtilRt.toSystemDependentName((String)resolvedPath), e.getMessage()}), e);
            }
            if (moduleEx == null) {
                ModuleModelImpl.$$$reportNull$$$0(20);
            }
            return moduleEx;
        }

        @NotNull
        private Module loadModuleInternal(@NotNull String filePath) throws IOException {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(21);
            }
            StandardFileSystems.local().refreshAndFindFileByPath(filePath);
            Module module2 = (Module)ReadAction.compute(() -> {
                if (filePath == null) {
                    ModuleModelImpl.$$$reportNull$$$0(27);
                }
                ModuleEx module2 = this.myManager.createAndLoadModule(filePath);
                this.initModule(module2, () -> {
                    if (filePath == null) {
                        ModuleModelImpl.$$$reportNull$$$0(28);
                    }
                    ((ModuleStore)((Object)ServiceKt.getStateStore((ComponentManager)module2))).setPath(filePath, false);
                });
                return module2;
            });
            if (module2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(22);
            }
            return module2;
        }

        private void initModule(@NotNull ModuleEx module2, @Nullable Runnable beforeComponentCreation) {
            if (module2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(23);
            }
            module2.init(beforeComponentCreation);
            this.myModulesCache = null;
            this.myModules.put(module2.getName(), module2);
        }

        public void disposeModule(@NotNull Module module2) {
            if (module2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(24);
            }
            this.assertWritable();
            this.myModulesCache = null;
            if (this.myModules.remove(module2.getName()) != null) {
                this.myModulesToDispose.add(module2);
            }
            if (this.myModuleGroupPath != null) {
                this.myModuleGroupPath.remove(module2);
            }
        }

        public Module findModuleByName(@NotNull String name2) {
            Module module2;
            if (name2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(25);
            }
            if ((module2 = this.myModules.get(name2)) != null && !module2.isDisposed()) {
                return module2;
            }
            return null;
        }

        private Comparator<Module> moduleDependencyComparator() {
            DFSTBuilder builder = new DFSTBuilder(this.moduleGraph(true));
            return builder.comparator();
        }

        private Graph<Module> moduleGraph(final boolean includeTests) {
            return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Module>(){

                public Collection<Module> getNodes() {
                    return myModules.values();
                }

                public Iterator<Module> getIn(Module m) {
                    Module[] dependentModules = ModuleRootManager.getInstance((Module)m).getDependencies(includeTests);
                    return Arrays.asList(dependentModules).iterator();
                }
            }));
        }

        public void commit() {
            ModifiableModelCommitter.multiCommit(Collections.emptyList(), (ModifiableModuleModel)this);
        }

        private void commitWithRunnable(Runnable runnable2) {
            this.myManager.commitModel(this, runnable2);
            this.clearRenamingStuff();
        }

        private void clearRenamingStuff() {
            this.myModuleToNewName.clear();
            this.myNewNameToModule.clear();
        }

        public void dispose() {
            this.assertWritable();
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            THashSet existingModules = new THashSet(Arrays.asList(this.myManager.myModuleModel.getModules()));
            for (Module thisModule : this.getModules()) {
                if (existingModules.contains(thisModule)) continue;
                Disposer.dispose((Disposable)thisModule);
            }
            for (Module moduleToDispose : this.myModulesToDispose) {
                if (existingModules.contains(moduleToDispose)) continue;
                Disposer.dispose((Disposable)moduleToDispose);
            }
            this.clearRenamingStuff();
        }

        public boolean isChanged() {
            if (!this.myIsWritable) {
                return false;
            }
            return !this.myModules.equals(this.myManager.myModuleModel.myModules) || !Comparing.equal(this.myManager.myModuleModel.myModuleGroupPath, this.myModuleGroupPath);
        }

        private void disposeModel() {
            Module[] modules = this.getModules();
            this.myModulesCache = null;
            this.myModules.clear();
            for (Module module2 : modules) {
                Disposer.dispose((Disposable)module2);
            }
            this.myModuleGroupPath = null;
        }

        public String[] getModuleGroupPath(Module module2) {
            return this.myModuleGroupPath == null ? null : this.myModuleGroupPath.get(module2);
        }

        public boolean hasModuleGroups() {
            return this.myModuleGroupPath != null && !this.myModuleGroupPath.isEmpty();
        }

        public void setModuleGroupPath(@NotNull Module module2, @Nullable(value="null means remove") String[] groupPath) {
            if (module2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(26);
            }
            if (this.myModuleGroupPath == null) {
                this.myModuleGroupPath = new THashMap();
            }
            if (groupPath == null) {
                this.myModuleGroupPath.remove(module2);
            } else {
                this.myModuleGroupPath.put(module2, groupPath);
            }
        }

        static /* synthetic */ Module[] access$502(ModuleModelImpl x0, Module[] x1) {
            x0.myModulesCache = x1;
            return x1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 20: 
                case 22: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 20: 
                case 22: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "that";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 20: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl";
                    break;
                }
                case 4: 
                case 8: 
                case 23: 
                case 24: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ModuleManagerImpl.ELEMENT_MODULE;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 9: 
                case 11: 
                case 15: 
                case 18: 
                case 19: 
                case 21: 
                case 27: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 12: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleTypeId";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModules";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortedModules";
                    break;
                }
                case 10: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newModule";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveShortWindowsName";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadModule";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadModuleInternal";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 20: 
                case 22: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "renameModule";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleToBeRenamed";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleByNewName";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getNewName";
                    break;
                }
                case 9: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "newModule";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveShortWindowsName";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleByFilePath";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "loadModule";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "loadModuleInternal";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "initModule";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "disposeModule";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "findModuleByName";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "setModuleGroupPath";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$loadModuleInternal$2";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$1";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$newModule$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 20: 
                case 22: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ModuleSaveItem
    extends SaveItem {
        private final Module myModule;

        ModuleSaveItem(Module module2) {
            if (module2 == null) {
                ModuleSaveItem.$$$reportNull$$$0(0);
            }
            this.myModule = module2;
        }

        @Override
        @NotNull
        protected String getModuleName() {
            String string = this.myModule.getName();
            if (string == null) {
                ModuleSaveItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected String getGroupPathString() {
            String[] groupPath = ModuleManagerImpl.this.getModuleGroupPath(this.myModule);
            return groupPath != null ? StringUtil.join((String[])groupPath, (String)ModuleManagerImpl.MODULE_GROUP_SEPARATOR) : null;
        }

        @Override
        @NotNull
        protected String getModuleFilePath() {
            String string = this.myModule.getModuleFilePath();
            if (string == null) {
                ModuleSaveItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ModuleManagerImpl.ELEMENT_MODULE;
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ModuleGroupInterner {
        private final StringInterner groups = new StringInterner();
        private final Map<String[], String[]> paths = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<String[]>(){

            public int computeHashCode(String[] object) {
                return Arrays.hashCode(object);
            }

            public boolean equals(String[] o1, String[] o2) {
                return Arrays.equals(o1, o2);
            }
        });

        private ModuleGroupInterner() {
        }

        private void setModuleGroupPath(@NotNull ModifiableModuleModel model, @NotNull Module module2, @Nullable String[] group) {
            String[] cached;
            if (model == null) {
                ModuleGroupInterner.$$$reportNull$$$0(0);
            }
            if (module2 == null) {
                ModuleGroupInterner.$$$reportNull$$$0(1);
            }
            String[] stringArray = cached = group == null ? null : this.paths.get(group);
            if (cached == null && group != null) {
                cached = new String[group.length];
                for (int i = 0; i < group.length; ++i) {
                    String g = group[i];
                    cached[i] = (String)this.groups.intern((Object)g);
                }
                this.paths.put(cached, cached);
            }
            model.setModuleGroupPath(module2, cached);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = ModuleManagerImpl.ELEMENT_MODULE;
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleGroupInterner";
            objectArray[2] = "setModuleGroupPath";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

