/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.ui.AppIcon;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Queue;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import javax.swing.JComponent;
import org.jetbrains.annotations.Debugger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumbServiceImpl
extends DumbService
implements Disposable,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.DumbServiceImpl");
    private final AtomicReference<State> myState = new AtomicReference<State>(State.SMART);
    private volatile Throwable myDumbStart;
    private volatile TransactionId myDumbStartTransaction;
    private final DumbService.DumbModeListener myPublisher;
    private long myModificationCount;
    private final Set<Object> myQueuedEquivalences = new HashSet<Object>();
    private final Queue<DumbModeTask> myUpdatesQueue = new Queue(5);
    private final Map<DumbModeTask, ProgressIndicatorEx> myProgresses = ContainerUtil.newConcurrentMap();
    private final Queue<Runnable> myRunWhenSmartQueue = new Queue(5);
    private final Project myProject;
    private final ThreadLocal<Integer> myAlternativeResolution = new ThreadLocal();
    private final StartupManager myStartupManager;

    public DumbServiceImpl(Project project2, StartupManager startupManager) {
        this.myProject = project2;
        this.myPublisher = (DumbService.DumbModeListener)project2.getMessageBus().syncPublisher(DUMB_MODE);
        this.myStartupManager = startupManager;
    }

    public static DumbServiceImpl getInstance(@NotNull Project project2) {
        if (project2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(0);
        }
        return (DumbServiceImpl)DumbService.getInstance((Project)project2);
    }

    public void cancelTask(@NotNull DumbModeTask task) {
        ProgressIndicatorEx indicator;
        if (task == null) {
            DumbServiceImpl.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("cancel " + task);
        }
        if ((indicator = this.myProgresses.get(task)) != null) {
            indicator.cancel();
        }
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUpdatesQueue.clear();
        this.myQueuedEquivalences.clear();
        this.myRunWhenSmartQueue.clear();
        for (DumbModeTask task : new ArrayList<DumbModeTask>(this.myProgresses.keySet())) {
            this.cancelTask(task);
            Disposer.dispose((Disposable)task);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean isAlternativeResolveEnabled() {
        return this.myAlternativeResolution.get() != null;
    }

    public void setAlternativeResolveEnabled(boolean enabled) {
        Integer oldValue = this.myAlternativeResolution.get();
        int newValue = (oldValue == null ? 0 : oldValue) + (enabled ? 1 : -1);
        assert (newValue >= 0) : "Non-paired alternative resolution mode";
        this.myAlternativeResolution.set(newValue == 0 ? null : Integer.valueOf(newValue));
    }

    public ModificationTracker getModificationTracker() {
        return this;
    }

    public boolean isDumb() {
        return this.myState.get() != State.SMART;
    }

    public void setDumb(boolean dumb) {
        if (dumb) {
            this.myState.set(State.RUNNING_DUMB_TASKS);
            this.myPublisher.enteredDumbMode();
        } else {
            this.myState.set(State.WAITING_FOR_FINISH);
            this.updateFinished();
        }
    }

    public void runWhenSmart(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(2);
        }
        this.myStartupManager.runWhenProjectIsInitialized(() -> {
            if (runnable2 == null) {
                DumbServiceImpl.$$$reportNull$$$0(27);
            }
            Queue<Runnable> queue2 = this.myRunWhenSmartQueue;
            synchronized (queue2) {
                if (this.isDumb()) {
                    this.myRunWhenSmartQueue.addLast((Object)runnable2);
                    return;
                }
            }
            runnable2.run();
        });
    }

    public void queueTask(@NotNull DumbModeTask task) {
        if (task == null) {
            DumbServiceImpl.$$$reportNull$$$0(3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduling task " + task);
        }
        LOG.assertTrue(!this.myProject.isDefault(), (Object)("No indexing tasks should be created for default project: " + task));
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            DumbServiceImpl.runTaskSynchronously(task);
        } else {
            this.queueAsynchronousTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runTaskSynchronously(@NotNull DumbModeTask task) {
        ProgressIndicator indicator;
        if (task == null) {
            DumbServiceImpl.$$$reportNull$$$0(4);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) == null) {
            indicator = new EmptyProgressIndicator();
        }
        indicator.pushState();
        try (AccessToken ignored = HeavyProcessLatch.INSTANCE.processStarted("Performing indexing task");){
            task.performInDumbMode(indicator);
        }
        finally {
            indicator.popState();
            Disposer.dispose((Disposable)task);
        }
    }

    @VisibleForTesting
    void queueAsynchronousTask(@NotNull DumbModeTask task) {
        if (task == null) {
            DumbServiceImpl.$$$reportNull$$$0(5);
        }
        Throwable trace = new Throwable();
        TransactionId contextTransaction = TransactionGuard.getInstance().getContextTransaction();
        Runnable runnable2 = () -> {
            if (task == null) {
                DumbServiceImpl.$$$reportNull$$$0(26);
            }
            this.queueTaskOnEdt(task, contextTransaction, trace);
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable2.run();
        } else {
            TransactionGuard.submitTransaction((Disposable)this.myProject, (Runnable)runnable2);
        }
    }

    private void queueTaskOnEdt(@NotNull DumbModeTask task, @Nullable TransactionId contextTransaction, @NotNull Throwable trace) {
        if (task == null) {
            DumbServiceImpl.$$$reportNull$$$0(6);
        }
        if (trace == null) {
            DumbServiceImpl.$$$reportNull$$$0(7);
        }
        if (!this.addTaskToQueue(task)) {
            return;
        }
        if (this.myState.get() == State.SMART || this.myState.get() == State.WAITING_FOR_FINISH) {
            this.enterDumbMode(contextTransaction, trace);
            ApplicationManager.getApplication().invokeLater(this::startBackgroundProcess, this.myProject.getDisposed());
        }
    }

    private boolean addTaskToQueue(@NotNull DumbModeTask task) {
        if (task == null) {
            DumbServiceImpl.$$$reportNull$$$0(8);
        }
        if (!this.myQueuedEquivalences.add(task.getEquivalenceObject())) {
            Disposer.dispose((Disposable)task);
            return false;
        }
        this.myProgresses.put(task, new ProgressIndicatorBase());
        Disposer.register((Disposable)task, () -> {
            if (task == null) {
                DumbServiceImpl.$$$reportNull$$$0(25);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myProgresses.remove(task);
        });
        this.myUpdatesQueue.addLast((Object)task);
        return true;
    }

    private void enterDumbMode(@Nullable TransactionId contextTransaction, @NotNull Throwable trace) {
        if (trace == null) {
            DumbServiceImpl.$$$reportNull$$$0(9);
        }
        boolean wasSmart = !this.isDumb();
        WriteAction.run(() -> {
            if (trace == null) {
                DumbServiceImpl.$$$reportNull$$$0(24);
            }
            Queue<Runnable> queue2 = this.myRunWhenSmartQueue;
            synchronized (queue2) {
                this.myState.set(State.SCHEDULED_TASKS);
            }
            this.myDumbStart = trace;
            this.myDumbStartTransaction = contextTransaction;
            ++this.myModificationCount;
        });
        if (wasSmart) {
            try {
                this.myPublisher.enteredDumbMode();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private void queueUpdateFinished() {
        if (this.myState.compareAndSet(State.RUNNING_DUMB_TASKS, State.WAITING_FOR_FINISH)) {
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> TransactionGuard.getInstance().submitTransaction((Disposable)this.myProject, this.myDumbStartTransaction, this::updateFinished));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean switchToSmartMode() {
        Queue<Runnable> queue2 = this.myRunWhenSmartQueue;
        synchronized (queue2) {
            if (!this.myState.compareAndSet(State.WAITING_FOR_FINISH, State.SMART)) {
                return false;
            }
        }
        this.myDumbStart = null;
        ++this.myModificationCount;
        return !this.myProject.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Debugger.Insert(keyExpression="runnable", group="com.intellij.openapi.project.DumbService.runWhenSmart")
    private void updateFinished() {
        if (!((Boolean)WriteAction.compute(this::switchToSmartMode)).booleanValue()) {
            return;
        }
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("updateFinished");
        }
        try {
            this.myPublisher.exitDumbMode();
            FileEditorManagerEx.getInstanceEx(this.myProject).refreshIcons();
        }
        catch (Throwable throwable) {
            while (!this.isDumb()) {
                Runnable runnable2;
                Queue<Runnable> queue2 = this.myRunWhenSmartQueue;
                synchronized (queue2) {
                    if (this.myRunWhenSmartQueue.isEmpty()) {
                        break;
                    }
                    runnable2 = (Runnable)this.myRunWhenSmartQueue.pullFirst();
                }
                try {
                    runnable2.run();
                }
                catch (ProcessCanceledException e) {
                    LOG.error("Task canceled: " + runnable2, new Attachment[]{new Attachment("pce", (Throwable)e)});
                }
                catch (Throwable e) {
                    LOG.error("Error executing task " + runnable2, e);
                }
            }
            throw throwable;
        }
        while (!this.isDumb()) {
            Runnable runnable3;
            Queue<Runnable> queue3 = this.myRunWhenSmartQueue;
            synchronized (queue3) {
                if (this.myRunWhenSmartQueue.isEmpty()) {
                    break;
                }
                runnable3 = (Runnable)this.myRunWhenSmartQueue.pullFirst();
            }
            try {
                runnable3.run();
            }
            catch (ProcessCanceledException e) {
                LOG.error("Task canceled: " + runnable3, new Attachment[]{new Attachment("pce", (Throwable)e)});
            }
            catch (Throwable e) {
                LOG.error("Error executing task " + runnable3, e);
            }
        }
    }

    public void showDumbModeNotification(@NotNull String message2) {
        if (message2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(10);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            IdeFrame ideFrame;
            if (message2 == null) {
                DumbServiceImpl.$$$reportNull$$$0(23);
            }
            if ((ideFrame = WindowManager.getInstance().getIdeFrame(this.myProject)) != null) {
                StatusBarEx statusBar = (StatusBarEx)ideFrame.getStatusBar();
                statusBar.notifyProgressByBalloon(MessageType.WARNING, message2, null, null);
            }
        });
    }

    public void waitForSmartMode() {
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed() || application.isDispatchThread()) {
            throw new AssertionError((Object)"Don't invoke waitForSmartMode from inside read action in dumb mode");
        }
        while (this.isDumb() && !this.myProject.isDisposed()) {
            LockSupport.parkNanos(50000000L);
            ProgressManager.checkCanceled();
        }
    }

    public JComponent wrapGently(@NotNull JComponent dumbUnawareContent, @NotNull Disposable parentDisposable) {
        if (dumbUnawareContent == null) {
            DumbServiceImpl.$$$reportNull$$$0(11);
        }
        if (parentDisposable == null) {
            DumbServiceImpl.$$$reportNull$$$0(12);
        }
        final DumbUnawareHider wrapper = new DumbUnawareHider(dumbUnawareContent);
        wrapper.setContentVisible(!this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                wrapper.setContentVisible(false);
            }

            public void exitDumbMode() {
                wrapper.setContentVisible(true);
            }
        });
        return wrapper;
    }

    public void smartInvokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(13);
        }
        this.smartInvokeLater(runnable2, ModalityState.defaultModalityState());
    }

    public void smartInvokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (runnable2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(14);
        }
        if (modalityState == null) {
            DumbServiceImpl.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (runnable2 == null) {
                DumbServiceImpl.$$$reportNull$$$0(19);
            }
            if (modalityState == null) {
                DumbServiceImpl.$$$reportNull$$$0(20);
            }
            if (this.isDumb()) {
                this.runWhenSmart(() -> {
                    if (runnable2 == null) {
                        DumbServiceImpl.$$$reportNull$$$0(21);
                    }
                    if (modalityState == null) {
                        DumbServiceImpl.$$$reportNull$$$0(22);
                    }
                    this.smartInvokeLater(runnable2, modalityState);
                });
            } else {
                runnable2.run();
            }
        }, modalityState, this.myProject.getDisposed());
    }

    public void completeJustSubmittedTasks() {
        assert (this.myProject.isInitialized());
        if (this.myState.get() != State.SCHEDULED_TASKS) {
            return;
        }
        while (this.isDumb()) {
            this.showModalProgress();
        }
    }

    private void showModalProgress() {
        NoAccessDuringPsiEvents.checkCallContext();
        try {
            ((ApplicationImpl)ApplicationManager.getApplication()).executeSuspendingWriteAction(this.myProject, IdeBundle.message((String)"progress.indexing", (Object[])new Object[0]), () -> this.runBackgroundProcess(ProgressManager.getInstance().getProgressIndicator()));
        }
        finally {
            if (this.myState.get() != State.SMART) {
                this.assertWeAreWaitingToFinish();
                this.updateFinished();
            }
        }
    }

    private void assertWeAreWaitingToFinish() {
        if (this.myState.get() != State.WAITING_FOR_FINISH) {
            Attachment[] attachmentArray;
            if (this.myDumbStart != null) {
                Attachment[] attachmentArray2 = new Attachment[1];
                attachmentArray = attachmentArray2;
                attachmentArray2[0] = new Attachment("indexingStart.trace", this.myDumbStart);
            } else {
                attachmentArray = Attachment.EMPTY_ARRAY;
            }
            Attachment[] attachments = attachmentArray;
            throw new RuntimeExceptionWithAttachments(this.myState.get().toString(), attachments);
        }
    }

    private void startBackgroundProcess() {
        try {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, IdeBundle.message((String)"progress.indexing", (Object[])new Object[0]), false){

                public void run(@NotNull ProgressIndicator visibleIndicator) {
                    if (visibleIndicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    DumbServiceImpl.this.runBackgroundProcess(visibleIndicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleIndicator", "com/intellij/openapi/project/DumbServiceImpl$2", "run"));
                }
            });
        }
        catch (Throwable e) {
            this.queueUpdateFinished();
            LOG.error("Failed to start background index update task", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runBackgroundProcess(final @NotNull ProgressIndicator visibleIndicator) {
        block21: {
            if (visibleIndicator == null) {
                DumbServiceImpl.$$$reportNull$$$0(16);
            }
            if (!this.myState.compareAndSet(State.SCHEDULED_TASKS, State.RUNNING_DUMB_TASKS)) {
                return;
            }
            ProgressSuspender.markSuspendable(visibleIndicator);
            shutdownTracker = ShutDownTracker.getInstance();
            self = Thread.currentThread();
            try {
                shutdownTracker.registerStopperThread(self);
                if (visibleIndicator instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)visibleIndicator).addStateDelegate(new AppIconProgress());
                }
                task = null;
                while (true) lbl-1000:
                // 3 sources

                {
                    if ((pair = this.getNextTask(task, visibleIndicator)) == null) {
                        break block21;
                    }
                    task = (DumbModeTask)pair.first;
                    taskIndicator = (ProgressIndicatorEx)pair.second;
                    if (visibleIndicator instanceof ProgressIndicatorEx) {
                        taskIndicator.addStateDelegate(new AbstractProgressIndicatorExBase(){

                            @Override
                            protected void delegateProgressChange(@NotNull AbstractProgressIndicatorExBase.IndicatorAction action) {
                                if (action == null) {
                                    3.$$$reportNull$$$0(0);
                                }
                                super.delegateProgressChange(action);
                                action.execute((ProgressIndicatorEx)visibleIndicator);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/project/DumbServiceImpl$3", "delegateProgressChange"));
                            }
                        });
                    }
                    ignored = HeavyProcessLatch.INSTANCE.processStarted("Performing indexing tasks");
                    var8_9 = null;
                    try {
                        DumbServiceImpl.runSingleTask(task, taskIndicator);
                    }
                    catch (Throwable var9_11) {
                        var8_9 = var9_11;
                        throw var9_11;
                    }
                    finally {
                        if (ignored == null) continue;
                        if (var8_9 != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable var9_10) {
                                var8_9.addSuppressed(var9_10);
                            }
                            continue;
                        }
                        ignored.close();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable unexpected) {
                DumbServiceImpl.LOG.error(unexpected);
                break block21;
            }
            finally {
                shutdownTracker.unregisterStopperThread(self);
            }
            ** GOTO lbl-1000
        }
    }

    private static void runSingleTask(DumbModeTask task, ProgressIndicatorEx taskIndicator) {
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("Running dumb mode task: " + task);
        }
        ProgressManager.getInstance().runProcess(() -> {
            try {
                taskIndicator.checkCanceled();
                taskIndicator.setIndeterminate(true);
                taskIndicator.setText(IdeBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
                task.performInDumbMode((ProgressIndicator)taskIndicator);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable unexpected) {
                LOG.error(unexpected);
            }
        }, (ProgressIndicator)taskIndicator);
    }

    @Nullable
    private Pair<DumbModeTask, ProgressIndicatorEx> getNextTask(@Nullable DumbModeTask prevTask, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            DumbServiceImpl.$$$reportNull$$$0(17);
        }
        CompletableFuture result2 = new CompletableFuture();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (indicator == null) {
                DumbServiceImpl.$$$reportNull$$$0(18);
            }
            if (this.myProject.isDisposed()) {
                result2.completeExceptionally(new ProcessCanceledException());
                return;
            }
            if (prevTask != null) {
                Disposer.dispose((Disposable)prevTask);
            }
            if (PowerSaveMode.isEnabled() && Registry.is((String)"pause.indexing.in.power.save.mode")) {
                indicator.setText("Indexing paused during Power Save mode...");
                this.runWhenPowerSaveModeChanges(() -> result2.complete(this.pollTaskQueue()));
                this.completeWhenProjectClosed(result2);
            } else {
                result2.complete(this.pollTaskQueue());
            }
        });
        return (Pair)DumbServiceImpl.waitForFuture(result2);
    }

    @Nullable
    private Pair<DumbModeTask, ProgressIndicatorEx> pollTaskQueue() {
        ProgressIndicatorEx indicator;
        DumbModeTask queuedTask;
        while (true) {
            if (this.myUpdatesQueue.isEmpty()) {
                this.queueUpdateFinished();
                return null;
            }
            queuedTask = (DumbModeTask)this.myUpdatesQueue.pullFirst();
            this.myQueuedEquivalences.remove(queuedTask.getEquivalenceObject());
            indicator = this.myProgresses.get(queuedTask);
            if (!indicator.isCanceled()) break;
            Disposer.dispose((Disposable)queuedTask);
        }
        return Pair.create((Object)queuedTask, (Object)indicator);
    }

    @Nullable
    private static <T> T waitForFuture(Future<T> result2) {
        try {
            return result2.get();
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof ProcessCanceledException)) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)cause);
            }
            return null;
        }
    }

    private void completeWhenProjectClosed(final CompletableFuture<Pair<DumbModeTask, ProgressIndicatorEx>> result2) {
        ProjectManagerListener listener2 = new ProjectManagerListener(){

            public void projectClosed(Project project2) {
                result2.completeExceptionally(new ProcessCanceledException());
            }
        };
        ProjectManager.getInstance().addProjectManagerListener(this.myProject, listener2);
        result2.thenAccept(p -> ProjectManager.getInstance().removeProjectManagerListener(this.myProject, listener2));
    }

    private void runWhenPowerSaveModeChanges(Runnable r) {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(PowerSaveMode.TOPIC, () -> {
            r.run();
            connection.disconnect();
        });
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    @Nullable
    public Throwable getDumbModeStartTrace() {
        return this.myDumbStart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: 
            case 9: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbUnawareContent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 15: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleIndicator";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/DumbServiceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runWhenSmart";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "queueTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runTaskSynchronously";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "queueAsynchronousTask";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "queueTaskOnEdt";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addTaskToQueue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "enterDumbMode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "showDumbModeNotification";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapGently";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "smartInvokeLater";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "runBackgroundProcess";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getNextTask";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getNextTask$11";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$smartInvokeLater$7";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$6";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showDumbModeNotification$5";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$enterDumbMode$3";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addTaskToQueue$2";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$queueAsynchronousTask$1";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runWhenSmart$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum State {
        SMART,
        SCHEDULED_TASKS,
        RUNNING_DUMB_TASKS,
        WAITING_FOR_FINISH;

    }

    private class AppIconProgress
    extends ProgressIndicatorBase {
        private double lastFraction;

        private AppIconProgress() {
        }

        @Override
        public void setFraction(double fraction) {
            if (fraction - this.lastFraction < 0.01) {
                return;
            }
            this.lastFraction = fraction;
            UIUtil.invokeLaterIfNeeded(() -> AppIcon.getInstance().setProgress(DumbServiceImpl.this.myProject, "indexUpdate", AppIconScheme.Progress.INDEXING, fraction, true));
        }

        @Override
        public void finish(@NotNull TaskInfo task) {
            if (task == null) {
                AppIconProgress.$$$reportNull$$$0(0);
            }
            if (this.lastFraction != 0.0) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    AppIcon appIcon = AppIcon.getInstance();
                    if (appIcon.hideProgress(DumbServiceImpl.this.myProject, "indexUpdate")) {
                        appIcon.requestAttention(DumbServiceImpl.this.myProject, false);
                        appIcon.setOkBadge(DumbServiceImpl.this.myProject, true);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/project/DumbServiceImpl$AppIconProgress", "finish"));
        }
    }
}

