/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.UnknownSdkType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.impl.MessageListenerList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectJdkTable", storages={@Storage(value="jdk.table.xml", roamingType=RoamingType.DISABLED)})
public class ProjectJdkTableImpl
extends ProjectJdkTable
implements ExportableComponent,
PersistentStateComponent<Element> {
    private final List<Sdk> mySdks = new ArrayList<Sdk>();
    private final MessageListenerList<ProjectJdkTable.Listener> myListenerList;
    @NonNls
    private static final String ELEMENT_JDK = "jdk";
    private final Map<String, ProjectJdkImpl> myCachedProjectJdks = new HashMap<String, ProjectJdkImpl>();
    private final MessageBus myMessageBus = ApplicationManager.getApplication().getMessageBus();

    public ProjectJdkTableImpl() {
        this.myListenerList = new MessageListenerList(this.myMessageBus, JDK_TABLE_TOPIC);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){
            private final FileTypeManager myFileTypeManager = FileTypeManager.getInstance();

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!events.isEmpty()) {
                    SmartHashSet affected = new SmartHashSet();
                    for (VFileEvent vFileEvent : events) {
                        this.addAffectedJavaSdk(vFileEvent, (Set<Sdk>)affected);
                    }
                    if (!affected.isEmpty()) {
                        for (Sdk sdk : affected) {
                            ((SdkType)sdk.getSdkType()).setupSdkPaths(sdk);
                        }
                    }
                }
            }

            private void addAffectedJavaSdk(VFileEvent event, Set<Sdk> affected) {
                VirtualFile file2 = event.getFile();
                CharSequence fileName = null;
                if (file2 != null && file2.isValid()) {
                    if (file2.isDirectory()) {
                        return;
                    }
                    fileName = file2.getNameSequence();
                }
                if (fileName == null) {
                    String eventPath = event.getPath();
                    fileName = VfsUtil.extractFileName((String)eventPath);
                }
                if (fileName != null && !FileTypes.ARCHIVE.equals(this.myFileTypeManager.getFileTypeByFileName(fileName))) {
                    return;
                }
                for (Sdk sdk : ProjectJdkTableImpl.this.mySdks) {
                    if (!(sdk.getSdkType() instanceof JavaSdkType) || affected.contains(sdk)) continue;
                    String homePath = sdk.getHomePath();
                    String eventPath = event.getPath();
                    if (StringUtil.isEmpty((String)homePath) || !FileUtil.isAncestor((String)homePath, (String)eventPath, (boolean)true)) continue;
                    affected.add(sdk);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/projectRoots/impl/ProjectJdkTableImpl$1", "after"));
            }
        });
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)"jdk.table")};
        if (fileArray == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(0);
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message((String)"sdk.table.settings", (Object[])new Object[0]);
        if (string == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public Sdk findJdk(String name2) {
        int len = this.mySdks.size();
        for (int i = 0; i < len; ++i) {
            Sdk jdk = this.mySdks.get(i);
            if (!Comparing.strEqual((String)name2, (String)jdk.getName())) continue;
            return jdk;
        }
        return null;
    }

    @Nullable
    public Sdk findJdk(String name2, String type2) {
        SdkType[] sdkTypes;
        Sdk projectJdk = this.findJdk(name2);
        if (projectJdk != null) {
            return projectJdk;
        }
        String sdkTypeName = this.getSdkTypeName(type2);
        String uniqueName = sdkTypeName + "." + name2;
        projectJdk = this.myCachedProjectJdks.get(uniqueName);
        if (projectJdk != null) {
            return projectJdk;
        }
        String jdkPrefix = "jdk.";
        String jdkPath = System.getProperty("jdk." + name2);
        if (jdkPath == null) {
            return null;
        }
        for (SdkType sdkType : sdkTypes = SdkType.getAllTypes()) {
            if (!Comparing.strEqual((String)sdkTypeName, (String)sdkType.getName())) continue;
            if (!sdkType.isValidSdkHome(jdkPath)) break;
            ProjectJdkImpl projectJdkImpl = new ProjectJdkImpl(name2, (SdkTypeId)sdkType);
            projectJdkImpl.setHomePath(jdkPath);
            sdkType.setupSdkPaths((Sdk)projectJdkImpl);
            this.myCachedProjectJdks.put(uniqueName, projectJdkImpl);
            return projectJdkImpl;
        }
        return null;
    }

    protected String getSdkTypeName(String type2) {
        return type2;
    }

    @NotNull
    public Sdk[] getAllJdks() {
        Sdk[] sdkArray = this.mySdks.toArray(new Sdk[this.mySdks.size()]);
        if (sdkArray == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(2);
        }
        return sdkArray;
    }

    @NotNull
    public List<Sdk> getSdksOfType(@NotNull SdkTypeId type2) {
        Sdk[] sdks;
        if (type2 == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(3);
        }
        ArrayList<Sdk> result2 = new ArrayList<Sdk>();
        for (Sdk sdk : sdks = this.getAllJdks()) {
            if (sdk.getSdkType() != type2) continue;
            result2.add(sdk);
        }
        ArrayList<Sdk> arrayList = result2;
        if (arrayList == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void addJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.mySdks.add(jdk);
        ((ProjectJdkTable.Listener)this.myMessageBus.syncPublisher(JDK_TABLE_TOPIC)).jdkAdded(jdk);
    }

    public void removeJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ((ProjectJdkTable.Listener)this.myMessageBus.syncPublisher(JDK_TABLE_TOPIC)).jdkRemoved(jdk);
        this.mySdks.remove(jdk);
        if (jdk instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)jdk));
        }
    }

    public void updateJdk(@NotNull Sdk originalJdk, @NotNull Sdk modifiedJdk) {
        if (originalJdk == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(7);
        }
        if (modifiedJdk == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(8);
        }
        String previousName = originalJdk.getName();
        String newName = modifiedJdk.getName();
        ((ProjectJdkImpl)modifiedJdk).copyTo((ProjectJdkImpl)originalJdk);
        if (!previousName.equals(newName)) {
            ((ProjectJdkTable.Listener)this.myMessageBus.syncPublisher(JDK_TABLE_TOPIC)).jdkNameChanged(originalJdk, previousName);
        }
    }

    public void addListener(@NotNull ProjectJdkTable.Listener listener2) {
        if (listener2 == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(9);
        }
        this.myListenerList.add((Object)listener2);
    }

    public void removeListener(@NotNull ProjectJdkTable.Listener listener2) {
        if (listener2 == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(10);
        }
        this.myListenerList.remove((Object)listener2);
    }

    @NotNull
    public SdkTypeId getDefaultSdkType() {
        UnknownSdkType unknownSdkType = UnknownSdkType.getInstance((String)"");
        if (unknownSdkType == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(11);
        }
        return unknownSdkType;
    }

    @NotNull
    public SdkTypeId getSdkTypeByName(@NotNull String sdkTypeName) {
        if (sdkTypeName == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(12);
        }
        SdkTypeId sdkTypeId = ProjectJdkTableImpl.findSdkTypeByName(sdkTypeName);
        if (sdkTypeId == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(13);
        }
        return sdkTypeId;
    }

    @NotNull
    private static SdkTypeId findSdkTypeByName(@NotNull String sdkTypeName) {
        SdkType[] allSdkTypes;
        if (sdkTypeName == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(14);
        }
        for (SdkType type2 : allSdkTypes = SdkType.getAllTypes()) {
            if (!type2.getName().equals(sdkTypeName)) continue;
            SdkType sdkType = type2;
            if (sdkType == null) {
                ProjectJdkTableImpl.$$$reportNull$$$0(15);
            }
            return sdkType;
        }
        UnknownSdkType unknownSdkType = UnknownSdkType.getInstance((String)sdkTypeName);
        if (unknownSdkType == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(16);
        }
        return unknownSdkType;
    }

    @NotNull
    public Sdk createSdk(@NotNull String name2, @NotNull SdkTypeId sdkType) {
        if (name2 == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(17);
        }
        if (sdkType == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(18);
        }
        ProjectJdkImpl projectJdkImpl = new ProjectJdkImpl(name2, sdkType);
        if (projectJdkImpl == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(19);
        }
        return projectJdkImpl;
    }

    public void loadState(Element element) {
        this.mySdks.clear();
        for (Element child : element.getChildren(ELEMENT_JDK)) {
            ProjectJdkImpl jdk = new ProjectJdkImpl(null, null);
            jdk.readExternal(child, this);
            this.mySdks.add(jdk);
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (Sdk jdk : this.mySdks) {
            Element e = new Element(ELEMENT_JDK);
            ((ProjectJdkImpl)jdk).writeExternal(e);
            element.addContent(e);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/ProjectJdkTableImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_JDK;
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalJdk";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedJdk";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypeName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllJdks";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/ProjectJdkTableImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdksOfType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSdkType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkTypeByName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findSdkTypeByName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdk";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSdksOfType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addJdk";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeJdk";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateJdk";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSdkTypeByName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSdkTypeByName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

