/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ArtifactErrorPanel {
    private final JPanel myMainPanel = new JPanel(new BorderLayout());
    private final JButton myFixButton;
    private final JLabel myErrorLabel = new JLabel();
    private List<? extends ConfigurationErrorQuickFix> myCurrentQuickFixes;
    private String myErrorText;

    public ArtifactErrorPanel(final ArtifactEditorImpl artifactEditor) {
        this.myMainPanel.add((Component)this.myErrorLabel, "Center");
        this.myFixButton = new JButton();
        this.myMainPanel.add((Component)this.myFixButton, "East");
        new UiNotifyConnector((Component)this.myMainPanel, (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                if (ArtifactErrorPanel.this.myErrorText != null) {
                    ArtifactErrorPanel.this.myErrorLabel.setText(ArtifactErrorPanel.this.myErrorText);
                    ArtifactErrorPanel.this.myErrorText = null;
                }
            }
        });
        this.myFixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ArtifactErrorPanel.this.myCurrentQuickFixes.isEmpty()) {
                    if (ArtifactErrorPanel.this.myCurrentQuickFixes.size() == 1) {
                        ArtifactErrorPanel.performFix((ConfigurationErrorQuickFix)ContainerUtil.getFirstItem((Collection)ArtifactErrorPanel.this.myCurrentQuickFixes, null), artifactEditor);
                    } else {
                        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ConfigurationErrorQuickFix>(null, ArtifactErrorPanel.this.myCurrentQuickFixes){

                            @NotNull
                            public String getTextFor(ConfigurationErrorQuickFix value2) {
                                String string = value2.getActionName();
                                if (string == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return string;
                            }

                            public PopupStep onChosen(ConfigurationErrorQuickFix selectedValue, boolean finalChoice) {
                                ArtifactErrorPanel.performFix(selectedValue, artifactEditor);
                                return FINAL_CHOICE;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactErrorPanel$2$1", "getTextFor"));
                            }
                        }).showUnderneathOf((Component)ArtifactErrorPanel.this.myFixButton);
                    }
                }
            }
        });
        this.clearError();
    }

    private static void performFix(ConfigurationErrorQuickFix quickFix, ArtifactEditorImpl artifactEditor) {
        quickFix.performFix();
        artifactEditor.queueValidation();
    }

    public void showError(@NotNull String message2, @NotNull ProjectStructureProblemType.Severity severity, @NotNull List<? extends ConfigurationErrorQuickFix> quickFixes) {
        if (message2 == null) {
            ArtifactErrorPanel.$$$reportNull$$$0(0);
        }
        if (severity == null) {
            ArtifactErrorPanel.$$$reportNull$$$0(1);
        }
        if (quickFixes == null) {
            ArtifactErrorPanel.$$$reportNull$$$0(2);
        }
        this.myErrorLabel.setVisible(true);
        this.myErrorLabel.setIcon(severity == ProjectStructureProblemType.Severity.ERROR ? AllIcons.General.Error : (severity == ProjectStructureProblemType.Severity.WARNING ? AllIcons.General.Warning : AllIcons.General.Information));
        String errorText = UIUtil.toHtml((String)message2);
        if (this.myErrorLabel.isShowing()) {
            this.myErrorLabel.setText(errorText);
        }
        this.myErrorText = errorText;
        this.myMainPanel.setVisible(true);
        this.myCurrentQuickFixes = quickFixes;
        this.myFixButton.setVisible(!quickFixes.isEmpty());
        if (!quickFixes.isEmpty()) {
            this.myFixButton.setText(quickFixes.size() == 1 ? ((ConfigurationErrorQuickFix)ContainerUtil.getFirstItem(quickFixes, null)).getActionName() : IdeBundle.message((String)"button.fix", (Object[])new Object[0]));
        }
    }

    public void clearError() {
        this.myErrorText = null;
        this.myMainPanel.setVisible(false);
        this.myErrorLabel.setVisible(false);
        this.myFixButton.setVisible(false);
    }

    public JComponent getMainPanel() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "message";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "severity";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "quickFixes";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactErrorPanel";
        objectArray[2] = "showError";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

