/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.LibrarySourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleGroupItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleSourceItemGroup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModulesAndLibrariesSourceItemsProvider
extends PackagingSourceItemsProvider {
    @NotNull
    public Collection<? extends PackagingSourceItem> getSourceItems(@NotNull ArtifactEditorContext editorContext, @NotNull Artifact artifact, PackagingSourceItem parent) {
        if (editorContext == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(0);
        }
        if (artifact == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            Collection<? extends PackagingSourceItem> collection = ModulesAndLibrariesSourceItemsProvider.createModuleItems(editorContext, Collections.emptyList());
            if (collection == null) {
                ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }
        if (parent instanceof ModuleGroupItem) {
            Collection<? extends PackagingSourceItem> collection = ModulesAndLibrariesSourceItemsProvider.createModuleItems(editorContext, ((ModuleGroupItem)parent).getPath());
            if (collection == null) {
                ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(3);
            }
            return collection;
        }
        if (parent instanceof ModuleSourceItemGroup) {
            Collection<? extends PackagingSourceItem> collection = ModulesAndLibrariesSourceItemsProvider.createClasspathItems(editorContext, artifact, ((ModuleSourceItemGroup)parent).getModule());
            if (collection == null) {
                ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(4);
            }
            return collection;
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    private static Collection<? extends PackagingSourceItem> createClasspathItems(@NotNull ArtifactEditorContext editorContext, @NotNull Artifact artifact, @NotNull Module module2) {
        if (editorContext == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(6);
        }
        if (artifact == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(7);
        }
        if (module2 == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(8);
        }
        ArrayList<PackagingSourceItem> items = new ArrayList<PackagingSourceItem>();
        ModuleRootModel rootModel = editorContext.getModulesProvider().getRootModel(module2);
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (OrderEntry orderEntry : rootModel.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryEntry = (LibraryOrderEntry)orderEntry;
            Library library = libraryEntry.getLibrary();
            DependencyScope scope = libraryEntry.getScope();
            if (library == null || !scope.isForProductionRuntime()) continue;
            libraries.add(library);
        }
        for (Module module3 : ModulesAndLibrariesSourceItemsProvider.getNotAddedModules(editorContext, artifact, module2)) {
            items.add(new ModuleOutputSourceItem(module3));
        }
        for (Library library : ModulesAndLibrariesSourceItemsProvider.getNotAddedLibraries(editorContext, artifact, libraries)) {
            items.add(new LibrarySourceItem(library));
        }
        ArrayList<PackagingSourceItem> arrayList = items;
        if (arrayList == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<? extends PackagingSourceItem> createModuleItems(@NotNull ArtifactEditorContext editorContext, @NotNull List<String> groupPath) {
        if (editorContext == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(10);
        }
        if (groupPath == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(11);
        }
        ArrayList<PackagingSourceItem> items = new ArrayList<PackagingSourceItem>();
        ModuleGrouper grouper = ModuleGrouper.instanceFor((Project)editorContext.getProject(), (ModifiableModuleModel)editorContext.getModifiableModuleModel());
        HashSet groups = new HashSet();
        for (Module module2 : grouper.getAllModules()) {
            List path = grouper.getGroupPath(module2);
            if (Comparing.equal((Object)path, groupPath)) {
                items.add(new ModuleSourceItemGroup(module2));
                continue;
            }
            if (!ContainerUtil.startsWith((List)path, groupPath)) continue;
            groups.add(path.get(groupPath.size()));
        }
        for (String group : groups) {
            items.add(0, new ModuleGroupItem(ContainerUtil.append(groupPath, (Object[])new String[]{group})));
        }
        ArrayList<PackagingSourceItem> arrayList = items;
        if (arrayList == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static List<? extends Module> getNotAddedModules(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, Module ... allModules) {
        if (context == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(13);
        }
        if (artifact == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(14);
        }
        HashSet<Module> modules = new HashSet<Module>(Arrays.asList(allModules));
        ArtifactUtil.processPackagingElements(artifact, ProductionModuleOutputElementType.ELEMENT_TYPE, moduleOutputPackagingElement -> {
            if (context == null) {
                ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(18);
            }
            modules.remove(moduleOutputPackagingElement.findModule((PackagingElementResolvingContext)context));
            return true;
        }, (PackagingElementResolvingContext)context, true);
        ArrayList<Module> arrayList = new ArrayList<Module>(modules);
        if (arrayList == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static List<? extends Library> getNotAddedLibraries(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, List<Library> librariesList) {
        if (context == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(16);
        }
        if (artifact == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(17);
        }
        HashSet roots = new HashSet();
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE, fileCopyPackagingElement -> {
            VirtualFile root = fileCopyPackagingElement.getLibraryRoot();
            if (root != null) {
                roots.add(root);
            }
            return true;
        }, (PackagingElementResolvingContext)context, true);
        ArrayList<Library> result2 = new ArrayList<Library>();
        for (Library library : librariesList) {
            if (roots.containsAll(Arrays.asList(library.getFiles(OrderRootType.CLASSES)))) continue;
            result2.add(library);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorContext";
                break;
            }
            case 1: 
            case 7: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPath";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceItems";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createClasspathItems";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleItems";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotAddedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSourceItems";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 12: 
            case 15: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createClasspathItems";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createModuleItems";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNotAddedModules";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNotAddedLibraries";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNotAddedModules$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

