/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ComparingJarFilesTask;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertToRepositoryLibraryActionBaseKt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#H\u0002J\u0018\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006H\u0002J\u0006\u0010'\u001a\u00020 J\b\u0010\u0015\u001a\u00020\nH\u0002J\b\u0010(\u001a\u00020 H\u0016J\u0010\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020+H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0012\"\u0004\b\u001e\u0010\u0014R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ComparingJarFilesTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "project", "Lcom/intellij/openapi/project/Project;", "downloadedFiles", "", "Ljava/io/File;", "libraryFiles", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/util/List;)V", "cancelled", "", "getCancelled", "()Z", "setCancelled", "(Z)V", "downloadedFileToCompare", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDownloadedFileToCompare", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setDownloadedFileToCompare", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "filesAreTheSame", "getFilesAreTheSame", "setFilesAreTheSame", "filesToDelete", "Ljava/util/ArrayList;", "getFilesToDelete", "()Ljava/util/ArrayList;", "libraryFileToCompare", "getLibraryFileToCompare", "setLibraryFileToCompare", "collectNestedJars", "", "file", "result", "", "contentEqual", "file1", "file2", "deleteTemporaryFiles", "onCancel", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "idea-ui"})
final class ComparingJarFilesTask
extends Task.Modal {
    private boolean cancelled;
    private boolean filesAreTheSame;
    @Nullable
    private VirtualFile downloadedFileToCompare;
    @Nullable
    private VirtualFile libraryFileToCompare;
    @NotNull
    private final ArrayList<File> filesToDelete;
    private final List<File> downloadedFiles;
    private final List<File> libraryFiles;

    public final boolean getCancelled() {
        return this.cancelled;
    }

    public final void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    public final boolean getFilesAreTheSame() {
        return this.filesAreTheSame;
    }

    public final void setFilesAreTheSame(boolean bl) {
        this.filesAreTheSame = bl;
    }

    @Nullable
    public final VirtualFile getDownloadedFileToCompare() {
        return this.downloadedFileToCompare;
    }

    public final void setDownloadedFileToCompare(@Nullable VirtualFile virtualFile) {
        this.downloadedFileToCompare = virtualFile;
    }

    @Nullable
    public final VirtualFile getLibraryFileToCompare() {
        return this.libraryFileToCompare;
    }

    public final void setLibraryFileToCompare(@Nullable VirtualFile virtualFile) {
        this.libraryFileToCompare = virtualFile;
    }

    @NotNull
    public final ArrayList<File> getFilesToDelete() {
        return this.filesToDelete;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        this.filesAreTheSame = this.filesAreTheSame();
        if (!this.filesAreTheSame) {
            Object downloadedFilesIoDir;
            File downloadedIoFileToCompare;
            File libraryIoFileToCompare;
            if (this.libraryFiles.size() == 1 && this.downloadedFiles.size() == 1) {
                libraryIoFileToCompare = this.libraryFiles.get(0);
                if (Intrinsics.areEqual((Object)this.downloadedFiles.get(0).getName(), (Object)this.libraryFiles.get(0).getName())) {
                    downloadedIoFileToCompare = this.downloadedFiles.get(0);
                } else {
                    downloadedFilesIoDir = FileUtil.createTempDirectory((String)"downloaded_file", (String)"", (boolean)true);
                    downloadedIoFileToCompare = new File((File)downloadedFilesIoDir, this.libraryFiles.get(0).getName());
                    FileUtil.copy((File)this.downloadedFiles.get(0), (File)downloadedIoFileToCompare);
                    Collection collection = this.filesToDelete;
                    collection.add(downloadedFilesIoDir);
                }
            } else {
                File it;
                File file2 = FileUtil.createTempDirectory((String)"library_files", (String)"", (boolean)true);
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtil.createTempDirec\u2026library_files\", \"\", true)");
                libraryIoFileToCompare = file2;
                downloadedFilesIoDir = this.filesToDelete;
                downloadedFilesIoDir.add(libraryIoFileToCompare);
                Iterable $receiver$iv = this.libraryFiles;
                for (Object element$iv : $receiver$iv) {
                    it = (File)element$iv;
                    FileUtil.copy((File)it, (File)new File(libraryIoFileToCompare, it.getName()));
                }
                File file3 = FileUtil.createTempDirectory((String)"downloaded_files", (String)"", (boolean)true);
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"FileUtil.createTempDirec\u2026nloaded_files\", \"\", true)");
                downloadedIoFileToCompare = file3;
                $receiver$iv = this.downloadedFiles;
                for (Object element$iv : $receiver$iv) {
                    it = (File)element$iv;
                    FileUtil.copy((File)it, (File)new File(downloadedIoFileToCompare, it.getName()));
                }
                $receiver$iv = this.filesToDelete;
                $receiver$iv.add(downloadedIoFileToCompare);
            }
            new WriteAction<Unit>(this, libraryIoFileToCompare, downloadedIoFileToCompare){
                final /* synthetic */ ComparingJarFilesTask this$0;
                final /* synthetic */ File $libraryIoFileToCompare;
                final /* synthetic */ File $downloadedIoFileToCompare;

                protected void run(@NotNull Result<Unit> result2) {
                    Intrinsics.checkParameterIsNotNull(result2, (String)"result");
                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.$libraryIoFileToCompare);
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    this.this$0.setLibraryFileToCompare(virtualFile);
                    VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.$downloadedIoFileToCompare);
                    if (virtualFile2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.this$0.setDownloadedFileToCompare(virtualFile2);
                }
                {
                    this.this$0 = $outer;
                    this.$libraryIoFileToCompare = $captured_local_variable$1;
                    this.$downloadedIoFileToCompare = $captured_local_variable$2;
                }
            }.execute();
            RefreshQueue.getInstance().refresh(false, false, null, new VirtualFile[]{this.libraryFileToCompare, this.downloadedFileToCompare});
            ArrayList jarFilesToRefresh = new ArrayList();
            new WriteAction<Unit>(this, jarFilesToRefresh){
                final /* synthetic */ ComparingJarFilesTask this$0;
                final /* synthetic */ ArrayList $jarFilesToRefresh;

                protected void run(@NotNull Result<Unit> result2) {
                    Intrinsics.checkParameterIsNotNull(result2, (String)"result");
                    VirtualFile virtualFile = this.this$0.getLibraryFileToCompare();
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    ComparingJarFilesTask.access$collectNestedJars(this.this$0, virtualFile, this.$jarFilesToRefresh);
                    VirtualFile virtualFile2 = this.this$0.getDownloadedFileToCompare();
                    if (virtualFile2 == null) {
                        Intrinsics.throwNpe();
                    }
                    ComparingJarFilesTask.access$collectNestedJars(this.this$0, virtualFile2, this.$jarFilesToRefresh);
                }
                {
                    this.this$0 = $outer;
                    this.$jarFilesToRefresh = $captured_local_variable$1;
                }
            }.execute();
            RefreshQueue.getInstance().refresh(false, true, null, (Collection)jarFilesToRefresh);
        }
    }

    private final void collectNestedJars(VirtualFile file2, List<VirtualFile> result2) {
        if (file2.isDirectory()) {
            Object[] $receiver$iv = file2.getChildren();
            for (int i = 0; i < $receiver$iv.length; ++i) {
                VirtualFile it;
                Object element$iv = $receiver$iv[i];
                VirtualFile virtualFile = it = (VirtualFile)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                this.collectNestedJars(virtualFile, result2);
            }
        } else if (Intrinsics.areEqual((Object)file2.getFileType(), (Object)StdFileTypes.ARCHIVE)) {
            String jarRootUrl = VfsUtil.getUrlForLibraryRoot((File)VfsUtil.virtualToIoFile((VirtualFile)file2));
            VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(jarRootUrl);
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"VirtualFileManager.getIn\u2026ndFileByUrl(jarRootUrl)!!");
            result2.add(virtualFile);
        }
    }

    public final void deleteTemporaryFiles() {
        FileUtil.asyncDelete((Collection)this.filesToDelete);
    }

    public void onCancel() {
        this.cancelled = true;
    }

    private final boolean filesAreTheSame() {
        String string;
        Logger logger;
        Logger $receiver$iv = ConvertToRepositoryLibraryActionBaseKt.access$getLOG$p();
        Exception e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            logger = $receiver$iv;
            string = "Downloaded files: " + CollectionsKt.joinToString$default((Iterable)this.downloadedFiles, null, null, null, (int)0, null, (Function1)filesAreTheSame.1.1.INSTANCE, (int)31, null);
            logger.debug(string, (Throwable)e$iv);
        }
        $receiver$iv = ConvertToRepositoryLibraryActionBaseKt.access$getLOG$p();
        e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            logger = $receiver$iv;
            string = "Library files: " + CollectionsKt.joinToString$default((Iterable)this.libraryFiles, null, null, null, (int)0, null, (Function1)filesAreTheSame.2.1.INSTANCE, (int)31, null);
            logger.debug(string, (Throwable)e$iv);
        }
        if (this.downloadedFiles.size() != this.libraryFiles.size()) {
            return false;
        }
        TObjectHashingStrategy<File> contentHashing2 = new TObjectHashingStrategy<File>(this){
            final /* synthetic */ ComparingJarFilesTask this$0;

            public int computeHashCode(@NotNull File file2) {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                return (int)file2.length();
            }

            public boolean equals(@NotNull File o1, @NotNull File o2) {
                Intrinsics.checkParameterIsNotNull((Object)o1, (String)"o1");
                Intrinsics.checkParameterIsNotNull((Object)o2, (String)"o2");
                boolean equal = ComparingJarFilesTask.access$contentEqual(this.this$0, o1, o2);
                ConvertToRepositoryLibraryActionBaseKt.access$getLOG$p().debug(" comparing files: " + o1.getAbsolutePath() + "" + (equal ? "==" : "!=") + "" + o2.getAbsolutePath());
                return equal;
            }
            {
                this.this$0 = $outer;
            }
        };
        return Intrinsics.areEqual((Object)new THashSet((Collection)this.downloadedFiles, (TObjectHashingStrategy)contentHashing2), (Object)new THashSet((Collection)this.libraryFiles, (TObjectHashingStrategy)contentHashing2));
    }

    /*
     * Exception decompiling
     */
    private final boolean contentEqual(File file1, File file2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 17[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ComparingJarFilesTask(@NotNull Project project2, @NotNull List<? extends File> downloadedFiles, @NotNull List<? extends File> libraryFiles) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(downloadedFiles, (String)"downloadedFiles");
        Intrinsics.checkParameterIsNotNull(libraryFiles, (String)"libraryFiles");
        super(project2, "Comparing JAR Files...", true);
        this.downloadedFiles = downloadedFiles;
        this.libraryFiles = libraryFiles;
        this.filesToDelete = new ArrayList();
    }

    public static final /* synthetic */ void access$collectNestedJars(ComparingJarFilesTask $this, @NotNull VirtualFile file2, @NotNull List result2) {
        $this.collectNestedJars(file2, result2);
    }

    public static final /* synthetic */ boolean access$contentEqual(ComparingJarFilesTask $this, @NotNull File file1, @NotNull File file2) {
        return $this.contentEqual(file1, file2);
    }
}

