/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.xml.util.XmlStringUtil;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\n\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/LibraryJarsDiffDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "libraryFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "downloadedFile", "mavenCoordinates", "Lorg/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor;", "libraryName", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "panel", "Lcom/intellij/diff/DiffRequestPanel;", "createCenterPanel", "Ljavax/swing/JComponent;", "createNorthPanel", "Lcom/intellij/ui/components/JBLabel;", "getPreferredFocusedComponent", "idea-ui"})
public final class LibraryJarsDiffDialog
extends DialogWrapper {
    private final DiffRequestPanel panel;
    private final JpsMavenRepositoryLibraryDescriptor mavenCoordinates;
    private final String libraryName;

    @NotNull
    protected JBLabel createNorthPanel() {
        return new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)("" + this.mavenCoordinates.getMavenId() + " JARs differ from '" + this.libraryName + "' library JARs.")));
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.panel.getComponent();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.panel.getPreferredFocusedComponent();
    }

    public LibraryJarsDiffDialog(@NotNull VirtualFile libraryFile, @NotNull VirtualFile downloadedFile, @NotNull JpsMavenRepositoryLibraryDescriptor mavenCoordinates, @NotNull String libraryName, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)libraryFile, (String)"libraryFile");
        Intrinsics.checkParameterIsNotNull((Object)downloadedFile, (String)"downloadedFile");
        Intrinsics.checkParameterIsNotNull((Object)mavenCoordinates, (String)"mavenCoordinates");
        Intrinsics.checkParameterIsNotNull((Object)libraryName, (String)"libraryName");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.mavenCoordinates = mavenCoordinates;
        this.libraryName = libraryName;
        this.setTitle("Replace Library");
        this.setOKButtonText("Replace");
        ContentDiffRequest contentDiffRequest = DiffRequestFactory.getInstance().createFromFiles(project2, libraryFile, downloadedFile);
        Intrinsics.checkExpressionValueIsNotNull((Object)contentDiffRequest, (String)"DiffRequestFactory.getIn\u2026raryFile, downloadedFile)");
        ContentDiffRequest request = contentDiffRequest;
        DiffRequestPanel diffRequestPanel = DiffManager.getInstance().createRequestPanel(project2, this.getDisposable(), this.getWindow());
        Intrinsics.checkExpressionValueIsNotNull((Object)diffRequestPanel, (String)"DiffManager.getInstance(\u2026ject, disposable, window)");
        this.panel = diffRequestPanel;
        DirDiffSettings dirDiffSettings = new DirDiffSettings();
        Key key2 = DirDiffSettings.KEY;
        DiffRequestPanel diffRequestPanel2 = this.panel;
        DirDiffSettings $receiver = dirDiffSettings;
        $receiver.enableChoosers = false;
        DirDiffSettings dirDiffSettings2 = dirDiffSettings;
        diffRequestPanel2.putContextHints(key2, (Object)dirDiffSettings2);
        this.panel.setRequest((DiffRequest)request);
        this.init();
    }
}

