/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ObjectUtils;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleConfigurable
extends ProjectStructureElementConfigurable<Module>
implements Place.Navigator {
    private final Module myModule;
    private final ModuleGrouper myModuleGrouper;
    private final ModulesConfigurator myConfigurator;
    private String myModuleName;
    private final ModuleProjectStructureElement myProjectStructureElement;
    private final StructureConfigurableContext myContext;

    public ModuleConfigurable(ModulesConfigurator modulesConfigurator, Module module2, Runnable updateTree, ModuleGrouper moduleGrouper) {
        super(true, updateTree);
        this.myModule = module2;
        this.myModuleGrouper = moduleGrouper;
        this.myConfigurator = modulesConfigurator;
        this.myModuleName = (String)ObjectUtils.notNull((Object)this.myConfigurator.getModuleModel().getNewName(this.myModule), (Object)this.myModule.getName());
        this.myContext = ModuleStructureConfigurable.getInstance(this.myModule.getProject()).getContext();
        this.myProjectStructureElement = new ModuleProjectStructureElement(this.myContext, this.myModule);
    }

    public void setDisplayName(String name2) {
        ModifiableModuleModel modifiableModuleModel = this.myConfigurator.getModuleModel();
        if (StringUtil.isEmpty((String)name2)) {
            return;
        }
        if (Comparing.strEqual((String)name2, (String)this.myModuleName)) {
            return;
        }
        try {
            modifiableModuleModel.renameModule(this.myModule, name2);
        }
        catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
            // empty catch block
        }
        this.myConfigurator.moduleRenamed(this.myModule, this.myModuleName, name2);
        this.myModuleName = name2;
        this.myConfigurator.setModified(!Comparing.strEqual((String)this.myModuleName, (String)this.myModule.getName()));
        this.myContext.getDaemonAnalyzer().queueUpdateForAllElementsWithErrors();
    }

    protected void checkName(@NotNull String name2) throws ConfigurationException {
        if (name2 == null) {
            ModuleConfigurable.$$$reportNull$$$0(0);
        }
        super.checkName(name2);
        if (this.myModuleGrouper.getShortenedNameByFullModuleName(name2).isEmpty()) {
            throw new ConfigurationException("Short name of a module cannot be empty");
        }
        List list2 = this.myModuleGrouper.getGroupPathByModuleName(name2);
        if (list2.stream().anyMatch(s -> s.isEmpty())) {
            throw new ConfigurationException("Names of parent groups for a module cannot be empty");
        }
    }

    public ModuleGrouper getModuleGrouper() {
        return this.myModuleGrouper;
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.myProjectStructureElement;
    }

    public Module getEditableObject() {
        return this.myModule;
    }

    public String getBannerSlogan() {
        return ProjectBundle.message((String)"project.roots.module.banner.text", (Object[])new Object[]{this.myModuleName});
    }

    public String getDisplayName() {
        return this.myModuleName;
    }

    public Icon getIcon(boolean open2) {
        return this.myModule.isDisposed() ? null : ModuleType.get((Module)this.myModule).getIcon();
    }

    public Module getModule() {
        return this.myModule;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        ModuleEditor editor = this.getModuleEditor();
        return editor == null ? null : editor.getHelpTopic();
    }

    public JComponent createOptionsPanel() {
        ModuleEditor editor = this.getModuleEditor();
        return editor == null ? null : editor.getPanel();
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public void reset() {
    }

    public void disposeUIResources() {
    }

    public ModuleEditor getModuleEditor() {
        return this.myConfigurator.getModuleEditor(this.myModule);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        ModuleEditor editor = this.getModuleEditor();
        return editor == null ? ActionCallback.REJECTED : editor.navigateTo(place, requestFocus);
    }

    public void queryPlace(@NotNull Place place) {
        ModuleEditor editor;
        if (place == null) {
            ModuleConfigurable.$$$reportNull$$$0(1);
        }
        if ((editor = this.getModuleEditor()) != null) {
            editor.queryPlace(place);
        }
    }

    public void setHistory(History history) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "queryPlace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

