/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.IgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class RecursiveFileHolder<T>
implements IgnoredFilesHolder {
    protected final Project myProject;
    protected final ProjectLevelVcsManager myVcsManager;
    protected final FileHolder.HolderType myHolderType;
    protected final TreeMap<VirtualFile, T> myMap;
    protected final TreeMap<VirtualFile, T> myDirMap;

    public RecursiveFileHolder(Project project2, FileHolder.HolderType holderType) {
        this.myProject = project2;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        this.myMap = new TreeMap(FilePathComparator.getInstance());
        this.myDirMap = new TreeMap(FilePathComparator.getInstance());
        this.myHolderType = holderType;
    }

    @Override
    public void cleanAll() {
        this.myMap.clear();
        this.myDirMap.clear();
    }

    protected Collection<VirtualFile> keys() {
        return this.myMap.keySet();
    }

    @Override
    public void notifyVcsStarted(AbstractVcs scope) {
    }

    @Override
    public FileHolder.HolderType getType() {
        return this.myHolderType;
    }

    @Override
    public void addFile(VirtualFile file2) {
        if (!this.containsFile(file2)) {
            this.myMap.put(file2, null);
            if (file2.isDirectory()) {
                this.myDirMap.put(file2, null);
            }
        }
    }

    public void removeFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RecursiveFileHolder.$$$reportNull$$$0(0);
        }
        this.myMap.remove(file2);
        if (file2.isDirectory()) {
            this.myDirMap.remove(file2);
        }
    }

    @Override
    public RecursiveFileHolder copy() {
        RecursiveFileHolder<T> copyHolder = new RecursiveFileHolder<T>(this.myProject, this.myHolderType);
        copyHolder.myMap.putAll(this.myMap);
        copyHolder.myDirMap.putAll(this.myDirMap);
        return copyHolder;
    }

    @Override
    public boolean containsFile(VirtualFile file2) {
        if (this.myMap.containsKey(file2)) {
            return true;
        }
        VirtualFile floor = this.myDirMap.floorKey(file2);
        if (floor == null) {
            return false;
        }
        NavigableMap<VirtualFile, T> floorMap = this.myDirMap.headMap(floor, true);
        for (VirtualFile parent : floorMap.keySet()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<VirtualFile> values() {
        return this.myMap.keySet();
    }

    @Override
    public void cleanAndAdjustScope(VcsModifiableDirtyScope scope) {
        if (this.myProject.isDisposed()) {
            return;
        }
        Iterator<VirtualFile> iterator = this.keys().iterator();
        while (iterator.hasNext()) {
            VirtualFile file2 = iterator.next();
            if (!this.isFileDirty((VcsDirtyScope)scope, file2)) continue;
            iterator.remove();
        }
    }

    protected boolean isFileDirty(VcsDirtyScope scope, VirtualFile file2) {
        if (!file2.isValid()) {
            return true;
        }
        AbstractVcs[] vcsArr = new AbstractVcs[1];
        if (scope.belongsTo(VcsUtil.getFilePath((VirtualFile)file2), vcs -> {
            vcsArr[0] = vcs;
        })) {
            return true;
        }
        return vcsArr[0] == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecursiveFileHolder that = (RecursiveFileHolder)o;
        if (this.myMap.size() != that.myMap.size()) {
            return false;
        }
        Iterator<Map.Entry<VirtualFile, T>> it1 = this.myMap.entrySet().iterator();
        Iterator<Map.Entry<VirtualFile, T>> it2 = that.myMap.entrySet().iterator();
        while (it1.hasNext()) {
            if (!it2.hasNext()) {
                return false;
            }
            Map.Entry<VirtualFile, T> next1 = it1.next();
            Map.Entry<VirtualFile, T> next2 = it2.next();
            if (Comparing.equal((Object)next1.getKey(), (Object)next2.getKey()) && Comparing.equal(next1.getValue(), next2.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/RecursiveFileHolder", "removeFile"));
    }
}

