/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScheduleForAdditionAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(0);
        }
        boolean enabled = e.getProject() != null && !UtilKt.isEmpty(this.getUnversionedFiles(e, e.getProject()));
        e.getPresentation().setEnabled(enabled);
        if ("ActionPlace.VcsQuickListPopupAction".equals(e.getPlace()) || "ChangesViewPopup".equals(e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(1);
        }
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        List<VirtualFile> unversionedFiles = this.getUnversionedFiles(e, project2).collect(Collectors.toList());
        ScheduleForAdditionAction.addUnversioned(project2, unversionedFiles, (Condition<FileStatus>)((Condition)this::isStatusForAddition), (ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY));
    }

    public static boolean addUnversioned(@NotNull Project project2, @NotNull List<VirtualFile> files, @NotNull Condition<FileStatus> unversionedFileCondition, @Nullable ChangesBrowserBase browser) {
        if (project2 == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(2);
        }
        if (files == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(3);
        }
        if (unversionedFileCondition == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(4);
        }
        boolean result2 = true;
        if (!files.isEmpty()) {
            FileDocumentManager.getInstance().saveAllDocuments();
            Consumer consumer = browser == null ? null : changes -> {
                if (browser instanceof CommitDialogChangesBrowser) {
                    ((CommitDialogChangesBrowser)browser).updateDisplayedChangeLists();
                }
                browser.getViewer().includeChanges((Collection<?>)changes);
            };
            ChangeListManagerImpl manager = ChangeListManagerImpl.getInstanceImpl(project2);
            LocalChangeList targetChangeList = browser instanceof CommitDialogChangesBrowser ? ((CommitDialogChangesBrowser)browser).getSelectedChangeList() : manager.getDefaultChangeList();
            List<VcsException> exceptions = manager.addUnversionedFiles(targetChangeList, files, unversionedFileCondition, (Consumer<List<Change>>)consumer);
            result2 = exceptions.isEmpty();
        }
        return result2;
    }

    @NotNull
    private Stream<VirtualFile> getUnversionedFiles(@NotNull AnActionEvent e, @NotNull Project project2) {
        boolean hasExplicitUnversioned;
        if (e == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(6);
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project2);
        boolean bl = hasExplicitUnversioned = !UtilKt.isEmpty((Stream)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY));
        Stream<VirtualFile> stream = hasExplicitUnversioned ? (Stream<VirtualFile>)e.getRequiredData(ChangesListView.UNVERSIONED_FILES_DATA_KEY) : (this.checkVirtualFiles(e) ? UtilKt.notNullize((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM)).filter(file2 -> this.isFileUnversioned((VirtualFile)file2, vcsManager, fileStatusManager)) : Stream.empty());
        if (stream == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(7);
        }
        return stream;
    }

    private boolean isFileUnversioned(@NotNull VirtualFile file2, @NotNull ProjectLevelVcsManager vcsManager, @NotNull FileStatusManager fileStatusManager) {
        AbstractVcs vcs;
        if (file2 == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(8);
        }
        if (vcsManager == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(9);
        }
        if (fileStatusManager == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(10);
        }
        return (vcs = vcsManager.getVcsFor(file2)) != null && !vcs.areDirectoriesVersionedItems() && file2.isDirectory() || this.isStatusForAddition(fileStatusManager.getStatus(file2));
    }

    protected boolean isStatusForAddition(FileStatus status) {
        return status == FileStatus.UNKNOWN;
    }

    protected boolean checkVirtualFiles(@NotNull AnActionEvent e) {
        if (e == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(11);
        }
        return ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unversionedFileCondition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatusManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addUnversioned";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUnversionedFiles";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isFileUnversioned";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkVirtualFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

