/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterKey;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterPriority;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureFilteringStrategy
implements ChangeListFilteringStrategy {
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private MyUI myUI;
    private final Project myProject;
    private final List<FilePath> mySelection = new ArrayList<FilePath>();

    public StructureFilteringStrategy(Project project2) {
        this.myProject = project2;
    }

    public CommittedChangesFilterKey getKey() {
        return new CommittedChangesFilterKey(this.toString(), CommittedChangesFilterPriority.STRUCTURE);
    }

    public String toString() {
        return VcsBundle.message((String)"filter.structure.name", (Object[])new Object[0]);
    }

    @Nullable
    public JComponent getFilterUI() {
        if (this.myUI == null) {
            this.myUI = new MyUI();
        }
        return this.myUI.getComponent();
    }

    public void setFilterBase(List<CommittedChangeList> changeLists) {
        if (this.myUI == null) {
            this.myUI = new MyUI();
        }
        this.myUI.reset();
        this.myUI.append(changeLists);
    }

    public void addChangeListener(ChangeListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeChangeListener(ChangeListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void resetFilterBase() {
        this.myUI.reset();
    }

    public void appendFilterBase(List<CommittedChangeList> changeLists) {
        this.myUI.append(changeLists);
    }

    @NotNull
    public List<CommittedChangeList> filterChangeLists(List<CommittedChangeList> changeLists) {
        if (this.mySelection.size() == 0) {
            List<CommittedChangeList> list2 = changeLists;
            if (list2 == null) {
                StructureFilteringStrategy.$$$reportNull$$$0(0);
            }
            return list2;
        }
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
        for (CommittedChangeList list3 : changeLists) {
            if (!this.listMatchesSelection(list3)) continue;
            result2.add(list3);
        }
        ArrayList<CommittedChangeList> arrayList = result2;
        if (arrayList == null) {
            StructureFilteringStrategy.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private boolean listMatchesSelection(CommittedChangeList list2) {
        for (Change change : list2.getChanges()) {
            FilePath path = ChangesUtil.getFilePath((Change)change);
            for (FilePath selPath : this.mySelection) {
                if (!path.isUnder(selPath, false)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/StructureFilteringStrategy", "filterChangeLists"));
    }

    private class MyUI {
        private final JComponent myScrollPane;
        private final Tree myStructureTree;
        private boolean myRendererInitialized;
        private final Set<FilePath> myFilePaths = new HashSet<FilePath>();
        private TreeState myState;

        public MyUI() {
            this.myStructureTree = new Tree();
            this.myStructureTree.setRootVisible(false);
            this.myStructureTree.setShowsRootHandles(true);
            this.myStructureTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    ArrayList filePaths = new ArrayList(StructureFilteringStrategy.this.mySelection);
                    StructureFilteringStrategy.this.mySelection.clear();
                    TreePath[] selectionPaths = MyUI.this.myStructureTree.getSelectionPaths();
                    if (selectionPaths != null) {
                        for (TreePath selectionPath : selectionPaths) {
                            StructureFilteringStrategy.this.mySelection.addAll(MyUI.this.getFilePathsUnder((ChangesBrowserNode)selectionPath.getLastPathComponent()));
                        }
                    }
                    if (Comparing.haveEqualElements(filePaths, (Collection)StructureFilteringStrategy.this.mySelection)) {
                        return;
                    }
                    for (ChangeListener listener2 : StructureFilteringStrategy.this.myListeners) {
                        listener2.stateChanged(new ChangeEvent(this));
                    }
                }
            });
            this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myStructureTree);
        }

        @NotNull
        private List<FilePath> getFilePathsUnder(@NotNull ChangesBrowserNode<?> node) {
            if (node == null) {
                MyUI.$$$reportNull$$$0(0);
            }
            List result2 = Collections.emptyList();
            Object userObject = node.getUserObject();
            if (userObject instanceof FilePath) {
                result2 = ContainerUtil.list((Object[])new FilePath[]{(FilePath)userObject});
            } else if (userObject instanceof Module) {
                result2 = Arrays.stream(ModuleRootManager.getInstance((Module)((Module)userObject)).getContentRoots()).map(VcsUtil::getFilePath).collect(Collectors.toList());
            }
            List list2 = result2;
            if (list2 == null) {
                MyUI.$$$reportNull$$$0(1);
            }
            return list2;
        }

        public void initRenderer() {
            if (!this.myRendererInitialized) {
                this.myRendererInitialized = true;
                this.myStructureTree.setCellRenderer((TreeCellRenderer)((Object)new ChangesBrowserNodeRenderer(StructureFilteringStrategy.this.myProject, BooleanGetter.FALSE, false)));
            }
        }

        public JComponent getComponent() {
            return this.myScrollPane;
        }

        public void reset() {
            this.myFilePaths.clear();
            this.myState = TreeState.createOn((JTree)this.myStructureTree, (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myStructureTree.getModel().getRoot()));
            this.myStructureTree.setModel((TreeModel)TreeModelBuilder.buildEmpty(StructureFilteringStrategy.this.myProject));
        }

        public void append(List<CommittedChangeList> changeLists) {
            TreeState localState = this.myState != null && this.myFilePaths.isEmpty() ? this.myState : TreeState.createOn((JTree)this.myStructureTree, (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myStructureTree.getModel().getRoot()));
            for (CommittedChangeList changeList : changeLists) {
                for (Change change : changeList.getChanges()) {
                    FilePath path = ChangesUtil.getFilePath((Change)change);
                    if (path.getParentPath() == null) continue;
                    this.myFilePaths.add(path.getParentPath());
                }
            }
            this.myStructureTree.setModel((TreeModel)TreeModelBuilder.buildFromFilePaths(StructureFilteringStrategy.this.myProject, false, this.myFilePaths));
            localState.applyTo((JTree)this.myStructureTree, (Object)((DefaultMutableTreeNode)this.myStructureTree.getModel().getRoot()));
            this.myStructureTree.revalidate();
            this.myStructureTree.repaint();
            this.initRenderer();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/StructureFilteringStrategy$MyUI";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/StructureFilteringStrategy$MyUI";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePathsUnder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilePathsUnder";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

