/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictResolution;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ChangelistConflictTracker {
    private final Map<String, Conflict> myConflicts;
    private final Options myOptions;
    private final Project myProject;
    private final ChangeListManager myChangeListManager;
    private final EditorNotifications myEditorNotifications;
    private final ChangeListAdapter myChangeListListener;
    private final FileDocumentManager myDocumentManager;
    private final DocumentListener myDocumentListener;
    private final FileStatusManager myFileStatusManager;
    private final Set<VirtualFile> myCheckSet;
    private final Object myCheckSetLock;

    public ChangelistConflictTracker(@NotNull Project project2, @NotNull ChangeListManager changeListManager, @NotNull FileStatusManager fileStatusManager, @NotNull EditorNotifications editorNotifications) {
        if (project2 == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(0);
        }
        if (changeListManager == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(1);
        }
        if (fileStatusManager == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(2);
        }
        if (editorNotifications == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(3);
        }
        this.myConflicts = Collections.synchronizedMap(new LinkedHashMap());
        this.myOptions = new Options();
        this.myProject = project2;
        this.myChangeListManager = changeListManager;
        this.myEditorNotifications = editorNotifications;
        this.myDocumentManager = FileDocumentManager.getInstance();
        this.myFileStatusManager = fileStatusManager;
        this.myCheckSetLock = new Object();
        this.myCheckSet = new HashSet();
        Application application = ApplicationManager.getApplication();
        final ZipperUpdater zipperUpdater = new ZipperUpdater(300, Alarm.ThreadToUse.SWING_THREAD, (Disposable)project2);
        final Runnable runnable2 = () -> {
            HashSet localSet;
            if (application.isDisposed() || this.myProject.isDisposed() || !this.myProject.isOpen()) {
                return;
            }
            Object object = this.myCheckSetLock;
            synchronized (object) {
                localSet = new HashSet();
                localSet.addAll(this.myCheckSet);
                this.myCheckSet.clear();
            }
            this.checkFiles((Collection<VirtualFile>)localSet);
        };
        this.myDocumentListener = new DocumentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentChanged(DocumentEvent e) {
                if (!((ChangelistConflictTracker)ChangelistConflictTracker.this).myOptions.TRACKING_ENABLED) {
                    return;
                }
                Document document = e.getDocument();
                VirtualFile file2 = ChangelistConflictTracker.this.myDocumentManager.getFile(document);
                if (ProjectUtil.guessProjectForFile((VirtualFile)file2) == ChangelistConflictTracker.this.myProject) {
                    Object object = ChangelistConflictTracker.this.myCheckSetLock;
                    synchronized (object) {
                        ChangelistConflictTracker.this.myCheckSet.add(file2);
                    }
                    zipperUpdater.queue(runnable2);
                }
            }
        };
        this.myChangeListListener = new ChangeListAdapter(){

            public void changeListChanged(ChangeList list2) {
                if (((LocalChangeList)list2).isDefault()) {
                    ChangelistConflictTracker.this.clearChanges(list2.getChanges());
                }
            }

            public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
                if (((LocalChangeList)toList).isDefault()) {
                    ChangelistConflictTracker.this.clearChanges(changes);
                }
            }

            public void changesRemoved(Collection<Change> changes, ChangeList fromList) {
                ChangelistConflictTracker.this.clearChanges(changes);
            }

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
                ChangelistConflictTracker.this.clearChanges(newDefaultList.getChanges());
            }
        };
    }

    private void checkFiles(Collection<VirtualFile> files) {
        this.myChangeListManager.invokeAfterUpdate(() -> {
            LocalChangeList list2 = this.myChangeListManager.getDefaultChangeList();
            for (VirtualFile file2 : files) {
                this.checkOneFile(file2, list2);
            }
        }, InvokeAfterUpdateMode.SILENT, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOneFile(VirtualFile file2, LocalChangeList defaultList) {
        if (file2 == null) {
            return;
        }
        LocalChangeList changeList = this.myChangeListManager.getChangeList(file2);
        if (changeList == null || Comparing.equal((Object)changeList, (Object)defaultList) || ChangesUtil.isInternalOperation((VirtualFile)file2)) {
            return;
        }
        String path = file2.getPath();
        boolean newConflict = false;
        Map<String, Conflict> map = this.myConflicts;
        synchronized (map) {
            Conflict conflict = this.myConflicts.get(path);
            if (conflict == null) {
                conflict = new Conflict();
                this.myConflicts.put(path, conflict);
                newConflict = true;
            }
        }
        if (newConflict && this.myOptions.HIGHLIGHT_CONFLICTS) {
            this.myFileStatusManager.fileStatusChanged(file2);
            this.myEditorNotifications.updateNotifications(file2);
        }
    }

    public boolean isWritingAllowed(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(4);
        }
        if (this.isFromActiveChangelist(file2)) {
            return true;
        }
        Conflict conflict = this.myConflicts.get(file2.getPath());
        return conflict != null && conflict.ignored;
    }

    public boolean isFromActiveChangelist(VirtualFile file2) {
        LocalChangeList changeList = this.myChangeListManager.getChangeList(file2);
        return changeList == null || changeList.isDefault();
    }

    private void clearChanges(Collection<Change> changes) {
        for (Change change : changes) {
            ContentRevision revision = change.getAfterRevision();
            if (revision == null) continue;
            FilePath filePath = revision.getFile();
            String path = filePath.getPath();
            Conflict wasRemoved = this.myConflicts.remove(path);
            VirtualFile file2 = filePath.getVirtualFile();
            if (wasRemoved == null || file2 == null) continue;
            this.myEditorNotifications.updateNotifications(file2);
            this.myFileStatusManager.fileStatusChanged(file2);
        }
    }

    public void startTracking() {
        this.myChangeListManager.addChangeListListener((ChangeListListener)this.myChangeListListener);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(this.myDocumentListener, (Disposable)this.myProject);
    }

    public void stopTracking() {
        this.myChangeListManager.removeChangeListListener((ChangeListListener)this.myChangeListListener);
    }

    public void saveState(Element to) {
        for (Map.Entry<String, Conflict> entry : this.myConflicts.entrySet()) {
            Element fileElement = new Element("file");
            fileElement.setAttribute("path", entry.getKey());
            fileElement.setAttribute("ignored", Boolean.toString(entry.getValue().ignored));
            to.addContent(fileElement);
        }
        XmlSerializer.serializeInto((Object)this.myOptions, (Element)to);
    }

    public void loadState(Element from) {
        this.myConflicts.clear();
        List files = from.getChildren("file");
        for (Object file2 : files) {
            VirtualFile vf;
            Element element = (Element)file2;
            String path = element.getAttributeValue("path");
            if (path == null || (vf = LocalFileSystem.getInstance().findFileByIoFile(new File(path))) == null || this.myChangeListManager.getChangeList(vf) == null) continue;
            Conflict conflict = new Conflict();
            conflict.ignored = Boolean.parseBoolean(element.getAttributeValue("ignored"));
            this.myConflicts.put(path, conflict);
        }
        XmlSerializer.deserializeInto((Object)this.myOptions, (Element)from);
    }

    public void optionsChanged() {
        for (Map.Entry<String, Conflict> entry : this.myConflicts.entrySet()) {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(entry.getKey());
            if (file2 == null) continue;
            this.myFileStatusManager.fileStatusChanged(file2);
            this.myEditorNotifications.updateNotifications(file2);
        }
    }

    public Map<String, Conflict> getConflicts() {
        return this.myConflicts;
    }

    public Collection<String> getIgnoredConflicts() {
        return ContainerUtil.mapNotNull(this.myConflicts.entrySet(), (Function)((NullableFunction)entry -> ((Conflict)entry.getValue()).ignored ? (String)entry.getKey() : null));
    }

    public boolean hasConflict(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(5);
        }
        if (!this.myOptions.TRACKING_ENABLED) {
            return false;
        }
        String path = file2.getPath();
        Conflict conflict = this.myConflicts.get(path);
        if (conflict != null && !conflict.ignored) {
            if (this.isFromActiveChangelist(file2)) {
                this.myConflicts.remove(path);
                return false;
            }
            return true;
        }
        return false;
    }

    public void ignoreConflict(@NotNull VirtualFile file2, boolean ignore) {
        String path;
        Conflict conflict;
        if (file2 == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(6);
        }
        if ((conflict = this.myConflicts.get(path = file2.getPath())) == null) {
            conflict = new Conflict();
            this.myConflicts.put(path, conflict);
        }
        conflict.ignored = ignore;
        this.myEditorNotifications.updateNotifications(file2);
        this.myFileStatusManager.fileStatusChanged(file2);
    }

    public Project getProject() {
        return this.myProject;
    }

    public ChangeListManager getChangeListManager() {
        return this.myChangeListManager;
    }

    public Options getOptions() {
        return this.myOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatusManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorNotifications";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isWritingAllowed";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasConflict";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoreConflict";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Options {
        public boolean TRACKING_ENABLED = true;
        public boolean SHOW_DIALOG = false;
        public boolean HIGHLIGHT_CONFLICTS = true;
        public boolean HIGHLIGHT_NON_ACTIVE_CHANGELIST = false;
        public ChangelistConflictResolution LAST_RESOLUTION = ChangelistConflictResolution.IGNORE;
    }

    public static class Conflict {
        boolean ignored;
    }
}

