/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.local;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class MoveChanges
implements ChangeListCommand {
    private final String myName;
    private final Change[] myChanges;
    private MultiMap<LocalChangeList, Change> myMovedFrom;
    private LocalChangeList myListCopy;

    public MoveChanges(String name2, Change[] changes) {
        this.myName = name2;
        this.myChanges = changes;
    }

    @Override
    public void apply(ChangeListWorker worker) {
        this.myMovedFrom = worker.moveChangesTo(this.myName, this.myChanges);
        this.myListCopy = worker.getChangeListCopyByName(this.myName);
    }

    @Override
    public void doNotify(EventDispatcher<ChangeListListener> dispatcher) {
        if (this.myMovedFrom != null && this.myListCopy != null) {
            for (LocalChangeList fromList : this.myMovedFrom.keySet()) {
                Collection changesInList = this.myMovedFrom.get((Object)fromList);
                ((ChangeListListener)dispatcher.getMulticaster()).changesMoved(changesInList, (ChangeList)fromList, (ChangeList)this.myListCopy);
            }
        }
    }

    @Nullable
    public MultiMap<LocalChangeList, Change> getMovedFrom() {
        return this.myMovedFrom;
    }
}

