/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchFileHeaderInfo;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.PatchVirtualFileReader;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeGoToChangePopupAction;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.patch.MatchPatchPaths;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooserPanel;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeImpl;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UI;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.log.VcsUser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchDifferentiatedDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(ApplyPatchDifferentiatedDialog.class);
    private final ZipperUpdater myLoadQueue;
    private final TextFieldWithBrowseButton myPatchFile;
    private final List<AbstractFilePatchInProgress> myPatches;
    private final List<ShelvedBinaryFilePatch> myBinaryShelvedPatches;
    @NotNull
    private EditorNotificationPanel myErrorNotificationPanel;
    @NotNull
    private final MyChangeTreeList myChangesTreeList;
    @Nullable
    private final Collection<Change> myPreselectedChanges;
    private final boolean myUseProjectRootAsPredefinedBase;
    private JComponent myCenterPanel;
    protected final Project myProject;
    private final AtomicReference<FilePresentationModel> myRecentPathFileChange;
    private final MyUpdater myUpdater;
    private final Runnable myReset;
    private final ChangeListChooserPanel myChangeListChooser;
    private final ChangesLegendCalculator myInfoCalculator;
    private final CommitLegendPanel myCommitLegendPanel;
    private final ApplyPatchExecutor myCallback;
    private final List<ApplyPatchExecutor> myExecutors;
    private boolean myContainBasedChanges;
    private JLabel myPatchFileLabel;
    private PatchReader myReader;
    private VirtualFileListener myListener;
    private final boolean myCanChangePatchFile;
    private String myHelpId;
    private final boolean myShouldUpdateChangeListName;

    public ApplyPatchDifferentiatedDialog(Project project2, ApplyPatchExecutor callback, List<ApplyPatchExecutor> executors, @NotNull ApplyPatchMode applyPatchMode, @NotNull VirtualFile patchFile) {
        if (applyPatchMode == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(0);
        }
        if (patchFile == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(1);
        }
        this(project2, callback, executors, applyPatchMode, patchFile, null, null, null, null, null, false);
    }

    public ApplyPatchDifferentiatedDialog(Project project2, ApplyPatchExecutor callback, List<ApplyPatchExecutor> executors, @NotNull ApplyPatchMode applyPatchMode, @NotNull List<TextFilePatch> patches, @Nullable LocalChangeList defaultList) {
        if (applyPatchMode == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(2);
        }
        if (patches == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(3);
        }
        this(project2, callback, executors, applyPatchMode, null, patches, defaultList, null, null, null, false);
    }

    public ApplyPatchDifferentiatedDialog(Project project2, ApplyPatchExecutor callback, List<ApplyPatchExecutor> executors, @NotNull ApplyPatchMode applyPatchMode, @Nullable VirtualFile patchFile, @Nullable List<TextFilePatch> patches, @Nullable LocalChangeList defaultList, @Nullable List<ShelvedBinaryFilePatch> binaryShelvedPatches, @Nullable Collection<Change> preselectedChanges, @Nullable String externalCommitMessage, boolean useProjectRootAsPredefinedBase) {
        if (applyPatchMode == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(4);
        }
        super(project2, true);
        this.myHelpId = "reference.dialogs.vcs.patch.apply";
        this.myCallback = callback;
        this.myExecutors = executors;
        this.myUseProjectRootAsPredefinedBase = useProjectRootAsPredefinedBase;
        this.setModal(false);
        this.setHorizontalStretch(2.0f);
        this.setVerticalStretch(2.0f);
        this.setTitle(applyPatchMode.getTitle());
        FileChooserDescriptor descriptor2 = ApplyPatchDifferentiatedDialog.createSelectPatchDescriptor();
        descriptor2.setTitle(VcsBundle.message((String)"patch.apply.select.title", (Object[])new Object[0]));
        this.myProject = project2;
        this.myPatches = new LinkedList<AbstractFilePatchInProgress>();
        this.myRecentPathFileChange = new AtomicReference();
        this.myBinaryShelvedPatches = binaryShelvedPatches;
        this.myPreselectedChanges = preselectedChanges;
        this.myErrorNotificationPanel = new EditorNotificationPanel(LightColors.RED);
        this.cleanNotifications();
        this.myChangesTreeList = new MyChangeTreeList(project2, new Runnable(){

            @Override
            public void run() {
                NamedLegendStatuses includedNameStatuses = new NamedLegendStatuses();
                Collection includedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getIncludedChanges();
                HashSet<Couple> set2 = new HashSet<Couple>();
                for (AbstractFilePatchInProgress.PatchChange change : includedChanges) {
                    Object patch = change.getPatchInProgress().getPatch();
                    Couple pair2 = Couple.of((Object)patch.getBeforeName(), (Object)patch.getAfterName());
                    if (set2.contains(pair2)) continue;
                    set2.add(pair2);
                    ApplyPatchDifferentiatedDialog.acceptChange(includedNameStatuses, change);
                }
                ApplyPatchDifferentiatedDialog.this.myInfoCalculator.setIncluded(includedNameStatuses);
                ApplyPatchDifferentiatedDialog.this.myCommitLegendPanel.update();
                ApplyPatchDifferentiatedDialog.this.updateOkActions();
            }
        }, new MyChangeNodeDecorator());
        this.myChangesTreeList.setDoubleClickHandler(() -> {
            List selectedChanges = this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() == 1 && !((AbstractFilePatchInProgress.PatchChange)((Object)((Object)selectedChanges.get(0)))).isValid()) {
                this.myChangesTreeList.handleInvalidChangesAndToggle();
            }
            new MyShowDiff().showDiff();
        });
        this.myShouldUpdateChangeListName = defaultList == null && externalCommitMessage == null;
        this.myUpdater = new MyUpdater();
        this.myPatchFile = new TextFieldWithBrowseButton();
        this.myPatchFile.addBrowseFolderListener(VcsBundle.message((String)"patch.apply.select.title", (Object[])new Object[0]), "", project2, descriptor2);
        this.myPatchFile.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ApplyPatchDifferentiatedDialog.this.setPathFileChangeDefault();
                ApplyPatchDifferentiatedDialog.this.queueRequest();
            }
        });
        this.myLoadQueue = new ZipperUpdater(500, Alarm.ThreadToUse.POOLED_THREAD, this.getDisposable());
        this.myCanChangePatchFile = applyPatchMode.isCanChangePatchFile();
        this.myReset = this.myCanChangePatchFile ? this::reset : EmptyRunnable.getInstance();
        this.myChangeListChooser = new ChangeListChooserPanel(project2, new NullableConsumer<String>(){

            public void consume(@Nullable String errorMessage) {
                ApplyPatchDifferentiatedDialog.this.setOKActionEnabled(errorMessage == null && ApplyPatchDifferentiatedDialog.this.isChangeTreeEnabled());
                ApplyPatchDifferentiatedDialog.this.setErrorText(errorMessage, ApplyPatchDifferentiatedDialog.this.myChangeListChooser);
            }
        });
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        this.myChangeListChooser.setChangeLists(changeListManager.getChangeListsCopy());
        if (defaultList != null) {
            this.myChangeListChooser.setDefaultSelection((ChangeList)defaultList);
        } else if (externalCommitMessage != null) {
            this.myChangeListChooser.setSuggestedName(externalCommitMessage);
        }
        this.myChangeListChooser.init();
        this.myInfoCalculator = new ChangesLegendCalculator();
        this.myCommitLegendPanel = new CommitLegendPanel(this.myInfoCalculator){

            @Override
            public void update() {
                super.update();
                int inapplicable = ApplyPatchDifferentiatedDialog.this.myInfoCalculator.getInapplicable();
                if (inapplicable > 0) {
                    this.appendSpace();
                    this.appendText(inapplicable, inapplicable, FileStatus.MERGED_WITH_CONFLICTS, "Missing Base:");
                }
            }
        };
        this.init();
        if (patchFile != null && patchFile.isValid()) {
            patchFile.refresh(false, false);
            this.init(patchFile);
        } else if (patches != null) {
            this.init(patches);
        }
        this.myPatchFileLabel.setVisible(this.myCanChangePatchFile);
        this.myPatchFile.setVisible(this.myCanChangePatchFile);
        if (this.myCanChangePatchFile) {
            this.myListener = new VirtualFileListener(){

                public void contentsChanged(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    ApplyPatchDifferentiatedDialog.this.syncUpdatePatchFileAndScheduleReloadIfNeeded(event.getFile());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$5", "contentsChanged"));
                }
            };
            VirtualFileManager fileManager = VirtualFileManager.getInstance();
            fileManager.addVirtualFileListener(this.myListener);
            Disposer.register((Disposable)this.getDisposable(), () -> fileManager.removeVirtualFileListener(this.myListener));
        }
        this.updateOkActions();
    }

    private void updateOkActions() {
        boolean changeTreeEnabled = this.isChangeTreeEnabled();
        this.setOKActionEnabled(changeTreeEnabled);
        if (changeTreeEnabled) {
            this.myChangeListChooser.updateEnabled();
        }
    }

    private boolean isChangeTreeEnabled() {
        return !this.myChangesTreeList.getIncludedChanges().isEmpty();
    }

    private void queueRequest() {
        this.paintBusy(true);
        this.myLoadQueue.queue(this.myUpdater);
    }

    private void init(List<? extends FilePatch> patches) {
        List<AbstractFilePatchInProgress> matchedPatches = new MatchPatchPaths(this.myProject).execute(patches, this.myUseProjectRootAsPredefinedBase);
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myPatches.clear();
            this.myPatches.addAll(matchedPatches);
            this.updateTree(true);
        });
    }

    public static FileChooserDescriptor createSelectPatchDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file2) {
                return file2.getFileType() == StdFileTypes.PATCH || file2.getFileType() == FileTypes.PLAIN_TEXT;
            }
        };
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myExecutors.isEmpty()) {
            Action[] actionArray = super.createActions();
            if (actionArray == null) {
                ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(5);
            }
            return actionArray;
        }
        ArrayList<Action> actions = new ArrayList<Action>(4);
        actions.add(this.getOKAction());
        int i = 0;
        while (i < this.myExecutors.size()) {
            final ApplyPatchExecutor executor = this.myExecutors.get(i);
            final int finalI = i++;
            actions.add(new AbstractAction(executor.getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplyPatchDifferentiatedDialog.this.runExecutor(executor);
                    ApplyPatchDifferentiatedDialog.this.close(2 + finalI);
                }
            });
        }
        actions.add(this.getCancelAction());
        actions.add(this.getHelpAction());
        Action[] actionArray = actions.toArray(new Action[actions.size()]);
        if (actionArray == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(6);
        }
        return actionArray;
    }

    private void runExecutor(ApplyPatchExecutor executor) {
        Collection<AbstractFilePatchInProgress> included = this.getIncluded();
        if (included.isEmpty()) {
            return;
        }
        MultiMap patchGroups = new MultiMap();
        for (AbstractFilePatchInProgress patchInProgress : included) {
            patchGroups.putValue((Object)patchInProgress.getBase(), (Object)patchInProgress);
        }
        LocalChangeList selected = this.getSelectedChangeList();
        FilePresentationModel presentation = this.myRecentPathFileChange.get();
        VirtualFile vf = presentation != null ? presentation.getVf() : null;
        executor.apply(this.getOriginalRemaining(), patchGroups, selected, vf == null ? null : vf.getName(), this.myReader == null ? null : this.myReader.getAdditionalInfo(ApplyPatchDefaultExecutor.pathsFromGroups((MultiMap<VirtualFile, AbstractFilePatchInProgress>)patchGroups)));
    }

    @NotNull
    private List<FilePatch> getOriginalRemaining() {
        Collection notIncluded = ContainerUtil.subtract(this.myPatches, this.getIncluded());
        ArrayList remainingOriginal = ContainerUtil.newArrayList();
        for (AbstractFilePatchInProgress progress : notIncluded) {
            progress.reset();
            remainingOriginal.add(progress.getPatch());
        }
        ArrayList arrayList = remainingOriginal;
        if (arrayList == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "vcs.ApplyPatchDifferentiatedDialog";
    }

    protected String getHelpId() {
        return this.myHelpId;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myChangeListChooser.getPreferredFocusedComponent();
    }

    private void setPathFileChangeDefault() {
        this.myRecentPathFileChange.set(new FilePresentationModel(this.myPatchFile.getText()));
    }

    private void init(@NotNull VirtualFile patchFile) {
        if (patchFile == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(8);
        }
        this.myPatchFile.setText(patchFile.getPresentableUrl());
        this.myRecentPathFileChange.set(new FilePresentationModel(patchFile));
    }

    public void setHelpId(String s) {
        this.myHelpId = s;
    }

    @Nullable
    private String getSubjectFromMessage(@Nullable String message2) {
        return StringUtil.isEmptyOrSpaces((String)message2) ? null : ChangeListUtil.createNameForChangeList(this.myProject, message2);
    }

    @Nullable
    private PatchReader loadPatches(final @NotNull VirtualFile patchFile) {
        PatchReader reader;
        if (patchFile == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(9);
        }
        try {
            reader = (PatchReader)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<PatchReader, IOException>(){

                public PatchReader compute() throws IOException {
                    return PatchVirtualFileReader.create(patchFile);
                }
            });
        }
        catch (IOException e) {
            this.addNotificationAndWarn("Can't read patchFile " + patchFile.getPresentableName() + ": " + e.getMessage());
            return null;
        }
        try {
            reader.parseAllPatches();
        }
        catch (PatchSyntaxException e) {
            this.addNotificationAndWarn("Can't read patch: " + e.getMessage());
            return null;
        }
        return reader;
    }

    private void addNotificationAndWarn(@NotNull String errorMessage) {
        if (errorMessage == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(10);
        }
        LOG.warn(errorMessage);
        this.myErrorNotificationPanel.setText(errorMessage);
        this.myErrorNotificationPanel.setVisible(true);
    }

    private void cleanNotifications() {
        this.myErrorNotificationPanel.setText("");
        this.myErrorNotificationPanel.setVisible(false);
    }

    private void syncUpdatePatchFileAndScheduleReloadIfNeeded(@Nullable VirtualFile eventFile) {
        VirtualFile filePresentationVf;
        FilePresentationModel filePresentationModel = this.myRecentPathFileChange.get();
        VirtualFile virtualFile = filePresentationVf = filePresentationModel != null ? filePresentationModel.getVf() : null;
        if (filePresentationVf != null && (eventFile == null || filePresentationVf.equals(eventFile))) {
            filePresentationVf.refresh(false, false);
            this.queueRequest();
        }
    }

    private void reset() {
        this.myPatches.clear();
        this.myChangesTreeList.setChangesToDisplay(Collections.emptyList());
        this.myChangesTreeList.repaint();
        this.myContainBasedChanges = false;
        this.paintBusy(false);
    }

    protected JComponent createCenterPanel() {
        if (this.myCenterPanel == null) {
            this.myCenterPanel = new JPanel(new GridBagLayout());
            GridBagConstraints centralGb = ApplyPatchDifferentiatedDialog.createConstraints();
            this.myPatchFileLabel = new JLabel(VcsBundle.message((String)"patch.apply.file.name.field", (Object[])new Object[0]));
            this.myPatchFileLabel.setLabelFor((Component)this.myPatchFile);
            this.myCenterPanel.add((Component)this.myPatchFileLabel, centralGb);
            centralGb.fill = 2;
            ++centralGb.gridy;
            this.myCenterPanel.add((Component)this.myPatchFile, centralGb);
            JPanel treePanel = new JPanel(new GridBagLayout());
            GridBagConstraints gb = ApplyPatchDifferentiatedDialog.createConstraints();
            DefaultActionGroup group = new DefaultActionGroup();
            AnAction[] treeActions = this.myChangesTreeList.getTreeActions();
            group.addAll(treeActions);
            group.add((AnAction)new MapDirectory());
            MyShowDiff diffAction = new MyShowDiff();
            diffAction.registerCustomShortcutSet(CommonShortcuts.getDiff(), this.getRootPane());
            group.add((AnAction)diffAction);
            group.add((AnAction)new StripUp());
            group.add((AnAction)new StripDown());
            group.add((AnAction)new ResetStrip());
            group.add((AnAction)new ZeroStrip());
            if (this.myCanChangePatchFile) {
                group.add(new AnAction("Refresh", "Refresh", AllIcons.Actions.Refresh){

                    public void actionPerformed(AnActionEvent e) {
                        ApplyPatchDifferentiatedDialog.this.syncUpdatePatchFileAndScheduleReloadIfNeeded(null);
                    }
                });
            }
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("APPLY_PATCH", (ActionGroup)group, true);
            gb.fill = 2;
            treePanel.add((Component)toolbar.getComponent(), gb);
            ++gb.gridy;
            gb.weighty = 1.0;
            gb.fill = 1;
            BorderLayoutPanel changeTreePanel = JBUI.Panels.simplePanel((Component)((Object)this.myChangesTreeList)).addToTop((Component)this.myErrorNotificationPanel);
            treePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)changeTreePanel), gb);
            ++gb.gridy;
            gb.weighty = 0.0;
            gb.fill = 0;
            gb.insets.bottom = 4;
            treePanel.add((Component)this.myCommitLegendPanel.getComponent(), gb);
            ++gb.gridy;
            Splitter splitter = new Splitter(true, 0.7f);
            splitter.setFirstComponent((JComponent)treePanel);
            splitter.setSecondComponent((JComponent)this.myChangeListChooser);
            ++centralGb.gridy;
            centralGb.weighty = 1.0;
            centralGb.fill = 1;
            this.myCenterPanel.add((Component)splitter, centralGb);
        }
        return this.myCenterPanel;
    }

    @NotNull
    private static GridBagConstraints createConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)1), 0, 0);
        if (gridBagConstraints == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(11);
        }
        return gridBagConstraints;
    }

    private void paintBusy(boolean requestPut) {
        if (requestPut) {
            this.myChangesTreeList.setPaintBusy(true);
        } else {
            this.myChangesTreeList.setPaintBusy(!this.myLoadQueue.isEmpty());
        }
    }

    private static boolean sameBase(List<AbstractFilePatchInProgress.PatchChange> selectedChanges) {
        VirtualFile base = null;
        for (AbstractFilePatchInProgress.PatchChange change : selectedChanges) {
            VirtualFile changeBase = change.getPatchInProgress().getBase();
            if (base == null) {
                base = changeBase;
                continue;
            }
            if (base.equals(changeBase)) continue;
            return false;
        }
        return true;
    }

    private void updateTree(boolean doInitCheck) {
        List<AbstractFilePatchInProgress> patchesToSelect = ApplyPatchDifferentiatedDialog.changes2patches(this.myChangesTreeList.getSelectedChanges());
        List<AbstractFilePatchInProgress.PatchChange> changes = this.getAllChanges();
        Collection<AbstractFilePatchInProgress.PatchChange> included = this.getIncluded(doInitCheck, changes);
        this.myChangesTreeList.setIncludedChanges(included);
        this.myChangesTreeList.setChangesToDisplay(changes);
        if (doInitCheck) {
            this.myChangesTreeList.expandAll();
        }
        this.myChangesTreeList.repaint();
        if (!doInitCheck) {
            ArrayList<AbstractFilePatchInProgress.PatchChange> toSelect2 = new ArrayList<AbstractFilePatchInProgress.PatchChange>(patchesToSelect.size());
            for (AbstractFilePatchInProgress.PatchChange change : changes) {
                if (!patchesToSelect.contains(change.getPatchInProgress())) continue;
                toSelect2.add(change);
            }
            this.myChangesTreeList.setSelectedChanges(toSelect2);
        }
        this.myContainBasedChanges = false;
        for (AbstractFilePatchInProgress patch : this.myPatches) {
            if (!patch.baseExistsOrAdded()) continue;
            this.myContainBasedChanges = true;
            break;
        }
    }

    private List<AbstractFilePatchInProgress.PatchChange> getAllChanges() {
        return ContainerUtil.map(this.myPatches, AbstractFilePatchInProgress::getChange);
    }

    private static void acceptChange(NamedLegendStatuses nameStatuses, AbstractFilePatchInProgress.PatchChange change) {
        AbstractFilePatchInProgress patchInProgress = change.getPatchInProgress();
        if (FilePatchStatus.ADDED.equals((Object)patchInProgress.getStatus())) {
            nameStatuses.plusAdded();
        } else if (FilePatchStatus.DELETED.equals((Object)patchInProgress.getStatus())) {
            nameStatuses.plusDeleted();
        } else {
            nameStatuses.plusModified();
        }
        if (!patchInProgress.baseExistsOrAdded()) {
            nameStatuses.plusInapplicable();
        }
    }

    private Collection<AbstractFilePatchInProgress.PatchChange> getIncluded(boolean doInitCheck, List<AbstractFilePatchInProgress.PatchChange> changes) {
        NamedLegendStatuses totalNameStatuses = new NamedLegendStatuses();
        NamedLegendStatuses includedNameStatuses = new NamedLegendStatuses();
        LinkedList<AbstractFilePatchInProgress.PatchChange> included = new LinkedList<AbstractFilePatchInProgress.PatchChange>();
        if (doInitCheck) {
            for (AbstractFilePatchInProgress.PatchChange change : changes) {
                ApplyPatchDifferentiatedDialog.acceptChange(totalNameStatuses, change);
                AbstractFilePatchInProgress abstractFilePatchInProgress = change.getPatchInProgress();
                if (!abstractFilePatchInProgress.baseExistsOrAdded() || this.myPreselectedChanges != null && !this.myPreselectedChanges.contains((Object)change)) continue;
                ApplyPatchDifferentiatedDialog.acceptChange(includedNameStatuses, change);
                included.add(change);
            }
        } else {
            AbstractFilePatchInProgress patch;
            Collection includedNow = this.myChangesTreeList.getIncludedChanges();
            HashSet<AbstractFilePatchInProgress> toBeIncluded = new HashSet<AbstractFilePatchInProgress>();
            for (AbstractFilePatchInProgress.PatchChange change : includedNow) {
                patch = change.getPatchInProgress();
                toBeIncluded.add(patch);
            }
            for (AbstractFilePatchInProgress.PatchChange change : changes) {
                patch = change.getPatchInProgress();
                ApplyPatchDifferentiatedDialog.acceptChange(totalNameStatuses, change);
                if (!toBeIncluded.contains(patch) || !patch.baseExistsOrAdded()) continue;
                ApplyPatchDifferentiatedDialog.acceptChange(includedNameStatuses, change);
                included.add(change);
            }
        }
        this.myInfoCalculator.setTotal(totalNameStatuses);
        this.myInfoCalculator.setIncluded(includedNameStatuses);
        this.myCommitLegendPanel.update();
        return included;
    }

    private static List<AbstractFilePatchInProgress> changes2patches(List<AbstractFilePatchInProgress.PatchChange> selectedChanges) {
        return ContainerUtil.map(selectedChanges, AbstractFilePatchInProgress.PatchChange::getPatchInProgress);
    }

    private boolean basePathWasChanged(@NotNull AbstractFilePatchInProgress patchInProgress) {
        if (patchInProgress == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(12);
        }
        return !FileUtil.filesEqual((File)patchInProgress.myIoCurrentBase, (File)new File(this.myProject.getBasePath(), patchInProgress.getOriginalBeforePath()));
    }

    private Collection<AbstractFilePatchInProgress> getIncluded() {
        return ContainerUtil.map(this.myChangesTreeList.getIncludedChanges(), AbstractFilePatchInProgress.PatchChange::getPatchInProgress);
    }

    @Nullable
    private LocalChangeList getSelectedChangeList() {
        return this.myChangeListChooser.getSelectedList(this.myProject);
    }

    protected void doOKAction() {
        super.doOKAction();
        this.runExecutor(this.myCallback);
    }

    @NotNull
    private static DiffRequestProducer createBaseNotFoundErrorRequest(final @NotNull AbstractFilePatchInProgress patchInProgress) {
        if (patchInProgress == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(13);
        }
        final String beforePath = patchInProgress.getPatch().getBeforeName();
        final String afterPath = patchInProgress.getPatch().getAfterName();
        DiffRequestProducer diffRequestProducer = new DiffRequestProducer(){

            @NotNull
            public String getName() {
                File ioCurrentBase = patchInProgress.getIoCurrentBase();
                String string = ioCurrentBase == null ? patchInProgress.getCurrentPath() : ioCurrentBase.getPath();
                if (string == null) {
                    10.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                if (context == null) {
                    10.$$$reportNull$$$0(1);
                }
                if (indicator == null) {
                    10.$$$reportNull$$$0(2);
                }
                throw new DiffRequestProducerException("Cannot find base for '" + (beforePath != null ? beforePath : afterPath) + "'");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$10";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$10";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "process";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (diffRequestProducer == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(14);
        }
        return diffRequestProducer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyPatchMode";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchInProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalRemaining";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstraints";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createBaseNotFoundErrorRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadPatches";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addNotificationAndWarn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "basePathWasChanged";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createBaseNotFoundErrorRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyChangeComparator
    implements Comparator<AbstractFilePatchInProgress.PatchChange> {
        private MyChangeComparator() {
        }

        @Override
        public int compare(AbstractFilePatchInProgress.PatchChange o1, AbstractFilePatchInProgress.PatchChange o2) {
            if (PropertiesComponent.getInstance((Project)ApplyPatchDifferentiatedDialog.this.myProject).isTrueValue("ChangesBrowser.SHOW_FLATTEN")) {
                return o1.getPatchInProgress().getIoCurrentBase().getName().compareTo(o2.getPatchInProgress().getIoCurrentBase().getName());
            }
            return FileUtil.compareFiles((File)o1.getPatchInProgress().getIoCurrentBase(), (File)o2.getPatchInProgress().getIoCurrentBase());
        }
    }

    private static class MyDiffRequestChain
    extends UserDataHolderBase
    implements DiffRequestChain,
    GoToChangePopupBuilder.Chain {
        private final List<DiffRequestProducer> myRequests;
        private final List<? extends Change> myChanges;
        private int myIndex;

        public MyDiffRequestChain(@NotNull List<DiffRequestProducer> requests, @NotNull List<? extends Change> changes, int index) {
            if (requests == null) {
                MyDiffRequestChain.$$$reportNull$$$0(0);
            }
            if (changes == null) {
                MyDiffRequestChain.$$$reportNull$$$0(1);
            }
            assert (requests.size() == changes.size());
            this.myRequests = requests;
            this.myChanges = changes;
            this.myIndex = index >= 0 ? index : 0;
        }

        @NotNull
        public List<? extends DiffRequestProducer> getRequests() {
            List<DiffRequestProducer> list2 = this.myRequests;
            if (list2 == null) {
                MyDiffRequestChain.$$$reportNull$$$0(2);
            }
            return list2;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public void setIndex(int index) {
            assert (index >= 0 && index < this.myRequests.size());
            this.myIndex = index;
        }

        @Override
        @NotNull
        public AnAction createGoToChangeAction(final @NotNull Consumer<Integer> onSelected) {
            if (onSelected == null) {
                MyDiffRequestChain.$$$reportNull$$$0(3);
            }
            ChangeGoToChangePopupAction<MyDiffRequestChain> changeGoToChangePopupAction = new ChangeGoToChangePopupAction<MyDiffRequestChain>(this, (Object)this.myIndex){

                @Override
                @NotNull
                protected DefaultTreeModel buildTreeModel(@NotNull Project project2, boolean showFlatten) {
                    if (project2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ArrayList<TreeModelBuilder.GenericNodeData> nodesData = new ArrayList<TreeModelBuilder.GenericNodeData>();
                    for (int i = 0; i < myChanges.size(); ++i) {
                        Change change = (Change)myChanges.get(i);
                        FilePath filePath = ChangesUtil.getFilePath((Change)change);
                        FileStatus fileStatus = change.getFileStatus();
                        nodesData.add(new TreeModelBuilder.GenericNodeData(filePath, fileStatus, i));
                    }
                    TreeModelBuilder builder = new TreeModelBuilder(project2, showFlatten);
                    builder.setGenericNodes(nodesData, null);
                    DefaultTreeModel defaultTreeModel = builder.build();
                    if (defaultTreeModel == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return defaultTreeModel;
                }

                @Override
                protected void onSelected(@Nullable Object object) {
                    onSelected.consume((Object)((Integer)object));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyDiffRequestChain$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyDiffRequestChain$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "buildTreeModel";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "buildTreeModel";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            if (changeGoToChangePopupAction == null) {
                MyDiffRequestChain.$$$reportNull$$$0(4);
            }
            return changeGoToChangePopupAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requests";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyDiffRequestChain";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onSelected";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyDiffRequestChain";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequests";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGoToChangeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createGoToChangeAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyShowDiff
    extends AnAction {
        private final MyChangeComparator myMyChangeComparator;

        private MyShowDiff() {
            super("Show Diff", "Show Diff", AllIcons.Actions.Diff);
            this.myMyChangeComparator = new MyChangeComparator();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(!ApplyPatchDifferentiatedDialog.this.myPatches.isEmpty() && ApplyPatchDifferentiatedDialog.this.myContainBasedChanges);
        }

        public void actionPerformed(AnActionEvent e) {
            this.showDiff();
        }

        private void showDiff() {
            if (ChangeListManager.getInstance((Project)ApplyPatchDifferentiatedDialog.this.myProject).isFreezedWithNotification(null)) {
                return;
            }
            if (ApplyPatchDifferentiatedDialog.this.myPatches.isEmpty() || !ApplyPatchDifferentiatedDialog.this.myContainBasedChanges) {
                return;
            }
            List changes = ApplyPatchDifferentiatedDialog.this.getAllChanges();
            Collections.sort(changes, this.myMyChangeComparator);
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (changes.isEmpty()) {
                return;
            }
            AbstractFilePatchInProgress.PatchChange selectedChange = !selectedChanges.isEmpty() ? (AbstractFilePatchInProgress.PatchChange)((Object)selectedChanges.get(0)) : (AbstractFilePatchInProgress.PatchChange)((Object)changes.get(0));
            int selectedIdx = 0;
            ArrayList<DiffRequestProducer> diffRequestPresentableList = new ArrayList<DiffRequestProducer>(changes.size());
            for (AbstractFilePatchInProgress.PatchChange change : changes) {
                AbstractFilePatchInProgress patchInProgress = change.getPatchInProgress();
                if (!patchInProgress.baseExistsOrAdded()) {
                    diffRequestPresentableList.add(ApplyPatchDifferentiatedDialog.createBaseNotFoundErrorRequest(patchInProgress));
                } else {
                    diffRequestPresentableList.add(patchInProgress.getDiffRequestProducers(ApplyPatchDifferentiatedDialog.this.myProject, ApplyPatchDifferentiatedDialog.this.myReader));
                }
                if (!change.equals((Object)selectedChange)) continue;
                selectedIdx = diffRequestPresentableList.size() - 1;
            }
            MyDiffRequestChain chain = new MyDiffRequestChain(diffRequestPresentableList, changes, selectedIdx);
            DiffManager.getInstance().showDiff(ApplyPatchDifferentiatedDialog.this.myProject, (DiffRequestChain)chain, DiffDialogHints.DEFAULT);
        }
    }

    private class ResetStrip
    extends AnAction {
        private ResetStrip() {
            super("Reset Directories", "Reset Directories", AllIcons.Vcs.ResetStrip);
        }

        public void actionPerformed(AnActionEvent e) {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            for (AbstractFilePatchInProgress.PatchChange change : selectedChanges) {
                change.getPatchInProgress().reset();
            }
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }
    }

    private class StripUp
    extends AnAction {
        private StripUp() {
            super("Strip Directory", "Strip Directory", AllIcons.Vcs.StripUp);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.isEnabled());
        }

        public void actionPerformed(AnActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            for (AbstractFilePatchInProgress.PatchChange change : selectedChanges) {
                change.getPatchInProgress().up();
            }
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }

        private boolean isEnabled() {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.isEmpty()) {
                return false;
            }
            for (AbstractFilePatchInProgress.PatchChange change : selectedChanges) {
                if (change.getPatchInProgress().canUp()) continue;
                return false;
            }
            return true;
        }
    }

    private class StripDown
    extends AnAction {
        private StripDown() {
            super("Restore Directory", "Restore Directory", AllIcons.Vcs.StripDown);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.isEnabled());
        }

        public void actionPerformed(AnActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            for (AbstractFilePatchInProgress.PatchChange change : selectedChanges) {
                change.getPatchInProgress().down();
            }
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }

        private boolean isEnabled() {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.isEmpty()) {
                return false;
            }
            for (AbstractFilePatchInProgress.PatchChange change : selectedChanges) {
                if (change.getPatchInProgress().canDown()) continue;
                return false;
            }
            return true;
        }
    }

    private class ZeroStrip
    extends AnAction {
        private ZeroStrip() {
            super("Remove Directories", "Remove Directories", AllIcons.Vcs.StripNull);
        }

        public void actionPerformed(AnActionEvent e) {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            for (AbstractFilePatchInProgress.PatchChange change : selectedChanges) {
                change.getPatchInProgress().setZero();
            }
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }
    }

    private class MyChangeNodeDecorator
    implements ChangeNodeDecorator {
        private MyChangeNodeDecorator() {
        }

        @Override
        public void decorate(Change change, SimpleColoredComponent component, boolean isShowFlatten) {
            if (change instanceof AbstractFilePatchInProgress.PatchChange) {
                AbstractFilePatchInProgress.PatchChange patchChange = (AbstractFilePatchInProgress.PatchChange)change;
                AbstractFilePatchInProgress patchInProgress = patchChange.getPatchInProgress();
                if (patchInProgress.getCurrentStrip() > 0) {
                    component.append(" stripped " + patchInProgress.getCurrentStrip(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                }
                String text2 = FilePatchStatus.ADDED.equals((Object)patchInProgress.getStatus()) ? "Added" : (FilePatchStatus.DELETED.equals((Object)patchInProgress.getStatus()) ? "Deleted" : "Modified");
                component.append("   ");
                component.append(text2, SimpleTextAttributes.GRAY_ATTRIBUTES);
                if (!patchInProgress.baseExistsOrAdded()) {
                    component.append("  ");
                    component.append("Select missing base", new SimpleTextAttributes(0, UI.getColor((String)"link.foreground")), () -> MyChangeNodeDecorator.lambda$decorate$0(ApplyPatchDifferentiatedDialog.this.myChangesTreeList));
                } else if (!patchInProgress.getStatus().equals((Object)FilePatchStatus.ADDED) && ApplyPatchDifferentiatedDialog.this.basePathWasChanged(patchInProgress)) {
                    component.append("  ");
                    component.append("New base detected", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                    component.setToolTipText(String.format("was: %s (base dir: %s)", patchInProgress.getOriginalBeforePath(), ApplyPatchDifferentiatedDialog.this.myProject.getBasePath()) + "<br/>" + String.format("now: %s (base dir: %s)", patchInProgress.getPatch().getBeforeName(), patchInProgress.getBase().getPath()));
                }
            }
        }

        @Override
        public void preDecorate(Change change, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
        }

        private static /* synthetic */ void lambda$decorate$0(MyChangeTreeList rec$) {
            rec$.handleInvalidChangesAndToggle();
        }
    }

    private static class ChangesLegendCalculator
    implements CommitLegendPanel.InfoCalculator {
        private NamedLegendStatuses myTotal = new NamedLegendStatuses();
        private NamedLegendStatuses myIncluded = new NamedLegendStatuses();

        private ChangesLegendCalculator() {
        }

        public void setTotal(NamedLegendStatuses nameStatuses) {
            this.myTotal = nameStatuses;
        }

        public void setIncluded(NamedLegendStatuses nameStatuses) {
            this.myIncluded = nameStatuses;
        }

        @Override
        public int getNew() {
            return this.myTotal.getAdded();
        }

        @Override
        public int getModified() {
            return this.myTotal.getModified();
        }

        @Override
        public int getDeleted() {
            return this.myTotal.getDeleted();
        }

        @Override
        public int getUnversioned() {
            return 0;
        }

        public int getInapplicable() {
            return this.myTotal.getInapplicable();
        }

        @Override
        public int getIncludedNew() {
            return this.myIncluded.getAdded();
        }

        @Override
        public int getIncludedModified() {
            return this.myIncluded.getModified();
        }

        @Override
        public int getIncludedDeleted() {
            return this.myIncluded.getDeleted();
        }

        @Override
        public int getIncludedUnversioned() {
            return 0;
        }
    }

    private static class NamedLegendStatuses {
        private int myAdded = 0;
        private int myModified = 0;
        private int myDeleted = 0;
        private int myInapplicable = 0;

        public void plusAdded() {
            ++this.myAdded;
        }

        public void plusModified() {
            ++this.myModified;
        }

        public void plusDeleted() {
            ++this.myDeleted;
        }

        public void plusInapplicable() {
            ++this.myInapplicable;
        }

        public int getAdded() {
            return this.myAdded;
        }

        public int getModified() {
            return this.myModified;
        }

        public int getDeleted() {
            return this.myDeleted;
        }

        public int getInapplicable() {
            return this.myInapplicable;
        }
    }

    private class MapPopup
    extends BaseListPopupStep<VirtualFile> {
        private final Runnable myNewBaseSelector;

        private MapPopup(List<? extends VirtualFile> aValues, Runnable newBaseSelector) {
            if (aValues == null) {
                MapPopup.$$$reportNull$$$0(0);
            }
            super("Select base directory for a path", aValues);
            this.myNewBaseSelector = newBaseSelector;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
            if (selectedValue == null) {
                this.myNewBaseSelector.run();
                return null;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() >= 1) {
                for (AbstractFilePatchInProgress.PatchChange patchChange : selectedChanges) {
                    AbstractFilePatchInProgress patch = patchChange.getPatchInProgress();
                    patch.setNewBase(selectedValue);
                }
                ApplyPatchDifferentiatedDialog.this.updateTree(false);
            }
            return null;
        }

        @NotNull
        public String getTextFor(VirtualFile value2) {
            String string = value2 == null ? "Select base for a path" : value2.getPath();
            if (string == null) {
                MapPopup.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aValues";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MapPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MapPopup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class NewBaseSelector
    implements Runnable {
        final boolean myDirectorySelector;

        public NewBaseSelector() {
            this(true);
        }

        public NewBaseSelector(boolean directorySelector) {
            this.myDirectorySelector = directorySelector;
        }

        @Override
        public void run() {
            FileChooserDescriptor descriptor2 = this.myDirectorySelector ? FileChooserDescriptorFactory.createSingleFolderDescriptor() : FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
            descriptor2.setTitle(String.format("Select %s Base", this.myDirectorySelector ? "Directory" : "File"));
            VirtualFile selectedFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)ApplyPatchDifferentiatedDialog.this.myProject, null);
            if (selectedFile == null) {
                return;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() >= 1) {
                for (AbstractFilePatchInProgress.PatchChange patchChange : selectedChanges) {
                    AbstractFilePatchInProgress patch = patchChange.getPatchInProgress();
                    if (this.myDirectorySelector) {
                        patch.setNewBase(selectedFile);
                        continue;
                    }
                    Object filePatch = patch.getPatch();
                    filePatch.setAfterName(selectedFile.getName());
                    filePatch.setBeforeName(selectedFile.getName());
                    patch.setNewBase(selectedFile.getParent());
                }
                ApplyPatchDifferentiatedDialog.this.updateTree(false);
            }
        }
    }

    private class MapDirectory
    extends AnAction {
        private final NewBaseSelector myNewBaseSelector;

        private MapDirectory() {
            super("Map base directory", "Map base directory", AllIcons.Vcs.MapBase);
            this.myNewBaseSelector = new NewBaseSelector();
        }

        public void actionPerformed(AnActionEvent e) {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() >= 1 && ApplyPatchDifferentiatedDialog.sameBase(selectedChanges)) {
                AbstractFilePatchInProgress.PatchChange patchChange = (AbstractFilePatchInProgress.PatchChange)((Object)selectedChanges.get(0));
                AbstractFilePatchInProgress patch = patchChange.getPatchInProgress();
                List<VirtualFile> autoBases = patch.getAutoBasesCopy();
                if (autoBases.isEmpty() || autoBases.size() == 1 && autoBases.get(0).equals(patch.getBase())) {
                    this.myNewBaseSelector.run();
                } else {
                    autoBases.add(null);
                    MapPopup step = new MapPopup(autoBases, this.myNewBaseSelector);
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showCenteredInCurrentWindow(ApplyPatchDifferentiatedDialog.this.myProject);
                }
            }
        }

        public void update(AnActionEvent e) {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            e.getPresentation().setEnabled(selectedChanges.size() >= 1 && ApplyPatchDifferentiatedDialog.sameBase(selectedChanges));
        }
    }

    private class MyChangeTreeList
    extends ChangesTreeImpl<AbstractFilePatchInProgress.PatchChange> {
        @Nullable
        private final ChangeNodeDecorator myChangeNodeDecorator;

        private MyChangeTreeList(@Nullable Project project2, @Nullable Runnable inclusionListener, ChangeNodeDecorator decorator) {
            super(project2, true, false, AbstractFilePatchInProgress.PatchChange.class);
            this.setInclusionListener(inclusionListener);
            this.myChangeNodeDecorator = decorator;
        }

        @Override
        @NotNull
        protected DefaultTreeModel buildTreeModel(@NotNull List<AbstractFilePatchInProgress.PatchChange> changes) {
            if (changes == null) {
                MyChangeTreeList.$$$reportNull$$$0(0);
            }
            DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromChanges(this.myProject, this.isShowFlatten(), changes, this.myChangeNodeDecorator);
            if (defaultTreeModel == null) {
                MyChangeTreeList.$$$reportNull$$$0(1);
            }
            return defaultTreeModel;
        }

        @Override
        protected boolean isNodeEnabled(ChangesBrowserNode<?> node) {
            boolean enabled = super.isNodeEnabled(node);
            Object value2 = node.getUserObject();
            if (value2 instanceof AbstractFilePatchInProgress.PatchChange) {
                enabled &= ((AbstractFilePatchInProgress.PatchChange)((Object)value2)).isValid();
            }
            return enabled;
        }

        @NotNull
        private List<AbstractFilePatchInProgress.PatchChange> getOnlyValidChanges(@NotNull Collection<AbstractFilePatchInProgress.PatchChange> changes) {
            if (changes == null) {
                MyChangeTreeList.$$$reportNull$$$0(2);
            }
            List list2 = ContainerUtil.filter(changes, AbstractFilePatchInProgress.PatchChange::isValid);
            if (list2 == null) {
                MyChangeTreeList.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        protected void toggleChanges(Collection<?> changes) {
            List patchChanges = ContainerUtil.findAll(changes, AbstractFilePatchInProgress.PatchChange.class);
            if (patchChanges.size() == 1 && !((AbstractFilePatchInProgress.PatchChange)((Object)patchChanges.get(0))).isValid()) {
                this.handleInvalidChangesAndToggle();
            } else {
                super.toggleChanges(this.getOnlyValidChanges(patchChanges));
            }
        }

        private void handleInvalidChangesAndToggle() {
            new NewBaseSelector(false).run();
            super.toggleChanges(this.getOnlyValidChanges(this.getSelectedChanges()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyChangeTreeList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyChangeTreeList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildTreeModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOnlyValidChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "buildTreeModel";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getOnlyValidChanges";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FilePresentationModel {
        @NotNull
        private final String myPath;
        @Nullable
        private VirtualFile myVf;

        private FilePresentationModel(@NotNull String path) {
            if (path == null) {
                FilePresentationModel.$$$reportNull$$$0(0);
            }
            this.myPath = path;
            this.myVf = null;
        }

        public FilePresentationModel(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FilePresentationModel.$$$reportNull$$$0(1);
            }
            this.myPath = file2.getPath();
            this.myVf = file2;
        }

        @Nullable
        public VirtualFile getVf() {
            if (this.myVf == null) {
                VirtualFile file2 = VfsUtil.findFileByIoFile((File)new File(this.myPath), (boolean)true);
                this.myVf = file2 != null && !file2.isDirectory() ? file2 : null;
            }
            return this.myVf;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$FilePresentationModel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyUpdater
    implements Runnable {
        private MyUpdater() {
        }

        @Override
        public void run() {
            VcsUser author;
            VirtualFile file2;
            ApplyPatchDifferentiatedDialog.this.cleanNotifications();
            FilePresentationModel filePresentationModel = (FilePresentationModel)ApplyPatchDifferentiatedDialog.this.myRecentPathFileChange.get();
            VirtualFile virtualFile = file2 = filePresentationModel != null ? filePresentationModel.getVf() : null;
            if (file2 == null) {
                ApplicationManager.getApplication().invokeLater(ApplyPatchDifferentiatedDialog.this.myReset, ModalityState.stateForComponent((Component)ApplyPatchDifferentiatedDialog.this.myCenterPanel));
                return;
            }
            ApplyPatchDifferentiatedDialog.this.myReader = ApplyPatchDifferentiatedDialog.this.loadPatches(file2);
            PatchFileHeaderInfo patchFileInfo = ApplyPatchDifferentiatedDialog.this.myReader != null ? ApplyPatchDifferentiatedDialog.this.myReader.getPatchFileInfo() : null;
            String messageFromPatch = patchFileInfo != null ? patchFileInfo.getMessage() : null;
            VcsUser vcsUser = author = patchFileInfo != null ? patchFileInfo.getAuthor() : null;
            if (author != null) {
                ApplyPatchDifferentiatedDialog.this.myChangeListChooser.setData(new ChangeListData(author));
            }
            ArrayList filePatches = ContainerUtil.newArrayList();
            if (ApplyPatchDifferentiatedDialog.this.myReader != null) {
                filePatches.addAll(ApplyPatchDifferentiatedDialog.this.myReader.getAllPatches());
            }
            if (!ContainerUtil.isEmpty((Collection)ApplyPatchDifferentiatedDialog.this.myBinaryShelvedPatches)) {
                filePatches.addAll(ApplyPatchDifferentiatedDialog.this.myBinaryShelvedPatches);
            }
            List<AbstractFilePatchInProgress> matchedPatches = new MatchPatchPaths(ApplyPatchDifferentiatedDialog.this.myProject).execute(filePatches, ApplyPatchDifferentiatedDialog.this.myUseProjectRootAsPredefinedBase);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (ApplyPatchDifferentiatedDialog.this.myShouldUpdateChangeListName) {
                    ApplyPatchDifferentiatedDialog.this.myChangeListChooser.setSuggestedName((String)ObjectUtils.chooseNotNull((Object)ApplyPatchDifferentiatedDialog.this.getSubjectFromMessage(messageFromPatch), (Object)file2.getNameWithoutExtension().replace('_', ' ').trim()), messageFromPatch);
                }
                ApplyPatchDifferentiatedDialog.this.myPatches.clear();
                ApplyPatchDifferentiatedDialog.this.myPatches.addAll(matchedPatches);
                ApplyPatchDifferentiatedDialog.this.updateTree(true);
                ApplyPatchDifferentiatedDialog.this.paintBusy(false);
                ApplyPatchDifferentiatedDialog.this.updateOkActions();
            }, ModalityState.stateForComponent((Component)ApplyPatchDifferentiatedDialog.this.myCenterPanel));
        }
    }
}

