/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.dnd.DnDAware;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.VcsCurrentRevisionProxy;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeCopyProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesListView
extends Tree
implements TypeSafeDataProvider,
DnDAware {
    private final Project myProject;
    private boolean myShowFlatten;
    private final CopyProvider myCopyProvider;
    @NonNls
    public static final String HELP_ID = "ideaInterface.changes";
    @NonNls
    public static final DataKey<ChangesListView> DATA_KEY = DataKey.create((String)"ChangeListView");
    @NonNls
    public static final DataKey<Stream<VirtualFile>> UNVERSIONED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.UnversionedFiles");
    @NonNls
    public static final DataKey<Stream<VirtualFile>> IGNORED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.IgnoredFiles");
    @NonNls
    public static final DataKey<List<FilePath>> MISSING_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.MissingFiles");
    @NonNls
    public static final DataKey<List<LocallyDeletedChange>> LOCALLY_DELETED_CHANGES = DataKey.create((String)"ChangeListView.LocallyDeletedChanges");

    public ChangesListView(@NotNull Project project2) {
        if (project2 == null) {
            ChangesListView.$$$reportNull$$$0(0);
        }
        this.myShowFlatten = false;
        this.myProject = project2;
        this.setModel(TreeModelBuilder.buildEmpty(project2));
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.setDragEnabled(true);
        this.myCopyProvider = new ChangesBrowserNodeCopyProvider((JTree)((Object)this));
        ChangesBrowserNodeRenderer renderer = new ChangesBrowserNodeRenderer(project2, () -> this.myShowFlatten, true);
        this.setCellRenderer((TreeCellRenderer)((Object)renderer));
        new TreeSpeedSearch(this, ChangesBrowserNode.TO_TEXT_CONVERTER);
        SmartExpander.installOn((JTree)((Object)this));
        new TreeLinkMouseListener(renderer).installOn((Component)((Object)this));
    }

    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public boolean isShowFlatten() {
        return this.myShowFlatten;
    }

    public void setShowFlatten(boolean showFlatten) {
        this.myShowFlatten = showFlatten;
    }

    public void updateModel(@NotNull DefaultTreeModel newModel) {
        if (newModel == null) {
            ChangesListView.$$$reportNull$$$0(1);
        }
        TreeState state = TreeState.createOn((JTree)((Object)this), this.getRoot());
        state.setScrollToSelection(false);
        ChangesBrowserNode<?> oldRoot = this.getRoot();
        this.setModel(newModel);
        ChangesBrowserNode<?> newRoot = this.getRoot();
        this.expandPath(new TreePath(newRoot.getPath()));
        state.applyTo((JTree)((Object)this), newRoot);
        this.expandDefaultChangeList(oldRoot, newRoot);
    }

    private void expandDefaultChangeList(ChangesBrowserNode oldRoot, ChangesBrowserNode root) {
        if (oldRoot.getFileCount() != 0) {
            return;
        }
        if (TreeUtil.collectExpandedPaths((JTree)((Object)this)).size() != 1) {
            return;
        }
        Iterator nodes = ContainerUtil.iterate(root.children());
        ChangesBrowserNode defaultListNode = (ChangesBrowserNode)ContainerUtil.find((Iterator)nodes, node -> {
            if (node instanceof ChangesBrowserChangeListNode) {
                ChangeList list2 = (ChangeList)((ChangesBrowserChangeListNode)node).getUserObject();
                return list2 instanceof LocalChangeList && ((LocalChangeList)list2).isDefault();
            }
            return false;
        });
        if (defaultListNode == null) {
            return;
        }
        if (defaultListNode.getChildCount() == 0) {
            return;
        }
        if (defaultListNode.getChildCount() > 10000) {
            return;
        }
        this.expandPath(new TreePath(new Object[]{root, defaultListNode}));
    }

    public void calcData(DataKey key2, DataSink sink) {
        ChangesBrowserNode firstNode;
        TreePath selectionPath;
        if (key2 == DATA_KEY) {
            sink.put(DATA_KEY, (Object)this);
        } else if (key2 == VcsDataKeys.CHANGES) {
            sink.put(VcsDataKeys.CHANGES, this.getSelectedChanges().toArray(Change[]::new));
        } else if (key2 == VcsDataKeys.CHANGE_LEAD_SELECTION) {
            sink.put(VcsDataKeys.CHANGE_LEAD_SELECTION, this.getLeadSelection().toArray(Change[]::new));
        } else if (key2 == VcsDataKeys.CHANGE_LISTS) {
            sink.put(VcsDataKeys.CHANGE_LISTS, this.getSelectedChangeLists().toArray(ChangeList[]::new));
        } else if (key2 == CommonDataKeys.VIRTUAL_FILE_ARRAY) {
            sink.put(CommonDataKeys.VIRTUAL_FILE_ARRAY, this.getSelectedFiles().toArray(VirtualFile[]::new));
        } else if (key2 == VcsDataKeys.VIRTUAL_FILE_STREAM) {
            sink.put(VcsDataKeys.VIRTUAL_FILE_STREAM, this.getSelectedFiles());
        } else if (key2 == CommonDataKeys.NAVIGATABLE) {
            VirtualFile file2 = UtilKt.getIfSingle(this.getNavigatableFiles());
            if (file2 != null && !file2.isDirectory()) {
                sink.put(CommonDataKeys.NAVIGATABLE, (Object)new OpenFileDescriptor(this.myProject, file2, 0));
            }
        } else if (key2 == CommonDataKeys.NAVIGATABLE_ARRAY) {
            sink.put(CommonDataKeys.NAVIGATABLE_ARRAY, (Object)ChangesUtil.getNavigatableArray((Project)this.myProject, this.getNavigatableFiles()));
        } else if (key2 == PlatformDataKeys.DELETE_ELEMENT_PROVIDER) {
            if (this.getSelectionObjectsStream().anyMatch(userObject -> !(userObject instanceof ChangeList))) {
                sink.put(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)new VirtualFileDeleteProvider());
            }
        } else if (key2 == PlatformDataKeys.COPY_PROVIDER) {
            sink.put(PlatformDataKeys.COPY_PROVIDER, (Object)this.myCopyProvider);
        } else if (key2 == UNVERSIONED_FILES_DATA_KEY) {
            sink.put(UNVERSIONED_FILES_DATA_KEY, this.getSelectedUnversionedFiles());
        } else if (key2 == IGNORED_FILES_DATA_KEY) {
            sink.put(IGNORED_FILES_DATA_KEY, this.getSelectedIgnoredFiles());
        } else if (key2 == VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY) {
            sink.put(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY, this.getSelectedModifiedWithoutEditing().collect(Collectors.toList()));
        } else if (key2 == LOCALLY_DELETED_CHANGES) {
            sink.put(LOCALLY_DELETED_CHANGES, this.getSelectedLocallyDeletedChanges().collect(Collectors.toList()));
        } else if (key2 == MISSING_FILES_DATA_KEY) {
            sink.put(MISSING_FILES_DATA_KEY, this.getSelectedMissingFiles().collect(Collectors.toList()));
        } else if (VcsDataKeys.HAVE_LOCALLY_DELETED == key2) {
            sink.put(VcsDataKeys.HAVE_LOCALLY_DELETED, (Object)this.getSelectedMissingFiles().findAny().isPresent());
        } else if (VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING == key2) {
            sink.put(VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING, (Object)this.getSelectedModifiedWithoutEditing().findAny().isPresent());
        } else if (VcsDataKeys.HAVE_SELECTED_CHANGES == key2) {
            sink.put(VcsDataKeys.HAVE_SELECTED_CHANGES, (Object)this.haveSelectedChanges());
        } else if (key2 == PlatformDataKeys.HELP_ID) {
            sink.put(PlatformDataKeys.HELP_ID, (Object)HELP_ID);
        } else if (key2 == VcsDataKeys.CHANGES_IN_LIST_KEY && (selectionPath = this.getSelectionPath()) != null && selectionPath.getPathCount() > 1 && (firstNode = (ChangesBrowserNode)selectionPath.getPathComponent(1)) instanceof ChangesBrowserChangeListNode) {
            sink.put(VcsDataKeys.CHANGES_IN_LIST_KEY, firstNode.getAllChangesUnder());
        }
    }

    @NotNull
    public Stream<VirtualFile> getUnversionedFiles() {
        Enumeration<TreeNode> nodes = this.getRoot().children();
        ChangesBrowserUnversionedFilesNode node = (ChangesBrowserUnversionedFilesNode)ContainerUtil.findInstance((Iterator)ContainerUtil.iterate(nodes), ChangesBrowserUnversionedFilesNode.class);
        if (node == null) {
            Stream<VirtualFile> stream = Stream.empty();
            if (stream == null) {
                ChangesListView.$$$reportNull$$$0(2);
            }
            return stream;
        }
        Stream<VirtualFile> stream = node.getFilesUnderStream();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(3);
        }
        return stream;
    }

    @NotNull
    public Stream<VirtualFile> getSelectedUnversionedFiles() {
        Stream<VirtualFile> stream = this.getSelectedVirtualFiles(ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(4);
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getSelectedIgnoredFiles() {
        Stream<VirtualFile> stream = this.getSelectedVirtualFiles(ChangesBrowserNode.IGNORED_FILES_TAG);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(5);
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getSelectedModifiedWithoutEditing() {
        Stream<VirtualFile> stream = this.getSelectedVirtualFiles(ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @NotNull
    protected Stream<VirtualFile> getSelectedVirtualFiles(@Nullable Object tag) {
        Stream<VirtualFile> stream = this.getSelectionNodesStream(tag).flatMap(ChangesBrowserNode::getFilesUnderStream).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(7);
        }
        return stream;
    }

    @NotNull
    private Stream<ChangesBrowserNode<?>> getSelectionNodesStream() {
        Stream<ChangesBrowserNode<?>> stream = this.getSelectionNodesStream(null);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(8);
        }
        return stream;
    }

    @NotNull
    private Stream<ChangesBrowserNode<?>> getSelectionNodesStream(@Nullable Object tag) {
        Stream<ChangesBrowserNode<?>> stream = UtilKt.stream(this.getSelectionPaths()).filter(path -> ChangesListView.isUnderTag(path, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(9);
        }
        return stream;
    }

    @NotNull
    private Stream<Object> getSelectionObjectsStream() {
        Stream<Object> stream = this.getSelectionNodesStream().map(ChangesBrowserNode::getUserObject);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(10);
        }
        return stream;
    }

    @NotNull
    static Stream<VirtualFile> getVirtualFiles(@Nullable TreePath[] paths, @Nullable Object tag) {
        Stream<VirtualFile> stream = UtilKt.stream(paths).filter(path -> ChangesListView.isUnderTag(path, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(ChangesBrowserNode::getFilesUnderStream).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(11);
        }
        return stream;
    }

    static boolean isUnderTag(@NotNull TreePath path, @Nullable Object tag) {
        if (path == null) {
            ChangesListView.$$$reportNull$$$0(12);
        }
        boolean result2 = true;
        if (tag != null) {
            result2 = path.getPathCount() > 1 && ((ChangesBrowserNode)path.getPathComponent(1)).getUserObject() == tag;
        }
        return result2;
    }

    @NotNull
    static Stream<Change> getChanges(@NotNull Project project2, @Nullable TreePath[] paths) {
        if (project2 == null) {
            ChangesListView.$$$reportNull$$$0(13);
        }
        Stream<Change> changes = UtilKt.stream(paths).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(node -> node.getObjectsUnderStream(Change.class)).map(Change.class::cast);
        Stream<Change> hijackedChanges = ChangesListView.getVirtualFiles(paths, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG).map(file2 -> {
            if (project2 == null) {
                ChangesListView.$$$reportNull$$$0(27);
            }
            return ChangesListView.toHijackedChange(project2, file2);
        }).filter(Objects::nonNull);
        Stream<Change> stream = Stream.concat(changes, hijackedChanges).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(14);
        }
        return stream;
    }

    @Nullable
    private static Change toHijackedChange(@NotNull Project project2, @NotNull VirtualFile file2) {
        VcsCurrentRevisionProxy before;
        if (project2 == null) {
            ChangesListView.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            ChangesListView.$$$reportNull$$$0(16);
        }
        if ((before = VcsCurrentRevisionProxy.create(file2, project2)) != null) {
            CurrentContentRevision afterRevision = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)file2));
            return new Change((ContentRevision)before, (ContentRevision)afterRevision, FileStatus.HIJACKED);
        }
        return null;
    }

    @NotNull
    private Stream<LocallyDeletedChange> getSelectedLocallyDeletedChanges() {
        Stream<LocallyDeletedChange> stream = this.getSelectionNodesStream(ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG).flatMap(node -> node.getObjectsUnderStream(LocallyDeletedChange.class)).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(17);
        }
        return stream;
    }

    @NotNull
    private Stream<FilePath> getSelectedMissingFiles() {
        Stream<FilePath> stream = this.getSelectedLocallyDeletedChanges().map(LocallyDeletedChange::getPath);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(18);
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getSelectedFiles() {
        Stream<VirtualFile> stream = Stream.concat(ChangesUtil.getAfterRevisionsFiles(this.getSelectedChanges()), this.getSelectedVirtualFiles(null)).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(19);
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getNavigatableFiles() {
        Stream<VirtualFile> stream = Stream.concat(ChangesUtil.getFiles(this.getSelectedChanges()), this.getSelectedVirtualFiles(null)).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(20);
        }
        return stream;
    }

    private boolean haveSelectedChanges() {
        return this.getSelectionNodesStream().anyMatch(node -> node instanceof ChangesBrowserChangeNode || node instanceof ChangesBrowserChangeListNode && node.getChildCount() > 0);
    }

    @NotNull
    private Stream<Change> getLeadSelection() {
        Stream<Change> stream = this.getSelectionNodesStream().filter(node -> node instanceof ChangesBrowserChangeNode).map(ChangesBrowserChangeNode.class::cast).map(ChangesBrowserNode::getUserObject).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(21);
        }
        return stream;
    }

    @NotNull
    public ChangesBrowserNode<?> getRoot() {
        ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)this.getModel().getRoot();
        if (changesBrowserNode == null) {
            ChangesListView.$$$reportNull$$$0(22);
        }
        return changesBrowserNode;
    }

    @NotNull
    public Stream<Change> getChanges() {
        Stream<Change> stream = this.getRoot().getObjectsUnderStream(Change.class);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(23);
        }
        return stream;
    }

    @NotNull
    public Stream<Change> getSelectedChanges() {
        Stream<Change> stream = ChangesListView.getChanges(this.myProject, this.getSelectionPaths());
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(24);
        }
        return stream;
    }

    @NotNull
    private Stream<ChangeList> getSelectedChangeLists() {
        Stream<ChangeList> stream = this.getSelectionObjectsStream().filter(userObject -> userObject instanceof ChangeList).map(ChangeList.class::cast).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(25);
        }
        return stream;
    }

    public void setMenuActions(ActionGroup menuGroup) {
        PopupHandler.installPopupHandler((JComponent)((Object)this), (ActionGroup)menuGroup, (String)"ChangesViewPopup", (ActionManager)ActionManager.getInstance());
        this.editSourceRegistration();
    }

    protected void editSourceRegistration() {
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this));
    }

    @NotNull
    public JComponent getComponent() {
        ChangesListView changesListView = this;
        if (changesListView == null) {
            ChangesListView.$$$reportNull$$$0(26);
        }
        return changesListView;
    }

    public void processMouseEvent(MouseEvent e) {
        if (!(502 != e.getID() || this.isSelectionEmpty() || e.isShiftDown() || e.isControlDown() || e.isMetaDown() || e.isPopupTrigger() || !this.isOverSelection(e.getPoint()))) {
            this.clearSelection();
            TreePath path = this.getPathForLocation(e.getPoint().x, e.getPoint().y);
            if (path != null) {
                this.setSelectionPath(path);
            }
        }
        super.processMouseEvent(e);
    }

    public boolean isOverSelection(Point point) {
        return TreeUtil.isOverSelection((JTree)((Object)this), (Point)point);
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModel";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesListView";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesListView";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUnversionedFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedIgnoredFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModifiedWithoutEditing";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVirtualFiles";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionNodesStream";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionObjectsStream";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
            case 14: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLocallyDeletedChanges";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMissingFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatableFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelection";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChangeLists";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isUnderTag";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getChanges";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "toHijackedChange";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChanges$13";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

