/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesTreeList<T>
extends ChangesTree {
    @NotNull
    private final List<T> myRawChanges;
    @Nullable
    private ChangeNodeDecorator myChangeDecorator;

    public ChangesTreeList(@NotNull Project project2, @NotNull Collection<T> initiallyIncluded, boolean showCheckboxes, boolean highlightProblems, @Nullable Runnable inclusionListener, @Nullable ChangeNodeDecorator decorator) {
        if (project2 == null) {
            ChangesTreeList.$$$reportNull$$$0(0);
        }
        if (initiallyIncluded == null) {
            ChangesTreeList.$$$reportNull$$$0(1);
        }
        super(project2, showCheckboxes, highlightProblems);
        this.myRawChanges = new ArrayList<T>();
        this.setIncludedChanges(initiallyIncluded);
        this.setInclusionListener(inclusionListener);
        this.myChangeDecorator = decorator;
    }

    public ChangesTreeList(@NotNull Project project2, boolean showCheckboxes, boolean highlightProblems) {
        if (project2 == null) {
            ChangesTreeList.$$$reportNull$$$0(2);
        }
        super(project2, showCheckboxes, highlightProblems);
        this.myRawChanges = new ArrayList<T>();
    }

    public void setChangeDecorator(@Nullable ChangeNodeDecorator changeDecorator) {
        this.myChangeDecorator = changeDecorator;
        this.rebuildTree();
    }

    @Deprecated
    public void setScrollPaneBorder(Border border) {
    }

    public void setChangesToDisplay(List<? extends T> changes) {
        this.setChangesToDisplay(changes, null);
    }

    public void setChangesToDisplay(List<? extends T> changes, @Nullable VirtualFile toSelect2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myRawChanges.clear();
        this.myRawChanges.addAll(changes);
        this.rebuildTree();
        if (toSelect2 != null) {
            this.selectFile(toSelect2);
        }
    }

    protected abstract DefaultTreeModel buildTreeModel(List<T> var1, ChangeNodeDecorator var2);

    @Override
    public void rebuildTree() {
        DefaultTreeModel newModel = this.buildTreeModel(this.myRawChanges, this.myChangeDecorator);
        this.updateTreeModel(newModel);
    }

    @NotNull
    public List<T> getChanges() {
        List<T> list2 = this.getSelectedObjects(this.getRoot());
        if (list2 == null) {
            ChangesTreeList.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public List<T> getSelectedChanges() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                ChangesTreeList.$$$reportNull$$$0(4);
            }
            return list2;
        }
        LinkedHashSet changes = ContainerUtil.newLinkedHashSet();
        for (TreePath path : paths) {
            changes.addAll(this.getSelectedObjects((ChangesBrowserNode)path.getLastPathComponent()));
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)changes);
        if (arrayList == null) {
            ChangesTreeList.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private List<T> getSelectedChangesOrAllIfNone() {
        List<T> changes = this.getSelectedChanges();
        if (!changes.isEmpty()) {
            List<T> list2 = changes;
            if (list2 == null) {
                ChangesTreeList.$$$reportNull$$$0(6);
            }
            return list2;
        }
        List<T> list3 = this.getChanges();
        if (list3 == null) {
            ChangesTreeList.$$$reportNull$$$0(7);
        }
        return list3;
    }

    protected abstract List<T> getSelectedObjects(ChangesBrowserNode<?> var1);

    @Nullable
    protected abstract T getLeadSelectedObject(ChangesBrowserNode<?> var1);

    @Nullable
    public T getHighestLeadSelection() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return this.getLeadSelectedObject((ChangesBrowserNode)path.getLastPathComponent());
    }

    @Nullable
    public T getLeadSelection() {
        TreePath path = this.getSelectionPath();
        return (T)(path == null ? null : ContainerUtil.getFirstItem(this.getSelectedObjects((ChangesBrowserNode)path.getLastPathComponent())));
    }

    @NotNull
    public Collection<T> getIncludedChanges() {
        Set<Object> includedSet = this.getIncludedSet();
        List list2 = ContainerUtil.filter(this.getChanges(), includedSet::contains);
        if (list2 == null) {
            ChangesTreeList.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public void select(@NotNull Collection<T> changes) {
        if (changes == null) {
            ChangesTreeList.$$$reportNull$$$0(9);
        }
        this.setSelectedChanges(changes);
    }

    public void setAlwaysExpandList(boolean alwaysExpandList) {
        this.setKeepTreeState(!alwaysExpandList);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initiallyIncluded";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesTreeList";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesTreeList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChangesOrAllIfNone";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

