/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.configurable.ShelfStorageConfigurationDialog;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ShelfProjectConfigurationPanel
extends JPanel {
    @NotNull
    private static final String CURRENT_LOCATION_HINT = "Current location is ";
    @NotNull
    private static final String DEFAULT_LOCATION_HINT = "Default location is ";
    @NotNull
    private final VcsConfiguration myVcsConfiguration;
    @NotNull
    private final Project myProject;
    @NotNull
    private final JBCheckBox myBaseRevisionTexts;
    @NotNull
    private final JLabel myInfoLabel;

    public ShelfProjectConfigurationPanel(@NotNull Project project2) {
        if (project2 == null) {
            ShelfProjectConfigurationPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myProject = project2;
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)project2);
        this.myBaseRevisionTexts = new JBCheckBox(VcsBundle.message((String)"vcs.shelf.store.base.content", (Object[])new Object[0]));
        this.myInfoLabel = new JLabel();
        this.myInfoLabel.setBorder(null);
        this.myInfoLabel.setForeground((Color)JBColor.GRAY);
        this.initComponents();
        this.layoutComponents();
    }

    private void initComponents() {
        this.restoreFromSettings();
        this.myBaseRevisionTexts.setMnemonic('b');
        this.updateLabelInfo();
    }

    private void layoutComponents() {
        JPanel contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBUI.insets((int)3), 0, 0);
        contentPanel.add((Component)this.createStoreBaseRevisionOption(), gb);
        JPanel shelfConfigurablePanel = new JPanel(new BorderLayout(10, 4));
        JButton shelfConfigurableButton = new JButton("Change Shelves Location");
        shelfConfigurableButton.setEnabled(!this.myProject.isDefault());
        shelfConfigurableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (new ShelfStorageConfigurationDialog(ShelfProjectConfigurationPanel.this.myProject).showAndGet()) {
                    ShelfProjectConfigurationPanel.this.updateLabelInfo();
                }
            }
        });
        shelfConfigurablePanel.add((Component)shelfConfigurableButton, "West");
        shelfConfigurablePanel.add((Component)this.myInfoLabel, "Center");
        ++gb.gridy;
        contentPanel.add((Component)shelfConfigurablePanel, gb);
        this.add((Component)contentPanel, "North");
    }

    private void updateLabelInfo() {
        this.myInfoLabel.setText((this.myProject.isDefault() ? DEFAULT_LOCATION_HINT : CURRENT_LOCATION_HINT) + (this.myVcsConfiguration.USE_CUSTOM_SHELF_PATH ? FileUtil.toSystemDependentName((String)((String)ObjectUtils.assertNotNull((Object)this.myVcsConfiguration.CUSTOM_SHELF_PATH))) : ShelfProjectConfigurationPanel.getDefaultShelfPresentationPath(this.myProject)));
    }

    @NotNull
    static String getDefaultShelfPresentationPath(@NotNull Project project2) {
        if (project2 == null) {
            ShelfProjectConfigurationPanel.$$$reportNull$$$0(1);
        }
        String string = FileUtil.toSystemDependentName((String)(project2.isDefault() ? "<Project>/shelf" : ShelveChangesManager.getDefaultShelfPath(project2)));
        if (string == null) {
            ShelfProjectConfigurationPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    private JComponent createStoreBaseRevisionOption() {
        JBLabel noteLabel = new JBLabel("The base content of files larger than 500K will not be stored");
        noteLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        noteLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        noteLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)25, (int)5, (int)0));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myBaseRevisionTexts, "North");
        panel2.add((Component)noteLabel, "South");
        return panel2;
    }

    public void restoreFromSettings() {
        this.myBaseRevisionTexts.setSelected(this.myVcsConfiguration.INCLUDE_TEXT_INTO_SHELF);
    }

    public boolean isModified() {
        return this.myVcsConfiguration.INCLUDE_TEXT_INTO_SHELF != this.myBaseRevisionTexts.isSelected();
    }

    public void apply() {
        this.myVcsConfiguration.INCLUDE_TEXT_INTO_SHELF = this.myBaseRevisionTexts.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/configurable/ShelfProjectConfigurationPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/configurable/ShelfProjectConfigurationPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultShelfPresentationPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultShelfPresentationPath";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

