/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Range {
    private static final Logger LOG = Logger.getInstance(Range.class);
    public static final byte EQUAL = 0;
    public static final byte MODIFIED = 1;
    public static final byte INSERTED = 2;
    public static final byte DELETED = 3;
    private int myLine1;
    private int myLine2;
    private int myVcsLine1;
    private int myVcsLine2;
    @Nullable
    private final List<InnerRange> myInnerRanges;
    @Nullable
    private RangeHighlighter myRangeHighlighter;
    private boolean myValid;

    public Range(@NotNull Range range) {
        if (range == null) {
            Range.$$$reportNull$$$0(0);
        }
        this(range.getLine1(), range.getLine2(), range.getVcsLine1(), range.getVcsLine2());
    }

    public Range(int line1, int line2, int vcsLine1, int vcsLine2) {
        this(line1, line2, vcsLine1, vcsLine2, null);
    }

    public Range(int line1, int line2, int vcsLine1, int vcsLine2, @Nullable List<InnerRange> innerRanges) {
        this.myValid = true;
        assert (line1 != line2 || vcsLine1 != vcsLine2);
        this.myLine1 = line1;
        this.myLine2 = line2;
        this.myVcsLine1 = vcsLine1;
        this.myVcsLine2 = vcsLine2;
        this.myInnerRanges = innerRanges;
    }

    public int hashCode() {
        return this.myVcsLine1 ^ this.myVcsLine2 ^ this.myLine1 ^ this.myLine2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (this.myLine1 != range.myLine1) {
            return false;
        }
        if (this.myLine2 != range.myLine2) {
            return false;
        }
        if (this.myVcsLine1 != range.myVcsLine1) {
            return false;
        }
        if (this.myVcsLine2 != range.myVcsLine2) {
            return false;
        }
        if (this.myInnerRanges == null) {
            return range.myInnerRanges == null;
        }
        if (range.myInnerRanges == null) {
            return false;
        }
        if (this.myInnerRanges.size() != range.myInnerRanges.size()) {
            return false;
        }
        for (int i = 0; i < this.myInnerRanges.size(); ++i) {
            if (this.myInnerRanges.get(i).equals(range.myInnerRanges.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("%s, %s, %s, %s", this.myLine1, this.myLine2, this.myVcsLine1, this.myVcsLine2);
    }

    public byte getType() {
        if (this.myLine1 == this.myLine2) {
            return 3;
        }
        if (this.myVcsLine1 == this.myVcsLine2) {
            return 2;
        }
        return 1;
    }

    public void shift(int shift) {
        this.myLine1 += shift;
        this.myLine2 += shift;
        if (this.myInnerRanges != null) {
            for (InnerRange range : this.myInnerRanges) {
                range.shift(shift);
            }
        }
    }

    public void vcsShift(int shift) {
        this.myVcsLine1 += shift;
        this.myVcsLine2 += shift;
    }

    @Nullable
    public List<InnerRange> getInnerRanges() {
        return this.myInnerRanges;
    }

    public int getLine1() {
        return this.myLine1;
    }

    public int getLine2() {
        return this.myLine2;
    }

    public int getVcsLine1() {
        return this.myVcsLine1;
    }

    public int getVcsLine2() {
        return this.myVcsLine2;
    }

    public void setHighlighter(@Nullable RangeHighlighter highlighter) {
        this.myRangeHighlighter = highlighter;
    }

    @Nullable
    public RangeHighlighter getHighlighter() {
        return this.myRangeHighlighter;
    }

    public boolean isValid() {
        return this.myValid;
    }

    public void invalidate() {
        this.myValid = false;
    }

    public boolean isSelectedByLine(int line) {
        return DiffUtil.isSelectedByLine(line, this.myLine1, this.myLine2);
    }

    @NotNull
    private static String getTypeName(byte type2) {
        switch (type2) {
            case 1: {
                if ("MODIFIED" == null) {
                    Range.$$$reportNull$$$0(1);
                }
                return "MODIFIED";
            }
            case 2: {
                if ("INSERTED" == null) {
                    Range.$$$reportNull$$$0(2);
                }
                return "INSERTED";
            }
            case 3: {
                if ("DELETED" == null) {
                    Range.$$$reportNull$$$0(3);
                }
                return "DELETED";
            }
            case 0: {
                if ("EQUAL" == null) {
                    Range.$$$reportNull$$$0(4);
                }
                return "EQUAL";
            }
        }
        String string = "UNKNOWN(" + type2 + ")";
        if (string == null) {
            Range.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ex/Range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ex/Range";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InnerRange {
        private int myLine1;
        private int myLine2;
        private final byte myType;

        public InnerRange(int line1, int line2, byte type2) {
            this.myLine1 = line1;
            this.myLine2 = line2;
            this.myType = type2;
        }

        public int getLine1() {
            return this.myLine1;
        }

        public int getLine2() {
            return this.myLine2;
        }

        public byte getType() {
            return this.myType;
        }

        public void shift(int shift) {
            this.myLine1 += shift;
            this.myLine2 += shift;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InnerRange range = (InnerRange)o;
            if (this.myLine1 != range.myLine1) {
                return false;
            }
            if (this.myLine2 != range.myLine2) {
                return false;
            }
            return this.myType == range.myType;
        }

        public int hashCode() {
            int result2 = this.myLine1;
            result2 = 31 * result2 + this.myLine2;
            result2 = 31 * result2 + this.myType;
            return result2;
        }

        public String toString() {
            return String.format("%s, %s, %s", this.myLine1, this.myLine2, Range.getTypeName(this.myType));
        }
    }
}

