/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.CachingVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileManagerImpl
extends VirtualFileManagerEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.VirtualFileManagerImpl");
    private final KeyedExtensionCollector<VirtualFileSystem, String> myCollector;
    private final VirtualFileSystem[] myPhysicalFileSystems;
    private final EventDispatcher<VirtualFileListener> myVirtualFileListenerMulticaster;
    private final List<VirtualFileManagerListener> myVirtualFileManagerListeners;
    private int myRefreshCount;

    public VirtualFileManagerImpl(@NotNull VirtualFileSystem[] fileSystems, @NotNull MessageBus bus) {
        if (fileSystems == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(0);
        }
        if (bus == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(1);
        }
        this.myCollector = new KeyedExtensionCollector<VirtualFileSystem, String>("com.intellij.virtualFileSystem"){

            @NotNull
            protected String keyToString(@NotNull String key2) {
                if (key2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = key2;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "keyToString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "keyToString";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myVirtualFileListenerMulticaster = EventDispatcher.create(VirtualFileListener.class);
        this.myVirtualFileManagerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myPhysicalFileSystems = fileSystems;
        for (VirtualFileSystem fileSystem : fileSystems) {
            this.myCollector.addExplicitExtension((Object)fileSystem.getProtocol(), (Object)fileSystem);
            if (fileSystem instanceof CachingVirtualFileSystem) continue;
            fileSystem.addVirtualFileListener((VirtualFileListener)this.myVirtualFileListenerMulticaster.getMulticaster());
        }
        if (LOG.isDebugEnabled() && !ApplicationInfoImpl.isInStressTest()) {
            this.addVirtualFileListener(new LoggingListener());
        }
        bus.connect().subscribe(VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)this.myVirtualFileListenerMulticaster.getMulticaster()));
    }

    public long getStructureModificationCount() {
        return 0L;
    }

    @Nullable
    public VirtualFileSystem getFileSystem(@Nullable String protocol) {
        if (protocol == null) {
            return null;
        }
        List systems = this.myCollector.forKey((Object)protocol);
        int size = systems.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            LOG.error(protocol + ": " + systems);
        }
        return (VirtualFileSystem)systems.get(0);
    }

    public long syncRefresh() {
        return this.doRefresh(false, null);
    }

    public long asyncRefresh(@Nullable Runnable postAction) {
        return this.doRefresh(true, postAction);
    }

    protected long doRefresh(boolean asynchronous, @Nullable Runnable postAction) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        for (VirtualFileSystem fileSystem : this.myPhysicalFileSystems) {
            if (fileSystem instanceof CachingVirtualFileSystem) continue;
            fileSystem.refresh(asynchronous);
        }
        return 0L;
    }

    public void refreshWithoutFileWatcher(boolean asynchronous) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        for (VirtualFileSystem fileSystem : this.myPhysicalFileSystems) {
            if (fileSystem instanceof CachingVirtualFileSystem) {
                ((CachingVirtualFileSystem)fileSystem).refreshWithoutFileWatcher(asynchronous);
                continue;
            }
            fileSystem.refresh(asynchronous);
        }
    }

    public VirtualFile findFileByUrl(@NotNull String url) {
        VirtualFileSystem fileSystem;
        if (url == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(2);
        }
        if ((fileSystem = this.getFileSystemForUrl(url)) == null) {
            return null;
        }
        return fileSystem.findFileByPath(VirtualFileManagerImpl.extractPath((String)url));
    }

    public VirtualFile refreshAndFindFileByUrl(@NotNull String url) {
        VirtualFileSystem fileSystem;
        if (url == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(3);
        }
        if ((fileSystem = this.getFileSystemForUrl(url)) == null) {
            return null;
        }
        return fileSystem.refreshAndFindFileByPath(VirtualFileManagerImpl.extractPath((String)url));
    }

    @Nullable
    private VirtualFileSystem getFileSystemForUrl(String url) {
        String protocol = VirtualFileManagerImpl.extractProtocol((String)url);
        if (protocol == null) {
            return null;
        }
        return this.getFileSystem(protocol);
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener2) {
        if (listener2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(4);
        }
        this.myVirtualFileListenerMulticaster.addListener((EventListener)listener2);
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(6);
        }
        this.myVirtualFileListenerMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeVirtualFileListener(@NotNull VirtualFileListener listener2) {
        if (listener2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(7);
        }
        this.myVirtualFileListenerMulticaster.removeListener((EventListener)listener2);
    }

    public void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener2) {
        if (listener2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(8);
        }
        this.myVirtualFileManagerListeners.add(listener2);
    }

    public void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(9);
        }
        if (parentDisposable == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(10);
        }
        this.addVirtualFileManagerListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> {
            if (listener2 == null) {
                VirtualFileManagerImpl.$$$reportNull$$$0(14);
            }
            this.removeVirtualFileManagerListener(listener2);
        });
    }

    public void removeVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener2) {
        if (listener2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(11);
        }
        this.myVirtualFileManagerListeners.remove(listener2);
    }

    public void notifyPropertyChanged(final @NotNull VirtualFile virtualFile, final @NotNull String property, final Object oldValue, final Object newValue) {
        if (virtualFile == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(12);
        }
        if (property == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(13);
        }
        final Application application = ApplicationManager.getApplication();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (virtualFile.isValid() && !application.isDisposed()) {
                    application.runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            List<VFilePropertyChangeEvent> events = Collections.singletonList(new VFilePropertyChangeEvent((Object)this, virtualFile, property, oldValue, newValue, false));
                            BulkFileListener listener2 = (BulkFileListener)application.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
                            listener2.before(events);
                            listener2.after(events);
                        }
                    });
                }
            }
        };
        application.invokeLater(runnable2, ModalityState.NON_MODAL);
    }

    @Override
    public void fireBeforeRefreshStart(boolean asynchronous) {
        if (this.myRefreshCount++ == 0) {
            for (VirtualFileManagerListener listener2 : this.myVirtualFileManagerListeners) {
                try {
                    listener2.beforeRefreshStart(asynchronous);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    @Override
    public void fireAfterRefreshFinish(boolean asynchronous) {
        if (--this.myRefreshCount == 0) {
            for (VirtualFileManagerListener listener2 : this.myVirtualFileManagerListeners) {
                try {
                    listener2.afterRefreshFinish(asynchronous);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    public long getModificationCount() {
        return 0L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystems";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileByUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshAndFindFileByUrl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addVirtualFileListener";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeVirtualFileListener";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addVirtualFileManagerListener";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "removeVirtualFileManagerListener";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyPropertyChanged";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addVirtualFileManagerListener$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LoggingListener
    implements VirtualFileListener {
        private LoggingListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(0);
            }
            LOG.debug("propertyChanged: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(1);
            }
            LOG.debug("contentsChanged: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(2);
            }
            LOG.debug("fileCreated: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(3);
            }
            LOG.debug("fileDeleted: file = " + event.getFile() + ", parent = " + event.getParent() + ", requestor = " + event.getRequestor());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(4);
            }
            LOG.debug("fileMoved: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(5);
            }
            LOG.debug("fileCopied: file = " + event.getFile() + "originalFile = " + event.getOriginalFile() + ", requestor = " + event.getRequestor());
        }

        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(6);
            }
            LOG.debug("beforeContentsChange: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(7);
            }
            LOG.debug("beforePropertyChange: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(8);
            }
            LOG.debug("beforeFileDeletion: file = " + event.getFile() + ", requestor = " + event.getRequestor());
            LOG.assertTrue(event.getFile().isValid());
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(9);
            }
            LOG.debug("beforeFileMovement: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeContentsChange";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforePropertyChange";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileDeletion";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileMovement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

