/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.impl.artifacts.ArtifactManagerImpl;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PathUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ArtifactVirtualFileListener
implements VirtualFileListener {
    private final CachedValue<MultiValuesMap<String, Artifact>> myParentPathsToArtifacts;
    private final ArtifactManagerImpl myArtifactManager;

    public ArtifactVirtualFileListener(Project project2, ArtifactManagerImpl artifactManager) {
        this.myArtifactManager = artifactManager;
        this.myParentPathsToArtifacts = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> {
            MultiValuesMap<String, Artifact> result2 = this.computeParentPathToArtifactMap();
            return CachedValueProvider.Result.createSingleDependency(result2, (Object)artifactManager.getModificationTracker());
        }, false);
    }

    private MultiValuesMap<String, Artifact> computeParentPathToArtifactMap() {
        final MultiValuesMap result2 = new MultiValuesMap();
        for (final Artifact artifact : this.myArtifactManager.getArtifacts()) {
            ArtifactUtil.processFileOrDirectoryCopyElements(artifact, new PackagingElementProcessor<FileOrDirectoryCopyPackagingElement<?>>(){

                @Override
                public boolean process(@NotNull FileOrDirectoryCopyPackagingElement<?> element, @NotNull PackagingElementPath pathToElement) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (pathToElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    String path = element.getFilePath();
                    while (path.length() > 0) {
                        result2.put((Object)path, (Object)artifact);
                        path = PathUtil.getParentPath((String)path);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "pathToElement";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactVirtualFileListener$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, this.myArtifactManager.getResolvingContext(), false);
        }
        return result2;
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            ArtifactVirtualFileListener.$$$reportNull$$$0(0);
        }
        String oldPath = event.getOldParent().getPath() + "/" + event.getFileName();
        this.filePathChanged(oldPath, event.getNewParent().getPath() + "/" + event.getFileName());
    }

    private void filePathChanged(final @NotNull String oldPath, final @NotNull String newPath) {
        Collection artifacts;
        if (oldPath == null) {
            ArtifactVirtualFileListener.$$$reportNull$$$0(1);
        }
        if (newPath == null) {
            ArtifactVirtualFileListener.$$$reportNull$$$0(2);
        }
        if ((artifacts = ((MultiValuesMap)this.myParentPathsToArtifacts.getValue()).get((Object)oldPath)) != null) {
            ModifiableArtifactModel model = this.myArtifactManager.createModifiableModel();
            for (Artifact artifact : artifacts) {
                ModifiableArtifact copy = model.getOrCreateModifiableArtifact(artifact);
                ArtifactUtil.processFileOrDirectoryCopyElements((Artifact)copy, new PackagingElementProcessor<FileOrDirectoryCopyPackagingElement<?>>(){

                    @Override
                    public boolean process(@NotNull FileOrDirectoryCopyPackagingElement<?> element, @NotNull PackagingElementPath pathToElement) {
                        String path;
                        if (element == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (pathToElement == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (FileUtil.startsWith((String)(path = element.getFilePath()), (String)oldPath)) {
                            element.setFilePath(newPath + path.substring(oldPath.length()));
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "pathToElement";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactVirtualFileListener$2";
                        objectArray[2] = "process";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, this.myArtifactManager.getResolvingContext(), false);
            }
            model.commit();
        }
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        VirtualFile parent;
        if (event == null) {
            ArtifactVirtualFileListener.$$$reportNull$$$0(3);
        }
        if ("name".equals(event.getPropertyName()) && (parent = event.getParent()) != null) {
            this.filePathChanged(parent.getPath() + "/" + event.getOldValue(), parent.getPath() + "/" + event.getNewValue());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/artifacts/ArtifactVirtualFileListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMoved";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "filePathChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

