/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.Generator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.RenameablePackagingElement;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.FileCopyPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileCopyPackagingElement
extends FileOrDirectoryCopyPackagingElement<FileCopyPackagingElement>
implements RenameablePackagingElement {
    @NonNls
    public static final String OUTPUT_FILE_NAME_ATTRIBUTE = "output-file-name";
    private String myRenamedOutputFileName;

    public FileCopyPackagingElement() {
        super(PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE);
    }

    public FileCopyPackagingElement(String filePath) {
        this();
        this.myFilePath = filePath;
    }

    public FileCopyPackagingElement(String filePath, String outputFileName) {
        this(filePath);
        this.myRenamedOutputFileName = outputFileName;
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            FileCopyPackagingElement.$$$reportNull$$$0(0);
        }
        return new FileCopyPresentation(this.myFilePath, this.getOutputFileName());
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        if (resolvingContext == null) {
            FileCopyPackagingElement.$$$reportNull$$$0(1);
        }
        if (creator == null) {
            FileCopyPackagingElement.$$$reportNull$$$0(2);
        }
        if (generationContext == null) {
            FileCopyPackagingElement.$$$reportNull$$$0(3);
        }
        if (artifactType == null) {
            FileCopyPackagingElement.$$$reportNull$$$0(4);
        }
        if (this.isDirectory()) {
            return Collections.emptyList();
        }
        String path = generationContext.getSubstitutedPath(this.myFilePath);
        return Collections.singletonList(creator.createFileCopyInstruction(path, this.getOutputFileName()));
    }

    public String getOutputFileName() {
        return this.myRenamedOutputFileName != null ? this.myRenamedOutputFileName : PathUtil.getFileName((String)this.myFilePath);
    }

    @NonNls
    public String toString() {
        return "file:" + this.myFilePath + (this.myRenamedOutputFileName != null ? ",rename to:" + this.myRenamedOutputFileName : "");
    }

    public boolean isDirectory() {
        return new File(FileUtil.toSystemDependentName((String)this.myFilePath)).isDirectory();
    }

    @Override
    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            FileCopyPackagingElement.$$$reportNull$$$0(5);
        }
        return element instanceof FileCopyPackagingElement && super.isEqualTo(element) && Comparing.equal((String)this.myRenamedOutputFileName, (String)((FileCopyPackagingElement)element).getRenamedOutputFileName());
    }

    public FileCopyPackagingElement getState() {
        return this;
    }

    public void loadState(FileCopyPackagingElement state) {
        this.setFilePath(state.getFilePath());
        this.setRenamedOutputFileName(state.getRenamedOutputFileName());
    }

    @Attribute(value="output-file-name")
    @Nullable
    public String getRenamedOutputFileName() {
        return this.myRenamedOutputFileName;
    }

    public void setRenamedOutputFileName(String renamedOutputFileName) {
        this.myRenamedOutputFileName = renamedOutputFileName;
    }

    public String getName() {
        return this.getOutputFileName();
    }

    public boolean canBeRenamed() {
        return !this.isDirectory();
    }

    public void rename(@NotNull String newName) {
        if (newName == null) {
            FileCopyPackagingElement.$$$reportNull$$$0(6);
        }
        this.myRenamedOutputFileName = newName.equals(PathUtil.getFileName((String)this.myFilePath)) ? null : newName;
    }

    @Nullable
    public VirtualFile getLibraryRoot() {
        String url = VfsUtil.getUrlForLibraryRoot((File)new File(FileUtil.toSystemDependentName((String)this.getFilePath())));
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvingContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/elements/FileCopyPackagingElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeAntInstructions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualTo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "rename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

