/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates.github;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.Outcome;
import com.intellij.util.NullableFunction;
import com.intellij.util.Producer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipUtil {
    private static final Logger LOG = Logger.getInstance(ZipUtil.class);

    public static void unzipWithProgressSynchronously(@Nullable Project project2, @NotNull String progressTitle, @NotNull File zipArchive, @NotNull File extractToDir, boolean unwrapSingleTopLevelFolder) throws GeneratorException {
        if (progressTitle == null) {
            ZipUtil.$$$reportNull$$$0(0);
        }
        if (zipArchive == null) {
            ZipUtil.$$$reportNull$$$0(1);
        }
        if (extractToDir == null) {
            ZipUtil.$$$reportNull$$$0(2);
        }
        ZipUtil.unzipWithProgressSynchronously(project2, progressTitle, zipArchive, extractToDir, null, unwrapSingleTopLevelFolder);
    }

    public static void unzipWithProgressSynchronously(@Nullable Project project2, @NotNull String progressTitle, @NotNull File zipArchive, @NotNull File extractToDir, @Nullable NullableFunction<String, String> pathConvertor, boolean unwrapSingleTopLevelFolder) throws GeneratorException {
        Outcome<Boolean> outcome;
        Boolean result2;
        if (progressTitle == null) {
            ZipUtil.$$$reportNull$$$0(3);
        }
        if (zipArchive == null) {
            ZipUtil.$$$reportNull$$$0(4);
        }
        if (extractToDir == null) {
            ZipUtil.$$$reportNull$$$0(5);
        }
        if ((result2 = (outcome = DownloadUtil.provideDataWithProgressSynchronously(project2, progressTitle, "Unpacking ...", () -> {
            if (extractToDir == null) {
                ZipUtil.$$$reportNull$$$0(18);
            }
            if (zipArchive == null) {
                ZipUtil.$$$reportNull$$$0(19);
            }
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            ZipUtil.unzip(progress, extractToDir, zipArchive, pathConvertor, null, unwrapSingleTopLevelFolder);
            return true;
        }, (Producer<Boolean>)((Producer)() -> false))).get()) == null) {
            Exception e = outcome.getException();
            if (e != null) {
                throw new GeneratorException("Unpacking failed, downloaded archive is broken");
            }
            throw new GeneratorException("Unpacking was cancelled");
        }
    }

    private static File getUnzipToDir(@Nullable ProgressIndicator progress, @NotNull File targetDir, boolean unwrapSingleTopLevelFolder) throws IOException {
        if (targetDir == null) {
            ZipUtil.$$$reportNull$$$0(6);
        }
        if (progress != null) {
            progress.setText("Extracting...");
        }
        if (unwrapSingleTopLevelFolder) {
            return FileUtil.createTempDirectory((String)"unzip-dir-", null);
        }
        return targetDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(@Nullable ProgressIndicator progress, @NotNull File targetDir, @NotNull File zipArchive, @Nullable NullableFunction<String, String> pathConvertor, @Nullable ContentProcessor contentProcessor, boolean unwrapSingleTopLevelFolder) throws IOException {
        if (targetDir == null) {
            ZipUtil.$$$reportNull$$$0(7);
        }
        if (zipArchive == null) {
            ZipUtil.$$$reportNull$$$0(8);
        }
        File unzipToDir = ZipUtil.getUnzipToDir(progress, targetDir, unwrapSingleTopLevelFolder);
        try (ZipFile zipFile = new ZipFile(zipArchive, 1);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream entryContentStream = zipFile.getInputStream(entry);
                ZipUtil.unzipEntryToDir(progress, entry, entryContentStream, unzipToDir, pathConvertor, contentProcessor);
                entryContentStream.close();
            }
        }
        ZipUtil.doUnwrapSingleTopLevelFolder(unwrapSingleTopLevelFolder, unzipToDir, targetDir);
    }

    public static void unzip(@Nullable ProgressIndicator progress, @NotNull File targetDir, @NotNull ZipInputStream stream, @Nullable NullableFunction<String, String> pathConvertor, @Nullable ContentProcessor contentProcessor, boolean unwrapSingleTopLevelFolder) throws IOException {
        ZipEntry entry;
        if (targetDir == null) {
            ZipUtil.$$$reportNull$$$0(9);
        }
        if (stream == null) {
            ZipUtil.$$$reportNull$$$0(10);
        }
        File unzipToDir = ZipUtil.getUnzipToDir(progress, targetDir, unwrapSingleTopLevelFolder);
        while ((entry = stream.getNextEntry()) != null) {
            ZipUtil.unzipEntryToDir(progress, entry, stream, unzipToDir, pathConvertor, contentProcessor);
        }
        ZipUtil.doUnwrapSingleTopLevelFolder(unwrapSingleTopLevelFolder, unzipToDir, targetDir);
    }

    private static void doUnwrapSingleTopLevelFolder(boolean unwrapSingleTopLevelFolder, @NotNull File unzipToDir, @NotNull File targetDir) throws IOException {
        if (unzipToDir == null) {
            ZipUtil.$$$reportNull$$$0(11);
        }
        if (targetDir == null) {
            ZipUtil.$$$reportNull$$$0(12);
        }
        if (unwrapSingleTopLevelFolder) {
            File[] topLevelFiles = unzipToDir.listFiles();
            File dirToMove = topLevelFiles != null && topLevelFiles.length == 1 && topLevelFiles[0].isDirectory() ? topLevelFiles[0] : unzipToDir;
            FileUtil.copyDirContent((File)dirToMove, (File)targetDir);
            FileUtil.delete((File)unzipToDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipEntryToDir(@Nullable ProgressIndicator progress, @NotNull ZipEntry zipEntry, @NotNull InputStream entryContentStream, @NotNull File extractToDir, @Nullable NullableFunction<String, String> pathConvertor, @Nullable ContentProcessor contentProcessor) throws IOException {
        File dir;
        if (zipEntry == null) {
            ZipUtil.$$$reportNull$$$0(13);
        }
        if (entryContentStream == null) {
            ZipUtil.$$$reportNull$$$0(14);
        }
        if (extractToDir == null) {
            ZipUtil.$$$reportNull$$$0(15);
        }
        String relativeExtractPath = ZipUtil.createRelativeExtractPath(zipEntry);
        if (pathConvertor != null && (relativeExtractPath = (String)pathConvertor.fun((Object)relativeExtractPath)) == null) {
            return;
        }
        File child = new File(extractToDir, relativeExtractPath);
        File file2 = dir = zipEntry.isDirectory() ? child : child.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create dir: '" + dir + "'!");
        }
        if (zipEntry.isDirectory()) {
            return;
        }
        if (progress != null) {
            progress.setText("Extracting " + relativeExtractPath + " ...");
        }
        if (contentProcessor == null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(child);){
                FileUtil.copy((InputStream)entryContentStream, (OutputStream)fileOutputStream);
            }
        } else {
            byte[] content = contentProcessor.processContent(FileUtil.loadBytes((InputStream)entryContentStream), child);
            if (content != null) {
                FileUtil.writeToFile((File)child, (byte[])content);
            }
        }
        LOG.info("Extract: " + relativeExtractPath);
    }

    @NotNull
    private static String createRelativeExtractPath(@NotNull ZipEntry zipEntry) {
        if (zipEntry == null) {
            ZipUtil.$$$reportNull$$$0(16);
        }
        String name2 = StringUtil.trimStart((String)zipEntry.getName(), (String)"/");
        String string = StringUtil.trimEnd((String)name2, (String)"/");
        if (string == null) {
            ZipUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipArchive";
                break;
            }
            case 2: 
            case 5: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractToDir";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unzipToDir";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipEntry";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryContentStream";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/templates/github/ZipUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/templates/github/ZipUtil";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createRelativeExtractPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unzipWithProgressSynchronously";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUnzipToDir";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unzip";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doUnwrapSingleTopLevelFolder";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "unzipEntryToDir";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createRelativeExtractPath";
                break;
            }
            case 17: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$unzipWithProgressSynchronously$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ContentProcessor {
        @Nullable
        public byte[] processContent(byte[] var1, File var2) throws IOException;
    }
}

