/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectView;

import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectView.TestProjectViewPSIPane;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.ProjectViewTestUtil;
import org.junit.Assert;

public class TestProjectTreeStructure
extends AbstractProjectTreeStructure
implements Disposable,
ProjectViewSettings {
    private boolean myShowExcludedFiles = true;
    protected boolean myShowMembers = false;
    protected boolean myHideEmptyMiddlePackages;
    protected boolean myFlattenPackages;
    private boolean myFlattenModules;
    protected boolean myShowLibraryContents = true;

    public TestProjectTreeStructure(Project project2, Disposable parentDisposable) {
        super(project2);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public void checkNavigateFromSourceBehaviour(PsiElement element, VirtualFile virtualFile, AbstractProjectViewPSIPane pane) {
        Assert.assertNull((Object)ProjectViewTestUtil.getNodeForElement(element, pane));
        pane.select(element, virtualFile, true);
        Assert.assertTrue((boolean)ProjectViewTestUtil.isExpanded(element, pane));
    }

    public AbstractProjectViewPSIPane createPane() {
        TestProjectViewPSIPane pane = new TestProjectViewPSIPane(this.myProject, this, 9);
        pane.createComponent();
        Disposer.register((Disposable)this, (Disposable)pane);
        return pane;
    }

    @Override
    public boolean isShowMembers() {
        return this.myShowMembers;
    }

    public boolean isFlattenPackages() {
        return this.myFlattenPackages;
    }

    public boolean isAbbreviatePackageNames() {
        return false;
    }

    public boolean isHideEmptyMiddlePackages() {
        return this.myHideEmptyMiddlePackages;
    }

    public boolean isShowLibraryContents() {
        return this.myShowLibraryContents;
    }

    @Override
    public boolean isShowExcludedFiles() {
        return this.myShowExcludedFiles;
    }

    public boolean isShowModules() {
        return true;
    }

    public void setShowMembers(boolean showMembers) {
        this.myShowMembers = showMembers;
    }

    public boolean isFlattenModules() {
        return this.myFlattenModules;
    }

    public void setFlattenModules(boolean flattenModules) {
        this.myFlattenModules = flattenModules;
    }

    public void setHideEmptyMiddlePackages(boolean hideEmptyMiddlePackages) {
        this.myHideEmptyMiddlePackages = hideEmptyMiddlePackages;
    }

    public void setFlattenPackages(boolean flattenPackages) {
        this.myFlattenPackages = flattenPackages;
    }

    public void hideExcludedFiles() {
        this.myShowExcludedFiles = false;
    }

    public void setShowLibraryContents(boolean showLibraryContents) {
        this.myShowLibraryContents = showLibraryContents;
    }

    public void dispose() {
    }
}

