/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.JavaModuleSystemEx;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddRequiredModuleFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.util.PsiUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J*\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/psi/impl/JavaPlatformModuleSystem;", "Lcom/intellij/codeInsight/JavaModuleSystemEx;", "()V", "ERR", "Lcom/intellij/codeInsight/JavaModuleSystemEx$ErrorWithFixes;", "checkAccess", "target", "Lcom/intellij/psi/PsiClass;", "place", "Lcom/intellij/psi/PsiElement;", "quick", "", "Lcom/intellij/psi/PsiFileSystemItem;", "packageName", "", "Lcom/intellij/psi/PsiPackage;", "getName", "isAccessible", "java-impl"})
public final class JavaPlatformModuleSystem
implements JavaModuleSystemEx {
    private final JavaModuleSystemEx.ErrorWithFixes ERR = new JavaModuleSystemEx.ErrorWithFixes("-");

    @NotNull
    public String getName() {
        return "Java Platform Module System";
    }

    public boolean isAccessible(@NotNull PsiPackage target2, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        return this.checkAccess(target2, place, true) == null;
    }

    public boolean isAccessible(@NotNull PsiClass target2, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        return this.checkAccess(target2, place, true) == null;
    }

    @Nullable
    public JavaModuleSystemEx.ErrorWithFixes checkAccess(@NotNull PsiPackage target2, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        return this.checkAccess(target2, place, false);
    }

    @Nullable
    public JavaModuleSystemEx.ErrorWithFixes checkAccess(@NotNull PsiClass target2, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        return this.checkAccess(target2, place, false);
    }

    private final JavaModuleSystemEx.ErrorWithFixes checkAccess(PsiClass target2, PsiElement place, boolean quick) {
        PsiFile targetFile;
        PsiFile useFile;
        PsiFile psiFile = place.getContainingFile();
        Object object = useFile = psiFile != null ? psiFile.getOriginalFile() : null;
        if (useFile != null && PsiUtil.isLanguageLevel9OrHigher((PsiElement)((PsiElement)useFile)) && (targetFile = target2.getContainingFile()) instanceof PsiClassOwner) {
            PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)targetFile;
            PsiFileSystemItem psiFileSystemItem2 = (PsiFileSystemItem)useFile;
            String string = ((PsiClassOwner)targetFile).getPackageName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"targetFile.packageName");
            return this.checkAccess(psiFileSystemItem, psiFileSystemItem2, string, quick);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final JavaModuleSystemEx.ErrorWithFixes checkAccess(PsiPackage target2, PsiElement place, boolean quick) {
        PsiFile psiFile = place.getContainingFile();
        if (psiFile == null) return null;
        PsiFile psiFile2 = psiFile.getOriginalFile();
        PsiFile useFile = psiFile2;
        if (useFile == null) return null;
        if (!PsiUtil.isLanguageLevel9OrHigher((PsiElement)((PsiElement)useFile))) return null;
        VirtualFile useVFile = useFile.getVirtualFile();
        if (useVFile == null) return null;
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)useFile.getProject());
        Module module2 = index.getModuleForFile(useVFile);
        if (module2 == null) return null;
        boolean test = index.isInTestSourceContent(useVFile);
        PsiDirectory[] dirs = target2.getDirectories(module2.getModuleWithDependenciesAndLibrariesScope(test));
        Object[] objectArray = dirs;
        if (objectArray.length == 0) {
            return quick ? this.ERR : new JavaModuleSystemEx.ErrorWithFixes(JavaErrorMessages.message("package.not.found", target2.getQualifiedName()));
        }
        PsiDirectory psiDirectory = dirs[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"dirs[0]");
        PsiFileSystemItem psiFileSystemItem2 = (PsiFileSystemItem)psiDirectory;
        psiFileSystemItem2 = (PsiFileSystemItem)useFile;
        String string = target2.getQualifiedName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.qualifiedName");
        JavaModuleSystemEx.ErrorWithFixes error = this.checkAccess(psiFileSystemItem, psiFileSystemItem2, string, quick);
        if (error == null) return null;
        if (((Object[])dirs).length > 1) {
            Sequence $receiver$iv = SequencesKt.drop((Sequence)ArraysKt.asSequence((Object[])dirs), (int)1);
            for (Object element$iv : $receiver$iv) {
                PsiDirectory it;
                PsiDirectory psiDirectory2 = it = (PsiDirectory)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory2, (String)"it");
                PsiFileSystemItem psiFileSystemItem4 = (PsiFileSystemItem)psiDirectory2;
                psiFileSystemItem4 = (PsiFileSystemItem)useFile;
                String string2 = target2.getQualifiedName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"target.qualifiedName");
                if (this.checkAccess(psiFileSystemItem3, psiFileSystemItem4, string2, true) == null) {
                    return null;
                }
                boolean bl = false;
                if (!bl) continue;
                return null;
            }
            boolean bl = false;
            if (bl) {
                return null;
            }
        }
        JavaModuleSystemEx.ErrorWithFixes errorWithFixes = error;
        return errorWithFixes;
    }

    private final JavaModuleSystemEx.ErrorWithFixes checkAccess(PsiFileSystemItem target2, PsiFileSystemItem place, String packageName, boolean quick) {
        PsiJavaModule psiJavaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)target2);
        PsiJavaModule targetModule = (PsiJavaModule)(psiJavaModule != null ? psiJavaModule.getOriginalElement() : null);
        PsiJavaModule psiJavaModule2 = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)place);
        PsiJavaModule useModule = (PsiJavaModule)(psiJavaModule2 != null ? psiJavaModule2.getOriginalElement() : null);
        if (targetModule != null) {
            PsiFile psiFile;
            if (Intrinsics.areEqual((Object)targetModule, (Object)useModule)) {
                return null;
            }
            if (useModule == null && !(((psiFile = targetModule.getContainingFile()) != null && (psiFile = psiFile.getVirtualFile()) != null ? psiFile.getFileSystem() : null) instanceof JrtFileSystem)) {
                return null;
            }
            if (!(targetModule instanceof LightJavaModule) && !JavaModuleGraphUtil.exports(targetModule, packageName, useModule)) {
                return quick ? this.ERR : (useModule == null ? new JavaModuleSystemEx.ErrorWithFixes(JavaErrorMessages.message("module.access.from.unnamed", packageName, targetModule.getName())) : new JavaModuleSystemEx.ErrorWithFixes(JavaErrorMessages.message("module.access.from.named", packageName, targetModule.getName(), useModule.getName())));
            }
            if (useModule == null) {
                return null;
            }
            if (!Intrinsics.areEqual((Object)targetModule.getName(), (Object)"java.base") && !JavaModuleGraphUtil.reads(useModule, targetModule)) {
                return quick ? this.ERR : new JavaModuleSystemEx.ErrorWithFixes(JavaErrorMessages.message("module.access.does.not.read", packageName, targetModule.getName(), useModule.getName()), CollectionsKt.listOf((Object)((Object)new AddRequiredModuleFix(useModule, targetModule.getName()))));
            }
        } else if (useModule != null) {
            return quick ? this.ERR : new JavaModuleSystemEx.ErrorWithFixes(JavaErrorMessages.message("module.access.to.unnamed", packageName, useModule.getName()));
        }
        return null;
    }
}

