/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.JavaSimplePropertyIndex;
import com.intellij.psi.impl.PropertyIndexValue;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stub.JavaStubImplUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\"*\u0010\u0000\u001a\u001e\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00040\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"indexId", "Lcom/intellij/util/indexing/ID;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/psi/impl/PropertyIndexValue;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getFieldOfGetter", "Lcom/intellij/psi/PsiField;", "method", "Lcom/intellij/psi/impl/source/PsiMethodImpl;", "getFieldOfSetter", "resolveFieldFromIndexValue", "isGetter", "", "java-indexing-impl"})
public final class JavaSimplePropertyIndexKt {
    private static final ID<Integer, PropertyIndexValue> indexId = ID.create((String)"java.simple.property");
    private static final Logger log = Logger.getInstance(JavaSimplePropertyIndex.class);

    @Nullable
    public static final PsiField getFieldOfGetter(@NotNull PsiMethodImpl method) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
        return JavaSimplePropertyIndexKt.resolveFieldFromIndexValue(method, true);
    }

    @Nullable
    public static final PsiField getFieldOfSetter(@NotNull PsiMethodImpl method) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
        return JavaSimplePropertyIndexKt.resolveFieldFromIndexValue(method, false);
    }

    private static final PsiField resolveFieldFromIndexValue(PsiMethodImpl method, boolean isGetter) {
        int id = JavaStubImplUtil.getMethodStubIndex(method);
        if (id != -1) {
            List values = FileBasedIndex.getInstance().getValues(indexId, (Object)id, GlobalSearchScope.fileScope((PsiFile)method.getContainingFile()));
            switch (values.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    PsiClass psiClass;
                    PropertyIndexValue indexValue = (PropertyIndexValue)values.get(0);
                    if (isGetter != indexValue.getGetter()) {
                        return null;
                    }
                    PsiClass psiClass2 = psiClass = method.getContainingClass();
                    if (psiClass2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Project project2 = psiClass2.getProject();
                    PsiExpression expr = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(indexValue.getPropertyRefText(), (PsiElement)psiClass);
                    return PropertyUtil.getSimplyReturnedField(expr);
                }
            }
            log.error("multiple index values for method " + (Object)((Object)method));
        }
        return null;
    }

    @NotNull
    public static final /* synthetic */ ID access$getIndexId$p() {
        return indexId;
    }
}

