/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiDocumentManagerBase
extends PsiDocumentManager
implements DocumentListener,
ProjectComponent {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiDocumentManagerImpl");
    private static final Key<Document> HARD_REF_TO_DOCUMENT = Key.create((String)"HARD_REFERENCE_TO_DOCUMENT");
    private final Key<PsiFile> HARD_REF_TO_PSI;
    private static final Key<List<Runnable>> ACTION_AFTER_COMMIT = Key.create((String)"ACTION_AFTER_COMMIT");
    protected final Project myProject;
    private final PsiManager myPsiManager;
    private final DocumentCommitProcessor myDocumentCommitProcessor;
    protected final Set<Document> myUncommittedDocuments;
    private final Map<Document, UncommittedInfo> myUncommittedInfos;
    protected boolean myStopTrackingDocuments;
    private boolean myPerformBackgroundCommit;
    private volatile boolean myIsCommitInProgress;
    private static volatile boolean ourIsFullReparseInProgress;
    private final PsiToDocumentSynchronizer mySynchronizer;
    private final List<PsiDocumentManager.Listener> myListeners;
    private final Map<Object, Runnable> actionsWhenAllDocumentsAreCommitted;
    private static final Object PERFORM_ALWAYS_KEY;

    protected PsiDocumentManagerBase(@NotNull Project project2, @NotNull PsiManager psiManager, @NotNull MessageBus bus, @NonNls @NotNull DocumentCommitProcessor documentCommitProcessor) {
        if (project2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(0);
        }
        if (psiManager == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(1);
        }
        if (bus == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(2);
        }
        if (documentCommitProcessor == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(3);
        }
        this.HARD_REF_TO_PSI = Key.create((String)"HARD_REF_TO_PSI");
        this.myUncommittedDocuments = ContainerUtil.newConcurrentSet();
        this.myUncommittedInfos = ContainerUtil.newConcurrentMap();
        this.myPerformBackgroundCommit = true;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.actionsWhenAllDocumentsAreCommitted = new LinkedHashMap<Object, Runnable>();
        this.myProject = project2;
        this.myPsiManager = psiManager;
        this.myDocumentCommitProcessor = documentCommitProcessor;
        this.mySynchronizer = new PsiToDocumentSynchronizer(this, bus);
        this.myPsiManager.addPsiTreeChangeListener((PsiTreeChangeListener)this.mySynchronizer);
        bus.connect().subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document document, @NotNull PsiFile file2) {
                if (document == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiDocumentManagerBase.this.myUncommittedDocuments.remove(document);
            }

            @Override
            public void transactionCompleted(@NotNull Document document, @NotNull PsiFile file2) {
                if (document == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/PsiDocumentManagerBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionStarted";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(4);
        }
        if (document instanceof DocumentWindow && !((DocumentWindow)document).isValid()) {
            return null;
        }
        PsiFile userData = (PsiFile)document.getUserData(this.HARD_REF_TO_PSI);
        if (userData != null) {
            return PsiDocumentManagerBase.ensureValidFile(userData, "From hard ref");
        }
        PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile != null) {
            return PsiDocumentManagerBase.ensureValidFile(psiFile, "Cached PSI");
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        psiFile = this.getPsiFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        this.fireFileCreated(document, psiFile);
        return psiFile;
    }

    @NotNull
    private static PsiFile ensureValidFile(@NotNull PsiFile psiFile, @NotNull String debugInfo) {
        if (psiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(5);
        }
        if (debugInfo == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(6);
        }
        if (!psiFile.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)psiFile, debugInfo);
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(7);
        }
        return psiFile2;
    }

    @Deprecated
    public static void cachePsi(@NotNull Document document, @Nullable PsiFile file2) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(8);
        }
        LOG.warn("Unsupported method");
    }

    public void associatePsi(@NotNull Document document, @Nullable PsiFile file2) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(9);
        }
        document.putUserData(this.HARD_REF_TO_PSI, (Object)file2);
    }

    public PsiFile getCachedPsiFile(@NotNull Document document) {
        PsiFile userData;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(10);
        }
        if ((userData = (PsiFile)document.getUserData(this.HARD_REF_TO_PSI)) != null) {
            return userData;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return this.getCachedPsiFile(virtualFile);
    }

    @Nullable
    FileViewProvider getCachedViewProvider(@NotNull Document document) {
        VirtualFile virtualFile;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(11);
        }
        if ((virtualFile = PsiDocumentManagerBase.getVirtualFile(document)) == null) {
            return null;
        }
        return this.getCachedViewProvider(virtualFile);
    }

    private FileViewProvider getCachedViewProvider(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(12);
        }
        return ((PsiManagerEx)this.myPsiManager).getFileManager().findCachedViewProvider(virtualFile);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull Document document) {
        VirtualFile virtualFile;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(13);
        }
        if ((virtualFile = FileDocumentManager.getInstance().getFile(document)) == null || !virtualFile.isValid()) {
            return null;
        }
        return virtualFile;
    }

    @Nullable
    PsiFile getCachedPsiFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(14);
        }
        return ((PsiManagerEx)this.myPsiManager).getFileManager().getCachedPsiFile(virtualFile);
    }

    @Nullable
    private PsiFile getPsiFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(15);
        }
        return ((PsiManagerEx)this.myPsiManager).getFileManager().findFile(virtualFile);
    }

    public Document getDocument(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(16);
        }
        if (file2 instanceof PsiBinaryFile) {
            return null;
        }
        Document document = this.getCachedDocument(file2);
        if (document != null) {
            if (!file2.getViewProvider().isPhysical() && document.getUserData(this.HARD_REF_TO_PSI) == null) {
                PsiUtilCore.ensureValid((PsiElement)file2);
                this.associatePsi(document, file2);
            }
            return document;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        if (!viewProvider.isEventSystemEnabled()) {
            return null;
        }
        document = FileDocumentManager.getInstance().getDocument(viewProvider.getVirtualFile());
        if (document != null) {
            if (document.getTextLength() != file2.getTextLength()) {
                String message2 = "Document/PSI mismatch: " + file2 + " (" + file2.getClass() + "); physical=" + viewProvider.isPhysical();
                if (document.getTextLength() + file2.getTextLength() < 8096) {
                    message2 = message2 + "\n=== document ===\n" + document.getText() + "\n=== PSI ===\n" + file2.getText();
                }
                throw new AssertionError((Object)message2);
            }
            if (!viewProvider.isPhysical()) {
                PsiUtilCore.ensureValid((PsiElement)file2);
                this.associatePsi(document, file2);
                file2.putUserData(HARD_REF_TO_DOCUMENT, (Object)document);
            }
        }
        return document;
    }

    public Document getCachedDocument(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(17);
        }
        if (!file2.isPhysical()) {
            return null;
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        return FileDocumentManager.getInstance().getCachedDocument(vFile);
    }

    public void commitAllDocuments() {
        Document[] documents;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        if (this.myUncommittedDocuments.isEmpty()) {
            return;
        }
        for (Document document : documents = this.getUncommittedDocuments()) {
            this.commitDocument(document);
        }
        LOG.assertTrue(!this.hasUncommitedDocuments(), this.myUncommittedDocuments);
    }

    public void performForCommittedDocument(@NotNull Document doc, @NotNull Runnable action) {
        Document document;
        if (doc == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(18);
        }
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(19);
        }
        Document document2 = document = doc instanceof DocumentWindow ? ((DocumentWindow)doc).getDelegate() : doc;
        if (this.isCommitted(document)) {
            action.run();
        } else {
            PsiDocumentManagerBase.addRunOnCommit(document, action);
        }
    }

    public boolean cancelAndRunWhenAllCommitted(@NonNls @NotNull Object key2, @NotNull Runnable action) {
        if (key2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(20);
        }
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            action.run();
            return true;
        }
        if (this.myUncommittedDocuments.isEmpty()) {
            if (!this.isCommitInProgress()) assert (this.actionsWhenAllDocumentsAreCommitted.isEmpty()) : this.actionsWhenAllDocumentsAreCommitted;
            action.run();
            return true;
        }
        this.checkWeAreOutsideAfterCommitHandler();
        this.actionsWhenAllDocumentsAreCommitted.put(key2, action);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRunOnCommit(@NotNull Document document, @NotNull Runnable action) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(22);
        }
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(23);
        }
        Key<List<Runnable>> key2 = ACTION_AFTER_COMMIT;
        synchronized (key2) {
            List list2 = (List)document.getUserData(ACTION_AFTER_COMMIT);
            if (list2 == null) {
                list2 = new SmartList();
                document.putUserData(ACTION_AFTER_COMMIT, (Object)list2);
            }
            list2.add(action);
        }
    }

    public void commitDocument(@NotNull Document doc) {
        Document document;
        if (doc == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(24);
        }
        Document document2 = document = doc instanceof DocumentWindow ? ((DocumentWindow)doc).getDelegate() : doc;
        if (this.isEventSystemEnabled(document)) {
            ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        }
        if (!this.isCommitted(document)) {
            this.doCommit(document);
        }
    }

    private boolean isEventSystemEnabled(Document document) {
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        return viewProvider != null && viewProvider.isEventSystemEnabled() && !AbstractFileViewProvider.isFreeThreaded(viewProvider);
    }

    public boolean finishCommit(final @NotNull Document document, final @NotNull List<Processor<Document>> finishProcessors, final boolean synchronously, @NotNull Object reason) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(25);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(26);
        }
        if (reason == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(27);
        }
        assert (!this.myProject.isDisposed()) : "Already disposed";
        ApplicationManager.getApplication().assertIsDispatchThread();
        final boolean[] ok = new boolean[]{true};
        DocumentRunnable runnable2 = new DocumentRunnable(document, this.myProject){

            public void run() {
                ok[0] = PsiDocumentManagerBase.this.finishCommitInWriteAction(document, finishProcessors, synchronously);
            }
        };
        if (synchronously) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().runWriteAction((Runnable)runnable2);
        }
        if (ok[0]) {
            if (!this.mySynchronizer.isDocumentAffectedByTransactions(document)) {
                InjectedLanguageManager.getInstance((Project)this.myProject).startRunInjectors(document, synchronously);
            }
            this.runAfterCommitActions(document);
            if (DebugUtil.DO_EXPENSIVE_CHECKS && !ApplicationInfoImpl.isInStressTest()) {
                this.checkAllElementsValid(document, reason);
            }
        }
        return ok[0];
    }

    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<Processor<Document>> finishProcessors, boolean synchronously) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(28);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(29);
        }
        return this.finishCommitInWriteAction(document, finishProcessors, synchronously, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<Processor<Document>> finishProcessors, boolean synchronously, boolean forceNoPsiCommit) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(30);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(31);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return false;
        }
        assert (!(document instanceof DocumentWindow));
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile != null) {
            this.getSmartPointerManager().fastenBelts(virtualFile);
        }
        FileViewProvider viewProvider = forceNoPsiCommit ? null : this.getCachedViewProvider(document);
        this.myIsCommitInProgress = true;
        boolean success = true;
        try {
            if (viewProvider != null) {
                success = this.commitToExistingPsi(document, finishProcessors, synchronously, virtualFile, viewProvider);
            } else {
                this.handleCommitWithoutPsi(document);
            }
        }
        catch (Throwable e) {
            this.forceReload(virtualFile, viewProvider);
            LOG.error(e);
        }
        finally {
            if (success) {
                this.myUncommittedDocuments.remove(document);
            }
            this.myIsCommitInProgress = false;
        }
        return success;
    }

    private boolean commitToExistingPsi(@NotNull Document document, @NotNull List<Processor<Document>> finishProcessors, boolean synchronously, @Nullable VirtualFile virtualFile, @NotNull FileViewProvider viewProvider) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(32);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(33);
        }
        if (viewProvider == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(34);
        }
        for (Processor<Document> finishRunnable : finishProcessors) {
            boolean success = finishRunnable.process((Object)document);
            if (synchronously) assert (success) : finishRunnable + " in " + finishProcessors;
            if (success) continue;
            return false;
        }
        this.clearUncommittedInfo(document);
        if (virtualFile != null) {
            this.getSmartPointerManager().updatePointerTargetsAfterReparse(virtualFile);
        }
        viewProvider.contentsSynchronized();
        return true;
    }

    void forceReload(VirtualFile virtualFile, @Nullable FileViewProvider viewProvider) {
        if (viewProvider != null) {
            ((AbstractFileViewProvider)viewProvider).markInvalidated();
        }
        if (virtualFile != null) {
            ((FileManagerImpl)((PsiManagerEx)this.myPsiManager).getFileManager()).forceReload(virtualFile);
        }
    }

    private void checkAllElementsValid(@NotNull Document document, final @NotNull Object reason) {
        PsiFile psiFile;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(35);
        }
        if (reason == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(36);
        }
        if ((psiFile = this.getCachedPsiFile(document)) != null) {
            psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (!element.isValid()) {
                        throw new AssertionError((Object)("Commit to '" + psiFile.getVirtualFile() + "' has led to invalid element: " + element + "; Reason: '" + reason + "'"));
                    }
                }
            });
        }
    }

    private void doCommit(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(37);
        }
        assert (!this.myIsCommitInProgress) : "Do not call commitDocument() from inside PSI change listener";
        if (this.getSynchronizer().isDocumentAffectedByTransactions(document)) {
            return;
        }
        PsiFile psiFile = this.getPsiFile(document);
        if (psiFile == null) {
            this.myUncommittedDocuments.remove(document);
            return;
        }
        Runnable runnable2 = () -> {
            if (document == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(84);
            }
            this.myIsCommitInProgress = true;
            try {
                this.myDocumentCommitProcessor.commitSynchronously(document, this.myProject, psiFile);
            }
            finally {
                this.myIsCommitInProgress = false;
            }
            assert (!this.isInUncommittedSet(document)) : "Document :" + document;
        };
        if (AbstractFileViewProvider.isFreeThreaded(psiFile.getViewProvider())) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().runWriteAction(runnable2);
        }
    }

    public boolean isCommitInProgress() {
        return this.myIsCommitInProgress || PsiDocumentManagerBase.isFullReparseInProgress();
    }

    public static boolean isFullReparseInProgress() {
        return ourIsFullReparseInProgress;
    }

    public <T> T commitAndRunReadAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(38);
        }
        Ref ref = Ref.create(null);
        this.commitAndRunReadAction(() -> {
            if (computation == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(83);
            }
            ref.set(computation.compute());
        });
        return (T)ref.get();
    }

    public void reparseFiles(@NotNull Collection<VirtualFile> files, boolean includeOpenFiles) {
        if (files == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(39);
        }
        FileContentUtilCore.reparseFiles(files);
    }

    public void commitAndRunReadAction(@NotNull Runnable runnable2) {
        boolean executed;
        if (runnable2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(40);
        }
        Application application = ApplicationManager.getApplication();
        if (SwingUtilities.isEventDispatchThread()) {
            this.commitAllDocuments();
            runnable2.run();
            return;
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("Don't call commitAndRunReadAction inside ReadAction, it will cause a deadlock otherwise. " + Thread.currentThread());
        }
        while (!(executed = ((Boolean)application.runReadAction(() -> {
            if (runnable2 == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(82);
            }
            if (this.myUncommittedDocuments.isEmpty()) {
                runnable2.run();
                return true;
            }
            return false;
        })).booleanValue())) {
            TransactionId contextTransaction = TransactionGuard.getInstance().getContextTransaction();
            Semaphore semaphore = new Semaphore(1);
            application.invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    semaphore.up();
                    return;
                }
                this.performWhenAllCommitted(() -> semaphore.up(), contextTransaction);
            }, ModalityState.any());
            semaphore.waitFor();
        }
    }

    public boolean performWhenAllCommitted(@NotNull Runnable action) {
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(41);
        }
        return this.performWhenAllCommitted(action, TransactionGuard.getInstance().getContextTransaction());
    }

    private boolean performWhenAllCommitted(@NotNull Runnable action, @Nullable TransactionId context) {
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(42);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkWeAreOutsideAfterCommitHandler();
        assert (!this.myProject.isDisposed()) : "Already disposed: " + this.myProject;
        if (this.myUncommittedDocuments.isEmpty()) {
            action.run();
            return true;
        }
        CompositeRunnable actions = (CompositeRunnable)this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY);
        if (actions == null) {
            actions = new CompositeRunnable();
            this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, actions);
        }
        actions.add(action);
        if (context != null) {
            for (Document document : this.myUncommittedDocuments) {
                this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, document, "re-added with context " + context + " because performWhenAllCommitted(" + context + ") was called", context);
            }
        }
        return false;
    }

    public void performLaterWhenAllCommitted(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(43);
        }
        this.performLaterWhenAllCommitted(runnable2, ModalityState.defaultModalityState());
    }

    public void performLaterWhenAllCommitted(@NotNull Runnable runnable2, ModalityState modalityState) {
        if (runnable2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(44);
        }
        Runnable whenAllCommitted = () -> {
            if (runnable2 == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(80);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (runnable2 == null) {
                    PsiDocumentManagerBase.$$$reportNull$$$0(81);
                }
                if (this.hasUncommitedDocuments()) {
                    this.performLaterWhenAllCommitted(runnable2);
                } else {
                    runnable2.run();
                }
            }, modalityState, this.myProject.getDisposed());
        };
        if (ApplicationManager.getApplication().isDispatchThread() && this.isInsideCommitHandler()) {
            whenAllCommitted.run();
        } else {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!this.myProject.isDisposed()) {
                    this.performWhenAllCommitted(whenAllCommitted);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void runAfterCommitActions(@NotNull Document document) {
        void list2;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(45);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Key<List<Runnable>> key2 = ACTION_AFTER_COMMIT;
        synchronized (key2) {
            ArrayList list22 = (ArrayList)document.getUserData(ACTION_AFTER_COMMIT);
            if (list22 != null) {
                list22 = new ArrayList(list22);
                document.putUserData(ACTION_AFTER_COMMIT, null);
            }
        }
        if (list2 != null) {
            for (Runnable runnable2 : list2) {
                runnable2.run();
            }
        }
        if (!this.hasUncommitedDocuments() && !this.actionsWhenAllDocumentsAreCommitted.isEmpty()) {
            ArrayList<Map.Entry<Object, Runnable>> entries = new ArrayList<Map.Entry<Object, Runnable>>(new LinkedHashMap<Object, Runnable>(this.actionsWhenAllDocumentsAreCommitted).entrySet());
            this.beforeCommitHandler();
            try {
                for (Map.Entry entry : entries) {
                    Runnable action = (Runnable)entry.getValue();
                    try {
                        action.run();
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    catch (Throwable e) {
                        LOG.error("During running " + action, e);
                    }
                }
            }
            finally {
                this.actionsWhenAllDocumentsAreCommitted.clear();
            }
        }
    }

    private void beforeCommitHandler() {
        this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, EmptyRunnable.getInstance());
    }

    private void checkWeAreOutsideAfterCommitHandler() {
        if (this.isInsideCommitHandler()) {
            throw new IncorrectOperationException("You must not call performWhenAllCommitted()/cancelAndRunWhenCommitted() from within after-commit handler");
        }
    }

    private boolean isInsideCommitHandler() {
        return this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY) == EmptyRunnable.getInstance();
    }

    public void addListener(@NotNull PsiDocumentManager.Listener listener2) {
        if (listener2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(46);
        }
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull PsiDocumentManager.Listener listener2) {
        if (listener2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(47);
        }
        this.myListeners.remove(listener2);
    }

    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        if (doc == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(48);
        }
        return false;
    }

    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
        if (doc == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(49);
        }
    }

    void fireDocumentCreated(@NotNull Document document, PsiFile file2) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(50);
        }
        for (PsiDocumentManager.Listener listener2 : this.myListeners) {
            listener2.documentCreated(document, file2);
        }
    }

    private void fireFileCreated(@NotNull Document document, @NotNull PsiFile file2) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(51);
        }
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(52);
        }
        for (PsiDocumentManager.Listener listener2 : this.myListeners) {
            listener2.fileCreated(file2, document);
        }
    }

    @NotNull
    public CharSequence getLastCommittedText(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(53);
        }
        CharSequence charSequence = this.getLastCommittedDocument(document).getImmutableCharSequence();
        if (charSequence == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(54);
        }
        return charSequence;
    }

    public long getLastCommittedStamp(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(55);
        }
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        return this.getLastCommittedDocument(document).getModificationStamp();
    }

    @Nullable
    public Document getLastCommittedDocument(@NotNull PsiFile file2) {
        Document document;
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(56);
        }
        return (document = this.getDocument(file2)) == null ? null : this.getLastCommittedDocument(document);
    }

    @NotNull
    public DocumentEx getLastCommittedDocument(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(57);
        }
        if (document instanceof FrozenDocument) {
            DocumentEx documentEx = (DocumentEx)document;
            if (documentEx == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(58);
            }
            return documentEx;
        }
        if (document instanceof DocumentWindow) {
            DocumentWindow answer;
            DocumentWindow window = (DocumentWindow)document;
            Document delegate = window.getDelegate();
            if (delegate instanceof FrozenDocument) {
                DocumentEx documentEx = (DocumentEx)window;
                if (documentEx == null) {
                    PsiDocumentManagerBase.$$$reportNull$$$0(59);
                }
                return documentEx;
            }
            if (!window.isValid()) {
                throw new AssertionError((Object)("host committed: " + this.isCommitted(delegate) + ", window=" + window));
            }
            UncommittedInfo info = this.myUncommittedInfos.get(delegate);
            DocumentWindow documentWindow = answer = info == null ? null : (DocumentWindow)info.myFrozenWindows.get(document);
            if (answer == null) {
                answer = this.freezeWindow(window);
            }
            if (info != null) {
                answer = (DocumentWindow)ConcurrencyUtil.cacheOrGet((ConcurrentMap)info.myFrozenWindows, (Object)window, (Object)answer);
            }
            DocumentEx documentEx = (DocumentEx)answer;
            if (documentEx == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(60);
            }
            return documentEx;
        }
        assert (document instanceof DocumentImpl);
        UncommittedInfo info = this.myUncommittedInfos.get(document);
        FrozenDocument frozenDocument = info != null ? info.myFrozen : ((DocumentImpl)document).freeze();
        if (frozenDocument == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(61);
        }
        return frozenDocument;
    }

    @NotNull
    protected DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(62);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public List<DocumentEvent> getEventsSinceCommit(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(63);
        }
        assert (document instanceof DocumentImpl);
        UncommittedInfo info = this.myUncommittedInfos.get(document);
        if (info != null) {
            List list2 = info.myEvents;
            if (list2 == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(64);
            }
            return list2;
        }
        List<DocumentEvent> list3 = Collections.emptyList();
        if (list3 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(65);
        }
        return list3;
    }

    @NotNull
    public Document[] getUncommittedDocuments() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object[] documents = this.myUncommittedDocuments.toArray(new Document[this.myUncommittedDocuments.size()]);
        Document[] documentArray = (Document[])ArrayUtil.stripTrailingNulls((Object[])documents);
        if (documentArray == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(66);
        }
        return documentArray;
    }

    boolean isInUncommittedSet(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(67);
        }
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        return this.myUncommittedDocuments.contains(document);
    }

    public boolean isUncommited(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(68);
        }
        return !this.isCommitted(document);
    }

    public boolean isCommitted(@NotNull Document document) {
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(69);
        }
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        if (this.getSynchronizer().isInSynchronization(document)) {
            return true;
        }
        return (!(document instanceof DocumentEx) || !((DocumentEx)document).isInEventsHandling()) && !this.isInUncommittedSet(document);
    }

    public boolean hasUncommitedDocuments() {
        return !this.myIsCommitInProgress && !this.myUncommittedDocuments.isEmpty();
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        FileViewProvider viewProvider;
        boolean inMyProject;
        boolean isRelevant;
        if (event == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(70);
        }
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean bl = isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        if (document instanceof DocumentImpl && !this.myUncommittedInfos.containsKey(document)) {
            this.myUncommittedInfos.put(document, new UncommittedInfo((DocumentImpl)document));
        }
        boolean bl2 = inMyProject = (viewProvider = this.getCachedViewProvider(document)) != null && viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            return;
        }
        List files = viewProvider.getAllFiles();
        PsiFile psiCause = null;
        for (PsiFile file2 : files) {
            if (file2 == null) {
                throw new AssertionError((Object)("View provider " + viewProvider + " (" + viewProvider.getClass() + ") returned null in its files array: " + files + " for file " + viewProvider.getVirtualFile()));
            }
            if (!PsiToDocumentSynchronizer.isInsideAtomicChange(file2)) continue;
            psiCause = file2;
        }
        if (psiCause == null) {
            this.beforeDocumentChangeOnUnlockedDocument(viewProvider);
        }
        ((AbstractFileViewProvider)viewProvider).beforeDocumentChanged(psiCause);
    }

    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(71);
        }
    }

    public void documentChanged(DocumentEvent event) {
        boolean forceCommit;
        boolean inMyProject;
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        if (viewProvider == null) {
            this.handleCommitWithoutPsi(document);
            return;
        }
        boolean bl = inMyProject = viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            this.clearUncommittedInfo(document);
            return;
        }
        List files = viewProvider.getAllFiles();
        boolean commitNecessary = files.stream().noneMatch(file2 -> PsiToDocumentSynchronizer.isInsideAtomicChange(file2) || !(file2 instanceof PsiFileImpl));
        boolean bl2 = forceCommit = ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.class) && (SystemProperties.getBooleanProperty((String)"idea.force.commit.on.external.change", (boolean)false) || ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode());
        if (event.isWholeTextReplaced() && document.getTextLength() > 100000) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)Boolean.TRUE);
        }
        if (commitNecessary) {
            assert (!(document instanceof DocumentWindow));
            this.myUncommittedDocuments.add(document);
            if (forceCommit) {
                this.commitDocument(document);
            } else if (!((DocumentEx)document).isInBulkUpdate() && this.myPerformBackgroundCommit) {
                this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, document, event, TransactionGuard.getInstance().getContextTransaction());
            }
        } else {
            this.clearUncommittedInfo(document);
        }
    }

    void handleCommitWithoutPsi(@NotNull Document document) {
        UncommittedInfo prevInfo;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(72);
        }
        if ((prevInfo = this.clearUncommittedInfo(document)) == null) {
            return;
        }
        if (!this.myProject.isInitialized() || this.myProject.isDisposed()) {
            return;
        }
        this.myUncommittedDocuments.remove(document);
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !FileIndexFacade.getInstance((Project)this.myProject).isInContent(virtualFile)) {
            return;
        }
        final PsiFile psiFile = this.getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

            @Override
            public void run() {
                ((AbstractFileViewProvider)psiFile.getViewProvider()).onContentReload();
            }
        });
    }

    @Nullable
    private UncommittedInfo clearUncommittedInfo(@NotNull Document document) {
        UncommittedInfo info;
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(73);
        }
        if ((info = this.myUncommittedInfos.remove(document)) != null) {
            this.getSmartPointerManager().updatePointers(document, info.myFrozen, info.myEvents);
            info.removeListener();
        }
        return info;
    }

    private SmartPointerManagerImpl getSmartPointerManager() {
        return (SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)this.myProject);
    }

    private boolean isRelevant(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(74);
        }
        return !virtualFile.getFileType().isBinary() && !this.myProject.isDisposed();
    }

    public static boolean checkConsistency(@NotNull PsiFile psiFile, @NotNull Document document) {
        int i;
        if (psiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(75);
        }
        if (document == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(76);
        }
        if (psiFile.getVirtualFile() == null) {
            return true;
        }
        CharSequence editorText = document.getCharsSequence();
        int documentLength = document.getTextLength();
        if (psiFile.textMatches(editorText)) {
            LOG.assertTrue(psiFile.getTextLength() == documentLength);
            return true;
        }
        char[] fileText = psiFile.textToCharArray();
        String error = "File '" + psiFile.getName() + "' text mismatch after reparse. File length=" + fileText.length + "; Doc length=" + documentLength + "\n";
        for (i = 0; i < documentLength; ++i) {
            if (i >= fileText.length) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (i >= editorText.length()) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (editorText.charAt(i) == fileText[i]) continue;
            error = error + "first unequal char i=" + i + "\n";
            break;
        }
        error = error + "*********************************************\n";
        error = error + "Editor Text tail:(" + (documentLength - i) + ")\n";
        error = error + "*********************************************\n";
        error = error + "Psi Text tail:(" + (fileText.length - i) + ")\n";
        error = error + "*********************************************\n";
        if (document instanceof DocumentWindow) {
            error = error + "doc: '" + document.getText() + "'\n";
            error = error + "psi: '" + psiFile.getText() + "'\n";
            error = error + "ast: '" + psiFile.getNode().getText() + "'\n";
            error = error + psiFile.getLanguage() + "\n";
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getInjectionHost((PsiElement)psiFile);
            if (context != null) {
                error = error + "context: " + context + "; text: '" + context.getText() + "'\n";
                error = error + "context file: " + context.getContainingFile() + "\n";
            }
            error = error + "document window ranges: " + Arrays.asList(((DocumentWindow)document).getHostRanges()) + "\n";
        }
        LOG.error(error);
        return false;
    }

    @VisibleForTesting
    public void clearUncommittedDocuments() {
        for (UncommittedInfo info : this.myUncommittedInfos.values()) {
            info.removeListener();
        }
        this.myUncommittedInfos.clear();
        this.myUncommittedDocuments.clear();
        this.mySynchronizer.cleanupForNextTest();
    }

    public void disableBackgroundCommit(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(77);
        }
        assert (this.myPerformBackgroundCommit);
        this.myPerformBackgroundCommit = false;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                PsiDocumentManagerBase.this.myPerformBackgroundCommit = true;
            }
        });
    }

    public void disposeComponent() {
        this.clearUncommittedDocuments();
    }

    @NotNull
    public String getComponentName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(78);
        }
        return string;
    }

    @NotNull
    public PsiToDocumentSynchronizer getSynchronizer() {
        PsiToDocumentSynchronizer psiToDocumentSynchronizer = this.mySynchronizer;
        if (psiToDocumentSynchronizer == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(79);
        }
        return psiToDocumentSynchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparseFileFromText(PsiFileImpl file2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isCommitInProgress()) {
            throw new IllegalStateException("Re-entrant commit is not allowed");
        }
        FileElement node = file2.calcTreeElement();
        CharSequence text2 = node.getChars();
        ourIsFullReparseInProgress = true;
        try {
            WriteAction.run(() -> {
                ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
                if (indicator == null) {
                    indicator = new EmptyProgressIndicator();
                }
                DiffLog log = BlockSupportImpl.makeFullParse(file2, node, text2, indicator, text2);
                DocumentCommitThread.doActualPsiChange(file2, log);
                file2.getViewProvider().contentsSynchronized();
            });
        }
        finally {
            ourIsFullReparseInProgress = false;
        }
    }

    static {
        PERFORM_ALWAYS_KEY = new Object(){

            @NonNls
            public String toString() {
                return "PERFORM_ALWAYS";
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 78: 
            case 79: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 78: 
            case 79: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentCommitProcessor";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 45: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 62: 
            case 63: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 76: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugInfo";
                break;
            }
            case 7: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiDocumentManagerBase";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 16: 
            case 17: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 24: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: 
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishProcessors";
                break;
            }
            case 27: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 34: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 38: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 40: 
            case 43: 
            case 44: 
            case 80: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiDocumentManagerBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureValidFile";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommittedText";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommittedDocument";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventsSinceCommit";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getUncommittedDocuments";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getSynchronizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ensureValidFile";
                break;
            }
            case 7: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 78: 
            case 79: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cachePsi";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "associatePsi";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCachedViewProvider";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDocument";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "performForCommittedDocument";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRunWhenAllCommitted";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addRunOnCommit";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "commitDocument";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "finishCommit";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "finishCommitInWriteAction";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "commitToExistingPsi";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkAllElementsValid";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "doCommit";
                break;
            }
            case 38: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "commitAndRunReadAction";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "reparseFiles";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "performWhenAllCommitted";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "performLaterWhenAllCommitted";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "runAfterCommitActions";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentBlockedByPsi";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "doPostponedOperationsAndUnblockDocument";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "fireDocumentCreated";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "fireFileCreated";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommittedText";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommittedStamp";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommittedDocument";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "freezeWindow";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getEventsSinceCommit";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isInUncommittedSet";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isUncommited";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isCommitted";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChangeOnUnlockedDocument";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitWithoutPsi";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "clearUncommittedInfo";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isRelevant";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "checkConsistency";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "disableBackgroundCommit";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performLaterWhenAllCommitted$6";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "lambda$commitAndRunReadAction$2";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "lambda$commitAndRunReadAction$1";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doCommit$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 78: 
            case 79: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UncommittedInfo
    implements PrioritizedInternalDocumentListener,
    DocumentListener {
        private final DocumentImpl myOriginal;
        private final FrozenDocument myFrozen;
        private final List<DocumentEvent> myEvents = ContainerUtil.newArrayList();
        private final ConcurrentMap<DocumentWindow, DocumentWindow> myFrozenWindows = ContainerUtil.newConcurrentMap();

        private UncommittedInfo(DocumentImpl original) {
            this.myOriginal = original;
            this.myFrozen = original.freeze();
            this.myOriginal.addDocumentListener(this);
        }

        @Override
        public int getPriority() {
            return 40;
        }

        public void documentChanged(DocumentEvent e) {
            this.myEvents.add(e);
        }

        @Override
        public void moveTextHappened(int start, int end, int base) {
            this.myEvents.add(new RetargetRangeMarkers(this.myOriginal, start, end, base));
        }

        public void removeListener() {
            this.myOriginal.removeDocumentListener(this);
        }
    }

    private static class CompositeRunnable
    extends ArrayList<Runnable>
    implements Runnable {
        private CompositeRunnable() {
        }

        @Override
        public void run() {
            for (Runnable runnable2 : this) {
                runnable2.run();
            }
        }
    }
}

