/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.SubstrateRef;
import com.intellij.psi.impl.source.tree.AstPath;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AstPathPsiMap {
    private final ConcurrentMap<AstPath, MyReference> myMap;
    private volatile Boolean myHasUnbindableCachedPsi;
    private static final Key<MyReferenceQueue> STUB_PSI_REFS = Key.create((String)"STUB_PSI_REFS");
    private final MyReferenceQueue myQueue;

    AstPathPsiMap(@NotNull Project project2) {
        if (project2 == null) {
            AstPathPsiMap.$$$reportNull$$$0(0);
        }
        this.myMap = ContainerUtil.newConcurrentMap();
        this.myHasUnbindableCachedPsi = null;
        MyReferenceQueue queue2 = (MyReferenceQueue)project2.getUserData(STUB_PSI_REFS);
        this.myQueue = queue2 != null ? queue2 : (MyReferenceQueue)((UserDataHolderEx)project2).putUserDataIfAbsent(STUB_PSI_REFS, (Object)new MyReferenceQueue(project2));
    }

    void invalidatePsi() {
        this.myQueue.cleanupStaleReferences();
        this.getAllCachedPsi().forEach(psi -> {
            DebugUtil.onInvalidated((PsiElement)psi);
            psi.setSubstrateRef(SubstrateRef.createInvalidRef(psi));
        });
        this.myMap.clear();
        this.myHasUnbindableCachedPsi = false;
    }

    void switchToStrongRefs() {
        this.myQueue.cleanupStaleReferences();
        this.getAllCachedPsi().forEach(psi -> {
            CompositeElement node = (CompositeElement)psi.getNode();
            node.setPsi((PsiElement)psi);
            psi.setSubstrateRef(SubstrateRef.createAstStrongRef(node));
        });
        this.myMap.clear();
        this.myHasUnbindableCachedPsi = false;
    }

    @Nullable
    StubBasedPsiElementBase<?> getCachedPsi(@NotNull AstPath ref) {
        if (ref == null) {
            AstPathPsiMap.$$$reportNull$$$0(1);
        }
        return (StubBasedPsiElementBase)((Object)SoftReference.dereference((Reference)((Reference)this.myMap.get(ref))));
    }

    @NotNull
    StubBasedPsiElementBase<?> cachePsi(@NotNull AstPath key2, @NotNull StubBasedPsiElementBase psi) {
        if (key2 == null) {
            AstPathPsiMap.$$$reportNull$$$0(2);
        }
        if (psi == null) {
            AstPathPsiMap.$$$reportNull$$$0(3);
        }
        this.myQueue.cleanupStaleReferences();
        psi.setSubstrateRef(key2);
        this.myMap.put(key2, new MyReference(psi, key2, this.myQueue));
        this.clearStubIndexCache();
        StubBasedPsiElementBase stubBasedPsiElementBase = psi;
        if (stubBasedPsiElementBase == null) {
            AstPathPsiMap.$$$reportNull$$$0(4);
        }
        return stubBasedPsiElementBase;
    }

    Stream<? extends StubBasedPsiElementBase<?>> getAllCachedPsi() {
        this.myQueue.cleanupStaleReferences();
        if (this.myMap.isEmpty()) {
            return Stream.empty();
        }
        return this.myMap.values().stream().map(Reference::get).filter(Objects::nonNull);
    }

    boolean hasUnbindableCachedPsi() {
        Boolean answer = this.myHasUnbindableCachedPsi;
        if (answer == null) {
            this.myHasUnbindableCachedPsi = answer = Boolean.valueOf(this.calcHasUnbindableCachedPsi());
        }
        return answer;
    }

    private boolean calcHasUnbindableCachedPsi() {
        this.myQueue.cleanupStaleReferences();
        if (this.myMap.isEmpty()) {
            return false;
        }
        return this.getAllCachedPsi().anyMatch(e -> e.getStubIndex() < 0);
    }

    void clearStubIndexCache() {
        this.myHasUnbindableCachedPsi = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/AstPathPsiMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/AstPathPsiMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "cachePsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsi";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cachePsi";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReferenceQueue
    extends ReferenceQueue<StubBasedPsiElementBase<?>> {
        MyReferenceQueue(Project project2) {
            LowMemoryWatcher.register(() -> this.cleanupStaleReferences(), (Disposable)project2);
        }

        void cleanupStaleReferences() {
            MyReference reference;
            while ((reference = (MyReference)this.poll()) != null) {
                AstPath key2 = reference.pathRef;
                AstPathPsiMap refToPsi = key2.getContainingFile().getRefToPsi();
                refToPsi.myMap.remove(key2, reference);
                refToPsi.clearStubIndexCache();
            }
        }
    }

    private static class MyReference
    extends WeakReference<StubBasedPsiElementBase<?>> {
        final AstPath pathRef;

        MyReference(StubBasedPsiElementBase psi, AstPath ref, ReferenceQueue<StubBasedPsiElementBase<?>> queue2) {
            super(psi, queue2);
            this.pathRef = ref;
        }
    }
}

